/*
 * Decompiled with CFR 0.152.
 */
package net.cofcool.chaos.server.common.security;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import net.cofcool.chaos.server.common.security.Auth;
import net.cofcool.chaos.server.common.security.Device;
import net.cofcool.chaos.server.common.security.UserRole;
import net.cofcool.chaos.server.common.security.UserStatus;

public class User<T extends Auth, ID extends Serializable>
implements Serializable {
    private static final long serialVersionUID = -7130929029282810791L;
    private ID userId;
    private String mobile;
    private String username;
    private String avatar;
    private String password;
    private Collection<UserRole> roles = new HashSet<UserRole>();
    private Date registerTime;
    private Date latestLoginTime;
    private Device device;
    private Collection<UserStatus> userStatuses = new HashSet<UserStatus>();
    private T detail;

    public User() {
    }

    public User(String username, String password) {
        this(username, password, null);
    }

    public User(String username, String password, Device device) {
        this.username = username;
        this.password = password;
        this.device = device;
    }

    public T getDetail() {
        return this.detail;
    }

    public void setDetail(T detail) {
        this.detail = detail;
    }

    public void addUserStatus(UserStatus status) {
        this.userStatuses.add(status);
    }

    public void addUserStatuses(Collection<UserStatus> statuses) {
        this.userStatuses.addAll(statuses);
    }

    public Collection<UserStatus> getUserStatuses() {
        return Collections.unmodifiableCollection(this.userStatuses);
    }

    public ID getUserId() {
        return this.userId;
    }

    public void setUserId(ID userId) {
        this.userId = userId;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Collection<UserRole> getRoles() {
        return Collections.unmodifiableCollection(this.roles);
    }

    protected void setRoles(Collection<UserRole> roles) {
        this.roles = roles;
    }

    protected void setUserStatuses(Collection<UserStatus> userStatuses) {
        this.userStatuses = userStatuses;
    }

    public void addRole(UserRole userRole) {
        this.roles.add(userRole);
    }

    public void addRoles(Collection<UserRole> userRoles) {
        this.roles.addAll(userRoles);
    }

    public Date getRegisterTime() {
        return this.registerTime;
    }

    public void setRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
    }

    public Date getLatestLoginTime() {
        return this.latestLoginTime;
    }

    public void setLatestLoginTime(Date latestLoginTime) {
        this.latestLoginTime = latestLoginTime;
    }

    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public User cloneUser(User newUser) {
        newUser.setAvatar(this.avatar);
        newUser.setUserId(this.userId);
        newUser.setMobile(this.mobile);
        newUser.setUsername(this.username);
        newUser.setPassword(this.password);
        newUser.setRoles(this.roles);
        newUser.setRegisterTime(this.registerTime);
        newUser.setLatestLoginTime(this.latestLoginTime);
        newUser.setDetail(this.detail);
        newUser.setDevice(this.device);
        newUser.setUserStatuses(this.userStatuses);
        return newUser;
    }

    public boolean equals(Object obj) {
        if (obj instanceof User) {
            return this.username.equals(((User)obj).username);
        }
        return false;
    }

    public int hashCode() {
        return this.username.hashCode();
    }

    public String toString() {
        return "User{userId=" + this.userId + ", mobile=" + this.mobile + ", username='" + this.username + '\'' + ", avatar='" + this.avatar + '\'' + ", roles=" + this.roles + ", registerTime=" + this.registerTime + ", latestLoginTime=" + this.latestLoginTime + ", device='" + this.device + ", userStatuses=" + this.userStatuses + ", detail=" + this.detail + '}';
    }

    public <D> D unwrap(Class<D> type) {
        if (type.isAssignableFrom(this.getDetail().getClass())) {
            return (D)this.getDetail();
        }
        throw new ClassCastException("detail cannot cast to be " + type.getName());
    }
}

