/*
 * Decompiled with CFR 0.152.
 */
package net.cofcool.chaos.server.common.security;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface UserRole
extends Comparable<UserRole>,
Serializable {
    @Nullable
    public UserRole parent();

    @Nullable
    public Collection<UserRole> children();

    public int roleId();

    default public String roleName() {
        return String.valueOf(this.roleId());
    }

    @Override
    default public int compareTo(@Nonnull UserRole userRole) {
        return Integer.compare(this.roleId(), userRole.roleId());
    }

    default public boolean contains(@Nonnull int[] roles) {
        boolean flag = roles.length == 0;
        for (int i = 0; i < roles.length && !flag; ++i) {
            if (roles[i] == this.roleId()) {
                flag = true;
                continue;
            }
            if (this.children() == null) continue;
            Iterator<UserRole> roleIterator = this.children().iterator();
            while (roleIterator.hasNext() && !flag) {
                flag = roleIterator.next().contains(roles);
            }
        }
        return flag;
    }
}

