/*
 * Decompiled with CFR 0.152.
 */
package net.cofcool.chaos.server.common.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.BeanCreationException;

public final class BeanUtils {
    @SafeVarargs
    public static <T> T chooseNotNullData(T ... args) {
        int curIndex = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            curIndex = i;
        }
        return args[curIndex];
    }

    public static <T> T copyProperties(Object source, Class<T> targetClass) {
        try {
            T parent = targetClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            org.springframework.beans.BeanUtils.copyProperties((Object)source, parent);
            return parent;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new BeanCreationException("creating failed", (Throwable)e);
        }
    }

    public static <T> void overwriteNullProperties(T target, T data) {
        ArrayList<String> nullProperties = new ArrayList<String>();
        for (PropertyDescriptor descriptor : BeanUtils.getPropertyDescriptors(target.getClass())) {
            try {
                if (descriptor.getReadMethod() == null || descriptor.getWriteMethod() == null || descriptor.getReadMethod().invoke(target, new Object[0]) == null) continue;
                nullProperties.add(descriptor.getName());
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        org.springframework.beans.BeanUtils.copyProperties(data, target, (String[])nullProperties.toArray(new String[0]));
    }

    @Nullable
    public static String getterToSetter(@Nonnull String getter) {
        if (getter.startsWith("get")) {
            return getter.replaceFirst("g", "s");
        }
        if (getter.startsWith("is")) {
            return String.valueOf(getter.charAt(2)).toLowerCase() + getter.substring(3);
        }
        return null;
    }

    public static <T, R> R applyNonnull(T target, Function<T, R> function) {
        return target != null ? (R)function.apply(target) : null;
    }

    public static <T> Optional<T> checkNullOrZero(T value) {
        if (value == null || "0".equals(value.toString())) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public static String convertWordsWithDashToCamelCase(String fieldName) {
        StringBuilder newFieldName = new StringBuilder();
        for (char c : fieldName.toCharArray()) {
            if (c <= 'Z' && c >= 'A') {
                newFieldName.append("-").append((char)(c + 32));
                continue;
            }
            newFieldName.append(c);
        }
        return newFieldName.toString();
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class targetClass) {
        return org.springframework.beans.BeanUtils.getPropertyDescriptors((Class)targetClass);
    }

    public static PropertyDescriptor getPropertyDescriptor(Class targetClass, String propertyName) {
        return org.springframework.beans.BeanUtils.getPropertyDescriptor((Class)targetClass, (String)propertyName);
    }

    private static final class BeanCache {
        private static final Map<Class, PropertyDescriptor[]> BEAN_PROPERTIES_CACHE = new HashMap<Class, PropertyDescriptor[]>();

        private BeanCache() {
        }

        private static PropertyDescriptor[] cachedBeanInfo(Class clazz) {
            return BEAN_PROPERTIES_CACHE.computeIfAbsent(clazz, key -> {
                try {
                    BeanInfo beanInfo = Introspector.getBeanInfo(key);
                    return beanInfo.getPropertyDescriptors();
                }
                catch (IntrospectionException introspectionException) {
                    return null;
                }
            });
        }
    }
}

