/*
 * Decompiled with CFR 0.152.
 */
package net.cofcool.chaos.server.common.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.springframework.boot.DefaultApplicationArguments;

public class GenerateCode {
    private static final String PATCH_PATH = "patch";
    private static final String RESULT_PATH = "path";
    private static final String INPUT_CONFIG = "config";
    private BufferedReader reader;
    private String resultPath;
    private String patchPath;
    private String configPath;
    private Configuration configuration;

    public static void main(String[] args) throws IOException {
        DefaultApplicationArguments arguments = new DefaultApplicationArguments(args);
        GenerateCode generateCode = new GenerateCode((String)arguments.getOptionValues(RESULT_PATH).get(0), (String)arguments.getOptionValues(PATCH_PATH).get(0), (String)arguments.getOptionValues(INPUT_CONFIG).get(0));
        generateCode.generatePatch();
    }

    public GenerateCode(String resultPath, String patchPath, String configPath) throws IOException {
        this.resultPath = resultPath;
        this.patchPath = patchPath;
        this.configPath = configPath;
        this.setupConfigMap();
        this.reader = this.getBufferedReader(patchPath);
    }

    private void setupConfigMap() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        this.configuration = (Configuration)mapper.readValue(new File(this.configPath), Configuration.class);
    }

    public void generatePatch() throws IOException {
        File file = new File(this.resultPath);
        file.mkdirs();
        for (ConfigItem item : this.configuration.newItems) {
            this.reader = this.getBufferedReader(this.patchPath);
            this.replacePatch(item);
        }
    }

    private void replacePatch(ConfigItem configItem) throws IOException {
        String lineStr;
        StringBuilder newStrs = new StringBuilder();
        while ((lineStr = this.reader.readLine()) != null) {
            newStrs.append(this.replaceStr(lineStr, configItem)).append("\n");
        }
        this.writePatch(newStrs.toString(), configItem.bean, this.resultPath);
    }

    private void writePatch(String string, String fileName, String patchPath) throws FileNotFoundException {
        FileOutputStream outputStream = new FileOutputStream(new File(patchPath + File.separator + fileName + ".patch"));
        PrintStream ps = new PrintStream(outputStream);
        ps.append(string);
        ps.close();
    }

    private BufferedReader getBufferedReader(String patchPath) throws FileNotFoundException {
        return new BufferedReader(new FileReader(new File(patchPath)));
    }

    private String replaceStr(String originStr, ConfigItem item) {
        return originStr.replace(this.configuration.origin.getPackageName(), item.getPackageName()).replace(this.configuration.origin.getBean(), item.getBean()).replace(this.configuration.origin.getBeanField(), item.getBean().toLowerCase()).replace(this.configuration.origin.getComment(), item.getComment());
    }

    public static class ConfigItem {
        private String packageName;
        private String bean;
        private String beanField;
        private String comment;

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getBean() {
            return this.bean;
        }

        public void setBean(String bean) {
            this.bean = bean;
        }

        public String getBeanField() {
            return this.beanField;
        }

        public void setBeanField(String beanField) {
            this.beanField = beanField;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }
    }

    public static class Configuration {
        private ConfigItem origin;
        private List<ConfigItem> newItems;

        public ConfigItem getOrigin() {
            return this.origin;
        }

        public void setOrigin(ConfigItem origin) {
            this.origin = origin;
        }

        public List<ConfigItem> getNewItems() {
            return this.newItems;
        }

        public void setNewItems(List<ConfigItem> newItems) {
            this.newItems = newItems;
        }
    }
}

