/*
 * Decompiled with CFR 0.152.
 */
package net.cofcool.chaos.server.common.util;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.cofcool.chaos.server.common.util.BeanUtils;
import net.cofcool.chaos.server.common.util.StringUtils;
import org.springframework.core.env.PropertyResolver;

public class PropertiesUtils {
    private static final Map<String, Properties> PROPERTIES_MAP = new HashMap<String, Properties>(4);

    private static Properties load(String fileName) {
        try {
            Properties properties = new Properties();
            properties.load(PropertiesUtils.class.getClassLoader().getResourceAsStream(fileName));
            return properties;
        }
        catch (IOException ignore) {
            throw new NullPointerException();
        }
    }

    public static Properties getConfigProperties(String fileName) {
        return PROPERTIES_MAP.computeIfAbsent(fileName, PropertiesUtils::load);
    }

    public static String getConfigProperty(String key) {
        for (Map.Entry<String, Properties> e : PROPERTIES_MAP.entrySet()) {
            String v = e.getValue().getProperty(key);
            if (StringUtils.isNullOrEmpty(v)) continue;
            return v;
        }
        return "";
    }

    public static String getConfigProperty(String fileName, String key) {
        return PropertiesUtils.getConfigProperties(fileName).getProperty(key);
    }

    public static <T> T parseProperties(PropertyResolver properties, String rootKey, Class<T> clazz) {
        try {
            T instance = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            PropertiesUtils.parseProperties(instance, new SResolver(properties), rootKey);
            return instance;
        }
        catch (Exception ignore) {
            throw new IllegalArgumentException();
        }
    }

    public static <T> T parseProperties(Properties properties, String rootKey, Class<T> clazz) {
        try {
            T instance = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            PropertiesUtils.parseProperties(instance, new PResolver(properties), rootKey);
            return instance;
        }
        catch (Exception ignore) {
            throw new IllegalArgumentException();
        }
    }

    private static void parseProperties(Object instance, Resolver properties, String rootKey) throws IllegalAccessException, InvocationTargetException {
        PropertyDescriptor[] pds;
        for (PropertyDescriptor pd : pds = BeanUtils.getPropertyDescriptors(instance.getClass())) {
            if (pd.getWriteMethod() == null || pd.getWriteMethod() == null) continue;
            String fieldKey = rootKey + "." + BeanUtils.convertWordsWithDashToCamelCase(pd.getName());
            if (pd.getPropertyType().equals(String.class)) {
                pd.getWriteMethod().invoke(instance, properties.getProperty(fieldKey, ""));
                continue;
            }
            PropertiesUtils.parseProperties(pd.getReadMethod().invoke(instance, new Object[0]), properties, fieldKey);
        }
    }

    static class SResolver
    implements Resolver {
        private PropertyResolver properties;

        public SResolver(PropertyResolver properties) {
            this.properties = properties;
        }

        @Override
        public String getProperty(String key) {
            return this.properties.getProperty(key);
        }

        @Override
        public String getProperty(String key, String defaultValue) {
            return this.properties.getProperty(key, defaultValue);
        }
    }

    static class PResolver
    implements Resolver {
        private Properties properties;

        public PResolver(Properties properties) {
            this.properties = properties;
        }

        @Override
        public String getProperty(String key) {
            return this.properties.getProperty(key);
        }

        @Override
        public String getProperty(String key, String defaultValue) {
            return this.properties.getProperty(key, defaultValue);
        }
    }

    static interface Resolver {
        public String getProperty(String var1);

        public String getProperty(String var1, String var2);
    }
}

