/*
 * Decompiled with CFR 0.152.
 */
package net.cofcool.chaos.server.common.util;

import java.util.Enumeration;
import javax.annotation.Nullable;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.cofcool.chaos.server.common.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.DispatcherServlet;

public final class WebUtils {
    public static HttpServletRequest getRequest() {
        ServletRequestAttributes attrs = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return attrs.getRequest();
    }

    public static HttpSession getSession() {
        HttpServletRequest request = WebUtils.getRequest();
        return request.getSession();
    }

    public static String getRequestUri() {
        HttpServletRequest httpServletRequest = WebUtils.getRequest();
        return httpServletRequest.getRequestURI();
    }

    public static String getRequestPath() {
        HttpServletRequest httpServletRequest = WebUtils.getRequest();
        StringBuilder builder = new StringBuilder();
        String scheme = httpServletRequest.getScheme();
        String serverName = httpServletRequest.getServerName();
        int serverPort = httpServletRequest.getServerPort();
        String requestURI = httpServletRequest.getRequestURI();
        builder.append(scheme);
        builder.append("://");
        builder.append(serverName);
        builder.append(":");
        builder.append(serverPort);
        builder.append(requestURI);
        Enumeration parameterNames = httpServletRequest.getParameterNames();
        boolean hasMoreElements = parameterNames.hasMoreElements();
        if (hasMoreElements) {
            builder.append("?");
        }
        while (parameterNames.hasMoreElements()) {
            String element = (String)parameterNames.nextElement();
            builder.append(element);
            builder.append("=");
            builder.append(httpServletRequest.getParameter(element));
            builder.append("&");
        }
        String str = builder.toString();
        if (hasMoreElements) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static String getIp(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (!StringUtils.isNullOrEmpty(ip) && !"unKnown".equalsIgnoreCase(ip)) {
            int index = ip.indexOf(",");
            if (index != -1) {
                return ip.substring(0, index);
            }
            return ip;
        }
        ip = request.getHeader("X-Real-IP");
        if (!StringUtils.isNullOrEmpty(ip) && !"unKnown".equalsIgnoreCase(ip)) {
            return ip;
        }
        return request.getRemoteAddr();
    }

    public static String getRealRequestPath(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        if (StringUtils.length(pathInfo) > 0) {
            servletPath = servletPath + pathInfo;
        }
        return servletPath;
    }

    public static WebApplicationContext getWebContext() {
        return (WebApplicationContext)WebUtils.getRequest().getAttribute(DispatcherServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE);
    }

    public static ServletResponse setupCorsHeader(HttpServletResponse servletResponse) {
        return WebUtils.setupCorsHeader(servletResponse, null);
    }

    public static ServletResponse setupCorsHeader(HttpServletResponse servletResponse, @Nullable String allowedDomain) {
        allowedDomain = allowedDomain != null ? allowedDomain : "*";
        servletResponse.setHeader("Access-Control-Allow-Origin", allowedDomain);
        servletResponse.setHeader("Access-Control-Allow-Headers", "Origin, No-Cache, X-Requested-With, If-Modified-Since, Pragma, Last-Modified, Cache-Control, Expires, Content-Type, Authorization");
        servletResponse.setHeader("Access-Control-Allow-Methods", "GET, POST, HEAD, OPTIONS");
        servletResponse.setHeader("Access-Control-ALLOW-Credentials", "true");
        servletResponse.setHeader("Access-Control-Max-Age", "43200");
        return servletResponse;
    }
}

