/*
 * Decompiled with CFR 0.152.
 */
package net.cst.zap.reporting;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.cst.zap.api.report.ZapReport;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ZapReportParser {
    public static final String RISKCODE = "riskcode";

    public int getHighestRiskCode(ZapReport report) {
        try {
            return this.getHighestRiskCode(report.getXmlReportAsString());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getHighestRiskCode(String xmlReport) throws ParserConfigurationException, SAXException, IOException {
        int highestFoundRiskCode = 0;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setCoalescing(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(xmlReport)));
        NodeList riskCodes = document.getElementsByTagName(RISKCODE);
        for (int i = 0; i < riskCodes.getLength(); ++i) {
            int riskCode = Integer.parseInt(riskCodes.item(i).getTextContent());
            if (riskCode <= highestFoundRiskCode) continue;
            highestFoundRiskCode = riskCode;
        }
        return highestFoundRiskCode;
    }
}

