/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.application.crypto;

import java.util.Objects;
import net.corda.v5.application.crypto.DigitalSignatureMetadata;
import net.corda.v5.base.annotations.ConstructorForDeserialization;
import net.corda.v5.base.annotations.CordaSerializable;
import net.corda.v5.crypto.DigitalSignature;
import net.corda.v5.crypto.SecureHash;
import net.corda.v5.crypto.merkle.MerkleProof;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CordaSerializable
public final class DigitalSignatureAndMetadata {
    private final DigitalSignature.WithKeyId signature;
    private final DigitalSignatureMetadata metadata;
    private final MerkleProof proof;

    private static void requireNotNull(@Nullable Object obj, @NotNull String message) {
        if (obj == null) {
            throw new IllegalArgumentException(message);
        }
    }

    @ConstructorForDeserialization
    public DigitalSignatureAndMetadata(@NotNull DigitalSignature.WithKeyId signature, @NotNull DigitalSignatureMetadata metadata, @Nullable MerkleProof proof) {
        DigitalSignatureAndMetadata.requireNotNull(signature, "signature must not be null");
        DigitalSignatureAndMetadata.requireNotNull(metadata, "metadata must not be null");
        this.signature = signature;
        this.metadata = metadata;
        this.proof = proof;
    }

    public DigitalSignatureAndMetadata(@NotNull DigitalSignature.WithKeyId signature, @NotNull DigitalSignatureMetadata metadata) {
        this(signature, metadata, null);
    }

    @NotNull
    public DigitalSignature.WithKeyId getSignature() {
        return this.signature;
    }

    @NotNull
    public DigitalSignatureMetadata getMetadata() {
        return this.metadata;
    }

    @Nullable
    public MerkleProof getProof() {
        return this.proof;
    }

    @NotNull
    public SecureHash getBy() {
        return this.signature.getBy();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DigitalSignatureAndMetadata)) {
            return false;
        }
        DigitalSignatureAndMetadata other = (DigitalSignatureAndMetadata)obj;
        return this.signature.equals(other.signature) && this.metadata.equals(other.metadata) && Objects.equals(this.proof, other.proof);
    }

    public int hashCode() {
        return Objects.hash(this.signature, this.metadata, this.proof);
    }

    @NotNull
    public String toString() {
        return "DigitalSignatureAndMetadata[signature=" + this.signature + ", metadata=" + this.metadata + ", proof=" + this.proof + "]";
    }
}

