/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.application.crypto;

import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import net.corda.v5.base.annotations.CordaSerializable;
import net.corda.v5.crypto.SignatureSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CordaSerializable
public final class DigitalSignatureMetadata {
    private final Instant timestamp;
    private final SignatureSpec signatureSpec;
    private final Map<String, String> properties;

    private static void requireNotNull(@Nullable Object obj, @NotNull String message) {
        if (obj == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public DigitalSignatureMetadata(@NotNull Instant timestamp, @NotNull SignatureSpec signatureSpec, @NotNull Map<String, String> properties) {
        DigitalSignatureMetadata.requireNotNull(timestamp, "timestamp should not be null");
        DigitalSignatureMetadata.requireNotNull(signatureSpec, "signatureSpec should not be null");
        DigitalSignatureMetadata.requireNotNull(properties, "properties should not be null");
        this.timestamp = timestamp;
        this.signatureSpec = signatureSpec;
        this.properties = Collections.unmodifiableMap(properties);
    }

    @NotNull
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public SignatureSpec getSignatureSpec() {
        return this.signatureSpec;
    }

    @NotNull
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DigitalSignatureMetadata)) {
            return false;
        }
        DigitalSignatureMetadata other = (DigitalSignatureMetadata)obj;
        return this.timestamp.equals(other.timestamp) && this.signatureSpec.equals(other.signatureSpec) && this.properties.equals(other.properties);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.signatureSpec, this.properties);
    }

    @NotNull
    public String toString() {
        return "DigitalSignatureMetadata[timestamp=" + this.timestamp + ", signatureSpec=" + this.signatureSpec + ", properties=" + this.properties + "]";
    }
}

