/*
 * Decompiled with CFR 0.152.
 */
package net.corda.common.logging.errorReporting;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.common.logging.errorReporting.DoubleInitializationException;
import net.corda.common.logging.errorReporting.ErrorContextProvider;
import net.corda.common.logging.errorReporting.ErrorReporter;
import net.corda.common.logging.errorReporting.ErrorReporterImpl;
import net.corda.common.logging.errorReporting.LocaleSettingUnsupportedException;
import net.corda.common.logging.errorReporting.NoContextProviderSuppliedException;
import net.corda.common.logging.errorReporting.ReportingUninitializedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B!\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\r\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0004R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnet/corda/common/logging/errorReporting/ErrorReporting;", "", "()V", "localeString", "", "resourceLocation", "contextProvider", "Lnet/corda/common/logging/errorReporting/ErrorContextProvider;", "(Ljava/lang/String;Ljava/lang/String;Lnet/corda/common/logging/errorReporting/ErrorContextProvider;)V", "getReporter", "Lnet/corda/common/logging/errorReporting/ErrorReporter;", "getReporter$common_logging", "initialiseReporting", "", "usingResourcesAt", "location", "withContextProvider", "withLocale", "locale", "Companion", "common-logging"})
public final class ErrorReporting {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final String localeString;
    @NotNull
    private final String resourceLocation;
    @Nullable
    private final ErrorContextProvider contextProvider;
    @NotNull
    private static final String DEFAULT_LOCALE = "en-US";
    @NotNull
    private static final String DEFAULT_LOCATION = ".";
    @Nullable
    private static ErrorReporter errorReporter;

    private ErrorReporting(String localeString, String resourceLocation, ErrorContextProvider contextProvider) {
        this.localeString = localeString;
        this.resourceLocation = resourceLocation;
        this.contextProvider = contextProvider;
    }

    public ErrorReporting() {
        this(DEFAULT_LOCALE, DEFAULT_LOCATION, null);
    }

    @NotNull
    public final ErrorReporting withLocale(@NotNull String locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        throw new LocaleSettingUnsupportedException();
    }

    @NotNull
    public final ErrorReporting usingResourcesAt(@NotNull String location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return new ErrorReporting(this.localeString, location, this.contextProvider);
    }

    @NotNull
    public final ErrorReporting withContextProvider(@NotNull ErrorContextProvider contextProvider) {
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        return new ErrorReporting(this.localeString, this.resourceLocation, contextProvider);
    }

    public final void initialiseReporting() {
        if (this.contextProvider == null) {
            throw new NoContextProviderSuppliedException();
        }
        if (errorReporter != null) {
            throw new DoubleInitializationException();
        }
        Locale locale = Locale.forLanguageTag(this.localeString);
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"forLanguageTag(...)");
        errorReporter = new ErrorReporterImpl(this.resourceLocation, locale, this.contextProvider);
    }

    @NotNull
    public final ErrorReporter getReporter$common_logging() {
        ErrorReporter errorReporter = ErrorReporting.errorReporter;
        if (errorReporter == null) {
            throw new ReportingUninitializedException();
        }
        return errorReporter;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lnet/corda/common/logging/errorReporting/ErrorReporting$Companion;", "", "()V", "DEFAULT_LOCALE", "", "DEFAULT_LOCATION", "errorReporter", "Lnet/corda/common/logging/errorReporting/ErrorReporter;", "common-logging"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

