/*
 * Decompiled with CFR 0.152.
 */
package net.corda.common.logging.errorReporting;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.common.logging.errorReporting.ErrorCode;
import net.corda.common.logging.errorReporting.ErrorReportingUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J#\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0019\u0010\u0014\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0019"}, d2={"Lnet/corda/common/logging/errorReporting/ErrorResource;", "", "bundle", "Ljava/util/ResourceBundle;", "locale", "Ljava/util/Locale;", "(Ljava/util/ResourceBundle;Ljava/util/Locale;)V", "actionsToFix", "", "getActionsToFix", "()Ljava/lang/String;", "aliases", "getAliases", "shortDescription", "getShortDescription", "formatTemplate", "template", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getErrorMessage", "([Ljava/lang/Object;)Ljava/lang/String;", "getProperty", "propertyName", "Companion", "common-logging"})
public final class ErrorResource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceBundle bundle;
    @NotNull
    private final Locale locale;
    @NotNull
    private final String shortDescription;
    @NotNull
    private final String actionsToFix;
    @NotNull
    private final String aliases;

    private ErrorResource(ResourceBundle bundle, Locale locale) {
        this.bundle = bundle;
        this.locale = locale;
        this.shortDescription = this.getProperty("shortDescription");
        this.actionsToFix = this.getProperty("actionsToFix");
        this.aliases = this.getProperty("aliases");
    }

    private final String getProperty(String propertyName) {
        String string = this.bundle.getString(propertyName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    private final String formatTemplate(String template, Object[] args) {
        MessageFormat formatter = new MessageFormat(template, this.locale);
        String string = formatter.format(args);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public final String getErrorMessage(@NotNull Object[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String template = this.getProperty("errorTemplate");
        return this.formatTemplate(template, args);
    }

    @NotNull
    public final String getShortDescription() {
        return this.shortDescription;
    }

    @NotNull
    public final String getActionsToFix() {
        return this.actionsToFix;
    }

    @NotNull
    public final String getAliases() {
        return this.aliases;
    }

    public /* synthetic */ ErrorResource(ResourceBundle bundle, Locale locale, DefaultConstructorMarker $constructor_marker) {
        this(bundle, locale);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000f"}, d2={"Lnet/corda/common/logging/errorReporting/ErrorResource$Companion;", "", "()V", "fromErrorCode", "Lnet/corda/common/logging/errorReporting/ErrorResource;", "errorCode", "Lnet/corda/common/logging/errorReporting/ErrorCode;", "resourceLocation", "", "locale", "Ljava/util/Locale;", "fromLoader", "resource", "classLoader", "Ljava/lang/ClassLoader;", "common-logging"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ErrorResource fromErrorCode(@NotNull ErrorCode<?> errorCode2, @NotNull String resourceLocation, @NotNull Locale locale) {
            Intrinsics.checkNotNullParameter(errorCode2, (String)"errorCode");
            Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"resourceLocation");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            String resource = resourceLocation + "/" + ErrorReportingUtilsKt.formatCode(errorCode2);
            ResourceBundle bundle = ResourceBundle.getBundle(resource, locale);
            Intrinsics.checkNotNull((Object)bundle);
            return new ErrorResource(bundle, locale, null);
        }

        @NotNull
        public final ErrorResource fromLoader(@NotNull String resource, @NotNull ClassLoader classLoader, @NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            ResourceBundle bundle = ResourceBundle.getBundle(resource, locale, classLoader);
            Intrinsics.checkNotNull((Object)bundle);
            return new ErrorResource(bundle, locale, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

