/*
 * Decompiled with CFR 0.152.
 */
package net.corda.common.logging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.corda.common.logging.CompositeMessage;
import net.corda.common.logging.CordaVersion;
import net.corda.common.logging.ExceptionsErrorCodeFunctionsKt;
import net.corda.common.logging.ExceptionsErrorCodeFunctionsKt$withErrorCodeFor$message$1;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.message.Message;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u001e\b\u0002\u0010\u0003\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u00050\u0004H\u0002\u001a#\u0010\u0000\u001a\u00020\u0001*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\b\u001a\u001b\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u0005*\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010\n\u001a\u001b\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u0005*\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\f\u001a*\u0010\r\u001a\u00020\u000e*\u00020\u000b2\u001e\b\u0002\u0010\u0003\u001a\u0018\u0012\u0004\u0012\u00020\u000b\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u00050\u0004\u001a\n\u0010\u000f\u001a\u00020\u000e*\u00020\u000b\u001a:\u0010\u0010\u001a\u00020\u0001*\u00020\u000b2\u001c\u0010\u0003\u001a\u0018\u0012\u0004\u0012\u00020\u000b\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u00050\u00042\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0002\u001a\u0014\u0010\u0013\u001a\u00020\u000e*\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016*\u00020\u000b\u001a\u001c\u0010\u0017\u001a\u00020\u0018*\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u001b\u00a8\u0006\u001c"}, d2={"customHashCode", "", "Ljava/lang/StackTraceElement;", "hashedFields", "Lkotlin/Function1;", "", "", "maxElementsToConsider", "([Ljava/lang/StackTraceElement;I)I", "defaultHashedFields", "(Ljava/lang/StackTraceElement;)[Ljava/lang/Object;", "", "(Ljava/lang/Throwable;)[Ljava/lang/Object;", "errorCode", "", "errorCodeLocationUrl", "staticLocationBasedHash", "visited", "", "toBase", "base", "walkExceptionCausedByList", "", "withErrorCodeFor", "Lorg/apache/logging/log4j/message/Message;", "error", "level", "Lorg/apache/logging/log4j/Level;", "common-logging"})
public final class ExceptionsErrorCodeFunctionsKt {
    @NotNull
    public static final Iterator<Throwable> walkExceptionCausedByList(@NotNull Throwable $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Throwable self = $receiver;
        return new Iterator<Throwable>(self){
            private Throwable cursor;
            private final Set<Throwable> knownThrowables;
            final /* synthetic */ Throwable $self;

            public boolean hasNext() {
                return this.cursor != null;
            }

            @NotNull
            public Throwable next() {
                Throwable result = this.cursor;
                Throwable throwable = this.cursor;
                Throwable cause = throwable != null ? throwable.getCause() : null;
                this.cursor = cause != null && this.knownThrowables.add(cause) ? cause : null;
                Throwable throwable2 = result;
                if (throwable2 == null) {
                    Intrinsics.throwNpe();
                }
                return throwable2;
            }
            {
                Set set;
                this.$self = $captured_local_variable$0;
                this.cursor = $captured_local_variable$0;
                walkExceptionCausedByList.1 var2_2 = this;
                var2_2.knownThrowables = set = (Set)new LinkedHashSet<E>();
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @NotNull
    public static final Message withErrorCodeFor(@NotNull Message $receiver, @Nullable Throwable error, @NotNull Level level) {
        Message message2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)level, (String)"level");
        if (error != null && level.isInRange(Level.FATAL, Level.WARN)) {
            String logMessage = $receiver.getFormattedMessage();
            String message3 = SequencesKt.joinToString$default((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.asSequence(ExceptionsErrorCodeFunctionsKt.walkExceptionCausedByList(error)), (Function1)((Function1)ExceptionsErrorCodeFunctionsKt$withErrorCodeFor$message$1.INSTANCE)), (CharSequence)" - ", null, null, (int)0, null, null, (int)62, null);
            message2 = (Message)new CompositeMessage(logMessage + " - " + message3 + " [errorCode=" + ExceptionsErrorCodeFunctionsKt.errorCode$default(error, null, 1, null) + ", moreInformationAt=" + ExceptionsErrorCodeFunctionsKt.errorCodeLocationUrl(error) + ']', $receiver.getFormat(), $receiver.getParameters(), $receiver.getThrowable());
        } else {
            message2 = $receiver;
        }
        return message2;
    }

    @NotNull
    public static final String errorCodeLocationUrl(@NotNull Throwable $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return "https://errors.corda.net/OS/" + CordaVersion.Companion.getSemanticVersion$common_logging() + '/' + ExceptionsErrorCodeFunctionsKt.errorCode$default($receiver, null, 1, null);
    }

    @NotNull
    public static final String errorCode(@NotNull Throwable $receiver, @NotNull Function1<? super Throwable, ? extends Object[]> hashedFields) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(hashedFields, (String)"hashedFields");
        int hash = ExceptionsErrorCodeFunctionsKt.staticLocationBasedHash$default($receiver, hashedFields, null, 2, null);
        return ExceptionsErrorCodeFunctionsKt.toBase(hash, 36);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String errorCode$default(Throwable throwable, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = errorCode.1.INSTANCE;
        }
        return ExceptionsErrorCodeFunctionsKt.errorCode(throwable, (Function1<? super Throwable, ? extends Object[]>)function1);
    }

    private static final int staticLocationBasedHash(@NotNull Throwable $receiver, Function1<? super Throwable, ? extends Object[]> hashedFields, Set<? extends Throwable> visited) {
        int n;
        Throwable cause = $receiver.getCause();
        Object[] fields = (Object[])hashedFields.invoke((Object)$receiver);
        if (cause != null && !visited.contains(cause)) {
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.addSpread((Object)fields);
            spreadBuilder.add((Object)ExceptionsErrorCodeFunctionsKt.staticLocationBasedHash(cause, hashedFields, SetsKt.plus(visited, (Object)cause)));
            n = Objects.hash(spreadBuilder.toArray(new Object[spreadBuilder.size()]));
        } else {
            n = Objects.hash(Arrays.copyOf(fields, fields.length));
        }
        return n;
    }

    static /* bridge */ /* synthetic */ int staticLocationBasedHash$default(Throwable throwable, Function1 function1, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.setOf((Object)throwable);
        }
        return ExceptionsErrorCodeFunctionsKt.staticLocationBasedHash(throwable, (Function1<? super Throwable, ? extends Object[]>)function1, set);
    }

    private static final String toBase(int $receiver, int base) {
        String string = Integer.toUnsignedString($receiver, base);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Integer.toUnsignedString(this, base)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final int customHashCode(@NotNull StackTraceElement[] $receiver, int maxElementsToConsider) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)ArraysKt.take((Object[])$receiver, (int)maxElementsToConsider);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            StackTraceElement stackTraceElement = (StackTraceElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            void v0 = it;
            Integer n = v0 != null ? ExceptionsErrorCodeFunctionsKt.customHashCode$default((StackTraceElement)v0, null, 1, null) : 0;
            collection.add(n);
        }
        return Arrays.hashCode(CollectionsKt.toIntArray((Collection)((List)destination$iv$iv)));
    }

    static /* bridge */ /* synthetic */ int customHashCode$default(StackTraceElement[] stackTraceElementArray, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = stackTraceElementArray.length;
        }
        return ExceptionsErrorCodeFunctionsKt.customHashCode(stackTraceElementArray, n);
    }

    private static final int customHashCode(@NotNull StackTraceElement $receiver, Function1<? super StackTraceElement, ? extends Object[]> hashedFields) {
        Object[] objectArray = (Object[])hashedFields.invoke((Object)$receiver);
        return Objects.hash(Arrays.copyOf(objectArray, objectArray.length));
    }

    static /* bridge */ /* synthetic */ int customHashCode$default(StackTraceElement stackTraceElement, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = customHashCode.2.INSTANCE;
        }
        return ExceptionsErrorCodeFunctionsKt.customHashCode(stackTraceElement, (Function1<? super StackTraceElement, ? extends Object[]>)function1);
    }

    private static final Object[] defaultHashedFields(@NotNull Throwable $receiver) {
        Object[] objectArray = new Object[2];
        objectArray[0] = $receiver.getClass().getName();
        StackTraceElement[] stackTraceElementArray = $receiver.getStackTrace();
        objectArray[1] = stackTraceElementArray != null ? Integer.valueOf(ExceptionsErrorCodeFunctionsKt.customHashCode(stackTraceElementArray, 3)) : Integer.valueOf(0);
        return objectArray;
    }

    private static final Object[] defaultHashedFields(@NotNull StackTraceElement $receiver) {
        return new String[]{$receiver.getClassName(), $receiver.getMethodName()};
    }

    @NotNull
    public static final /* synthetic */ Object[] access$defaultHashedFields(@NotNull Throwable $receiver) {
        return ExceptionsErrorCodeFunctionsKt.defaultHashedFields($receiver);
    }

    @NotNull
    public static final /* synthetic */ Object[] access$defaultHashedFields(@NotNull StackTraceElement $receiver) {
        return ExceptionsErrorCodeFunctionsKt.defaultHashedFields($receiver);
    }
}

