/*
 * Decompiled with CFR 0.152.
 */
package net.corda.common.logging.errorReporting;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.corda.common.logging.errorReporting.ErrorCode;
import net.corda.common.logging.errorReporting.ErrorContextProvider;
import net.corda.common.logging.errorReporting.ErrorReporter;
import net.corda.common.logging.errorReporting.ErrorReportingUtilsKt;
import net.corda.common.logging.errorReporting.ErrorResource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ-\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\rH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0010\u001a\u00020\u00032\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J\u001c\u0010\u0013\u001a\u00020\u00142\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/corda/common/logging/errorReporting/ErrorReporterImpl;", "Lnet/corda/common/logging/errorReporting/ErrorReporter;", "resourceLocation", "", "locale", "Ljava/util/Locale;", "errorContextProvider", "Lnet/corda/common/logging/errorReporting/ErrorContextProvider;", "(Ljava/lang/String;Ljava/util/Locale;Lnet/corda/common/logging/errorReporting/ErrorContextProvider;)V", "fetchAndFormat", "resource", "property", "params", "", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getErrorInfo", "error", "Lnet/corda/common/logging/errorReporting/ErrorCode;", "report", "", "logger", "Lorg/slf4j/Logger;", "common-logging"})
public final class ErrorReporterImpl
implements ErrorReporter {
    private final String resourceLocation;
    private final Locale locale;
    private final ErrorContextProvider errorContextProvider;

    private final String fetchAndFormat(String resource, String property, Object[] params) {
        ResourceBundle bundle = ResourceBundle.getBundle(resource, this.locale);
        String template = bundle.getString(property);
        MessageFormat formatter = new MessageFormat(template, this.locale);
        String string = formatter.format(params);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"formatter.format(params)");
        return string;
    }

    private final String getErrorInfo(ErrorCode<?> error) {
        String resource = this.resourceLocation + "/ErrorInfo";
        String codeMessage = this.fetchAndFormat(resource, "errorCodeMessage", new String[]{ErrorReportingUtilsKt.formatCode(error)});
        String urlMessage = this.fetchAndFormat(resource, "errorCodeUrl", new String[]{this.errorContextProvider.getURL(this.locale)});
        return '[' + codeMessage + ' ' + urlMessage + ']';
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void report(@NotNull ErrorCode<?> error, @NotNull Logger logger) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(error, (String)"error");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        ErrorResource errorResource = ErrorResource.Companion.fromErrorCode(error, this.resourceLocation, this.locale);
        Collection collection = error.getParameters();
        ErrorResource errorResource2 = errorResource;
        StringBuilder stringBuilder = new StringBuilder();
        void v0 = $receiver$iv;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v0;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        if (objectArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray2 = objectArray;
        String message2 = stringBuilder.append(errorResource2.getErrorMessage(objectArray2)).append(' ').append(this.getErrorInfo(error)).toString();
        if (error instanceof Exception) {
            logger.error(message2, (Throwable)((Object)error));
        } else {
            logger.error(message2);
        }
    }

    public ErrorReporterImpl(@NotNull String resourceLocation, @NotNull Locale locale, @NotNull ErrorContextProvider errorContextProvider) {
        Intrinsics.checkParameterIsNotNull((Object)resourceLocation, (String)"resourceLocation");
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        Intrinsics.checkParameterIsNotNull((Object)errorContextProvider, (String)"errorContextProvider");
        this.resourceLocation = resourceLocation;
        this.locale = locale;
        this.errorContextProvider = errorContextProvider;
    }
}

