/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.crypto;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.v5.base.annotations.CordaSerializable;
import net.corda.v5.base.types.ByteArrays;
import net.corda.v5.base.types.ByteSequence;
import net.corda.v5.base.util.KotlinUtilsKt;
import net.corda.v5.crypto.CompositeKey;
import net.corda.v5.crypto.CryptoUtils;
import net.corda.v5.crypto.internal.CordaObjectIdentifier;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\n\u0018\u0000 )2\u00020\u0001:\u0003()*B\u001d\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0013J\u001c\u0010\u0018\u001a\u00020\u00132\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00110\u001aH\u0002J\u0013\u0010\u001b\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u001fH\u0016J\b\u0010#\u001a\u00020\u0003H\u0016J\u000e\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u0001J\u0014\u0010$\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016J\b\u0010&\u001a\u00020\u001fH\u0016J\b\u0010'\u001a\u00020\u0003H\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lnet/corda/v5/crypto/CompositeKey;", "Ljava/security/PublicKey;", "threshold", "", "children", "", "Lnet/corda/v5/crypto/CompositeKey$NodeAndWeight;", "(ILjava/util/List;)V", "getChildren", "()Ljava/util/List;", "leafKeys", "", "getLeafKeys", "()Ljava/util/Set;", "getThreshold", "()I", "validated", "", "checkConstraints", "", "checkFulfilledBy", "keysToCheck", "", "checkValidity", "cycleDetection", "visitedMap", "Ljava/util/IdentityHashMap;", "equals", "other", "", "getAlgorithm", "", "getEncoded", "", "getFormat", "hashCode", "isFulfilledBy", "key", "toString", "totalWeight", "Builder", "Companion", "NodeAndWeight", "crypto-api"})
public final class CompositeKey
implements PublicKey {
    @NotNull
    private final List<NodeAndWeight> children;
    private transient boolean validated;
    private final int threshold;
    @NotNull
    public static final String KEY_ALGORITHM = "COMPOSITE";
    private static final Comparator<NodeAndWeight> descWeightComparator;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final List<NodeAndWeight> getChildren() {
        return this.children;
    }

    private final void checkConstraints() {
        boolean bl = this.children.size() == CollectionsKt.toSet((Iterable)this.children).size();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "CompositeKey with duplicated child nodes detected.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.children.size() > 1;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "CompositeKey must consist of two or more child nodes.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.threshold > 0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "CompositeKey threshold is set to " + this.threshold + ", but it should be a positive integer.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int totalWeight = this.totalWeight();
        bl2 = this.threshold <= totalWeight;
        bl3 = false;
        boolean bl7 = false;
        if (!bl2) {
            boolean bl8 = false;
            String string = "CompositeKey threshold: " + this.threshold + " cannot be bigger than aggregated weight of child nodes: " + totalWeight;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    private final void cycleDetection(IdentityHashMap<CompositeKey, Boolean> visitedMap) {
        for (NodeAndWeight nodeAndWeight : this.children) {
            PublicKey node = nodeAndWeight.component1();
            if (!(node instanceof CompositeKey)) continue;
            IdentityHashMap<CompositeKey, Boolean> curVisitedMap = new IdentityHashMap<CompositeKey, Boolean>();
            curVisitedMap.putAll((Map)visitedMap);
            Map map = curVisitedMap;
            boolean bl = false;
            Map map2 = map;
            boolean bl2 = false;
            boolean bl3 = !map2.containsKey(node);
            bl = false;
            boolean bl4 = false;
            if (!bl3) {
                boolean bl5 = false;
                String string = "Cycle detected for CompositeKey";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            ((Map)curVisitedMap).put(node, true);
            ((CompositeKey)node).cycleDetection(curVisitedMap);
        }
    }

    public final void checkValidity() {
        if (this.validated) {
            return;
        }
        IdentityHashMap<CompositeKey, Boolean> visitedMap = new IdentityHashMap<CompositeKey, Boolean>();
        ((Map)visitedMap).put(this, true);
        this.cycleDetection(visitedMap);
        this.checkConstraints();
        for (NodeAndWeight nodeAndWeight : this.children) {
            PublicKey node = nodeAndWeight.component1();
            if (!(node instanceof CompositeKey)) continue;
            ((CompositeKey)node).checkConstraints();
        }
        this.validated = true;
    }

    private final int totalWeight() {
        int sum = 0;
        for (NodeAndWeight nodeAndWeight : this.children) {
            int weight = nodeAndWeight.component2();
            boolean bl = weight > 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Non-positive weight: " + weight + " detected.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            sum = KotlinUtilsKt.exactAdd((int)sum, (int)weight);
        }
        return sum;
    }

    public final boolean isFulfilledBy(@NotNull PublicKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.isFulfilledBy(SetsKt.setOf((Object)key));
    }

    @Override
    @NotNull
    public String getAlgorithm() {
        return KEY_ALGORITHM;
    }

    @Override
    @NotNull
    public byte[] getEncoded() {
        ASN1EncodableVector keyVector = new ASN1EncodableVector();
        ASN1EncodableVector childrenVector = new ASN1EncodableVector();
        Iterable $this$forEach$iv = this.children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NodeAndWeight it = (NodeAndWeight)element$iv;
            boolean bl = false;
            childrenVector.add((ASN1Encodable)it.toASN1Primitive());
        }
        keyVector.add((ASN1Encodable)new ASN1Integer((long)this.threshold));
        keyVector.add((ASN1Encodable)new DERSequence(childrenVector));
        byte[] byArray = new SubjectPublicKeyInfo(new AlgorithmIdentifier(CordaObjectIdentifier.COMPOSITE_KEY), (ASN1Encodable)new DERSequence(keyVector)).getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"SubjectPublicKeyInfo(Alg\u2026uence(keyVector)).encoded");
        return byArray;
    }

    @Override
    @NotNull
    public String getFormat() {
        return "DER";
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkFulfilledBy(Iterable<? extends PublicKey> keysToCheck) {
        int totalWeight = 0;
        Iterable $this$forEach$iv = this.children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void node;
            NodeAndWeight $dstr$node$weight = (NodeAndWeight)element$iv;
            boolean bl = false;
            PublicKey publicKey = $dstr$node$weight.component1();
            int weight = $dstr$node$weight.component2();
            if (node instanceof CompositeKey) {
                if (((CompositeKey)node).checkFulfilledBy(keysToCheck)) {
                    totalWeight += weight;
                }
            } else if (CollectionsKt.contains(keysToCheck, (Object)node)) {
                totalWeight += weight;
            }
            if (totalWeight < this.threshold) continue;
            return true;
        }
        return false;
    }

    public final boolean isFulfilledBy(@NotNull Iterable<? extends PublicKey> keysToCheck) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(keysToCheck, (String)"keysToCheck");
            this.checkValidity();
            Iterable<? extends PublicKey> $this$any$iv = keysToCheck;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator<? extends PublicKey> iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    PublicKey element$iv;
                    PublicKey it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!(it instanceof CompositeKey)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        return this.checkFulfilledBy(keysToCheck);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<PublicKey> getLeafKeys() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.children;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            NodeAndWeight it = (NodeAndWeight)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = CryptoUtils.getKeys(it.getNode());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CompositeKey)) {
            return false;
        }
        if (this.threshold != ((CompositeKey)other).threshold) {
            return false;
        }
        return !(Intrinsics.areEqual(this.children, ((CompositeKey)other).children) ^ true);
    }

    public int hashCode() {
        int result = this.threshold;
        result = 31 * result + ((Object)this.children).hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return '(' + CollectionsKt.joinToString$default((Iterable)this.children, null, null, null, (int)0, null, null, (int)63, null) + ')';
    }

    public final int getThreshold() {
        return this.threshold;
    }

    private CompositeKey(int threshold, List<NodeAndWeight> children) {
        this.threshold = threshold;
        this.children = CollectionsKt.sortedWith((Iterable)children, descWeightComparator);
        this.checkConstraints();
    }

    static {
        Companion = new Companion(null);
        descWeightComparator = ComparisonsKt.compareBy((Function1[])new Function1[]{Companion.descWeightComparator.1.INSTANCE, Companion.descWeightComparator.2.INSTANCE});
    }

    public /* synthetic */ CompositeKey(int threshold, List children, DefaultConstructorMarker $constructor_marker) {
        this(threshold, children);
    }

    @CordaSerializable
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u000e\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lnet/corda/v5/crypto/CompositeKey$NodeAndWeight;", "", "Lorg/bouncycastle/asn1/ASN1Object;", "node", "Ljava/security/PublicKey;", "weight", "", "(Ljava/security/PublicKey;I)V", "getNode", "()Ljava/security/PublicKey;", "getWeight", "()I", "compareTo", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toASN1Primitive", "Lorg/bouncycastle/asn1/ASN1Primitive;", "toString", "", "crypto-api"})
    public static final class NodeAndWeight
    extends ASN1Object
    implements Comparable<NodeAndWeight> {
        @NotNull
        private final PublicKey node;
        private final int weight;

        @Override
        public int compareTo(@NotNull NodeAndWeight other) {
            int n;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (this.weight == other.weight) {
                byte[] byArray = this.node.getEncoded();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"node.encoded");
                ByteSequence byteSequence = ByteArrays.sequence$default((byte[])byArray, (int)0, (int)0, (int)3, null);
                byte[] byArray2 = other.node.getEncoded();
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"other.node.encoded");
                n = byteSequence.compareTo(ByteArrays.sequence$default((byte[])byArray2, (int)0, (int)0, (int)3, null));
            } else {
                n = Intrinsics.compare((int)this.weight, (int)other.weight);
            }
            return n;
        }

        @NotNull
        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)new DERBitString(this.node.getEncoded()));
            vector.add((ASN1Encodable)new ASN1Integer((long)this.weight));
            return (ASN1Primitive)new DERSequence(vector);
        }

        @NotNull
        public String toString() {
            return "Public key: " + CryptoUtils.toStringShort(this.node) + ", weight: " + this.weight;
        }

        @NotNull
        public final PublicKey getNode() {
            return this.node;
        }

        public final int getWeight() {
            return this.weight;
        }

        public NodeAndWeight(@NotNull PublicKey node, int weight) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.node = node;
            this.weight = weight;
            boolean bl = this.weight > 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "A non-positive weight was detected. Member info: " + this;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final PublicKey component1() {
            return this.node;
        }

        public final int component2() {
            return this.weight;
        }

        @NotNull
        public final NodeAndWeight copy(@NotNull PublicKey node, int weight) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return new NodeAndWeight(node, weight);
        }

        public static /* synthetic */ NodeAndWeight copy$default(NodeAndWeight nodeAndWeight, PublicKey publicKey, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                publicKey = nodeAndWeight.node;
            }
            if ((n2 & 2) != 0) {
                n = nodeAndWeight.weight;
            }
            return nodeAndWeight.copy(publicKey, n);
        }

        public int hashCode() {
            PublicKey publicKey = this.node;
            return (publicKey != null ? publicKey.hashCode() : 0) * 31 + Integer.hashCode(this.weight);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof NodeAndWeight)) break block3;
                    NodeAndWeight nodeAndWeight = (NodeAndWeight)object;
                    if (!Intrinsics.areEqual((Object)this.node, (Object)nodeAndWeight.node) || this.weight != nodeAndWeight.weight) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nJ\u001f\u0010\u000b\u001a\u00020\u00002\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\r\"\u00020\b\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u000b\u001a\u00020\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u000fJ\u0006\u0010\u0010\u001a\u00020\bJ\u0015\u0010\u0010\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0012R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnet/corda/v5/crypto/CompositeKey$Builder;", "", "()V", "children", "", "Lnet/corda/v5/crypto/CompositeKey$NodeAndWeight;", "addKey", "key", "Ljava/security/PublicKey;", "weight", "", "addKeys", "keys", "", "([Ljava/security/PublicKey;)Lnet/corda/v5/crypto/CompositeKey$Builder;", "", "build", "threshold", "(Ljava/lang/Integer;)Ljava/security/PublicKey;", "crypto-api"})
    public static final class Builder {
        private final List<NodeAndWeight> children;

        @NotNull
        public final Builder addKey(@NotNull PublicKey key, int weight) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.children.add(new NodeAndWeight(key, weight));
            return this;
        }

        public static /* synthetic */ Builder addKey$default(Builder builder, PublicKey publicKey, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 1;
            }
            return builder.addKey(publicKey, n);
        }

        @NotNull
        public final Builder addKeys(PublicKey ... keys) {
            Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
            PublicKey[] $this$forEach$iv = keys;
            boolean $i$f$forEach = false;
            PublicKey[] publicKeyArray = $this$forEach$iv;
            int n = publicKeyArray.length;
            for (int i = 0; i < n; ++i) {
                PublicKey element$iv;
                PublicKey it = element$iv = publicKeyArray[i];
                boolean bl = false;
                Builder.addKey$default(this, it, 0, 2, null);
            }
            return this;
        }

        @NotNull
        public final Builder addKeys(@NotNull List<? extends PublicKey> keys) {
            Intrinsics.checkNotNullParameter(keys, (String)"keys");
            Collection $this$toTypedArray$iv = keys;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            PublicKey[] publicKeyArray = thisCollection$iv.toArray(new PublicKey[0]);
            if (publicKeyArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return this.addKeys(Arrays.copyOf(publicKeyArray, publicKeyArray.length));
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final PublicKey build(@Nullable Integer threshold) {
            block8: {
                block9: {
                    block7: {
                        var2_2 = threshold == null || threshold > 0;
                        var3_3 = 0;
                        var4_5 = false;
                        if (!var2_2) {
                            $i$a$-require-CompositeKey$Builder$build$1 = false;
                            var4_6 = "Threshold must not be specified or its value must be greater than zero";
                            throw (Throwable)new IllegalArgumentException(var4_6.toString());
                        }
                        n = this.children.size();
                        if (n <= 1) break block7;
                        v0 = threshold;
                        if (v0 != null) {
                            v1 = v0;
                        } else {
                            $this$map$iv = this.children;
                            $i$f$map = false;
                            $i$a$-require-CompositeKey$Builder$build$1 = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                var10_16 = (NodeAndWeight)item$iv$iv;
                                var15_19 = destination$iv$iv;
                                $i$a$-map-CompositeKey$Builder$build$2 = false;
                                weight = $dstr$_u24__u24$weight.component2();
                                var16_20 = weight;
                                var15_19.add(var16_20);
                            }
                            var15_19 = (List)destination$iv$iv;
                            v1 = CollectionsKt.sumOfInt((Iterable)var15_19);
                        }
                        var17_21 = null;
                        var18_22 = this.children;
                        var19_23 = v1;
                        v2 = new CompositeKey(var19_23, var18_22, var17_21);
                        break block8;
                    }
                    if (n != 1) break block9;
                    if (threshold == null) ** GOTO lbl-1000
                    var3_3 = ((NodeAndWeight)CollectionsKt.first(this.children)).getWeight();
                    if (threshold == var3_3) lbl-1000:
                    // 2 sources

                    {
                        v3 = 1;
                    } else {
                        v3 = 0;
                    }
                    var3_3 = v3;
                    var4_5 = false;
                    var5_9 = false;
                    if (var3_3 == 0) {
                        $i$a$-require-CompositeKey$Builder$build$3 = false;
                        var5_10 = "Trying to build invalid CompositeKey, threshold value different than weight of single child node.";
                        throw (Throwable)new IllegalArgumentException(var5_10.toString());
                    }
                    v2 = ((NodeAndWeight)CollectionsKt.first(this.children)).getNode();
                    break block8;
                }
                throw (Throwable)new IllegalStateException("Trying to build CompositeKey without child nodes.");
            }
            return v2;
        }

        @NotNull
        public final PublicKey build() {
            return this.build(null);
        }

        public Builder() {
            boolean bl = false;
            this.children = new ArrayList();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\n0\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/corda/v5/crypto/CompositeKey$Companion;", "", "()V", "KEY_ALGORITHM", "", "descWeightComparator", "Ljava/util/Comparator;", "Lnet/corda/v5/crypto/CompositeKey$NodeAndWeight;", "Lkotlin/Comparator;", "getInstance", "Ljava/security/PublicKey;", "encoded", "", "asn1", "Lorg/bouncycastle/asn1/ASN1Primitive;", "decoder", "Lkotlin/Function1;", "crypto-api"})
    public static final class Companion {
        @NotNull
        public final PublicKey getInstance(@NotNull byte[] encoded) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray((byte[])encoded);
            Intrinsics.checkNotNullExpressionValue((Object)aSN1Primitive, (String)"ASN1Primitive.fromByteArray(encoded)");
            return this.getInstance(aSN1Primitive, (Function1<? super byte[], ? extends PublicKey>)((Function1)getInstance.1.INSTANCE));
        }

        @NotNull
        public final PublicKey getInstance(@NotNull ASN1Primitive asn1, @NotNull Function1<? super byte[], ? extends PublicKey> decoder) {
            SubjectPublicKeyInfo keyInfo;
            Intrinsics.checkNotNullParameter((Object)asn1, (String)"asn1");
            Intrinsics.checkNotNullParameter(decoder, (String)"decoder");
            SubjectPublicKeyInfo subjectPublicKeyInfo = keyInfo = SubjectPublicKeyInfo.getInstance((Object)asn1);
            Intrinsics.checkNotNullExpressionValue((Object)subjectPublicKeyInfo, (String)"keyInfo");
            AlgorithmIdentifier algorithmIdentifier = subjectPublicKeyInfo.getAlgorithm();
            Intrinsics.checkNotNullExpressionValue((Object)algorithmIdentifier, (String)"keyInfo.algorithm");
            boolean bl = Intrinsics.areEqual((Object)algorithmIdentifier.getAlgorithm(), (Object)CordaObjectIdentifier.COMPOSITE_KEY);
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Key must be composite";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            ASN1Sequence sequence = ASN1Sequence.getInstance((Object)keyInfo.parsePublicKey());
            ASN1Integer aSN1Integer = ASN1Integer.getInstance((Object)sequence.getObjectAt(0));
            Intrinsics.checkNotNullExpressionValue((Object)aSN1Integer, (String)"ASN1Integer.getInstance(sequence.getObjectAt(0))");
            int threshold = aSN1Integer.getPositiveValue().intValue();
            ASN1Sequence sequenceOfChildren = ASN1Sequence.getInstance((Object)sequence.getObjectAt(1));
            Builder builder = new Builder();
            ASN1Sequence aSN1Sequence = sequenceOfChildren;
            Intrinsics.checkNotNullExpressionValue((Object)aSN1Sequence, (String)"sequenceOfChildren");
            Enumeration enumeration = aSN1Sequence.getObjects();
            Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"sequenceOfChildren.objects");
            Enumeration enumeration2 = enumeration;
            boolean bl5 = false;
            ArrayList arrayList = Collections.list(enumeration2);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"java.util.Collections.list(this)");
            List listOfChildren = arrayList;
            Iterable $this$forEach$iv = listOfChildren;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                ASN1Integer weight;
                Object element$iv;
                Object childSeq = element$iv = iterator.next();
                boolean bl6 = false;
                boolean bl7 = childSeq instanceof ASN1Sequence;
                boolean bl8 = false;
                boolean bl9 = false;
                if (!bl7) {
                    boolean bl10 = false;
                    String string = "Child key is not in ASN1 format";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                ASN1Encodable aSN1Encodable = ((ASN1Sequence)childSeq).getObjectAt(0);
                if (aSN1Encodable == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.bouncycastle.asn1.DERBitString");
                }
                byte[] byArray = ((DERBitString)aSN1Encodable).getBytes();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(childSeq.getObjectAt(0) as DERBitString).bytes");
                PublicKey key = (PublicKey)decoder.invoke((Object)byArray);
                ASN1Integer aSN1Integer2 = weight = ASN1Integer.getInstance((Object)((ASN1Sequence)childSeq).getObjectAt(1));
                Intrinsics.checkNotNullExpressionValue((Object)aSN1Integer2, (String)"weight");
                builder.addKey(key, aSN1Integer2.getPositiveValue().intValue());
            }
            return builder.build(threshold);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

