/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.crypto;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import net.corda.v5.base.util.EncodingUtils;
import net.corda.v5.crypto.CompositeKey;
import net.corda.v5.crypto.DigestAlgorithmName;
import net.corda.v5.crypto.DigitalSignature;
import net.corda.v5.crypto.internal.DigestAlgorithm;
import net.corda.v5.crypto.internal.DigestSupplier;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\b\u0012\u0004\u0012\u00020\t0\b\u001a\r\u0010\n\u001a\u00020\u000b*\u00020\fH\u0086\u0002\u001a\r\u0010\r\u001a\u00020\u0004*\u00020\fH\u0086\u0002\u001a\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u001a\u0012\u0010\u0011\u001a\u00020\u000f*\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004\u001a\u0018\u0010\u0011\u001a\u00020\u000f*\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0004H\u0000\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0014H\u0000\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0004\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"messageDigestSha256", "Lnet/corda/v5/crypto/internal/DigestSupplier;", "keys", "", "Ljava/security/PublicKey;", "getKeys", "(Ljava/security/PublicKey;)Ljava/util/Set;", "byKeys", "", "Lnet/corda/v5/crypto/DigitalSignature$WithKey;", "component1", "Ljava/security/PrivateKey;", "Ljava/security/KeyPair;", "component2", "containsAny", "", "otherKeys", "isFulfilledBy", "otherKey", "sha256Bytes", "", "toStringShort", "", "crypto-api"})
@JvmName(name="CryptoUtils")
public final class CryptoUtils {
    private static final DigestSupplier messageDigestSha256 = new DigestSupplier(DigestAlgorithmName.SHA2_256.getName());

    @NotNull
    public static final byte[] sha256Bytes(@NotNull byte[] $this$sha256Bytes) {
        Intrinsics.checkNotNullParameter((Object)$this$sha256Bytes, (String)"$this$sha256Bytes");
        return messageDigestSha256.get().digest($this$sha256Bytes);
    }

    @NotNull
    public static final byte[] sha256Bytes(@NotNull PublicKey $this$sha256Bytes) {
        Intrinsics.checkNotNullParameter((Object)$this$sha256Bytes, (String)"$this$sha256Bytes");
        DigestAlgorithm digestAlgorithm = messageDigestSha256.get();
        byte[] byArray = $this$sha256Bytes.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"encoded");
        return digestAlgorithm.digest(byArray);
    }

    @NotNull
    public static final String toStringShort(@NotNull PublicKey $this$toStringShort) {
        Intrinsics.checkNotNullParameter((Object)$this$toStringShort, (String)"$this$toStringShort");
        return "DL" + EncodingUtils.toBase58((byte[])CryptoUtils.sha256Bytes($this$toStringShort));
    }

    @NotNull
    public static final Set<PublicKey> getKeys(@NotNull PublicKey $this$keys) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$keys, (String)"$this$keys");
        PublicKey publicKey = $this$keys;
        if (!(publicKey instanceof CompositeKey)) {
            publicKey = null;
        }
        if ((object = (CompositeKey)publicKey) == null || (object = ((CompositeKey)object).getLeafKeys()) == null) {
            object = SetsKt.setOf((Object)$this$keys);
        }
        return object;
    }

    public static final boolean isFulfilledBy(@NotNull PublicKey $this$isFulfilledBy, @NotNull PublicKey otherKey) {
        Intrinsics.checkNotNullParameter((Object)$this$isFulfilledBy, (String)"$this$isFulfilledBy");
        Intrinsics.checkNotNullParameter((Object)otherKey, (String)"otherKey");
        return CryptoUtils.isFulfilledBy($this$isFulfilledBy, SetsKt.setOf((Object)otherKey));
    }

    public static final boolean isFulfilledBy(@NotNull PublicKey $this$isFulfilledBy, @NotNull Iterable<? extends PublicKey> otherKeys) {
        Intrinsics.checkNotNullParameter((Object)$this$isFulfilledBy, (String)"$this$isFulfilledBy");
        Intrinsics.checkNotNullParameter(otherKeys, (String)"otherKeys");
        PublicKey publicKey = $this$isFulfilledBy;
        if (!(publicKey instanceof CompositeKey)) {
            publicKey = null;
        }
        CompositeKey compositeKey = (CompositeKey)publicKey;
        return compositeKey != null ? compositeKey.isFulfilledBy(otherKeys) : CollectionsKt.contains(otherKeys, (Object)$this$isFulfilledBy);
    }

    public static final boolean containsAny(@NotNull PublicKey $this$containsAny, @NotNull Iterable<? extends PublicKey> otherKeys) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$containsAny, (String)"$this$containsAny");
        Intrinsics.checkNotNullParameter(otherKeys, (String)"otherKeys");
        if ($this$containsAny instanceof CompositeKey) {
            Collection collection = CollectionsKt.intersect((Iterable)CryptoUtils.getKeys($this$containsAny), otherKeys);
            boolean bl2 = false;
            bl = !collection.isEmpty();
        } else {
            bl = CollectionsKt.contains(otherKeys, (Object)$this$containsAny);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<PublicKey> byKeys(@NotNull Iterable<? extends DigitalSignature.WithKey> $this$byKeys) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$byKeys, (String)"$this$byKeys");
        Iterable<? extends DigitalSignature.WithKey> $this$map$iv = $this$byKeys;
        boolean $i$f$map = false;
        Iterable<? extends DigitalSignature.WithKey> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DigitalSignature.WithKey withKey = (DigitalSignature.WithKey)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PublicKey publicKey = it.getBy();
            collection.add(publicKey);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static final PrivateKey component1(@NotNull KeyPair $this$component1) {
        Intrinsics.checkNotNullParameter((Object)$this$component1, (String)"$this$component1");
        PrivateKey privateKey = $this$component1.getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"this.private");
        return privateKey;
    }

    @NotNull
    public static final PublicKey component2(@NotNull KeyPair $this$component2) {
        Intrinsics.checkNotNullParameter((Object)$this$component2, (String)"$this$component2");
        PublicKey publicKey = $this$component2.getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"this.public");
        return publicKey;
    }
}

