/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.crypto;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.v5.base.annotations.CordaSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CordaSerializable
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lnet/corda/v5/crypto/DigestAlgorithmName;", "", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "crypto-api"})
public final class DigestAlgorithmName {
    @NotNull
    private final String name;
    public static final int NONCE_SIZE = 8;
    @JvmField
    @NotNull
    public static final DigestAlgorithmName SHA2_256;
    @JvmField
    @NotNull
    public static final DigestAlgorithmName SHA2_384;
    @JvmField
    @NotNull
    public static final DigestAlgorithmName SHA2_512;
    @JvmField
    @NotNull
    public static final DigestAlgorithmName DEFAULT_ALGORITHM_NAME;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final String getName() {
        return this.name;
    }

    public DigestAlgorithmName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        CharSequence charSequence = this.name;
        boolean bl = false;
        boolean bl2 = charSequence.length() > 0;
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "Hash algorithm name unavailable or not specified";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    static {
        Companion = new Companion(null);
        SHA2_256 = new DigestAlgorithmName("SHA-256");
        SHA2_384 = new DigestAlgorithmName("SHA-384");
        SHA2_512 = new DigestAlgorithmName("SHA-512");
        DEFAULT_ALGORITHM_NAME = SHA2_256;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final DigestAlgorithmName copy(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new DigestAlgorithmName(name);
    }

    public static /* synthetic */ DigestAlgorithmName copy$default(DigestAlgorithmName digestAlgorithmName, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = digestAlgorithmName.name;
        }
        return digestAlgorithmName.copy(string);
    }

    @NotNull
    public String toString() {
        return "DigestAlgorithmName(name=" + this.name + ")";
    }

    public int hashCode() {
        String string = this.name;
        return string != null ? string.hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DigestAlgorithmName)) break block3;
                DigestAlgorithmName digestAlgorithmName = (DigestAlgorithmName)object;
                if (!Intrinsics.areEqual((Object)this.name, (Object)digestAlgorithmName.name)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lnet/corda/v5/crypto/DigestAlgorithmName$Companion;", "", "()V", "DEFAULT_ALGORITHM_NAME", "Lnet/corda/v5/crypto/DigestAlgorithmName;", "NONCE_SIZE", "", "SHA2_256", "SHA2_384", "SHA2_512", "crypto-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

