/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.crypto;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.corda.v5.base.types.ByteArrays;
import net.corda.v5.crypto.DigestAlgorithmName;
import net.corda.v5.crypto.DigestService;
import net.corda.v5.crypto.HashConstants;
import net.corda.v5.crypto.SecureHash;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u001c\u0010\b\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0012\u0010\f\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b\u001a\u0014\u0010\r\u001a\u00020\u0003*\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0012\u0010\u000e\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"hashConstants", "Ljava/util/concurrent/ConcurrentMap;", "", "Lnet/corda/v5/crypto/HashConstants;", "create", "Lnet/corda/v5/crypto/SecureHash;", "Lnet/corda/v5/crypto/DigestService;", "str", "decode", "value", "digestAlgorithmName", "Lnet/corda/v5/crypto/DigestAlgorithmName;", "getAllOnesHash", "getConstantsFor", "getZeroHash", "crypto-api"})
@JvmName(name="DigestServiceUtils")
public final class DigestServiceUtils {
    private static final ConcurrentMap<String, HashConstants> hashConstants = new ConcurrentHashMap();

    @NotNull
    public static final SecureHash create(@NotNull DigestService $this$create, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)$this$create, (String)"$this$create");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        int idx = StringsKt.indexOf$default((CharSequence)str, (char)':', (int)0, (boolean)false, (int)6, null);
        if (idx == -1) {
            throw (Throwable)new IllegalArgumentException("Provided string should be of format algorithm:hexadecimal");
        }
        String string = str;
        int n = 0;
        int n2 = 0;
        String string2 = string.substring(n, idx);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String algorithm = string2;
        String string3 = str;
        n2 = idx + 1;
        boolean bl = false;
        String string4 = string3.substring(n2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        String value = string4;
        return DigestServiceUtils.decode($this$create, value, new DigestAlgorithmName(algorithm));
    }

    @NotNull
    public static final SecureHash getZeroHash(@NotNull DigestService $this$getZeroHash, @NotNull DigestAlgorithmName digestAlgorithmName) {
        Intrinsics.checkNotNullParameter((Object)$this$getZeroHash, (String)"$this$getZeroHash");
        Intrinsics.checkNotNullParameter((Object)digestAlgorithmName, (String)"digestAlgorithmName");
        return DigestServiceUtils.getConstantsFor($this$getZeroHash, digestAlgorithmName).getZero();
    }

    @NotNull
    public static final SecureHash getAllOnesHash(@NotNull DigestService $this$getAllOnesHash, @NotNull DigestAlgorithmName digestAlgorithmName) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllOnesHash, (String)"$this$getAllOnesHash");
        Intrinsics.checkNotNullParameter((Object)digestAlgorithmName, (String)"digestAlgorithmName");
        return DigestServiceUtils.getConstantsFor($this$getAllOnesHash, digestAlgorithmName).getAllOnes();
    }

    private static final HashConstants getConstantsFor(DigestService $this$getConstantsFor, DigestAlgorithmName digestAlgorithmName) {
        String algorithm = digestAlgorithmName.getName();
        ConcurrentMap<String, HashConstants> $this$getOrPut$iv = hashConstants;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(algorithm);
        if (object == null) {
            byte[] byArray;
            int n;
            Object object2;
            boolean bl = false;
            int digestLength = $this$getConstantsFor.digestLength(digestAlgorithmName);
            String string = algorithm;
            byte[] byArray2 = new byte[digestLength];
            int n2 = 0;
            while (n2 < digestLength) {
                int n3 = n2;
                int n4 = n2++;
                object2 = byArray2;
                boolean bl2 = false;
                object2[n4] = n = 0;
            }
            byte[] byArray3 = object2 = byArray2;
            String string2 = string;
            object2 = algorithm;
            SecureHash secureHash = new SecureHash(string2, byArray3);
            byArray2 = new byte[digestLength];
            n2 = 0;
            while (n2 < digestLength) {
                byte by;
                int it = n2;
                n = n2++;
                byte[] byArray4 = byArray2;
                boolean bl3 = false;
                byArray4[n] = by = (byte)255;
            }
            byte[] byArray5 = byArray = byArray2;
            Object object3 = object2;
            SecureHash secureHash2 = new SecureHash((String)object3, byArray5);
            SecureHash secureHash3 = secureHash;
            HashConstants hashConstants = new HashConstants(secureHash3, secureHash2);
            boolean bl4 = false;
            boolean bl5 = false;
            HashConstants default$iv = hashConstants;
            boolean bl6 = false;
            object = $this$getOrPut$iv.putIfAbsent(algorithm, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        return (HashConstants)object;
    }

    private static final SecureHash decode(DigestService $this$decode, String value, DigestAlgorithmName digestAlgorithmName) {
        int digestLength = $this$decode.digestLength(digestAlgorithmName);
        byte[] data = ByteArrays.parseAsHex((String)value);
        int n = data.length;
        if (n != digestLength) {
            throw (Throwable)new IllegalArgumentException("Provided string is " + data.length + " bytes not " + digestLength + " bytes in hex: " + value);
        }
        return new SecureHash(digestAlgorithmName.getName(), data);
    }
}

