/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.crypto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.corda.v5.crypto.DigestAlgorithmName;
import net.corda.v5.crypto.DigestService;
import net.corda.v5.crypto.DigestServiceUtils;
import net.corda.v5.crypto.SecureHash;
import net.corda.v5.crypto.exceptions.MerkleTreeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00072\u00020\u0001:\u0003\u0007\b\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lnet/corda/v5/crypto/MerkleTree;", "", "()V", "hash", "Lnet/corda/v5/crypto/SecureHash;", "getHash", "()Lnet/corda/v5/crypto/SecureHash;", "Companion", "Leaf", "Node", "Lnet/corda/v5/crypto/MerkleTree$Leaf;", "Lnet/corda/v5/crypto/MerkleTree$Node;", "crypto-api"})
public abstract class MerkleTree {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract SecureHash getHash();

    private MerkleTree() {
    }

    public /* synthetic */ MerkleTree(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lnet/corda/v5/crypto/MerkleTree$Leaf;", "Lnet/corda/v5/crypto/MerkleTree;", "hash", "Lnet/corda/v5/crypto/SecureHash;", "(Lnet/corda/v5/crypto/SecureHash;)V", "getHash", "()Lnet/corda/v5/crypto/SecureHash;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "crypto-api"})
    public static final class Leaf
    extends MerkleTree {
        @NotNull
        private final SecureHash hash;

        @Override
        @NotNull
        public SecureHash getHash() {
            return this.hash;
        }

        public Leaf(@NotNull SecureHash hash) {
            Intrinsics.checkNotNullParameter((Object)((Object)hash), (String)"hash");
            super(null);
            this.hash = hash;
        }

        @NotNull
        public final SecureHash component1() {
            return this.getHash();
        }

        @NotNull
        public final Leaf copy(@NotNull SecureHash hash) {
            Intrinsics.checkNotNullParameter((Object)((Object)hash), (String)"hash");
            return new Leaf(hash);
        }

        public static /* synthetic */ Leaf copy$default(Leaf leaf, SecureHash secureHash, int n, Object object) {
            if ((n & 1) != 0) {
                secureHash = leaf.getHash();
            }
            return leaf.copy(secureHash);
        }

        @NotNull
        public String toString() {
            return "Leaf(hash=" + (Object)((Object)this.getHash()) + ")";
        }

        public int hashCode() {
            SecureHash secureHash = this.getHash();
            return secureHash != null ? ((Object)((Object)secureHash)).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Leaf)) break block3;
                    Leaf leaf = (Leaf)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.getHash()), (Object)((Object)leaf.getHash()))) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0001H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0018"}, d2={"Lnet/corda/v5/crypto/MerkleTree$Node;", "Lnet/corda/v5/crypto/MerkleTree;", "hash", "Lnet/corda/v5/crypto/SecureHash;", "left", "right", "(Lnet/corda/v5/crypto/SecureHash;Lnet/corda/v5/crypto/MerkleTree;Lnet/corda/v5/crypto/MerkleTree;)V", "getHash", "()Lnet/corda/v5/crypto/SecureHash;", "getLeft", "()Lnet/corda/v5/crypto/MerkleTree;", "getRight", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "crypto-api"})
    public static final class Node
    extends MerkleTree {
        @NotNull
        private final SecureHash hash;
        @NotNull
        private final MerkleTree left;
        @NotNull
        private final MerkleTree right;

        @Override
        @NotNull
        public SecureHash getHash() {
            return this.hash;
        }

        @NotNull
        public final MerkleTree getLeft() {
            return this.left;
        }

        @NotNull
        public final MerkleTree getRight() {
            return this.right;
        }

        public Node(@NotNull SecureHash hash, @NotNull MerkleTree left, @NotNull MerkleTree right) {
            Intrinsics.checkNotNullParameter((Object)((Object)hash), (String)"hash");
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            super(null);
            this.hash = hash;
            this.left = left;
            this.right = right;
        }

        @NotNull
        public final SecureHash component1() {
            return this.getHash();
        }

        @NotNull
        public final MerkleTree component2() {
            return this.left;
        }

        @NotNull
        public final MerkleTree component3() {
            return this.right;
        }

        @NotNull
        public final Node copy(@NotNull SecureHash hash, @NotNull MerkleTree left, @NotNull MerkleTree right) {
            Intrinsics.checkNotNullParameter((Object)((Object)hash), (String)"hash");
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            return new Node(hash, left, right);
        }

        public static /* synthetic */ Node copy$default(Node node, SecureHash secureHash, MerkleTree merkleTree, MerkleTree merkleTree2, int n, Object object) {
            if ((n & 1) != 0) {
                secureHash = node.getHash();
            }
            if ((n & 2) != 0) {
                merkleTree = node.left;
            }
            if ((n & 4) != 0) {
                merkleTree2 = node.right;
            }
            return node.copy(secureHash, merkleTree, merkleTree2);
        }

        @NotNull
        public String toString() {
            return "Node(hash=" + (Object)((Object)this.getHash()) + ", left=" + this.left + ", right=" + this.right + ")";
        }

        public int hashCode() {
            SecureHash secureHash = this.getHash();
            MerkleTree merkleTree = this.left;
            MerkleTree merkleTree2 = this.right;
            return ((secureHash != null ? ((Object)((Object)secureHash)).hashCode() : 0) * 31 + (merkleTree != null ? merkleTree.hashCode() : 0)) * 31 + (merkleTree2 != null ? merkleTree2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Node)) break block3;
                    Node node = (Node)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.getHash()), (Object)((Object)node.getHash())) || !Intrinsics.areEqual((Object)this.left, (Object)node.left) || !Intrinsics.areEqual((Object)this.right, (Object)node.right)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0082\u0010J$\u0010\u000b\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0013"}, d2={"Lnet/corda/v5/crypto/MerkleTree$Companion;", "", "()V", "buildMerkleTree", "Lnet/corda/v5/crypto/MerkleTree;", "lastNodesList", "", "nodeDigestAlgorithmName", "Lnet/corda/v5/crypto/DigestAlgorithmName;", "digestService", "Lnet/corda/v5/crypto/DigestService;", "getMerkleTree", "allLeavesHashes", "Lnet/corda/v5/crypto/SecureHash;", "isPow2", "", "num", "", "padWithZeros", "crypto-api"})
    public static final class Companion {
        private final boolean isPow2(int num) {
            return (num & num - 1) == 0;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final MerkleTree getMerkleTree(@NotNull List<SecureHash> allLeavesHashes, @NotNull DigestAlgorithmName nodeDigestAlgorithmName, @NotNull DigestService digestService) {
            void $this$mapTo$iv$iv;
            Object object;
            Collection collection;
            void $this$mapTo$iv22;
            Intrinsics.checkNotNullParameter(allLeavesHashes, (String)"allLeavesHashes");
            Intrinsics.checkNotNullParameter((Object)nodeDigestAlgorithmName, (String)"nodeDigestAlgorithmName");
            Intrinsics.checkNotNullParameter((Object)digestService, (String)"digestService");
            if (allLeavesHashes.isEmpty()) {
                throw (Throwable)((Object)new MerkleTreeException("Cannot calculate Merkle root on empty hash list."));
            }
            Iterable iterable = allLeavesHashes;
            Collection destination$iv22 = new HashSet();
            boolean $i$f$mapTo2 = false;
            Iterator iterator = $this$mapTo$iv22.iterator();
            while (iterator.hasNext()) {
                void receiver;
                Object item$iv;
                Object t = item$iv = iterator.next();
                collection = destination$iv22;
                boolean bl = false;
                object = ((SecureHash)receiver).getAlgorithm();
                collection.add(object);
            }
            HashSet algorithms = (HashSet)destination$iv22;
            boolean $this$mapTo$iv22 = algorithms.size() == 1;
            boolean destination$iv22 = false;
            $i$f$mapTo2 = false;
            if (!$this$mapTo$iv22) {
                boolean bl = false;
                String $i$f$mapTo2 = "Cannot build Merkle tree with multiple hash algorithms: " + algorithms;
                throw (Throwable)new IllegalArgumentException($i$f$mapTo2.toString());
            }
            Iterable $this$map$iv = this.padWithZeros(allLeavesHashes, digestService);
            boolean $i$f$map = false;
            Iterable bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SecureHash secureHash = (SecureHash)((Object)item$iv$iv);
                collection = destination$iv$iv;
                boolean bl2 = false;
                object = new Leaf((SecureHash)it);
                collection.add(object);
            }
            List leaves = (List)destination$iv$iv;
            return this.buildMerkleTree(leaves, nodeDigestAlgorithmName, digestService);
        }

        private final List<SecureHash> padWithZeros(List<SecureHash> allLeavesHashes, DigestService digestService) {
            int n = allLeavesHashes.size();
            if (n > 1 && this.isPow2(n)) {
                return allLeavesHashes;
            }
            ArrayList<SecureHash> paddedHashes = new ArrayList<SecureHash>((Collection)allLeavesHashes);
            SecureHash zeroHash = DigestServiceUtils.getZeroHash(digestService, new DigestAlgorithmName(((SecureHash)((Object)paddedHashes.get(0))).getAlgorithm()));
            do {
                paddedHashes.add(zeroHash);
            } while (!this.isPow2(++n));
            return paddedHashes;
        }

        /*
         * WARNING - void declaration
         */
        private final MerkleTree buildMerkleTree(List<? extends MerkleTree> lastNodesList, DigestAlgorithmName nodeDigestAlgorithmName, DigestService digestService) {
            while (lastNodesList.size() != 1) {
                List newLevelHashes = new ArrayList();
                int n = lastNodesList.size();
                int n2 = (n & 1) == 0 ? 1 : 0;
                int n3 = 0;
                int n4 = 0;
                if (n2 == 0) {
                    boolean bl = false;
                    String string = "Sanity check: number of nodes should be even.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                int bl = 0;
                IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)new IntRange(bl, n - 2)), (int)2);
                n2 = intProgression.getFirst();
                n3 = intProgression.getLast();
                n4 = intProgression.getStep();
                int n5 = n2;
                int n6 = n3;
                if (n4 >= 0 ? n5 <= n6 : n5 >= n6) {
                    while (true) {
                        void i;
                        MerkleTree left = lastNodesList.get((int)i);
                        MerkleTree right = (MerkleTree)lastNodesList.get((int)(i + true));
                        Node node = new Node(digestService.hash(ArraysKt.plus((byte[])left.getHash().getBytes(), (byte[])right.getHash().getBytes()), nodeDigestAlgorithmName), left, right);
                        newLevelHashes.add(node);
                        if (i == n3) break;
                        i += n4;
                    }
                }
                lastNodesList = newLevelHashes;
            }
            return lastNodesList.get(0);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

