/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.crypto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.v5.base.annotations.CordaInternal;
import net.corda.v5.base.annotations.CordaSerializable;
import net.corda.v5.crypto.DigestAlgorithmName;
import net.corda.v5.crypto.DigestService;
import net.corda.v5.crypto.MerkleTree;
import net.corda.v5.crypto.PartialMerkleTreeKt;
import net.corda.v5.crypto.SecureHash;
import net.corda.v5.crypto.exceptions.MerkleTreeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CordaSerializable
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J&\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00032\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0002J$\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lnet/corda/v5/crypto/PartialMerkleTree;", "", "root", "Lnet/corda/v5/crypto/PartialMerkleTree$PartialTree;", "(Lnet/corda/v5/crypto/PartialMerkleTree$PartialTree;)V", "getRoot", "()Lnet/corda/v5/crypto/PartialMerkleTree$PartialTree;", "indexFromFlagPath", "", "pathList", "", "", "leafIndex", "leaf", "Lnet/corda/v5/crypto/SecureHash;", "leafIndexHelper", "node", "path", "", "verify", "merkleRootHash", "hashesToCheck", "hashingService", "Lnet/corda/v5/crypto/DigestService;", "Companion", "PartialTree", "crypto-api"})
public final class PartialMerkleTree {
    @NotNull
    private final PartialTree root;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final boolean verify(@NotNull SecureHash merkleRootHash, @NotNull List<SecureHash> hashesToCheck, @NotNull DigestService hashingService) {
        Intrinsics.checkNotNullParameter((Object)((Object)merkleRootHash), (String)"merkleRootHash");
        Intrinsics.checkNotNullParameter(hashesToCheck, (String)"hashesToCheck");
        Intrinsics.checkNotNullParameter((Object)hashingService, (String)"hashingService");
        ArrayList usedHashes = new ArrayList();
        SecureHash verifyRoot = Companion.rootAndUsedHashes(this.root, usedHashes, hashingService);
        return Intrinsics.areEqual((Object)((Object)verifyRoot), (Object)((Object)merkleRootHash)) && hashesToCheck.size() == usedHashes.size() && CollectionsKt.toSet((Iterable)hashesToCheck).containsAll(usedHashes);
    }

    @CordaInternal
    public final int leafIndex(@NotNull SecureHash leaf) {
        Intrinsics.checkNotNullParameter((Object)((Object)leaf), (String)"leaf");
        if (this.root instanceof PartialTree.IncludedLeaf && Intrinsics.areEqual((Object)((Object)((PartialTree.IncludedLeaf)this.root).getHash()), (Object)((Object)leaf))) {
            return 0;
        }
        boolean bl = false;
        List flagPath = new ArrayList();
        if (!this.leafIndexHelper(leaf, this.root, flagPath)) {
            throw (Throwable)((Object)new MerkleTreeException("The provided hash " + (Object)((Object)leaf) + " is not in the tree."));
        }
        return this.indexFromFlagPath(flagPath);
    }

    private final boolean leafIndexHelper(SecureHash leaf, PartialTree node, List<Boolean> path) {
        if (node instanceof PartialTree.IncludedLeaf) {
            return Intrinsics.areEqual((Object)((Object)((PartialTree.IncludedLeaf)node).getHash()), (Object)((Object)leaf));
        }
        if (node instanceof PartialTree.Node) {
            if (this.leafIndexHelper(leaf, ((PartialTree.Node)node).getLeft(), path)) {
                path.add(false);
                return true;
            }
            if (this.leafIndexHelper(leaf, ((PartialTree.Node)node).getRight(), path)) {
                path.add(true);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final int indexFromFlagPath(List<Boolean> pathList) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = pathList;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void value;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            boolean bl2 = (Boolean)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            Integer n3 = value != false ? 1 << index : 0;
            collection.add(n3);
        }
        return CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final PartialTree getRoot() {
        return this.root;
    }

    public PartialMerkleTree(@NotNull PartialTree root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
    }

    @JvmStatic
    @NotNull
    public static final PartialMerkleTree build(@NotNull MerkleTree merkleRoot, @NotNull List<SecureHash> includeHashes) {
        return Companion.build(merkleRoot, includeHashes);
    }

    @JvmStatic
    @NotNull
    public static final SecureHash rootAndUsedHashes(@NotNull PartialTree node, @NotNull List<SecureHash> usedHashes, @NotNull DigestService digestService) {
        return Companion.rootAndUsedHashes(node, usedHashes, digestService);
    }

    @CordaSerializable
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lnet/corda/v5/crypto/PartialMerkleTree$PartialTree;", "", "()V", "IncludedLeaf", "Leaf", "Node", "Lnet/corda/v5/crypto/PartialMerkleTree$PartialTree$IncludedLeaf;", "Lnet/corda/v5/crypto/PartialMerkleTree$PartialTree$Leaf;", "Lnet/corda/v5/crypto/PartialMerkleTree$PartialTree$Node;", "crypto-api"})
    public static abstract class PartialTree {
        private PartialTree() {
        }

        public /* synthetic */ PartialTree(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lnet/corda/v5/crypto/PartialMerkleTree$PartialTree$IncludedLeaf;", "Lnet/corda/v5/crypto/PartialMerkleTree$PartialTree;", "hash", "Lnet/corda/v5/crypto/SecureHash;", "(Lnet/corda/v5/crypto/SecureHash;)V", "getHash", "()Lnet/corda/v5/crypto/SecureHash;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "crypto-api"})
        public static final class IncludedLeaf
        extends PartialTree {
            @NotNull
            private final SecureHash hash;

            @NotNull
            public final SecureHash getHash() {
                return this.hash;
            }

            public IncludedLeaf(@NotNull SecureHash hash) {
                Intrinsics.checkNotNullParameter((Object)((Object)hash), (String)"hash");
                super(null);
                this.hash = hash;
            }

            @NotNull
            public final SecureHash component1() {
                return this.hash;
            }

            @NotNull
            public final IncludedLeaf copy(@NotNull SecureHash hash) {
                Intrinsics.checkNotNullParameter((Object)((Object)hash), (String)"hash");
                return new IncludedLeaf(hash);
            }

            public static /* synthetic */ IncludedLeaf copy$default(IncludedLeaf includedLeaf, SecureHash secureHash, int n, Object object) {
                if ((n & 1) != 0) {
                    secureHash = includedLeaf.hash;
                }
                return includedLeaf.copy(secureHash);
            }

            @NotNull
            public String toString() {
                return "IncludedLeaf(hash=" + (Object)((Object)this.hash) + ")";
            }

            public int hashCode() {
                SecureHash secureHash = this.hash;
                return secureHash != null ? ((Object)((Object)secureHash)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof IncludedLeaf)) break block3;
                        IncludedLeaf includedLeaf = (IncludedLeaf)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.hash), (Object)((Object)includedLeaf.hash))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lnet/corda/v5/crypto/PartialMerkleTree$PartialTree$Leaf;", "Lnet/corda/v5/crypto/PartialMerkleTree$PartialTree;", "hash", "Lnet/corda/v5/crypto/SecureHash;", "(Lnet/corda/v5/crypto/SecureHash;)V", "getHash", "()Lnet/corda/v5/crypto/SecureHash;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "crypto-api"})
        public static final class Leaf
        extends PartialTree {
            @NotNull
            private final SecureHash hash;

            @NotNull
            public final SecureHash getHash() {
                return this.hash;
            }

            public Leaf(@NotNull SecureHash hash) {
                Intrinsics.checkNotNullParameter((Object)((Object)hash), (String)"hash");
                super(null);
                this.hash = hash;
            }

            @NotNull
            public final SecureHash component1() {
                return this.hash;
            }

            @NotNull
            public final Leaf copy(@NotNull SecureHash hash) {
                Intrinsics.checkNotNullParameter((Object)((Object)hash), (String)"hash");
                return new Leaf(hash);
            }

            public static /* synthetic */ Leaf copy$default(Leaf leaf, SecureHash secureHash, int n, Object object) {
                if ((n & 1) != 0) {
                    secureHash = leaf.hash;
                }
                return leaf.copy(secureHash);
            }

            @NotNull
            public String toString() {
                return "Leaf(hash=" + (Object)((Object)this.hash) + ")";
            }

            public int hashCode() {
                SecureHash secureHash = this.hash;
                return secureHash != null ? ((Object)((Object)secureHash)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Leaf)) break block3;
                        Leaf leaf = (Leaf)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.hash), (Object)((Object)leaf.hash))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\f\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0001H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J)\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u00012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0017"}, d2={"Lnet/corda/v5/crypto/PartialMerkleTree$PartialTree$Node;", "Lnet/corda/v5/crypto/PartialMerkleTree$PartialTree;", "left", "right", "hashAlgorithm", "", "(Lnet/corda/v5/crypto/PartialMerkleTree$PartialTree;Lnet/corda/v5/crypto/PartialMerkleTree$PartialTree;Ljava/lang/String;)V", "getHashAlgorithm", "()Ljava/lang/String;", "getLeft", "()Lnet/corda/v5/crypto/PartialMerkleTree$PartialTree;", "getRight", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "crypto-api"})
        public static final class Node
        extends PartialTree {
            @NotNull
            private final PartialTree left;
            @NotNull
            private final PartialTree right;
            @Nullable
            private final String hashAlgorithm;

            @NotNull
            public final PartialTree getLeft() {
                return this.left;
            }

            @NotNull
            public final PartialTree getRight() {
                return this.right;
            }

            @Nullable
            public final String getHashAlgorithm() {
                return this.hashAlgorithm;
            }

            public Node(@NotNull PartialTree left, @NotNull PartialTree right, @Nullable String hashAlgorithm) {
                Intrinsics.checkNotNullParameter((Object)left, (String)"left");
                Intrinsics.checkNotNullParameter((Object)right, (String)"right");
                super(null);
                this.left = left;
                this.right = right;
                this.hashAlgorithm = hashAlgorithm;
            }

            public /* synthetic */ Node(PartialTree partialTree, PartialTree partialTree2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    string = DigestAlgorithmName.SHA2_256.getName();
                }
                this(partialTree, partialTree2, string);
            }

            @NotNull
            public final PartialTree component1() {
                return this.left;
            }

            @NotNull
            public final PartialTree component2() {
                return this.right;
            }

            @Nullable
            public final String component3() {
                return this.hashAlgorithm;
            }

            @NotNull
            public final Node copy(@NotNull PartialTree left, @NotNull PartialTree right, @Nullable String hashAlgorithm) {
                Intrinsics.checkNotNullParameter((Object)left, (String)"left");
                Intrinsics.checkNotNullParameter((Object)right, (String)"right");
                return new Node(left, right, hashAlgorithm);
            }

            public static /* synthetic */ Node copy$default(Node node, PartialTree partialTree, PartialTree partialTree2, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    partialTree = node.left;
                }
                if ((n & 2) != 0) {
                    partialTree2 = node.right;
                }
                if ((n & 4) != 0) {
                    string = node.hashAlgorithm;
                }
                return node.copy(partialTree, partialTree2, string);
            }

            @NotNull
            public String toString() {
                return "Node(left=" + this.left + ", right=" + this.right + ", hashAlgorithm=" + this.hashAlgorithm + ")";
            }

            public int hashCode() {
                PartialTree partialTree = this.left;
                PartialTree partialTree2 = this.right;
                String string = this.hashAlgorithm;
                return ((partialTree != null ? partialTree.hashCode() : 0) * 31 + (partialTree2 != null ? partialTree2.hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Node)) break block3;
                        Node node = (Node)object;
                        if (!Intrinsics.areEqual((Object)this.left, (Object)node.left) || !Intrinsics.areEqual((Object)this.right, (Object)node.right) || !Intrinsics.areEqual((Object)this.hashAlgorithm, (Object)node.hashAlgorithm)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007J8\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0002J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\u0014\u001a\u00020\u0012H\u0002J(\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J&\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0007\u00a8\u0006\u001e"}, d2={"Lnet/corda/v5/crypto/PartialMerkleTree$Companion;", "", "()V", "build", "Lnet/corda/v5/crypto/PartialMerkleTree;", "merkleRoot", "Lnet/corda/v5/crypto/MerkleTree;", "includeHashes", "", "Lnet/corda/v5/crypto/SecureHash;", "buildPartialTree", "Lkotlin/Pair;", "", "Lnet/corda/v5/crypto/PartialMerkleTree$PartialTree;", "root", "usedHashes", "", "checkFull", "", "tree", "level", "concatenateAs", "digestService", "Lnet/corda/v5/crypto/DigestService;", "first", "second", "concatAlgorithmName", "Lnet/corda/v5/crypto/DigestAlgorithmName;", "rootAndUsedHashes", "node", "crypto-api"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final PartialMerkleTree build(@NotNull MerkleTree merkleRoot, @NotNull List<SecureHash> includeHashes) {
            boolean bl;
            boolean $i$f$none;
            block5: {
                Intrinsics.checkNotNullParameter((Object)merkleRoot, (String)"merkleRoot");
                Intrinsics.checkNotNullParameter(includeHashes, (String)"includeHashes");
                Iterable $this$none$iv = includeHashes;
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator = $this$none$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv;
                        Object receiver = element$iv = iterator.next();
                        boolean bl2 = false;
                        if (!PartialMerkleTreeKt.access$isZero$p((SecureHash)((Object)receiver))) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            boolean $this$none$iv = bl;
            $i$f$none = false;
            boolean bl3 = false;
            if (!$this$none$iv) {
                boolean bl4 = false;
                String string = "Zero hashes shouldn't be included in partial tree.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            net.corda.v5.crypto.PartialMerkleTree$Companion.checkFull$default(this, merkleRoot, 0, 2, null);
            ArrayList usedHashes = new ArrayList();
            Pair<Boolean, PartialTree> tree = this.buildPartialTree(merkleRoot, includeHashes, usedHashes);
            if (includeHashes.size() != usedHashes.size()) {
                throw (Throwable)((Object)new MerkleTreeException("Some of the provided hashes are not in the tree."));
            }
            return new PartialMerkleTree((PartialTree)tree.getSecond());
        }

        private final int checkFull(MerkleTree tree, int level) {
            int n;
            MerkleTree merkleTree = tree;
            if (merkleTree instanceof MerkleTree.Leaf) {
                n = level;
            } else if (merkleTree instanceof MerkleTree.Node) {
                int l2;
                int l1 = this.checkFull(((MerkleTree.Node)tree).getLeft(), level + 1);
                if (l1 != (l2 = this.checkFull(((MerkleTree.Node)tree).getRight(), level + 1))) {
                    throw (Throwable)((Object)new MerkleTreeException("Got not full binary tree."));
                }
                n = l1;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return n;
        }

        static /* synthetic */ int checkFull$default(Companion companion, MerkleTree merkleTree, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.checkFull(merkleTree, n);
        }

        private final Pair<Boolean, PartialTree> buildPartialTree(MerkleTree root, List<SecureHash> includeHashes, List<SecureHash> usedHashes) {
            Pair pair;
            MerkleTree merkleTree = root;
            if (merkleTree instanceof MerkleTree.Leaf) {
                if (includeHashes.contains((Object)root.getHash())) {
                    usedHashes.add(root.getHash());
                    pair = new Pair((Object)true, (Object)new PartialTree.IncludedLeaf(root.getHash()));
                } else {
                    pair = new Pair((Object)false, (Object)new PartialTree.Leaf(root.getHash()));
                }
            } else if (merkleTree instanceof MerkleTree.Node) {
                Pair<Boolean, PartialTree> leftNode = this.buildPartialTree(((MerkleTree.Node)root).getLeft(), includeHashes, usedHashes);
                Pair<Boolean, PartialTree> rightNode = this.buildPartialTree(((MerkleTree.Node)root).getRight(), includeHashes, usedHashes);
                if ((Boolean)leftNode.getFirst() | (Boolean)rightNode.getFirst()) {
                    PartialTree.Node newTree = new PartialTree.Node((PartialTree)leftNode.getSecond(), (PartialTree)rightNode.getSecond(), root.getHash().getAlgorithm());
                    pair = new Pair((Object)true, (Object)newTree);
                } else {
                    PartialTree.Leaf newTree = new PartialTree.Leaf(root.getHash());
                    pair = new Pair((Object)false, (Object)newTree);
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return pair;
        }

        @JvmStatic
        @NotNull
        public final SecureHash rootAndUsedHashes(@NotNull PartialTree node, @NotNull List<SecureHash> usedHashes, @NotNull DigestService digestService) {
            SecureHash secureHash;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(usedHashes, (String)"usedHashes");
            Intrinsics.checkNotNullParameter((Object)digestService, (String)"digestService");
            PartialTree partialTree = node;
            if (partialTree instanceof PartialTree.IncludedLeaf) {
                usedHashes.add(((PartialTree.IncludedLeaf)node).getHash());
                secureHash = ((PartialTree.IncludedLeaf)node).getHash();
            } else if (partialTree instanceof PartialTree.Leaf) {
                secureHash = ((PartialTree.Leaf)node).getHash();
            } else if (partialTree instanceof PartialTree.Node) {
                SecureHash leftHash = this.rootAndUsedHashes(((PartialTree.Node)node).getLeft(), usedHashes, digestService);
                SecureHash rightHash = this.rootAndUsedHashes(((PartialTree.Node)node).getRight(), usedHashes, digestService);
                String string = ((PartialTree.Node)node).getHashAlgorithm();
                Intrinsics.checkNotNull((Object)string);
                secureHash = this.concatenateAs(digestService, leftHash, rightHash, new DigestAlgorithmName(string));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return secureHash;
        }

        private final SecureHash concatenateAs(DigestService digestService, SecureHash first, SecureHash second, DigestAlgorithmName concatAlgorithmName) {
            boolean bl = Intrinsics.areEqual((Object)first.getAlgorithm(), (Object)second.getAlgorithm());
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Cannot concatenate " + first.getAlgorithm() + " with " + second.getAlgorithm();
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            byte[] concatBytes = ArraysKt.plus((byte[])first.getBytes(), (byte[])second.getBytes());
            return digestService.hash(concatBytes, concatAlgorithmName);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

