/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.crypto;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.corda.v5.base.annotations.CordaSerializable;
import net.corda.v5.base.types.ByteArrays;
import net.corda.v5.base.types.OpaqueBytes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CordaSerializable
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u000eJ\u0006\u0010\u0011\u001a\u00020\u0003J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lnet/corda/v5/crypto/SecureHash;", "Lnet/corda/v5/base/types/OpaqueBytes;", "algorithm", "", "bytes", "", "(Ljava/lang/String;[B)V", "getAlgorithm", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "prefixChars", "prefixLen", "toHexString", "toString", "Companion", "crypto-api"})
public final class SecureHash
extends OpaqueBytes {
    @NotNull
    private final String algorithm;
    public static final char DELIMITER = ':';
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String toHexString() {
        return ByteArrays.toHexString((byte[])this.getBytes());
    }

    @NotNull
    public final String prefixChars(int prefixLen) {
        String string = this.toHexString();
        int n = 0;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, prefixLen);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    public static /* synthetic */ String prefixChars$default(SecureHash secureHash, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 6;
        }
        return secureHash.prefixChars(n);
    }

    public boolean equals(@Nullable Object other) {
        return this == other ? true : (!(other instanceof SecureHash) ? false : Intrinsics.areEqual((Object)this.algorithm, (Object)((SecureHash)((Object)other)).algorithm) && super.equals(other));
    }

    public int hashCode() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.getBytes());
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"ByteBuffer.wrap(bytes)");
        return byteBuffer.getInt();
    }

    @NotNull
    public String toString() {
        return this.algorithm + ':' + this.toHexString();
    }

    @NotNull
    public final String getAlgorithm() {
        return this.algorithm;
    }

    public SecureHash(@NotNull String algorithm, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        super(bytes);
        this.algorithm = algorithm;
    }

    @JvmStatic
    @NotNull
    public static final SecureHash create(@NotNull String str) {
        return Companion.create(str);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnet/corda/v5/crypto/SecureHash$Companion;", "", "()V", "DELIMITER", "", "create", "Lnet/corda/v5/crypto/SecureHash;", "str", "", "crypto-api"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final SecureHash create(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            int idx = StringsKt.indexOf$default((CharSequence)str, (char)':', (int)0, (boolean)false, (int)6, null);
            if (idx == -1) {
                throw (Throwable)new IllegalArgumentException("Provided string should be of format algorithm:hexadecimal");
            }
            String string = str;
            int n = 0;
            int n2 = 0;
            String string2 = string.substring(n, idx);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String algorithm = string2;
            String string3 = str;
            n2 = idx + 1;
            boolean bl = false;
            String string4 = string3.substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            String value = string4;
            byte[] data = ByteArrays.parseAsHex((String)value);
            return new SecureHash(algorithm, data);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

