/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.crypto.internal;

import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lnet/corda/v5/crypto/internal/AliasPrivateKey;", "Ljava/security/PrivateKey;", "alias", "", "(Ljava/lang/String;)V", "getAlias", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "getAlgorithm", "getEncoded", "", "getFormat", "hashCode", "", "toString", "Companion", "crypto-api"})
public final class AliasPrivateKey
implements PrivateKey {
    @NotNull
    private final String alias;
    @NotNull
    public static final String ALIAS_KEY_ALGORITHM = "AliasPrivateKey";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getAlgorithm() {
        return ALIAS_KEY_ALGORITHM;
    }

    @Override
    @NotNull
    public byte[] getEncoded() {
        ASN1EncodableVector keyVector = new ASN1EncodableVector();
        keyVector.add((ASN1Encodable)new DERUTF8String(this.alias));
        byte[] privateKeyInfoBytes = new PrivateKeyInfo(new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.3.6.1.4.1.50530.1.2")), (ASN1Encodable)new DERSequence(keyVector)).getEncoded("DER");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyInfoBytes);
        byte[] byArray = keySpec.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"keySpec.encoded");
        return byArray;
    }

    @Override
    @NotNull
    public String getFormat() {
        return "PKCS#8";
    }

    @NotNull
    public final String getAlias() {
        return this.alias;
    }

    public AliasPrivateKey(@NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        this.alias = alias;
    }

    @NotNull
    public final String component1() {
        return this.alias;
    }

    @NotNull
    public final AliasPrivateKey copy(@NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        return new AliasPrivateKey(alias);
    }

    public static /* synthetic */ AliasPrivateKey copy$default(AliasPrivateKey aliasPrivateKey, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = aliasPrivateKey.alias;
        }
        return aliasPrivateKey.copy(string);
    }

    @NotNull
    public String toString() {
        return "AliasPrivateKey(alias=" + this.alias + ")";
    }

    public int hashCode() {
        String string = this.alias;
        return string != null ? string.hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof AliasPrivateKey)) break block3;
                AliasPrivateKey aliasPrivateKey = (AliasPrivateKey)object;
                if (!Intrinsics.areEqual((Object)this.alias, (Object)aliasPrivateKey.alias)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/v5/crypto/internal/AliasPrivateKey$Companion;", "", "()V", "ALIAS_KEY_ALGORITHM", "", "crypto-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

