/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.crypto.internal;

import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.corda.v5.crypto.internal.DigestAlgorithm;
import org.bouncycastle.crypto.digests.Blake2sDigest;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lnet/corda/v5/crypto/internal/BLAKE2s256TestDigest;", "Lnet/corda/v5/crypto/internal/DigestAlgorithm;", "()V", "algorithm", "", "getAlgorithm", "()Ljava/lang/String;", "digestLength", "", "getDigestLength", "()I", "digest", "", "bytes", "crypto-api"})
public final class BLAKE2s256TestDigest
implements DigestAlgorithm {
    @NotNull
    private final String algorithm;
    private final int digestLength;

    @Override
    @NotNull
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public int getDigestLength() {
        return this.digestLength;
    }

    @Override
    @NotNull
    public byte[] digest(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int n = this.getDigestLength();
        String string = "12345678";
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        Blake2sDigest blake2s256 = new Blake2sDigest(null, n, null, byArray);
        blake2s256.reset();
        blake2s256.update(bytes, 0, bytes.length);
        byte[] hash = new byte[this.getDigestLength()];
        blake2s256.doFinal(hash, 0);
        return hash;
    }

    public BLAKE2s256TestDigest() {
        this.algorithm = "BLAKE_TEST";
        this.digestLength = 32;
    }
}

