/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.crypto.internal;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.v5.crypto.CompositeKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J-\u0010\t\u001a\u0002H\n\"\b\b\u0000\u0010\n*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\n0\rH\u0014\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u0010"}, d2={"Lnet/corda/v5/crypto/internal/CompositeKeyFactory;", "Ljava/security/KeyFactorySpi;", "()V", "engineGeneratePrivate", "Ljava/security/PrivateKey;", "keySpec", "Ljava/security/spec/KeySpec;", "engineGeneratePublic", "Ljava/security/PublicKey;", "engineGetKeySpec", "T", "key", "Ljava/security/Key;", "Ljava/lang/Class;", "(Ljava/security/Key;Ljava/lang/Class;)Ljava/security/spec/KeySpec;", "engineTranslateKey", "crypto-api"})
public final class CompositeKeyFactory
extends KeyFactorySpi {
    @Override
    @NotNull
    protected PrivateKey engineGeneratePrivate(@NotNull KeySpec keySpec) throws InvalidKeySpecException {
        Intrinsics.checkNotNullParameter((Object)keySpec, (String)"keySpec");
        throw (Throwable)new InvalidKeySpecException("key spec not recognised: " + keySpec.getClass());
    }

    @Override
    @Nullable
    protected PublicKey engineGeneratePublic(@NotNull KeySpec keySpec) throws InvalidKeySpecException {
        Intrinsics.checkNotNullParameter((Object)keySpec, (String)"keySpec");
        KeySpec keySpec2 = keySpec;
        if (!(keySpec2 instanceof X509EncodedKeySpec)) {
            throw (Throwable)new InvalidKeySpecException("key spec not recognised: " + keySpec.getClass());
        }
        byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"keySpec.encoded");
        return CompositeKey.Companion.getInstance(byArray);
    }

    @Override
    @NotNull
    protected <T extends KeySpec> T engineGetKeySpec(@NotNull Key key, @NotNull Class<T> keySpec) throws InvalidKeySpecException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(keySpec, (String)"keySpec");
        throw (Throwable)new InvalidKeySpecException("Not implemented yet " + key + ' ' + keySpec);
    }

    @Override
    @NotNull
    protected Key engineTranslateKey(@NotNull Key key) throws InvalidKeyException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        throw (Throwable)new InvalidKeyException("No other composite key providers known");
    }
}

