/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.crypto.internal;

import java.io.ByteArrayOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.v5.crypto.CompositeKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0002J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0015J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\u0012\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u001c\u0010\u0011\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u0015J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J \u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0014J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0016H\u0014R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lnet/corda/v5/crypto/internal/CompositeSignature;", "Ljava/security/Signature;", "()V", "signatureState", "Lnet/corda/v5/crypto/internal/CompositeSignature$State;", "assertInitialised", "engineGetParameter", "", "param", "", "engineInitSign", "", "privateKey", "Ljava/security/PrivateKey;", "engineInitVerify", "publicKey", "Ljava/security/PublicKey;", "engineSetParameter", "params", "Ljava/security/spec/AlgorithmParameterSpec;", "value", "engineSign", "", "engineUpdate", "b", "", "off", "", "len", "engineVerify", "", "sigBytes", "Companion", "State", "crypto-api"})
public final class CompositeSignature
extends Signature {
    private State signatureState;
    @NotNull
    public static final String SIGNATURE_ALGORITHM = "COMPOSITESIG";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final State assertInitialised() throws SignatureException {
        if (this.signatureState == null) {
            throw (Throwable)new SignatureException("Engine has not been initialised");
        }
        State state = this.signatureState;
        Intrinsics.checkNotNull((Object)state);
        return state;
    }

    @Override
    @Deprecated(message="Deprecated in inherited API")
    @NotNull
    protected Object engineGetParameter(@Nullable String param) throws InvalidAlgorithmParameterException {
        throw (Throwable)new InvalidAlgorithmParameterException("Composite signatures do not support any parameters");
    }

    @Override
    protected void engineInitSign(@Nullable PrivateKey privateKey) throws InvalidKeyException {
        throw (Throwable)new InvalidKeyException("Composite signatures must be assembled independently from signatures provided by the component private keys");
    }

    @Override
    protected void engineInitVerify(@Nullable PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof CompositeKey)) {
            throw (Throwable)new InvalidKeyException("Key to verify must be a composite key");
        }
        this.signatureState = new State(new ByteArrayOutputStream(1024), (CompositeKey)publicKey);
    }

    @Override
    @Deprecated(message="Deprecated in inherited API")
    protected void engineSetParameter(@Nullable String param, @Nullable Object value) throws InvalidAlgorithmParameterException {
        throw (Throwable)new InvalidAlgorithmParameterException("Composite signatures do not support any parameters");
    }

    @Override
    protected void engineSetParameter(@NotNull AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        throw (Throwable)new InvalidAlgorithmParameterException("Composite signatures do not support any parameters");
    }

    @Override
    @NotNull
    protected byte[] engineSign() throws SignatureException {
        throw (Throwable)new SignatureException("Composite signatures must be assembled independently from signatures provided by the component private keys");
    }

    @Override
    protected void engineUpdate(byte b) {
        this.assertInitialised().getBuffer().write(b);
    }

    @Override
    protected void engineUpdate(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.assertInitialised().getBuffer().write(b, off, len);
    }

    @Override
    protected boolean engineVerify(@NotNull byte[] sigBytes) throws SignatureException {
        Intrinsics.checkNotNullParameter((Object)sigBytes, (String)"sigBytes");
        return this.assertInitialised().engineVerify(sigBytes);
    }

    public CompositeSignature() {
        super(SIGNATURE_ALGORITHM);
    }

    @JvmStatic
    @NotNull
    public static final Provider.Service getService(@NotNull Provider provider) {
        return Companion.getService(provider);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0013\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lnet/corda/v5/crypto/internal/CompositeSignature$State;", "", "buffer", "Ljava/io/ByteArrayOutputStream;", "verifyKey", "Lnet/corda/v5/crypto/CompositeKey;", "(Ljava/io/ByteArrayOutputStream;Lnet/corda/v5/crypto/CompositeKey;)V", "getBuffer", "()Ljava/io/ByteArrayOutputStream;", "getVerifyKey", "()Lnet/corda/v5/crypto/CompositeKey;", "component1", "component2", "copy", "engineVerify", "", "sigBytes", "", "equals", "other", "hashCode", "", "toString", "", "crypto-api"})
    public static final class State {
        @NotNull
        private final ByteArrayOutputStream buffer;
        @NotNull
        private final CompositeKey verifyKey;

        public final boolean engineVerify(@NotNull byte[] sigBytes) {
            Intrinsics.checkNotNullParameter((Object)sigBytes, (String)"sigBytes");
            throw (Throwable)new UnsupportedOperationException("CompositeSignature.engineVerify unimplemented");
        }

        @NotNull
        public final ByteArrayOutputStream getBuffer() {
            return this.buffer;
        }

        @NotNull
        public final CompositeKey getVerifyKey() {
            return this.verifyKey;
        }

        public State(@NotNull ByteArrayOutputStream buffer, @NotNull CompositeKey verifyKey) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter((Object)verifyKey, (String)"verifyKey");
            this.buffer = buffer;
            this.verifyKey = verifyKey;
        }

        @NotNull
        public final ByteArrayOutputStream component1() {
            return this.buffer;
        }

        @NotNull
        public final CompositeKey component2() {
            return this.verifyKey;
        }

        @NotNull
        public final State copy(@NotNull ByteArrayOutputStream buffer, @NotNull CompositeKey verifyKey) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter((Object)verifyKey, (String)"verifyKey");
            return new State(buffer, verifyKey);
        }

        public static /* synthetic */ State copy$default(State state, ByteArrayOutputStream byteArrayOutputStream, CompositeKey compositeKey, int n, Object object) {
            if ((n & 1) != 0) {
                byteArrayOutputStream = state.buffer;
            }
            if ((n & 2) != 0) {
                compositeKey = state.verifyKey;
            }
            return state.copy(byteArrayOutputStream, compositeKey);
        }

        @NotNull
        public String toString() {
            return "State(buffer=" + this.buffer + ", verifyKey=" + this.verifyKey + ")";
        }

        public int hashCode() {
            ByteArrayOutputStream byteArrayOutputStream = this.buffer;
            CompositeKey compositeKey = this.verifyKey;
            return (byteArrayOutputStream != null ? byteArrayOutputStream.hashCode() : 0) * 31 + (compositeKey != null ? ((Object)compositeKey).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof State)) break block3;
                    State state = (State)object;
                    if (!Intrinsics.areEqual((Object)this.buffer, (Object)state.buffer) || !Intrinsics.areEqual((Object)this.verifyKey, (Object)state.verifyKey)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnet/corda/v5/crypto/internal/CompositeSignature$Companion;", "", "()V", "SIGNATURE_ALGORITHM", "", "getService", "Ljava/security/Provider$Service;", "provider", "Ljava/security/Provider;", "crypto-api"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Provider.Service getService(@NotNull Provider provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            return new Provider.Service(provider, "Signature", CompositeSignature.SIGNATURE_ALGORITHM, CompositeSignature.class.getName(), CollectionsKt.emptyList(), MapsKt.emptyMap());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

