/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.crypto.internal;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import net.corda.v5.crypto.CompositeKey;
import net.corda.v5.crypto.CryptoUtils;
import net.corda.v5.crypto.internal.AliasPrivateKey;
import net.corda.v5.crypto.internal.CordaObjectIdentifier;
import net.corda.v5.crypto.internal.CryptoUtilsInternal;
import net.corda.v5.crypto.internal.Instances;
import net.corda.v5.crypto.internal.ProviderMapKt;
import net.corda.v5.crypto.internal.SignatureScheme;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.math.Curve;
import net.i2p.crypto.eddsa.math.GroupElement;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.bc.BCObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.math.ec.WNafUtil;
import org.bouncycastle.pqc.jcajce.provider.sphincs.BCSphincs256PrivateKey;
import org.bouncycastle.pqc.jcajce.provider.sphincs.BCSphincs256PublicKey;
import org.bouncycastle.pqc.jcajce.spec.SPHINCS256KeyGenParameterSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0018\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0018\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u001cH\u0002J\u0018\u0010(\u001a\u00020!2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u001cH\u0007J \u0010(\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u001cH\u0007J \u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020+2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u001cH\u0002J\u0018\u0010,\u001a\u00020!2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u001cH\u0002J\u0010\u0010-\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0007J\u0018\u0010-\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#H\u0007J\u0018\u0010.\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u001cH\u0007J \u0010.\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u001cH\u0007J \u0010.\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u001cH\u0007J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0011H\u0007J\u0010\u00103\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0013H\u0007J\u0010\u00103\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0016H\u0007J\u0010\u00103\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0011H\u0007J\u0010\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u000fH\u0007J\b\u00105\u001a\u00020!H\u0007J\u0010\u00105\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u0011H\u0007J\u0010\u00105\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u0004H\u0007J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010:\u001a\u0002072\u0006\u0010\u001e\u001a\u00020\u0004H\u0007J\u0010\u0010;\u001a\u00020<2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\u0010\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\u000fH\u0002J\u0018\u0010?\u001a\u0002072\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u0016H\u0007J\b\u0010@\u001a\u00020AH\u0007J\b\u0010B\u001a\u00020AH\u0002J\u000e\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00040DH\u0007J\u0010\u0010E\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0007J\u0010\u0010F\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0016H\u0007J\u0010\u0010F\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020GH\u0007J\u0010\u0010H\u001a\u0002072\u0006\u0010\u0014\u001a\u00020\u0016H\u0007J\u0018\u0010H\u001a\u0002072\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0016H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lnet/corda/v5/crypto/internal/Crypto;", "", "()V", "COMPOSITE_KEY", "Lnet/corda/v5/crypto/internal/SignatureScheme;", "DEFAULT_SIGNATURE_SCHEME", "ECDSA_SECP256K1_SHA256", "ECDSA_SECP256R1_SHA256", "EDDSA_ED25519_SHA512", "RSA_SHA256", "SHA512_256", "Lorg/bouncycastle/asn1/DLSequence;", "SPHINCS256_SHA256", "algorithmMap", "", "Lorg/bouncycastle/asn1/x509/AlgorithmIdentifier;", "signatureSchemeMap", "", "convertIfBCEdDSAPrivateKey", "Ljava/security/PrivateKey;", "key", "convertIfBCEdDSAPublicKey", "Ljava/security/PublicKey;", "decodeAliasPrivateKey", "keyInfo", "Lorg/bouncycastle/asn1/pkcs/PrivateKeyInfo;", "decodePrivateKey", "encodedKey", "", "schemeCodeName", "signatureScheme", "decodePublicKey", "deriveECDSAKeyPairFromEntropy", "Ljava/security/KeyPair;", "entropy", "Ljava/math/BigInteger;", "deriveEdDSAKeyPairFromEntropy", "deriveHMAC", "privateKey", "seed", "deriveKeyPair", "deriveKeyPairECDSA", "parameterSpec", "Lorg/bouncycastle/jce/spec/ECParameterSpec;", "deriveKeyPairEdDSA", "deriveKeyPairFromEntropy", "doSign", "clearData", "findProvider", "Ljava/security/Provider;", "name", "findSignatureScheme", "algorithm", "generateKeyPair", "isEdDSAPointAtInfinity", "", "publicKey", "Lnet/i2p/crypto/eddsa/EdDSAPublicKey;", "isSupportedSignatureScheme", "keyFactory", "Ljava/security/KeyFactory;", "normaliseAlgorithmIdentifier", "id", "publicKeyOnCurve", "registerProviders", "", "setBouncyCastleRNG", "supportedSignatureSchemes", "", "toSupportedPrivateKey", "toSupportedPublicKey", "Lorg/bouncycastle/asn1/x509/SubjectPublicKeyInfo;", "validatePublicKey", "crypto-api"})
public final class Crypto {
    @JvmField
    @NotNull
    public static final SignatureScheme RSA_SHA256;
    @JvmField
    @NotNull
    public static final SignatureScheme ECDSA_SECP256K1_SHA256;
    @JvmField
    @NotNull
    public static final SignatureScheme ECDSA_SECP256R1_SHA256;
    @JvmField
    @NotNull
    public static final SignatureScheme EDDSA_ED25519_SHA512;
    @JvmField
    @NotNull
    public static final DLSequence SHA512_256;
    @JvmField
    @NotNull
    public static final SignatureScheme SPHINCS256_SHA256;
    @JvmField
    @NotNull
    public static final SignatureScheme COMPOSITE_KEY;
    @JvmField
    @NotNull
    public static final SignatureScheme DEFAULT_SIGNATURE_SCHEME;
    private static final Map<String, SignatureScheme> signatureSchemeMap;
    private static final Map<AlgorithmIdentifier, SignatureScheme> algorithmMap;
    @NotNull
    public static final Crypto INSTANCE;

    @JvmStatic
    @NotNull
    public static final List<SignatureScheme> supportedSignatureSchemes() {
        return new ArrayList<SignatureScheme>(signatureSchemeMap.values());
    }

    @JvmStatic
    @NotNull
    public static final Provider findProvider(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Provider provider = ProviderMapKt.getProviderMap().get(name);
        if (provider == null) {
            throw (Throwable)new IllegalArgumentException("Unrecognised provider: " + name);
        }
        return provider;
    }

    private final AlgorithmIdentifier normaliseAlgorithmIdentifier(AlgorithmIdentifier id) {
        return id.getParameters() instanceof DERNull ? new AlgorithmIdentifier(id.getAlgorithm(), null) : id;
    }

    @JvmStatic
    @NotNull
    public static final SignatureScheme findSignatureScheme(@NotNull AlgorithmIdentifier algorithm) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        SignatureScheme signatureScheme = algorithmMap.get(INSTANCE.normaliseAlgorithmIdentifier(algorithm));
        if (signatureScheme == null) {
            StringBuilder stringBuilder = new StringBuilder().append("Unrecognised algorithm: ");
            ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithm.getAlgorithm();
            Intrinsics.checkNotNullExpressionValue((Object)aSN1ObjectIdentifier, (String)"algorithm.algorithm");
            throw (Throwable)new IllegalArgumentException(stringBuilder.append(aSN1ObjectIdentifier.getId()).toString());
        }
        return signatureScheme;
    }

    @JvmStatic
    @NotNull
    public static final SignatureScheme findSignatureScheme(@NotNull String schemeCodeName) {
        Intrinsics.checkNotNullParameter((Object)schemeCodeName, (String)"schemeCodeName");
        SignatureScheme signatureScheme = signatureSchemeMap.get(schemeCodeName);
        if (signatureScheme == null) {
            throw (Throwable)new IllegalArgumentException("Unsupported key/algorithm for schemeCodeName: " + schemeCodeName);
        }
        return signatureScheme;
    }

    @JvmStatic
    @NotNull
    public static final SignatureScheme findSignatureScheme(@NotNull PublicKey key) {
        SubjectPublicKeyInfo keyInfo;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SubjectPublicKeyInfo subjectPublicKeyInfo = keyInfo = SubjectPublicKeyInfo.getInstance((Object)key.getEncoded());
        Intrinsics.checkNotNullExpressionValue((Object)subjectPublicKeyInfo, (String)"keyInfo");
        AlgorithmIdentifier algorithmIdentifier = subjectPublicKeyInfo.getAlgorithm();
        Intrinsics.checkNotNullExpressionValue((Object)algorithmIdentifier, (String)"keyInfo.algorithm");
        return Crypto.findSignatureScheme(algorithmIdentifier);
    }

    @JvmStatic
    @NotNull
    public static final SignatureScheme findSignatureScheme(@NotNull PrivateKey key) {
        PrivateKeyInfo keyInfo;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        PrivateKeyInfo privateKeyInfo = keyInfo = PrivateKeyInfo.getInstance((Object)key.getEncoded());
        Intrinsics.checkNotNullExpressionValue((Object)privateKeyInfo, (String)"keyInfo");
        AlgorithmIdentifier algorithmIdentifier = privateKeyInfo.getPrivateKeyAlgorithm();
        Intrinsics.checkNotNullExpressionValue((Object)algorithmIdentifier, (String)"keyInfo.privateKeyAlgorithm");
        return Crypto.findSignatureScheme(algorithmIdentifier);
    }

    @JvmStatic
    @NotNull
    public static final PrivateKey decodePrivateKey(@NotNull byte[] encodedKey) {
        PrivateKeyInfo keyInfo;
        Intrinsics.checkNotNullParameter((Object)encodedKey, (String)"encodedKey");
        PrivateKeyInfo privateKeyInfo = keyInfo = PrivateKeyInfo.getInstance((Object)encodedKey);
        Intrinsics.checkNotNullExpressionValue((Object)privateKeyInfo, (String)"keyInfo");
        AlgorithmIdentifier algorithmIdentifier = privateKeyInfo.getPrivateKeyAlgorithm();
        Intrinsics.checkNotNullExpressionValue((Object)algorithmIdentifier, (String)"keyInfo.privateKeyAlgorithm");
        if (Intrinsics.areEqual((Object)algorithmIdentifier.getAlgorithm(), (Object)new ASN1ObjectIdentifier("1.3.6.1.4.1.50530.1.2"))) {
            return INSTANCE.convertIfBCEdDSAPrivateKey(INSTANCE.decodeAliasPrivateKey(keyInfo));
        }
        AlgorithmIdentifier algorithmIdentifier2 = keyInfo.getPrivateKeyAlgorithm();
        Intrinsics.checkNotNullExpressionValue((Object)algorithmIdentifier2, (String)"keyInfo.privateKeyAlgorithm");
        SignatureScheme signatureScheme = Crypto.findSignatureScheme(algorithmIdentifier2);
        KeyFactory keyFactory2 = INSTANCE.keyFactory(signatureScheme);
        PrivateKey privateKey = keyFactory2.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"keyFactory.generatePriva\u2026codedKeySpec(encodedKey))");
        return INSTANCE.convertIfBCEdDSAPrivateKey(privateKey);
    }

    private final PrivateKey decodeAliasPrivateKey(PrivateKeyInfo keyInfo) {
        String alias;
        ASN1Encodable derutF8String;
        ASN1Encodable aSN1Encodable = keyInfo.parsePrivateKey();
        if (aSN1Encodable == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.bouncycastle.asn1.DLSequence");
        }
        DLSequence encodable = (DLSequence)aSN1Encodable;
        ASN1Encodable aSN1Encodable2 = derutF8String = encodable.getObjectAt(0);
        if (aSN1Encodable2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.bouncycastle.asn1.DERUTF8String");
        }
        String string = alias = ((DERUTF8String)aSN1Encodable2).getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"alias");
        return new AliasPrivateKey(string);
    }

    @JvmStatic
    @NotNull
    public static final PrivateKey decodePrivateKey(@NotNull String schemeCodeName, @NotNull byte[] encodedKey) throws InvalidKeySpecException {
        Intrinsics.checkNotNullParameter((Object)schemeCodeName, (String)"schemeCodeName");
        Intrinsics.checkNotNullParameter((Object)encodedKey, (String)"encodedKey");
        return Crypto.decodePrivateKey(Crypto.findSignatureScheme(schemeCodeName), encodedKey);
    }

    @JvmStatic
    @NotNull
    public static final PrivateKey decodePrivateKey(@NotNull SignatureScheme signatureScheme, @NotNull byte[] encodedKey) throws InvalidKeySpecException {
        Intrinsics.checkNotNullParameter((Object)signatureScheme, (String)"signatureScheme");
        Intrinsics.checkNotNullParameter((Object)encodedKey, (String)"encodedKey");
        boolean bl = Crypto.isSupportedSignatureScheme(signatureScheme);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Unsupported key/algorithm for schemeCodeName: " + signatureScheme.getSchemeCodeName();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        try {
            KeyFactory keyFactory2 = INSTANCE.keyFactory(signatureScheme);
            PrivateKey privateKey = keyFactory2.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
            Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"keyFactory.generatePriva\u2026codedKeySpec(encodedKey))");
            return INSTANCE.convertIfBCEdDSAPrivateKey(privateKey);
        }
        catch (InvalidKeySpecException ikse) {
            throw (Throwable)new InvalidKeySpecException("This private key cannot be decoded, please ensure it is PKCS8 encoded and that it corresponds to the input scheme's code name.", ikse);
        }
    }

    @JvmStatic
    @NotNull
    public static final PublicKey decodePublicKey(@NotNull byte[] encodedKey) {
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        Intrinsics.checkNotNullParameter((Object)encodedKey, (String)"encodedKey");
        SubjectPublicKeyInfo subjectPublicKeyInfo2 = subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)encodedKey);
        Intrinsics.checkNotNullExpressionValue((Object)subjectPublicKeyInfo2, (String)"subjectPublicKeyInfo");
        AlgorithmIdentifier algorithmIdentifier = subjectPublicKeyInfo2.getAlgorithm();
        Intrinsics.checkNotNullExpressionValue((Object)algorithmIdentifier, (String)"subjectPublicKeyInfo.algorithm");
        SignatureScheme signatureScheme = Crypto.findSignatureScheme(algorithmIdentifier);
        KeyFactory keyFactory2 = INSTANCE.keyFactory(signatureScheme);
        PublicKey publicKey = keyFactory2.generatePublic(new X509EncodedKeySpec(encodedKey));
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"keyFactory.generatePubli\u2026codedKeySpec(encodedKey))");
        return INSTANCE.convertIfBCEdDSAPublicKey(publicKey);
    }

    @JvmStatic
    @NotNull
    public static final PublicKey decodePublicKey(@NotNull String schemeCodeName, @NotNull byte[] encodedKey) throws InvalidKeySpecException {
        Intrinsics.checkNotNullParameter((Object)schemeCodeName, (String)"schemeCodeName");
        Intrinsics.checkNotNullParameter((Object)encodedKey, (String)"encodedKey");
        return Crypto.decodePublicKey(Crypto.findSignatureScheme(schemeCodeName), encodedKey);
    }

    @JvmStatic
    @NotNull
    public static final PublicKey decodePublicKey(@NotNull SignatureScheme signatureScheme, @NotNull byte[] encodedKey) throws InvalidKeySpecException {
        Intrinsics.checkNotNullParameter((Object)signatureScheme, (String)"signatureScheme");
        Intrinsics.checkNotNullParameter((Object)encodedKey, (String)"encodedKey");
        boolean bl = Crypto.isSupportedSignatureScheme(signatureScheme);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Unsupported key/algorithm for schemeCodeName: " + signatureScheme.getSchemeCodeName();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        try {
            KeyFactory keyFactory2 = INSTANCE.keyFactory(signatureScheme);
            PublicKey publicKey = keyFactory2.generatePublic(new X509EncodedKeySpec(encodedKey));
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"keyFactory.generatePubli\u2026codedKeySpec(encodedKey))");
            return INSTANCE.convertIfBCEdDSAPublicKey(publicKey);
        }
        catch (InvalidKeySpecException ikse) {
            throw (Throwable)new InvalidKeySpecException("This public key cannot be decoded, please ensure it is X509 encoded and that it corresponds to the input scheme's code name.", ikse);
        }
    }

    @JvmStatic
    @NotNull
    public static final byte[] doSign(@NotNull PrivateKey privateKey, @NotNull byte[] clearData) throws InvalidKeyException, SignatureException {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)clearData, (String)"clearData");
        return Crypto.doSign(Crypto.findSignatureScheme(privateKey), privateKey, clearData);
    }

    @JvmStatic
    @NotNull
    public static final byte[] doSign(@NotNull String schemeCodeName, @NotNull PrivateKey privateKey, @NotNull byte[] clearData) throws InvalidKeyException, SignatureException {
        Intrinsics.checkNotNullParameter((Object)schemeCodeName, (String)"schemeCodeName");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)clearData, (String)"clearData");
        return Crypto.doSign(Crypto.findSignatureScheme(schemeCodeName), privateKey, clearData);
    }

    @JvmStatic
    @NotNull
    public static final byte[] doSign(@NotNull SignatureScheme signatureScheme, @NotNull PrivateKey privateKey, @NotNull byte[] clearData) throws InvalidKeyException, SignatureException {
        Intrinsics.checkNotNullParameter((Object)signatureScheme, (String)"signatureScheme");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)clearData, (String)"clearData");
        boolean bl = Crypto.isSupportedSignatureScheme(signatureScheme);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Unsupported key/algorithm for schemeCodeName: " + signatureScheme.getSchemeCodeName();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        byte[] byArray = clearData;
        bl2 = false;
        byte[] byArray2 = byArray;
        boolean bl4 = false;
        boolean bl5 = !(byArray2.length == 0);
        bl2 = false;
        boolean bl6 = false;
        if (!bl5) {
            boolean bl7 = false;
            String string = "Signing of an empty array is not permitted!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Object a = Instances.INSTANCE.withSignature(signatureScheme, (Function1)new Function1<Signature, byte[]>(signatureScheme, privateKey, clearData){
            final /* synthetic */ SignatureScheme $signatureScheme;
            final /* synthetic */ PrivateKey $privateKey;
            final /* synthetic */ byte[] $clearData;

            public final byte[] invoke(@NotNull Signature signature) {
                Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                if (Intrinsics.areEqual((Object)this.$signatureScheme, (Object)Crypto.EDDSA_ED25519_SHA512) || Intrinsics.areEqual((Object)this.$signatureScheme, (Object)Crypto.SPHINCS256_SHA256) || Intrinsics.areEqual((Object)this.$signatureScheme, (Object)Crypto.RSA_SHA256)) {
                    signature.initSign(this.$privateKey);
                } else {
                    signature.initSign(this.$privateKey, CryptoUtilsInternal.newSecureRandom());
                }
                signature.update(this.$clearData);
                return signature.sign();
            }
            {
                this.$signatureScheme = signatureScheme;
                this.$privateKey = privateKey;
                this.$clearData = byArray;
                super(1);
            }
        });
        Intrinsics.checkNotNullExpressionValue(a, (String)"withSignature(signatureS\u2026ignature.sign()\n        }");
        return (byte[])a;
    }

    @JvmStatic
    @NotNull
    public static final KeyPair generateKeyPair(@NotNull String schemeCodeName) {
        Intrinsics.checkNotNullParameter((Object)schemeCodeName, (String)"schemeCodeName");
        return Crypto.generateKeyPair(Crypto.findSignatureScheme(schemeCodeName));
    }

    @JvmStatic
    @NotNull
    public static final KeyPair generateKeyPair(@NotNull SignatureScheme signatureScheme) {
        Intrinsics.checkNotNullParameter((Object)signatureScheme, (String)"signatureScheme");
        boolean bl = Crypto.isSupportedSignatureScheme(signatureScheme);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Unsupported key/algorithm for schemeCodeName: " + signatureScheme.getSchemeCodeName();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(signatureScheme.getAlgorithmName(), ProviderMapKt.getProviderMap().get(signatureScheme.getProviderName()));
        if (signatureScheme.getAlgSpec() != null) {
            keyPairGenerator.initialize(signatureScheme.getAlgSpec(), CryptoUtilsInternal.newSecureRandom());
        } else {
            Integer n = signatureScheme.getKeySize();
            Intrinsics.checkNotNull((Object)n);
            keyPairGenerator.initialize(n, CryptoUtilsInternal.newSecureRandom());
        }
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"keyPairGenerator.generateKeyPair()");
        return keyPair;
    }

    @JvmStatic
    @NotNull
    public static final KeyPair generateKeyPair() {
        return Crypto.generateKeyPair(DEFAULT_SIGNATURE_SCHEME);
    }

    @JvmStatic
    @NotNull
    public static final KeyPair deriveKeyPair(@NotNull SignatureScheme signatureScheme, @NotNull PrivateKey privateKey, @NotNull byte[] seed) {
        KeyPair keyPair;
        Intrinsics.checkNotNullParameter((Object)signatureScheme, (String)"signatureScheme");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        boolean bl = Crypto.isSupportedSignatureScheme(signatureScheme);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Unsupported key/algorithm for schemeCodeName: " + signatureScheme.getSchemeCodeName();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        SignatureScheme signatureScheme2 = signatureScheme;
        if (Intrinsics.areEqual((Object)signatureScheme2, (Object)ECDSA_SECP256R1_SHA256) || Intrinsics.areEqual((Object)signatureScheme2, (Object)ECDSA_SECP256K1_SHA256)) {
            AlgorithmParameterSpec algorithmParameterSpec = signatureScheme.getAlgSpec();
            if (algorithmParameterSpec == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.bouncycastle.jce.spec.ECParameterSpec");
            }
            keyPair = INSTANCE.deriveKeyPairECDSA((ECParameterSpec)algorithmParameterSpec, privateKey, seed);
        } else if (Intrinsics.areEqual((Object)signatureScheme2, (Object)EDDSA_ED25519_SHA512)) {
            keyPair = INSTANCE.deriveKeyPairEdDSA(privateKey, seed);
        } else {
            throw (Throwable)new UnsupportedOperationException("Although supported for signing, deterministic key derivation is " + "not currently implemented for " + signatureScheme.getSchemeCodeName());
        }
        return keyPair;
    }

    @JvmStatic
    @NotNull
    public static final KeyPair deriveKeyPair(@NotNull PrivateKey privateKey, @NotNull byte[] seed) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        return Crypto.deriveKeyPair(Crypto.findSignatureScheme(privateKey), privateKey, seed);
    }

    private final KeyPair deriveKeyPairECDSA(ECParameterSpec parameterSpec, PrivateKey privateKey, byte[] seed) {
        ECPoint pointQ;
        byte[] macBytes;
        byte[] byArray = macBytes = this.deriveHMAC(privateKey, seed);
        ECCurve eCCurve = parameterSpec.getCurve();
        Intrinsics.checkNotNullExpressionValue((Object)eCCurve, (String)"parameterSpec.curve");
        int n = eCCurve.getFieldSize() / 8;
        boolean bl = false;
        byte[] byArray2 = Arrays.copyOf(byArray, n);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
        byte[] fieldSizeMacBytes = byArray2;
        BigInteger deterministicD = new BigInteger(1, fieldSizeMacBytes);
        if (deterministicD.compareTo(ECConstants.TWO) < 0 || WNafUtil.getNafWeight((BigInteger)deterministicD) < parameterSpec.getN().bitLength() >>> 2 || deterministicD.compareTo(parameterSpec.getN()) >= 0) {
            return this.deriveKeyPairECDSA(parameterSpec, privateKey, CryptoUtils.sha256Bytes(seed));
        }
        ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(deterministicD, parameterSpec);
        BCECPrivateKey privateKeyD = new BCECPrivateKey(privateKey.getAlgorithm(), privateKeySpec, BouncyCastleProvider.CONFIGURATION);
        ECPoint eCPoint = pointQ = new FixedPointCombMultiplier().multiply(parameterSpec.getG(), deterministicD);
        Intrinsics.checkNotNullExpressionValue((Object)eCPoint, (String)"pointQ");
        if (eCPoint.isInfinity()) {
            return this.deriveKeyPairECDSA(parameterSpec, privateKey, CryptoUtils.sha256Bytes(seed));
        }
        ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(pointQ, parameterSpec);
        BCECPublicKey publicKeyD = new BCECPublicKey(privateKey.getAlgorithm(), publicKeySpec, BouncyCastleProvider.CONFIGURATION);
        return new KeyPair((PublicKey)publicKeyD, (PrivateKey)privateKeyD);
    }

    private final KeyPair deriveKeyPairEdDSA(PrivateKey privateKey, byte[] seed) {
        byte[] macBytes = this.deriveHMAC(privateKey, seed);
        AlgorithmParameterSpec algorithmParameterSpec = EDDSA_ED25519_SHA512.getAlgSpec();
        if (algorithmParameterSpec == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec");
        }
        EdDSANamedCurveSpec params = (EdDSANamedCurveSpec)algorithmParameterSpec;
        byte[] byArray = macBytes;
        Curve curve = params.getCurve();
        Intrinsics.checkNotNullExpressionValue((Object)curve, (String)"params.curve");
        int n = curve.getField().getb() / 8;
        boolean bl = false;
        byte[] byArray2 = Arrays.copyOf(byArray, n);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
        byte[] bytes = byArray2;
        EdDSAPrivateKeySpec privateKeyD = new EdDSAPrivateKeySpec(bytes, (EdDSAParameterSpec)params);
        EdDSAPublicKeySpec publicKeyD = new EdDSAPublicKeySpec(privateKeyD.getA(), (EdDSAParameterSpec)params);
        return new KeyPair((PublicKey)new EdDSAPublicKey(publicKeyD), (PrivateKey)new EdDSAPrivateKey(privateKeyD));
    }

    @JvmStatic
    @NotNull
    public static final KeyPair deriveKeyPairFromEntropy(@NotNull SignatureScheme signatureScheme, @NotNull BigInteger entropy) {
        KeyPair keyPair;
        Intrinsics.checkNotNullParameter((Object)signatureScheme, (String)"signatureScheme");
        Intrinsics.checkNotNullParameter((Object)entropy, (String)"entropy");
        SignatureScheme signatureScheme2 = signatureScheme;
        if (Intrinsics.areEqual((Object)signatureScheme2, (Object)EDDSA_ED25519_SHA512)) {
            keyPair = INSTANCE.deriveEdDSAKeyPairFromEntropy(entropy);
        } else if (Intrinsics.areEqual((Object)signatureScheme2, (Object)ECDSA_SECP256R1_SHA256) || Intrinsics.areEqual((Object)signatureScheme2, (Object)ECDSA_SECP256K1_SHA256)) {
            keyPair = INSTANCE.deriveECDSAKeyPairFromEntropy(signatureScheme, entropy);
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported signature scheme for fixed entropy-based key pair " + "generation: " + signatureScheme.getSchemeCodeName());
        }
        return keyPair;
    }

    @JvmStatic
    @NotNull
    public static final KeyPair deriveKeyPairFromEntropy(@NotNull BigInteger entropy) {
        Intrinsics.checkNotNullParameter((Object)entropy, (String)"entropy");
        return Crypto.deriveKeyPairFromEntropy(DEFAULT_SIGNATURE_SCHEME, entropy);
    }

    private final KeyPair deriveEdDSAKeyPairFromEntropy(BigInteger entropy) {
        AlgorithmParameterSpec algorithmParameterSpec = EDDSA_ED25519_SHA512.getAlgSpec();
        if (algorithmParameterSpec == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec");
        }
        EdDSANamedCurveSpec params = (EdDSANamedCurveSpec)algorithmParameterSpec;
        byte[] byArray = entropy.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"entropy.toByteArray()");
        byte[] byArray2 = byArray;
        Curve curve = params.getCurve();
        Intrinsics.checkNotNullExpressionValue((Object)curve, (String)"params.curve");
        int n = curve.getField().getb() / 8;
        boolean bl = false;
        byte[] byArray3 = Arrays.copyOf(byArray2, n);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"java.util.Arrays.copyOf(this, newSize)");
        byte[] bytes = byArray3;
        EdDSAPrivateKeySpec priv = new EdDSAPrivateKeySpec(bytes, (EdDSAParameterSpec)params);
        EdDSAPublicKeySpec pub = new EdDSAPublicKeySpec(priv.getA(), (EdDSAParameterSpec)params);
        return new KeyPair((PublicKey)new EdDSAPublicKey(pub), (PrivateKey)new EdDSAPrivateKey(priv));
    }

    private final KeyPair deriveECDSAKeyPairFromEntropy(SignatureScheme signatureScheme, BigInteger entropy) {
        ECPoint pointQ;
        AlgorithmParameterSpec algorithmParameterSpec = signatureScheme.getAlgSpec();
        if (algorithmParameterSpec == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.bouncycastle.jce.spec.ECNamedCurveParameterSpec");
        }
        ECNamedCurveParameterSpec parameterSpec = (ECNamedCurveParameterSpec)algorithmParameterSpec;
        if (entropy.compareTo(ECConstants.TWO) < 0 || entropy.compareTo(parameterSpec.getN()) >= 0) {
            byte[] byArray = entropy.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"entropy.toByteArray()");
            return this.deriveECDSAKeyPairFromEntropy(signatureScheme, new BigInteger(1, CryptoUtils.sha256Bytes(byArray)));
        }
        ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(entropy, (ECParameterSpec)parameterSpec);
        BCECPrivateKey priv = new BCECPrivateKey("EC", privateKeySpec, BouncyCastleProvider.CONFIGURATION);
        ECPoint eCPoint = pointQ = new FixedPointCombMultiplier().multiply(parameterSpec.getG(), entropy);
        Intrinsics.checkNotNullExpressionValue((Object)eCPoint, (String)"pointQ");
        if (eCPoint.isInfinity()) {
            byte[] byArray = entropy.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"entropy.toByteArray()");
            return this.deriveECDSAKeyPairFromEntropy(signatureScheme, new BigInteger(1, CryptoUtils.sha256Bytes(byArray)));
        }
        ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(pointQ, (ECParameterSpec)parameterSpec);
        BCECPublicKey pub = new BCECPublicKey("EC", publicKeySpec, BouncyCastleProvider.CONFIGURATION);
        return new KeyPair((PublicKey)pub, (PrivateKey)priv);
    }

    private final byte[] deriveHMAC(PrivateKey privateKey, byte[] seed) {
        byte[] byArray;
        Mac mac = Mac.getInstance("HmacSHA512", ProviderMapKt.getCordaBouncyCastleProvider());
        PrivateKey privateKey2 = privateKey;
        if (privateKey2 instanceof BCECPrivateKey) {
            byArray = ((BCECPrivateKey)privateKey).getD().toByteArray();
        } else if (privateKey2 instanceof EdDSAPrivateKey) {
            byArray = ((EdDSAPrivateKey)privateKey).geta();
        } else {
            throw (Throwable)new InvalidKeyException("Key type " + privateKey.getAlgorithm() + " is not supported for deterministic key derivation");
        }
        byte[] keyData = byArray;
        SecretKeySpec key = new SecretKeySpec(keyData, "HmacSHA512");
        mac.init(key);
        byte[] byArray2 = mac.doFinal(seed);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"mac.doFinal(seed)");
        return byArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean publicKeyOnCurve(@NotNull SignatureScheme signatureScheme, @NotNull PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)signatureScheme, (String)"signatureScheme");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        boolean bl = Crypto.isSupportedSignatureScheme(signatureScheme);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Unsupported key/algorithm for schemeCodeName: " + signatureScheme.getSchemeCodeName();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        PublicKey publicKey2 = publicKey;
        if (publicKey2 instanceof BCECPublicKey) {
            if (!Intrinsics.areEqual((Object)((BCECPublicKey)publicKey).getParameters(), (Object)signatureScheme.getAlgSpec())) return false;
            ECPoint eCPoint = ((BCECPublicKey)publicKey).getQ();
            Intrinsics.checkNotNullExpressionValue((Object)eCPoint, (String)"publicKey.q");
            if (eCPoint.isInfinity()) return false;
            ECPoint eCPoint2 = ((BCECPublicKey)publicKey).getQ();
            Intrinsics.checkNotNullExpressionValue((Object)eCPoint2, (String)"publicKey.q");
            if (!eCPoint2.isValid()) return false;
            return true;
        }
        if (!(publicKey2 instanceof EdDSAPublicKey)) throw (Throwable)new IllegalArgumentException("Unsupported key type: " + Reflection.getOrCreateKotlinClass(publicKey.getClass()));
        if (!Intrinsics.areEqual((Object)((EdDSAPublicKey)publicKey).getParams(), (Object)signatureScheme.getAlgSpec())) return false;
        if (INSTANCE.isEdDSAPointAtInfinity((EdDSAPublicKey)publicKey)) return false;
        GroupElement groupElement = ((EdDSAPublicKey)publicKey).getA();
        Intrinsics.checkNotNullExpressionValue((Object)groupElement, (String)"publicKey.a");
        if (!groupElement.isOnCurve()) return false;
        return true;
    }

    private final boolean isEdDSAPointAtInfinity(EdDSAPublicKey publicKey) {
        AlgorithmParameterSpec algorithmParameterSpec = EDDSA_ED25519_SHA512.getAlgSpec();
        if (algorithmParameterSpec == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec");
        }
        return Intrinsics.areEqual((Object)publicKey.getA().toP3(), (Object)((EdDSANamedCurveSpec)algorithmParameterSpec).getCurve().getZero(GroupElement.Representation.P3));
    }

    @JvmStatic
    public static final boolean isSupportedSignatureScheme(@NotNull SignatureScheme signatureScheme) {
        Intrinsics.checkNotNullParameter((Object)signatureScheme, (String)"signatureScheme");
        Map<String, SignatureScheme> map = signatureSchemeMap;
        String string = signatureScheme.getSchemeCodeName();
        boolean bl = false;
        Map<String, SignatureScheme> map2 = map;
        boolean bl2 = false;
        return map2.containsKey(string);
    }

    @JvmStatic
    public static final boolean validatePublicKey(@NotNull PublicKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return INSTANCE.validatePublicKey(Crypto.findSignatureScheme(key), key);
    }

    private final boolean validatePublicKey(SignatureScheme signatureScheme, PublicKey key) {
        boolean bl;
        PublicKey publicKey = key;
        if (publicKey instanceof BCECPublicKey || publicKey instanceof EdDSAPublicKey) {
            bl = Crypto.publicKeyOnCurve(signatureScheme, key);
        } else if (publicKey instanceof BCRSAPublicKey) {
            bl = ((BCRSAPublicKey)key).getModulus().bitLength() >= 2048;
        } else if (publicKey instanceof BCSphincs256PublicKey) {
            bl = true;
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported key type: " + Reflection.getOrCreateKotlinClass(key.getClass()));
        }
        return bl;
    }

    private final PublicKey convertIfBCEdDSAPublicKey(PublicKey key) {
        PublicKey publicKey = key;
        return publicKey instanceof BCEdDSAPublicKey ? (PublicKey)new EdDSAPublicKey(new X509EncodedKeySpec(((BCEdDSAPublicKey)key).getEncoded())) : key;
    }

    @NotNull
    public final PrivateKey convertIfBCEdDSAPrivateKey(@NotNull PrivateKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        PrivateKey privateKey = key;
        return privateKey instanceof BCEdDSAPrivateKey ? (PrivateKey)new EdDSAPrivateKey(new PKCS8EncodedKeySpec(((BCEdDSAPrivateKey)key).getEncoded())) : key;
    }

    @JvmStatic
    @NotNull
    public static final PublicKey toSupportedPublicKey(@NotNull SubjectPublicKeyInfo key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        byte[] byArray = key.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"key.encoded");
        return Crypto.decodePublicKey(byArray);
    }

    @JvmStatic
    @NotNull
    public static final PublicKey toSupportedPublicKey(@NotNull PublicKey key) {
        PublicKey publicKey;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        PublicKey publicKey2 = key;
        if (publicKey2 instanceof BCECPublicKey) {
            publicKey = key;
        } else if (publicKey2 instanceof BCRSAPublicKey) {
            publicKey = key;
        } else if (publicKey2 instanceof BCSphincs256PublicKey) {
            publicKey = key;
        } else if (publicKey2 instanceof EdDSAPublicKey) {
            publicKey = key;
        } else if (publicKey2 instanceof CompositeKey) {
            publicKey = key;
        } else if (publicKey2 instanceof BCEdDSAPublicKey) {
            publicKey = INSTANCE.convertIfBCEdDSAPublicKey(key);
        } else {
            byte[] byArray = key.getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"key.encoded");
            publicKey = Crypto.decodePublicKey(byArray);
        }
        return publicKey;
    }

    @JvmStatic
    @NotNull
    public static final PrivateKey toSupportedPrivateKey(@NotNull PrivateKey key) {
        PrivateKey privateKey;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        PrivateKey privateKey2 = key;
        if (privateKey2 instanceof BCECPrivateKey) {
            privateKey = key;
        } else if (privateKey2 instanceof BCRSAPrivateKey) {
            privateKey = key;
        } else if (privateKey2 instanceof BCSphincs256PrivateKey) {
            privateKey = key;
        } else if (privateKey2 instanceof EdDSAPrivateKey) {
            privateKey = key;
        } else if (privateKey2 instanceof BCEdDSAPrivateKey) {
            privateKey = INSTANCE.convertIfBCEdDSAPrivateKey(key);
        } else {
            byte[] byArray = key.getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"key.encoded");
            privateKey = Crypto.decodePrivateKey(byArray);
        }
        return privateKey;
    }

    @JvmStatic
    public static final void registerProviders() {
        ProviderMapKt.getProviderMap();
        INSTANCE.setBouncyCastleRNG();
    }

    private final void setBouncyCastleRNG() {
        CryptoServicesRegistrar.setSecureRandom((SecureRandom)CryptoUtilsInternal.newSecureRandom());
    }

    private final KeyFactory keyFactory(SignatureScheme signatureScheme) {
        return signatureScheme.getKeyFactory$crypto_api((Function0<? extends KeyFactory>)((Function0)new Function0<KeyFactory>(signatureScheme){
            final /* synthetic */ SignatureScheme $signatureScheme;

            @NotNull
            public final KeyFactory invoke() {
                KeyFactory keyFactory2 = KeyFactory.getInstance(this.$signatureScheme.getAlgorithmName(), ProviderMapKt.getProviderMap().get(this.$signatureScheme.getProviderName()));
                Intrinsics.checkNotNullExpressionValue((Object)keyFactory2, (String)"KeyFactory.getInstance(s\u2026tureScheme.providerName])");
                return keyFactory2;
            }
            {
                this.$signatureScheme = signatureScheme;
                super(0);
            }
        }));
    }

    private Crypto() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Object object;
        Object object2;
        void $this$associateByTo$iv$iv;
        Crypto crypto;
        INSTANCE = crypto = new Crypto();
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha256WithRSAEncryption, null);
        List list = CollectionsKt.listOf((Object)new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, null));
        String string = ProviderMapKt.getCordaBouncyCastleProvider().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cordaBouncyCastleProvider.name");
        RSA_SHA256 = new SignatureScheme("CORDA.RSA.SHA256", algorithmIdentifier, list, string, "RSA", "SHA256WITHRSA", "SHA256", null, 3072, "RSA_SHA256 signature scheme using SHA256 as hash algorithm.");
        AlgorithmIdentifier algorithmIdentifier2 = new AlgorithmIdentifier(X9ObjectIdentifiers.ecdsa_with_SHA256, (ASN1Encodable)SECObjectIdentifiers.secp256k1);
        List list2 = CollectionsKt.listOf((Object)new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)SECObjectIdentifiers.secp256k1));
        String string2 = ProviderMapKt.getCordaBouncyCastleProvider().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"cordaBouncyCastleProvider.name");
        ECDSA_SECP256K1_SHA256 = new SignatureScheme("CORDA.ECDSA.SECP256K1.SHA256", algorithmIdentifier2, list2, string2, "EC", "SHA256withECDSA", "SHA256", (AlgorithmParameterSpec)ECNamedCurveTable.getParameterSpec((String)"secp256k1"), null, "ECDSA signature scheme using the secp256k1 Koblitz curve.");
        AlgorithmIdentifier algorithmIdentifier3 = new AlgorithmIdentifier(X9ObjectIdentifiers.ecdsa_with_SHA256, (ASN1Encodable)SECObjectIdentifiers.secp256r1);
        List list3 = CollectionsKt.listOf((Object)new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)SECObjectIdentifiers.secp256r1));
        String string3 = ProviderMapKt.getCordaBouncyCastleProvider().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"cordaBouncyCastleProvider.name");
        ECDSA_SECP256R1_SHA256 = new SignatureScheme("CORDA.ECDSA.SECP256R1.SHA256", algorithmIdentifier3, list3, string3, "EC", "SHA256withECDSA", "SHA256", (AlgorithmParameterSpec)ECNamedCurveTable.getParameterSpec((String)"secp256r1"), null, "ECDSA signature scheme using the secp256r1 (NIST P-256) curve.");
        AlgorithmIdentifier algorithmIdentifier4 = new AlgorithmIdentifier(ProviderMapKt.getId-Curve25519ph(), null);
        List list4 = CollectionsKt.emptyList();
        String string4 = ProviderMapKt.getCordaBouncyCastleProvider().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"cordaBouncyCastleProvider.name");
        EDDSA_ED25519_SHA512 = new SignatureScheme("CORDA.EDDSA.ED25519.SHA512", algorithmIdentifier4, list4, string4, "1.3.101.112", "NONEwithEdDSA", null, (AlgorithmParameterSpec)EdDSANamedCurveTable.getByName((String)"ED25519"), null, "EdDSA signature scheme using the ed25519 twisted Edwards curve.");
        SHA512_256 = new DLSequence((ASN1Encodable[])new ASN1ObjectIdentifier[]{NISTObjectIdentifiers.id_sha512_256});
        AlgorithmIdentifier algorithmIdentifier5 = new AlgorithmIdentifier(BCObjectIdentifiers.sphincs256_with_SHA512, (ASN1Encodable)new DLSequence((ASN1Encodable[])new ASN1Primitive[]{(ASN1Primitive)new ASN1Integer(0L), (ASN1Primitive)SHA512_256}));
        List list5 = CollectionsKt.listOf((Object)new AlgorithmIdentifier(BCObjectIdentifiers.sphincs256, (ASN1Encodable)new DLSequence((ASN1Encodable[])new ASN1Primitive[]{(ASN1Primitive)new ASN1Integer(0L), (ASN1Primitive)SHA512_256})));
        String string5 = ProviderMapKt.getBouncyCastlePQCProvider().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"bouncyCastlePQCProvider.name");
        SPHINCS256_SHA256 = new SignatureScheme("CORDA.SPHINCS-256.SHA512", algorithmIdentifier5, list5, string5, "SPHINCS256", "SHA512WITHSPHINCS256", "SHA512", (AlgorithmParameterSpec)new SPHINCS256KeyGenParameterSpec("SHA512-256"), null, "SPHINCS-256 hash-based signature scheme. It provides 128bit security against post-quantum attackers at the cost of larger key sizes and loss of compatibility.");
        AlgorithmIdentifier algorithmIdentifier6 = new AlgorithmIdentifier(CordaObjectIdentifier.COMPOSITE_KEY);
        List list6 = CollectionsKt.emptyList();
        String string6 = ProviderMapKt.getCordaSecurityProvider().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"cordaSecurityProvider.name");
        COMPOSITE_KEY = new SignatureScheme("COMPOSITE", algorithmIdentifier6, list6, string6, "COMPOSITE", "COMPOSITESIG", null, null, null, "Composite keys composed from individual public keys");
        DEFAULT_SIGNATURE_SCHEME = EDDSA_ED25519_SHA512;
        Iterable $this$associateBy$iv = CollectionsKt.listOf((Object[])new SignatureScheme[]{RSA_SHA256, ECDSA_SECP256K1_SHA256, ECDSA_SECP256R1_SHA256, EDDSA_ED25519_SHA512, SPHINCS256_SHA256, COMPOSITE_KEY});
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            SignatureScheme signatureScheme = (SignatureScheme)element$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = it.getSchemeCodeName();
            object2.put(object, element$iv$iv);
        }
        signatureSchemeMap = destination$iv$iv;
        Iterable $this$flatMap$iv = signatureSchemeMap.values();
        boolean $i$f$flatMap = false;
        Iterable capacity$iv22 = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            SignatureScheme scheme = (SignatureScheme)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = scheme.getAlternativeOIDs();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                AlgorithmIdentifier algorithmIdentifier7 = (AlgorithmIdentifier)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl2 = false;
                Pair pair = new Pair((Object)it, (Object)scheme);
                collection.add(pair);
            }
            list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = signatureSchemeMap.values();
        object2 = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            list$iv$iv = (SignatureScheme)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            Pair pair = new Pair((Object)it.getSignatureOID(), (Object)it);
            object.add(pair);
        }
        object = (List)destination$iv$iv2;
        algorithmMap = MapsKt.toMap((Iterable)CollectionsKt.plus((Collection)object2, (Iterable)((Iterable)object)));
    }
}

