/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.crypto.internal;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import net.corda.v5.base.types.OpaqueBytes;
import net.corda.v5.crypto.DigitalSignature;
import net.corda.v5.crypto.internal.Crypto;
import net.corda.v5.crypto.internal.ProviderMapKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\n\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0012\u0010\r\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u000f\u001a\u00020\n\u001a\u001a\u0010\r\u001a\u00020\u000e*\u00020\u00122\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"entropyToKeyPair", "Ljava/security/KeyPair;", "entropy", "Ljava/math/BigInteger;", "generateKeyPair", "newSecureRandom", "Ljava/security/SecureRandom;", "random63BitValue", "", "secureRandomBytes", "", "numOfBytes", "", "sign", "Lnet/corda/v5/crypto/DigitalSignature$WithKey;", "bytesToSign", "Lnet/corda/v5/base/types/OpaqueBytes;", "Lnet/corda/v5/crypto/DigitalSignature;", "Ljava/security/PrivateKey;", "publicKey", "Ljava/security/PublicKey;", "crypto-api"})
@JvmName(name="CryptoUtilsInternal")
public final class CryptoUtilsInternal {
    @NotNull
    public static final DigitalSignature sign(@NotNull PrivateKey $this$sign, @NotNull byte[] bytesToSign) throws InvalidKeyException, SignatureException {
        Intrinsics.checkNotNullParameter((Object)$this$sign, (String)"$this$sign");
        Intrinsics.checkNotNullParameter((Object)bytesToSign, (String)"bytesToSign");
        return new DigitalSignature(Crypto.doSign($this$sign, bytesToSign));
    }

    @NotNull
    public static final DigitalSignature.WithKey sign(@NotNull PrivateKey $this$sign, @NotNull byte[] bytesToSign, @NotNull PublicKey publicKey) throws InvalidKeyException, SignatureException {
        Intrinsics.checkNotNullParameter((Object)$this$sign, (String)"$this$sign");
        Intrinsics.checkNotNullParameter((Object)bytesToSign, (String)"bytesToSign");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        return new DigitalSignature.WithKey(publicKey, CryptoUtilsInternal.sign($this$sign, bytesToSign).getBytes());
    }

    @NotNull
    public static final DigitalSignature.WithKey sign(@NotNull KeyPair $this$sign, @NotNull byte[] bytesToSign) throws InvalidKeyException, SignatureException {
        Intrinsics.checkNotNullParameter((Object)$this$sign, (String)"$this$sign");
        Intrinsics.checkNotNullParameter((Object)bytesToSign, (String)"bytesToSign");
        PrivateKey privateKey = $this$sign.getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"private");
        PublicKey publicKey = $this$sign.getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"public");
        return CryptoUtilsInternal.sign(privateKey, bytesToSign, publicKey);
    }

    @NotNull
    public static final DigitalSignature.WithKey sign(@NotNull KeyPair $this$sign, @NotNull OpaqueBytes bytesToSign) throws InvalidKeyException, SignatureException {
        Intrinsics.checkNotNullParameter((Object)$this$sign, (String)"$this$sign");
        Intrinsics.checkNotNullParameter((Object)bytesToSign, (String)"bytesToSign");
        return CryptoUtilsInternal.sign($this$sign, bytesToSign.getBytes());
    }

    @NotNull
    public static final KeyPair generateKeyPair() {
        return Crypto.generateKeyPair();
    }

    @NotNull
    public static final KeyPair entropyToKeyPair(@NotNull BigInteger entropy) {
        Intrinsics.checkNotNullParameter((Object)entropy, (String)"entropy");
        return Crypto.deriveKeyPairFromEntropy(entropy);
    }

    @NotNull
    public static final byte[] secureRandomBytes(int numOfBytes) throws NoSuchAlgorithmException {
        byte[] byArray = new byte[numOfBytes];
        boolean bl = false;
        boolean bl2 = false;
        byte[] $this$apply = byArray;
        boolean bl3 = false;
        CryptoUtilsInternal.newSecureRandom().nextBytes($this$apply);
        return byArray;
    }

    @NotNull
    public static final SecureRandom newSecureRandom() throws NoSuchAlgorithmException {
        return ProviderMapKt.platformSecureRandomFactory();
    }

    public static final long random63BitValue() {
        long candidate;
        while ((candidate = Math.abs(CryptoUtilsInternal.newSecureRandom().nextLong())) == 0L || candidate == Long.MIN_VALUE) {
        }
        return candidate;
    }
}

