/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.crypto.internal;

import java.lang.reflect.Constructor;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.v5.crypto.internal.DigestAlgorithm;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \t2\u00020\u0001:\u0003\t\n\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\f\r\u00a8\u0006\u000e"}, d2={"Lnet/corda/v5/crypto/internal/DigestAlgorithmFactory;", "", "()V", "algorithm", "", "getAlgorithm", "()Ljava/lang/String;", "create", "Lnet/corda/v5/crypto/internal/DigestAlgorithm;", "Companion", "CustomAlgorithmFactory", "MessageDigestFactory", "Lnet/corda/v5/crypto/internal/DigestAlgorithmFactory$MessageDigestFactory;", "Lnet/corda/v5/crypto/internal/DigestAlgorithmFactory$CustomAlgorithmFactory;", "crypto-api"})
public abstract class DigestAlgorithmFactory {
    private static final String SHA2_256 = "SHA-256";
    private static final Set<String> BANNED;
    private static final MessageDigestFactory sha256Factory;
    private static final ConcurrentHashMap<String, DigestAlgorithmFactory> factories;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public abstract DigestAlgorithm create();

    @NotNull
    public abstract String getAlgorithm();

    private DigestAlgorithmFactory() {
    }

    static {
        Companion = new Companion(null);
        Set set = Collections.unmodifiableSet(SetsKt.setOf((Object[])new String[]{"MD5", "MD2", "SHA-1"}));
        Intrinsics.checkNotNullExpressionValue(set, (String)"Collections.unmodifiable\u2026f(\"MD5\", \"MD2\", \"SHA-1\"))");
        BANNED = set;
        sha256Factory = new MessageDigestFactory(SHA2_256);
        factories = new ConcurrentHashMap();
    }

    public /* synthetic */ DigestAlgorithmFactory(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lnet/corda/v5/crypto/internal/DigestAlgorithmFactory$MessageDigestFactory;", "Lnet/corda/v5/crypto/internal/DigestAlgorithmFactory;", "algorithm", "", "(Ljava/lang/String;)V", "getAlgorithm", "()Ljava/lang/String;", "create", "Lnet/corda/v5/crypto/internal/DigestAlgorithm;", "MessageDigestWrapper", "crypto-api"})
    private static final class MessageDigestFactory
    extends DigestAlgorithmFactory {
        @NotNull
        private final String algorithm;

        @Override
        @NotNull
        public DigestAlgorithm create() {
            try {
                MessageDigest messageDigest;
                MessageDigest messageDigest2 = messageDigest = MessageDigest.getInstance(this.getAlgorithm());
                Intrinsics.checkNotNullExpressionValue((Object)messageDigest2, (String)"messageDigest");
                return new MessageDigestWrapper(messageDigest2, this.getAlgorithm());
            }
            catch (NoSuchAlgorithmException e) {
                throw (Throwable)new IllegalArgumentException("Unknown hash algorithm " + this.getAlgorithm());
            }
        }

        @Override
        @NotNull
        public String getAlgorithm() {
            return this.algorithm;
        }

        public MessageDigestFactory(@NotNull String algorithm) {
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            super(null);
            this.algorithm = algorithm;
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lnet/corda/v5/crypto/internal/DigestAlgorithmFactory$MessageDigestFactory$MessageDigestWrapper;", "Lnet/corda/v5/crypto/internal/DigestAlgorithm;", "messageDigest", "Ljava/security/MessageDigest;", "algorithm", "", "(Ljava/security/MessageDigest;Ljava/lang/String;)V", "getAlgorithm", "()Ljava/lang/String;", "digestLength", "", "getDigestLength", "()I", "getMessageDigest", "()Ljava/security/MessageDigest;", "digest", "", "bytes", "crypto-api"})
        private static final class MessageDigestWrapper
        implements DigestAlgorithm {
            private final int digestLength;
            @NotNull
            private final MessageDigest messageDigest;
            @NotNull
            private final String algorithm;

            @Override
            public int getDigestLength() {
                return this.digestLength;
            }

            @Override
            @NotNull
            public byte[] digest(@NotNull byte[] bytes) {
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                byte[] byArray = this.messageDigest.digest(bytes);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"messageDigest.digest(bytes)");
                return byArray;
            }

            @NotNull
            public final MessageDigest getMessageDigest() {
                return this.messageDigest;
            }

            @Override
            @NotNull
            public String getAlgorithm() {
                return this.algorithm;
            }

            public MessageDigestWrapper(@NotNull MessageDigest messageDigest, @NotNull String algorithm) {
                Intrinsics.checkNotNullParameter((Object)messageDigest, (String)"messageDigest");
                Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
                this.messageDigest = messageDigest;
                this.algorithm = algorithm;
                this.digestLength = this.messageDigest.getDigestLength();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\nH\u0016R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lnet/corda/v5/crypto/internal/DigestAlgorithmFactory$CustomAlgorithmFactory;", "Lnet/corda/v5/crypto/internal/DigestAlgorithmFactory;", "className", "", "(Ljava/lang/String;)V", "algorithm", "getAlgorithm", "()Ljava/lang/String;", "constructor", "Ljava/lang/reflect/Constructor;", "Lnet/corda/v5/crypto/internal/DigestAlgorithm;", "getConstructor", "()Ljava/lang/reflect/Constructor;", "create", "crypto-api"})
    private static final class CustomAlgorithmFactory
    extends DigestAlgorithmFactory {
        @NotNull
        private final Constructor<? extends DigestAlgorithm> constructor;
        @NotNull
        private final String algorithm;

        @NotNull
        public final Constructor<? extends DigestAlgorithm> getConstructor() {
            return this.constructor;
        }

        @Override
        @NotNull
        public String getAlgorithm() {
            return this.algorithm;
        }

        @Override
        @NotNull
        public DigestAlgorithm create() {
            DigestAlgorithm digestAlgorithm = this.constructor.newInstance(new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)digestAlgorithm, (String)"constructor.newInstance()");
            return digestAlgorithm;
        }

        public CustomAlgorithmFactory(@NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            super(null);
            Constructor<DigestAlgorithm> constructor = this.getClass().getClassLoader().loadClass(className).asSubclass(DigestAlgorithm.class).getConstructor(new Class[0]);
            Intrinsics.checkNotNullExpressionValue(constructor, (String)"javaClass\n              \u2026        .getConstructor()");
            this.constructor = constructor;
            this.algorithm = this.constructor.newInstance(new Object[0]).getAlgorithm();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnet/corda/v5/crypto/internal/DigestAlgorithmFactory$Companion;", "", "()V", "BANNED", "", "", "SHA2_256", "factories", "Ljava/util/concurrent/ConcurrentHashMap;", "Lnet/corda/v5/crypto/internal/DigestAlgorithmFactory;", "sha256Factory", "Lnet/corda/v5/crypto/internal/DigestAlgorithmFactory$MessageDigestFactory;", "check", "", "algorithm", "create", "Lnet/corda/v5/crypto/internal/DigestAlgorithm;", "registerClass", "className", "crypto-api"})
    public static final class Companion {
        private final void check(String algorithm) {
            String string = algorithm;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
            boolean bl2 = Intrinsics.areEqual((Object)string3, (Object)algorithm);
            bl = false;
            boolean bl3 = false;
            if (!bl2) {
                boolean bl4 = false;
                String string4 = "Hash algorithm name " + Companion + " must be in the upper case";
                throw (Throwable)new IllegalArgumentException(string4.toString());
            }
            bl2 = !BANNED.contains(algorithm);
            bl = false;
            bl3 = false;
            if (!bl2) {
                boolean bl5 = false;
                String string5 = algorithm + " is forbidden!";
                throw (Throwable)new IllegalArgumentException(string5.toString());
            }
        }

        @NotNull
        public final String registerClass(@NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            CustomAlgorithmFactory factory = new CustomAlgorithmFactory(className);
            this.check(factory.getAlgorithm());
            boolean bl = Intrinsics.areEqual((Object)factory.getAlgorithm(), (Object)DigestAlgorithmFactory.SHA2_256) ^ true;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Standard algorithm name is not allowed in " + className;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            factories.putIfAbsent(factory.getAlgorithm(), factory);
            return factory.getAlgorithm();
        }

        @NotNull
        public final DigestAlgorithm create(@NotNull String algorithm) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            this.check(algorithm);
            String string = algorithm;
            switch (string.hashCode()) {
                case -1523887726: {
                    if (string.equals(DigestAlgorithmFactory.SHA2_256)) {
                        object = sha256Factory.create();
                        break;
                    }
                }
                default: {
                    object = (DigestAlgorithmFactory)factories.get(algorithm);
                    if (object != null && (object = ((DigestAlgorithmFactory)object).create()) != null) break;
                    object = new MessageDigestFactory(algorithm).create();
                }
            }
            return object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

