/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.crypto.internal;

import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.v5.crypto.internal.DigestAlgorithm;
import net.corda.v5.crypto.internal.LocalDigest;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\u0002H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/corda/v5/crypto/internal/DigestSupplier;", "Ljava/util/function/Supplier;", "Lnet/corda/v5/crypto/internal/DigestAlgorithm;", "algorithm", "", "(Ljava/lang/String;)V", "digestLength", "", "getDigestLength", "()I", "threadLocalMessageDigest", "Lnet/corda/v5/crypto/internal/LocalDigest;", "get", "crypto-api"})
public final class DigestSupplier
implements Supplier<DigestAlgorithm> {
    private final LocalDigest threadLocalMessageDigest;
    private final int digestLength;

    @Override
    @NotNull
    public DigestAlgorithm get() {
        Object object = this.threadLocalMessageDigest.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"threadLocalMessageDigest.get()");
        return (DigestAlgorithm)object;
    }

    public final int getDigestLength() {
        return this.digestLength;
    }

    public DigestSupplier(@NotNull String algorithm) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        this.threadLocalMessageDigest = new LocalDigest(algorithm);
        this.digestLength = this.get().getDigestLength();
    }
}

