/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.crypto.internal;

import java.security.Provider;
import java.security.Signature;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.corda.internal.base.LazyPool;
import net.corda.v5.crypto.internal.ProviderMapKt;
import net.corda.v5.crypto.internal.SignatureFactory;
import net.corda.v5.crypto.internal.SignatureScheme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006J<\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112!\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u0002H\u000f0\u0013\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnet/corda/v5/crypto/internal/Instances;", "", "()V", "signatureFactory", "Lnet/corda/v5/crypto/internal/SignatureFactory;", "getSignatureInstance", "Ljava/security/Signature;", "algorithm", "", "provider", "Ljava/security/Provider;", "releaseSignatureInstance", "", "sig", "withSignature", "A", "signatureScheme", "Lnet/corda/v5/crypto/internal/SignatureScheme;", "func", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "signature", "(Lnet/corda/v5/crypto/internal/SignatureScheme;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "CachingSignatureFactory", "SignatureKey", "crypto-api"})
public final class Instances {
    private static final SignatureFactory signatureFactory;
    @NotNull
    public static final Instances INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <A> A withSignature(@NotNull SignatureScheme signatureScheme, @NotNull Function1<? super Signature, ? extends A> func) {
        Intrinsics.checkNotNullParameter((Object)signatureScheme, (String)"signatureScheme");
        Intrinsics.checkNotNullParameter(func, (String)"func");
        Signature signature = this.getSignatureInstance(signatureScheme.getSignatureName(), ProviderMapKt.getProviderMap().get(signatureScheme.getProviderName()));
        try {
            Object object = func.invoke((Object)signature);
            return (A)object;
        }
        finally {
            this.releaseSignatureInstance(signature);
        }
    }

    @NotNull
    public final Signature getSignatureInstance(@NotNull String algorithm, @Nullable Provider provider) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        return signatureFactory.borrow(algorithm, provider);
    }

    public final void releaseSignatureInstance(@NotNull Signature sig) {
        Intrinsics.checkNotNullParameter((Object)sig, (String)"sig");
        signatureFactory.release(sig);
    }

    private Instances() {
    }

    static {
        Instances instances;
        INSTANCE = instances = new Instances();
        signatureFactory = new CachingSignatureFactory();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ0\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0015\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lnet/corda/v5/crypto/internal/Instances$SignatureKey;", "", "algorithm", "", "provider", "Ljava/security/Provider;", "(Ljava/lang/String;Ljava/security/Provider;)V", "providerName", "providerVersion", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Double;)V", "getAlgorithm", "()Ljava/lang/String;", "getProviderName", "getProviderVersion", "()Ljava/lang/Double;", "Ljava/lang/Double;", "component1", "component2", "component3", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Double;)Lnet/corda/v5/crypto/internal/Instances$SignatureKey;", "equals", "", "other", "hashCode", "", "toString", "crypto-api"})
    private static final class SignatureKey {
        @NotNull
        private final String algorithm;
        @Nullable
        private final String providerName;
        @Nullable
        private final Double providerVersion;

        @NotNull
        public final String getAlgorithm() {
            return this.algorithm;
        }

        @Nullable
        public final String getProviderName() {
            return this.providerName;
        }

        @Nullable
        public final Double getProviderVersion() {
            return this.providerVersion;
        }

        public SignatureKey(@NotNull String algorithm, @Nullable String providerName, @Nullable Double providerVersion) {
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            this.algorithm = algorithm;
            this.providerName = providerName;
            this.providerVersion = providerVersion;
        }

        public SignatureKey(@NotNull String algorithm, @Nullable Provider provider) {
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            Provider provider2 = provider;
            Provider provider3 = provider;
            this(algorithm, provider2 != null ? provider2.getName() : null, provider3 != null ? Double.valueOf(provider3.getVersion()) : null);
        }

        @NotNull
        public final String component1() {
            return this.algorithm;
        }

        @Nullable
        public final String component2() {
            return this.providerName;
        }

        @Nullable
        public final Double component3() {
            return this.providerVersion;
        }

        @NotNull
        public final SignatureKey copy(@NotNull String algorithm, @Nullable String providerName, @Nullable Double providerVersion) {
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            return new SignatureKey(algorithm, providerName, providerVersion);
        }

        public static /* synthetic */ SignatureKey copy$default(SignatureKey signatureKey, String string, String string2, Double d, int n, Object object) {
            if ((n & 1) != 0) {
                string = signatureKey.algorithm;
            }
            if ((n & 2) != 0) {
                string2 = signatureKey.providerName;
            }
            if ((n & 4) != 0) {
                d = signatureKey.providerVersion;
            }
            return signatureKey.copy(string, string2, d);
        }

        @NotNull
        public String toString() {
            return "SignatureKey(algorithm=" + this.algorithm + ", providerName=" + this.providerName + ", providerVersion=" + this.providerVersion + ")";
        }

        public int hashCode() {
            String string = this.algorithm;
            String string2 = this.providerName;
            Double d = this.providerVersion;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (d != null ? ((Object)d).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SignatureKey)) break block3;
                    SignatureKey signatureKey = (SignatureKey)object;
                    if (!Intrinsics.areEqual((Object)this.algorithm, (Object)signatureKey.algorithm) || !Intrinsics.areEqual((Object)this.providerName, (Object)signatureKey.providerName) || !Intrinsics.areEqual((Object)this.providerVersion, (Object)signatureKey.providerVersion)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnet/corda/v5/crypto/internal/Instances$CachingSignatureFactory;", "Lnet/corda/v5/crypto/internal/SignatureFactory;", "()V", "signatureInstances", "Ljava/util/concurrent/ConcurrentHashMap;", "Lnet/corda/v5/crypto/internal/Instances$SignatureKey;", "Lnet/corda/internal/base/LazyPool;", "Ljava/security/Signature;", "borrow", "algorithm", "", "provider", "Ljava/security/Provider;", "release", "", "sig", "crypto-api"})
    private static final class CachingSignatureFactory
    implements SignatureFactory {
        private final ConcurrentHashMap<SignatureKey, LazyPool<Signature>> signatureInstances = new ConcurrentHashMap();

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Signature borrow(@NotNull String algorithm, @Nullable Provider provider) {
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            ConcurrentMap concurrentMap = this.signatureInstances;
            SignatureKey key$iv = new SignatureKey(algorithm, provider);
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(key$iv);
            if (object == null) {
                boolean bl = false;
                LazyPool lazyPool = new LazyPool(null, null, null, (Function0)new Function0<Signature>(algorithm, provider){
                    final /* synthetic */ String $algorithm$inlined;
                    final /* synthetic */ Provider $provider$inlined;
                    {
                        this.$algorithm$inlined = string;
                        this.$provider$inlined = provider;
                        super(0);
                    }

                    @NotNull
                    public final Signature invoke() {
                        Signature signature = Signature.getInstance(this.$algorithm$inlined, this.$provider$inlined);
                        Intrinsics.checkNotNullExpressionValue((Object)signature, (String)"Signature.getInstance(algorithm, provider)");
                        return signature;
                    }
                }, 7, null);
                boolean bl2 = false;
                boolean bl3 = false;
                LazyPool default$iv = lazyPool;
                boolean bl4 = false;
                object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            return (Signature)((LazyPool)object).borrow();
        }

        @Override
        public void release(@NotNull Signature sig) {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)sig, (String)"sig");
            String string = sig.getAlgorithm();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sig.algorithm");
            LazyPool<Signature> lazyPool = this.signatureInstances.get(new SignatureKey(string, sig.getProvider()));
            if (lazyPool != null) {
                lazyPool.release((Object)sig);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Intrinsics.checkNotNull((Object)unit);
        }
    }
}

