/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.crypto.internal;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandomSpi;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0014J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0006H\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnet/corda/v5/crypto/internal/LinuxSecureRandomSpi;", "Ljava/security/SecureRandomSpi;", "()V", "urandom", "Ljava/io/DataInputStream;", "engineGenerateSeed", "", "numBytes", "", "engineNextBytes", "", "bytes", "engineSetSeed", "seed", "openURandom", "Ljava/io/InputStream;", "crypto-api"})
final class LinuxSecureRandomSpi
extends SecureRandomSpi {
    private DataInputStream urandom = new DataInputStream(this.openURandom());

    private final InputStream openURandom() {
        try {
            File file = new File("/dev/urandom");
            FileInputStream stream = new FileInputStream(file);
            if (stream.read() == -1) {
                throw (Throwable)new RuntimeException("/dev/urandom not readable?");
            }
            return stream;
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    @Override
    protected void engineSetSeed(@NotNull byte[] seed) {
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
    }

    @Override
    protected void engineNextBytes(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        try {
            this.urandom.readFully(bytes);
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    protected byte[] engineGenerateSeed(int numBytes) {
        byte[] byArray = new byte[numBytes];
        boolean bl = false;
        boolean bl2 = false;
        byte[] $this$apply = byArray;
        boolean bl3 = false;
        this.engineNextBytes($this$apply);
        return byArray;
    }
}

