/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.crypto.internal;

import java.security.Provider;
import java.security.SecureRandomSpi;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.v5.crypto.internal.LinuxSecureRandomSpi;
import net.corda.v5.crypto.internal.PlatformSecureRandomSpi;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnet/corda/v5/crypto/internal/PlatformSecureRandomService;", "Ljava/security/Provider$Service;", "provider", "Ljava/security/Provider;", "(Ljava/security/Provider;)V", "instance", "Ljava/security/SecureRandomSpi;", "newInstance", "constructorParameter", "", "tryAndUseLinuxSecureRandomSpi", "Companion", "crypto-api"})
public final class PlatformSecureRandomService
extends Provider.Service {
    private final SecureRandomSpi instance;
    @NotNull
    public static final String algorithm = "CordaPRNG";
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    private final SecureRandomSpi tryAndUseLinuxSecureRandomSpi() {
        SecureRandomSpi secureRandomSpi;
        try {
            secureRandomSpi = new LinuxSecureRandomSpi();
        }
        catch (Exception e) {
            logger.error("Unable to initialise LinuxSecureRandomSpi. The exception logged with this message might assist with diagnosis.  The process will now exit.", (Throwable)e);
            System.exit(1);
            throw (Throwable)new RuntimeException("Never reached, but calms the compiler.");
        }
        return secureRandomSpi;
    }

    @Override
    @NotNull
    public SecureRandomSpi newInstance(@Nullable Object constructorParameter) {
        return this.instance;
    }

    public PlatformSecureRandomService(@NotNull Provider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        super(provider, "SecureRandom", algorithm, "javaClass", null, null);
        this.instance = SystemUtils.IS_OS_LINUX ? this.tryAndUseLinuxSecureRandomSpi() : (SecureRandomSpi)new PlatformSecureRandomSpi();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$loggerFor = false;
        Logger logger = LoggerFactory.getLogger(PlatformSecureRandomService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(T::class.java)");
        PlatformSecureRandomService.logger = logger;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lnet/corda/v5/crypto/internal/PlatformSecureRandomService$Companion;", "", "()V", "algorithm", "", "logger", "Lorg/slf4j/Logger;", "crypto-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

