/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.crypto.internal;

import io.netty.util.concurrent.FastThreadLocal;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.v5.crypto.internal.PlatformSecureRandomSpi;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000/\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004*\u0001\b\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0014J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000bH\u0014R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0013"}, d2={"Lnet/corda/v5/crypto/internal/PlatformSecureRandomSpi;", "Ljava/security/SecureRandomSpi;", "()V", "secureRandom", "Ljava/security/SecureRandom;", "getSecureRandom", "()Ljava/security/SecureRandom;", "threadLocalSecureRandom", "net/corda/v5/crypto/internal/PlatformSecureRandomSpi$threadLocalSecureRandom$1", "Lnet/corda/v5/crypto/internal/PlatformSecureRandomSpi$threadLocalSecureRandom$1;", "engineGenerateSeed", "", "numBytes", "", "engineNextBytes", "", "bytes", "engineSetSeed", "seed", "crypto-api"})
final class PlatformSecureRandomSpi
extends SecureRandomSpi {
    private final threadLocalSecureRandom.1 threadLocalSecureRandom = new FastThreadLocal<SecureRandom>(){

        protected SecureRandom initialValue() {
            return SecureRandom.getInstanceStrong();
        }
    };

    private final SecureRandom getSecureRandom() {
        Object object = this.threadLocalSecureRandom.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"threadLocalSecureRandom.get()");
        return (SecureRandom)object;
    }

    @Override
    protected void engineSetSeed(@NotNull byte[] seed) {
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        this.getSecureRandom().setSeed(seed);
    }

    @Override
    protected void engineNextBytes(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.getSecureRandom().nextBytes(bytes);
    }

    @Override
    @NotNull
    protected byte[] engineGenerateSeed(int numBytes) {
        byte[] byArray = this.getSecureRandom().generateSeed(numBytes);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"secureRandom.generateSeed(numBytes)");
        return byArray;
    }
}

