/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.crypto.internal;

import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.v5.crypto.internal.CordaSecurityProvider;
import net.corda.v5.crypto.internal.Crypto;
import net.corda.v5.crypto.internal.PlatformSecureRandom;
import net.corda.v5.crypto.internal.SecurityProviderWrapper;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSASecurityProvider;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.provider.asymmetric.ec.AlgorithmParametersSpi;
import org.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.jcajce.provider.BouncyCastlePQCProvider;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0015\u001a\u00020\u0016\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\" \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00050\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"bouncyCastlePQCProvider", "Lorg/bouncycastle/pqc/jcajce/provider/BouncyCastlePQCProvider;", "getBouncyCastlePQCProvider", "()Lorg/bouncycastle/pqc/jcajce/provider/BouncyCastlePQCProvider;", "cordaBouncyCastleProvider", "Ljava/security/Provider;", "getCordaBouncyCastleProvider", "()Ljava/security/Provider;", "cordaSecurityProvider", "Lnet/corda/v5/crypto/internal/CordaSecurityProvider;", "getCordaSecurityProvider", "()Lnet/corda/v5/crypto/internal/CordaSecurityProvider;", "id-Curve25519ph", "Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;", "getId-Curve25519ph", "()Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;", "providerMap", "", "", "getProviderMap", "()Ljava/util/Map;", "platformSecureRandomFactory", "Ljava/security/SecureRandom;", "crypto-api"})
public final class ProviderMapKt {
    @NotNull
    private static final CordaSecurityProvider cordaSecurityProvider;
    @NotNull
    private static final ASN1ObjectIdentifier id-Curve25519ph;
    @NotNull
    private static final Provider cordaBouncyCastleProvider;
    @NotNull
    private static final BouncyCastlePQCProvider bouncyCastlePQCProvider;
    @NotNull
    private static final Map<String, Provider> providerMap;

    @NotNull
    public static final CordaSecurityProvider getCordaSecurityProvider() {
        return cordaSecurityProvider;
    }

    @NotNull
    public static final ASN1ObjectIdentifier getId-Curve25519ph() {
        return id-Curve25519ph;
    }

    @NotNull
    public static final Provider getCordaBouncyCastleProvider() {
        return cordaBouncyCastleProvider;
    }

    @NotNull
    public static final BouncyCastlePQCProvider getBouncyCastlePQCProvider() {
        return bouncyCastlePQCProvider;
    }

    @NotNull
    public static final Map<String, Provider> getProviderMap() {
        return providerMap;
    }

    @NotNull
    public static final SecureRandom platformSecureRandomFactory() {
        return (SecureRandom)PlatformSecureRandom.getPlatformSecureRandom().invoke();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_2;
        void $this$associateByTo$iv;
        Object object = new CordaSecurityProvider();
        boolean bl = false;
        boolean bl2 = false;
        CordaSecurityProvider it = object;
        boolean bl3 = false;
        Security.insertProviderAt(it, 1);
        cordaSecurityProvider = object;
        id-Curve25519ph = new ASN1ObjectIdentifier("1.3.101.112");
        object = new BouncyCastleProvider();
        bl = false;
        bl2 = false;
        CordaSecurityProvider $this$apply = object;
        boolean bl4 = false;
        $this$apply.addKeyInfoConverter(id-Curve25519ph, new AsymmetricKeyInfoConverter(){

            @NotNull
            public PublicKey generatePublic(@NotNull SubjectPublicKeyInfo keyInfo) {
                Intrinsics.checkNotNullParameter((Object)keyInfo, (String)"keyInfo");
                byte[] byArray = keyInfo.getEncoded();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"keyInfo.encoded");
                return Crypto.decodePublicKey(Crypto.EDDSA_ED25519_SHA512, byArray);
            }

            @NotNull
            public PrivateKey generatePrivate(@NotNull PrivateKeyInfo keyInfo) {
                Intrinsics.checkNotNullParameter((Object)keyInfo, (String)"keyInfo");
                byte[] byArray = keyInfo.getEncoded();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"keyInfo.encoded");
                return Crypto.decodePrivateKey(Crypto.EDDSA_ED25519_SHA512, byArray);
            }
        });
        Unit unit = Unit.INSTANCE;
        Provider provider = (Provider)object;
        object = new SecurityProviderWrapper(provider);
        bl = false;
        bl2 = false;
        $this$apply = object;
        boolean bl5 = false;
        $this$apply.putAll((Map<?, ?>)((Map)new EdDSASecurityProvider()));
        $this$apply.put("AlgorithmParameters.SHA256WITHECDSA", AlgorithmParametersSpi.class.getName());
        $this$apply.put("Signature.NONEwithEdDSA", EdDSAEngine.class.getName());
        $this$apply.put("Signature.Ed25519", EdDSAEngine.class.getName());
        bl = false;
        bl2 = false;
        it = object;
        boolean bl6 = false;
        Security.addProvider(it);
        cordaBouncyCastleProvider = (Provider)object;
        object = new BouncyCastlePQCProvider();
        bl = false;
        bl2 = false;
        $this$apply = object;
        boolean bl7 = false;
        boolean bl8 = Intrinsics.areEqual((Object)$this$apply.getName(), (Object)"BCPQC");
        boolean bl9 = false;
        boolean bl10 = false;
        if (!bl8) {
            boolean bl11 = false;
            String string = "Invalid PQCProvider name";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = false;
        bl2 = false;
        it = object;
        boolean bl12 = false;
        Security.addProvider(it);
        bouncyCastlePQCProvider = object;
        object = CollectionsKt.listOf((Object[])new Provider[]{cordaBouncyCastleProvider, cordaSecurityProvider, (Provider)bouncyCastlePQCProvider});
        Map destination$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv : $this$associateByTo$iv) {
            void p1;
            Provider provider2 = (Provider)element$iv;
            Map map = destination$iv;
            boolean bl13 = false;
            String string = p1.getName();
            map.put(string, element$iv);
        }
        Map map = Collections.unmodifiableMap(var1_2);
        Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap(\n    lis\u2026p(), Provider::getName)\n)");
        providerMap = map;
    }
}

