/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.crypto;

import java.security.PublicKey;
import org.jetbrains.annotations.NotNull;

public final class CompositeKeyNodeAndWeight {
    private final PublicKey node;
    private final int weight;

    public CompositeKeyNodeAndWeight(@NotNull PublicKey node, int weight) {
        if (weight <= 0) {
            throw new IllegalArgumentException("A non-positive weight was detected. Member info: " + this);
        }
        this.node = node;
        this.weight = weight;
    }

    public CompositeKeyNodeAndWeight(@NotNull PublicKey node) {
        this(node, 1);
    }

    @NotNull
    public PublicKey getNode() {
        return this.node;
    }

    public int getWeight() {
        return this.weight;
    }

    @NotNull
    public String toString() {
        return String.format("[%s, %d]", this.node, this.weight);
    }

    public int hashCode() {
        return this.node.hashCode() + 31 * this.weight;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CompositeKeyNodeAndWeight)) {
            return false;
        }
        CompositeKeyNodeAndWeight otherKey = (CompositeKeyNodeAndWeight)other;
        if (!otherKey.node.equals(this.node)) {
            return false;
        }
        return otherKey.weight == this.weight;
    }
}

