/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.crypto;

import net.corda.v5.base.annotations.CordaSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CordaSerializable
public final class DigestAlgorithmName {
    private final String name;
    @NotNull
    public static final DigestAlgorithmName SHA2_256 = new DigestAlgorithmName("SHA-256");
    @NotNull
    public static final DigestAlgorithmName SHA2_256D = new DigestAlgorithmName("SHA-256D");
    @NotNull
    public static final DigestAlgorithmName SHA2_384 = new DigestAlgorithmName("SHA-384");
    @NotNull
    public static final DigestAlgorithmName SHA2_512 = new DigestAlgorithmName("SHA-512");

    public DigestAlgorithmName(@NotNull String name) {
        if (name == null || name.isBlank()) {
            throw new IllegalArgumentException("Hash algorithm name unavailable or not specified");
        }
        this.name = name;
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.toUpperCase().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof DigestAlgorithmName)) {
            return false;
        }
        DigestAlgorithmName otherDigest = (DigestAlgorithmName)other;
        return this.name.equalsIgnoreCase(otherDigest.name);
    }

    @NotNull
    public String getName() {
        return this.name;
    }
}

