/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.crypto;

import java.security.PublicKey;
import java.util.Collections;
import java.util.Set;
import net.corda.v5.crypto.CompositeKey;
import org.jetbrains.annotations.NotNull;

public final class KeyUtils {
    private KeyUtils() {
    }

    public static boolean isKeyInSet(@NotNull PublicKey key, @NotNull Set<PublicKey> otherKeys) {
        if (key instanceof CompositeKey) {
            CompositeKey compositeKey = (CompositeKey)key;
            Set<PublicKey> leafKeys = compositeKey.getLeafKeys();
            leafKeys.retainAll(otherKeys);
            return !leafKeys.isEmpty();
        }
        return otherKeys.contains(key);
    }

    public static boolean isKeyFulfilledBy(@NotNull PublicKey key, @NotNull Set<PublicKey> otherKeys) {
        if (key instanceof CompositeKey) {
            CompositeKey firstKeyComposite = (CompositeKey)key;
            return firstKeyComposite.isFulfilledBy(otherKeys);
        }
        return otherKeys.contains(key);
    }

    public static boolean isKeyFulfilledBy(@NotNull PublicKey key, @NotNull PublicKey otherKey) {
        return KeyUtils.isKeyFulfilledBy(key, Collections.singleton(otherKey));
    }
}

