/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.ledger.common;

import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.v5.base.annotations.CordaSerializable;
import net.corda.v5.base.types.MemberX500Name;
import net.corda.v5.crypto.CryptoUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CordaSerializable
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lnet/corda/v5/ledger/common/Party;", "", "name", "Lnet/corda/v5/base/types/MemberX500Name;", "owningKey", "Ljava/security/PublicKey;", "(Lnet/corda/v5/base/types/MemberX500Name;Ljava/security/PublicKey;)V", "getName", "()Lnet/corda/v5/base/types/MemberX500Name;", "getOwningKey", "()Ljava/security/PublicKey;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ledger-common"})
public final class Party {
    @NotNull
    private final MemberX500Name name;
    @NotNull
    private final PublicKey owningKey;

    public Party(@NotNull MemberX500Name name, @NotNull PublicKey owningKey) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)owningKey, (String)"owningKey");
        this.name = name;
        this.owningKey = owningKey;
    }

    @NotNull
    public final MemberX500Name getName() {
        return this.name;
    }

    @NotNull
    public final PublicKey getOwningKey() {
        return this.owningKey;
    }

    @NotNull
    public String toString() {
        return this.name + " (owningKey = " + CryptoUtils.toStringShort((PublicKey)this.owningKey) + ")";
    }

    @NotNull
    public final MemberX500Name component1() {
        return this.name;
    }

    @NotNull
    public final PublicKey component2() {
        return this.owningKey;
    }

    @NotNull
    public final Party copy(@NotNull MemberX500Name name, @NotNull PublicKey owningKey) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)owningKey, (String)"owningKey");
        return new Party(name, owningKey);
    }

    public static /* synthetic */ Party copy$default(Party party, MemberX500Name memberX500Name, PublicKey publicKey, int n, Object object) {
        if ((n & 1) != 0) {
            memberX500Name = party.name;
        }
        if ((n & 2) != 0) {
            publicKey = party.owningKey;
        }
        return party.copy(memberX500Name, publicKey);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.owningKey.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Party)) {
            return false;
        }
        Party party = (Party)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)party.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.owningKey, (Object)party.owningKey);
    }
}

