/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.node;

import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\n \u000b*\u0004\u0018\u00010\t0\t2\u0006\u0010\b\u001a\u00020\tJ\b\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnet/corda/testing/node/DatabaseSnapshot;", "", "()V", "databaseName", "", "previousCordaVersion", "copyDatabaseSnapshot", "", "baseDirectory", "Ljava/nio/file/Path;", "databaseFilename", "kotlin.jvm.PlatformType", "getDatabaseSnapshotStream", "Ljava/io/InputStream;", "node-driver"})
public final class DatabaseSnapshot {
    private static final String previousCordaVersion = "4.5.1";
    private static final String databaseName = "persistence.mv.db";
    public static final DatabaseSnapshot INSTANCE;

    private final InputStream getDatabaseSnapshotStream() {
        URL resourceUri = this.getClass().getResource("/databasesnapshots/4.5.1/persistence.mv.db");
        InputStream inputStream = resourceUri.openStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"resourceUri.openStream()");
        return inputStream;
    }

    public final Path databaseFilename(@NotNull Path baseDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)baseDirectory, (String)"baseDirectory");
        return baseDirectory.resolve(databaseName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copyDatabaseSnapshot(@NotNull Path baseDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)baseDirectory, (String)"baseDirectory");
        Closeable closeable = this.getDatabaseSnapshotStream();
        Throwable throwable = null;
        try {
            InputStream stream = (InputStream)closeable;
            Files.createDirectories(baseDirectory, new FileAttribute[0]);
            long l = Files.copy(stream, INSTANCE.databaseFilename(baseDirectory), new CopyOption[0]);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private DatabaseSnapshot() {
    }

    static {
        DatabaseSnapshot databaseSnapshot;
        INSTANCE = databaseSnapshot = new DatabaseSnapshot();
    }
}

