/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.node;

import com.google.common.collect.MutableClassToInstanceMap;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.PublicKey;
import java.sql.Connection;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import javax.persistence.EntityManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import net.corda.core.contracts.Attachment;
import net.corda.core.contracts.ContractState;
import net.corda.core.contracts.StateAndRef;
import net.corda.core.contracts.StateRef;
import net.corda.core.contracts.TransactionState;
import net.corda.core.cordapp.CordappContext;
import net.corda.core.cordapp.CordappProvider;
import net.corda.core.crypto.SecureHash;
import net.corda.core.crypto.TransactionSignature;
import net.corda.core.flows.StateMachineRunId;
import net.corda.core.identity.AbstractParty;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.identity.Party;
import net.corda.core.identity.PartyAndCertificate;
import net.corda.core.internal.NamedCacheFactory;
import net.corda.core.messaging.DataFeed;
import net.corda.core.messaging.StateMachineTransactionMapping;
import net.corda.core.node.NetworkParameters;
import net.corda.core.node.NodeInfo;
import net.corda.core.node.ServiceHub;
import net.corda.core.node.ServicesForResolution;
import net.corda.core.node.StatesToRecord;
import net.corda.core.node.services.AttachmentStorage;
import net.corda.core.node.services.ContractUpgradeService;
import net.corda.core.node.services.CordaService;
import net.corda.core.node.services.IdentityService;
import net.corda.core.node.services.KeyManagementService;
import net.corda.core.node.services.NetworkMapCache;
import net.corda.core.node.services.NetworkParametersService;
import net.corda.core.node.services.TransactionStorage;
import net.corda.core.node.services.TransactionVerifierService;
import net.corda.core.node.services.VaultService;
import net.corda.core.node.services.diagnostics.DiagnosticsService;
import net.corda.core.serialization.SerializeAsToken;
import net.corda.core.transactions.FilteredTransaction;
import net.corda.core.transactions.SignedTransaction;
import net.corda.core.transactions.TransactionBuilder;
import net.corda.core.utilities.NetworkHostAndPort;
import net.corda.coretesting.internal.InternalTestConstantsKt;
import net.corda.node.VersionInfo;
import net.corda.node.internal.ServicesForResolutionImpl;
import net.corda.node.internal.cordapp.CordappProviderInternal;
import net.corda.node.internal.cordapp.JarScanningCordappLoader;
import net.corda.node.services.api.IdentityServiceInternal;
import net.corda.node.services.api.SchemaService;
import net.corda.node.services.api.StateMachineRecordedTransactionMappingStorage;
import net.corda.node.services.api.VaultServiceInternal;
import net.corda.node.services.api.WritableTransactionStorage;
import net.corda.node.services.diagnostics.NodeDiagnosticsService;
import net.corda.node.services.identity.PersistentIdentityService;
import net.corda.node.services.keys.BasicHSMKeyManagementService;
import net.corda.node.services.network.PersistentNetworkMapCache;
import net.corda.node.services.persistence.PublicKeyToOwningIdentityCacheImpl;
import net.corda.node.services.persistence.WritablePublicKeyToOwningIdentityCache;
import net.corda.node.services.schema.NodeSchemaService;
import net.corda.node.services.transactions.InMemoryTransactionVerifierService;
import net.corda.node.services.vault.NodeVaultService;
import net.corda.nodeapi.internal.cordapp.CordappLoader;
import net.corda.nodeapi.internal.cryptoservice.SignOnlyCryptoService;
import net.corda.nodeapi.internal.persistence.CordaPersistence;
import net.corda.nodeapi.internal.persistence.DatabaseConfig;
import net.corda.nodeapi.internal.persistence.DatabaseTransaction;
import net.corda.testing.common.internal.ParametersUtilitiesKt;
import net.corda.testing.core.TestIdentity;
import net.corda.testing.internal.MockCordappProvider;
import net.corda.testing.internal.TestingNamedCacheFactory;
import net.corda.testing.node.DatabaseSnapshot;
import net.corda.testing.node.MockServices;
import net.corda.testing.node.MockServicesKt;
import net.corda.testing.node.TestClock;
import net.corda.testing.node.internal.CustomCordapp;
import net.corda.testing.node.internal.DriverDSLImpl;
import net.corda.testing.node.internal.InternalTestUtilsKt;
import net.corda.testing.node.internal.MockCryptoService;
import net.corda.testing.node.internal.MockKeyManagementService;
import net.corda.testing.node.internal.MockNetworkParametersStorage;
import net.corda.testing.node.internal.MockTransactionStorage;
import net.corda.testing.services.MockAttachmentStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u00cc\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u009c\u00012\u00020\u0001:\u0004\u009c\u0001\u009d\u0001B?\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fB7\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\u0010B;\b\u0017\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\f\u00a2\u0006\u0002\u0010\u0014BA\b\u0016\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\f\u00a2\u0006\u0002\u0010\u0015BI\b\u0016\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0016BC\b\u0017\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0019\u001a\u00020\f\u0012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\f\u00a2\u0006\u0002\u0010\u001aB'\b\u0017\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u001bB\u0015\b\u0016\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\u0010\u001cB5\b\u0017\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0019\u001a\u00020\f\u0012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\f\u00a2\u0006\u0002\u0010\u001dB\u0019\b\u0017\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u001eB-\b\u0016\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u001f\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010 B5\b\u0016\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u001f\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0019\u001a\u00020\f\u00a2\u0006\u0002\u0010!B#\b\u0016\u0012\u0006\u0010\"\u001a\u00020\t\u0012\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u000b\"\u00020\t\u00a2\u0006\u0002\u0010$B+\b\u0016\u0012\u0006\u0010\"\u001a\u00020\t\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u000b\"\u00020\t\u00a2\u0006\u0002\u0010%B1\b\u0016\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u001f\u0012\u0006\u0010\"\u001a\u00020\t\u0012\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u000b\"\u00020\t\u00a2\u0006\u0002\u0010&B9\b\u0016\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u001f\u0012\u0006\u0010\"\u001a\u00020\t\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u000b\"\u00020\t\u00a2\u0006\u0002\u0010'B\u0007\b\u0016\u00a2\u0006\u0002\u0010(BI\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010)\u001a\u00020*\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010+\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010,J\u0012\u0010o\u001a\u00020p2\n\u0010q\u001a\u00060\u0013j\u0002`rJ%\u0010s\u001a\u0002Ht\"\b\b\u0000\u0010t*\u00020C2\f\u0010u\u001a\b\u0012\u0004\u0012\u0002Ht0vH\u0016\u00a2\u0006\u0002\u0010wJ\b\u0010x\u001a\u00020yH\u0016J\u0010\u0010z\u001a\u00020{2\u0006\u0010|\u001a\u00020}H\u0016J\u0014\u0010~\u001a\u0006\u0012\u0002\b\u00030\u007f2\u0006\u0010|\u001a\u00020}H\u0016J(\u0010\u0080\u0001\u001a\u0011\u0012\f\u0012\n\u0012\u0005\u0012\u00030\u0083\u00010\u0082\u00010\u0081\u00012\u000e\u0010\u0084\u0001\u001a\t\u0012\u0004\u0012\u00020}0\u0081\u0001H\u0016J,\u0010\u0085\u0001\u001a\u00030\u0086\u00012\b\u0010\u0087\u0001\u001a\u00030\u0088\u00012\b\u0010\u0089\u0001\u001a\u00030\u008a\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a2\u0006\u0003\b\u008b\u0001J#\u0010\u008c\u0001\u001a\u00020p2\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\u000e\u0010\u008f\u0001\u001a\t\u0012\u0005\u0012\u00030\u0090\u00010\u0012H\u0016J\u001a\u0010\u0091\u0001\u001a\u00030\u0092\u00012\u000e\u0010\u0093\u0001\u001a\t\u0012\u0004\u0012\u00020p0\u0094\u0001H\u0016J\u001a\u0010\u0095\u0001\u001a\u00020p2\u000f\u0010\u0096\u0001\u001a\n\u0012\u0005\u0012\u00030\u0098\u00010\u0097\u0001H\u0016J2\u0010\u0095\u0001\u001a\u0002Ht\"\u0004\b\u0000\u0010t2\u001b\u0010\u0096\u0001\u001a\u0016\u0012\u0005\u0012\u00030\u0098\u0001\u0012\u0004\u0012\u0002Ht0\u0099\u0001\u00a2\u0006\u0003\b\u009a\u0001H\u0016\u00a2\u0006\u0003\u0010\u009b\u0001R\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0014\u00101\u001a\u0002028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0014\u00105\u001a\u0002068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0011\u00109\u001a\u00020:8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010=\u001a\u00020>8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u001a\u0010A\u001a\b\u0012\u0004\u0012\u00020C0BX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u0014\u0010F\u001a\u00020GX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010IR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010KR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010MR\u000e\u0010N\u001a\u00020OX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010PR\u0014\u0010Q\u001a\u00020R8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bS\u0010TR\u0014\u0010U\u001a\u00020V8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bW\u0010XR\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bY\u0010ZR\u001a\u0010[\u001a\u00020\\X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b]\u0010^\"\u0004\b_\u0010`R\u0014\u0010a\u001a\u00020b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bc\u0010dR\u0014\u0010e\u001a\u00020f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bg\u0010hR\u0014\u0010)\u001a\u00020*X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bi\u0010jR\u0014\u0010k\u001a\u00020l8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bm\u0010n\u00a8\u0006\u009e\u0001"}, d2={"Lnet/corda/testing/node/MockServices;", "Lnet/corda/core/node/ServiceHub;", "cordappLoader", "Lnet/corda/nodeapi/internal/cordapp/CordappLoader;", "identityService", "Lnet/corda/core/node/services/IdentityService;", "networkParameters", "Lnet/corda/core/node/NetworkParameters;", "initialIdentity", "Lnet/corda/testing/core/TestIdentity;", "moreKeys", "", "Ljava/security/KeyPair;", "keyManagementService", "Lnet/corda/core/node/services/KeyManagementService;", "(Lnet/corda/nodeapi/internal/cordapp/CordappLoader;Lnet/corda/core/node/services/IdentityService;Lnet/corda/core/node/NetworkParameters;Lnet/corda/testing/core/TestIdentity;[Ljava/security/KeyPair;Lnet/corda/core/node/services/KeyManagementService;)V", "(Lnet/corda/nodeapi/internal/cordapp/CordappLoader;Lnet/corda/core/node/services/IdentityService;Lnet/corda/core/node/NetworkParameters;Lnet/corda/testing/core/TestIdentity;[Ljava/security/KeyPair;)V", "cordappPackages", "", "", "(Ljava/lang/Iterable;Lnet/corda/testing/core/TestIdentity;Lnet/corda/core/node/services/IdentityService;[Ljava/security/KeyPair;)V", "(Ljava/lang/Iterable;Lnet/corda/testing/core/TestIdentity;Lnet/corda/core/node/services/IdentityService;Lnet/corda/core/node/NetworkParameters;[Ljava/security/KeyPair;)V", "(Ljava/lang/Iterable;Lnet/corda/testing/core/TestIdentity;Lnet/corda/core/node/services/IdentityService;Lnet/corda/core/node/NetworkParameters;[Ljava/security/KeyPair;Lnet/corda/core/node/services/KeyManagementService;)V", "initialIdentityName", "Lnet/corda/core/identity/CordaX500Name;", "key", "(Ljava/lang/Iterable;Lnet/corda/core/identity/CordaX500Name;Lnet/corda/core/node/services/IdentityService;Ljava/security/KeyPair;[Ljava/security/KeyPair;)V", "(Ljava/lang/Iterable;Lnet/corda/core/identity/CordaX500Name;Lnet/corda/core/node/services/IdentityService;)V", "(Ljava/lang/Iterable;)V", "(Lnet/corda/core/identity/CordaX500Name;Lnet/corda/core/node/services/IdentityService;Ljava/security/KeyPair;[Ljava/security/KeyPair;)V", "(Lnet/corda/core/identity/CordaX500Name;Lnet/corda/core/node/services/IdentityService;)V", "", "(Ljava/util/List;Lnet/corda/core/identity/CordaX500Name;Lnet/corda/core/node/services/IdentityService;Lnet/corda/core/node/NetworkParameters;)V", "(Ljava/util/List;Lnet/corda/core/identity/CordaX500Name;Lnet/corda/core/node/services/IdentityService;Lnet/corda/core/node/NetworkParameters;Ljava/security/KeyPair;)V", "firstIdentity", "moreIdentities", "(Lnet/corda/testing/core/TestIdentity;[Lnet/corda/testing/core/TestIdentity;)V", "(Lnet/corda/testing/core/TestIdentity;Lnet/corda/core/node/NetworkParameters;[Lnet/corda/testing/core/TestIdentity;)V", "(Ljava/util/List;Lnet/corda/testing/core/TestIdentity;[Lnet/corda/testing/core/TestIdentity;)V", "(Ljava/util/List;Lnet/corda/testing/core/TestIdentity;Lnet/corda/core/node/NetworkParameters;[Lnet/corda/testing/core/TestIdentity;)V", "()V", "validatedTransactions", "Lnet/corda/core/node/services/TransactionStorage;", "initialNetworkParameters", "(Lnet/corda/nodeapi/internal/cordapp/CordappLoader;Lnet/corda/core/node/services/TransactionStorage;Lnet/corda/core/node/services/IdentityService;Lnet/corda/core/node/NetworkParameters;Lnet/corda/testing/core/TestIdentity;[Ljava/security/KeyPair;Lnet/corda/core/node/services/KeyManagementService;)V", "attachments", "Lnet/corda/testing/services/MockAttachmentStorage;", "getAttachments", "()Lnet/corda/testing/services/MockAttachmentStorage;", "clock", "Lnet/corda/testing/node/TestClock;", "getClock", "()Lnet/corda/testing/node/TestClock;", "contractUpgradeService", "Lnet/corda/core/node/services/ContractUpgradeService;", "getContractUpgradeService", "()Lnet/corda/core/node/services/ContractUpgradeService;", "cordappClassloader", "Ljava/lang/ClassLoader;", "getCordappClassloader", "()Ljava/lang/ClassLoader;", "cordappProvider", "Lnet/corda/core/cordapp/CordappProvider;", "getCordappProvider", "()Lnet/corda/core/cordapp/CordappProvider;", "cordappServices", "Lcom/google/common/collect/MutableClassToInstanceMap;", "Lnet/corda/core/serialization/SerializeAsToken;", "getCordappServices$node_driver", "()Lcom/google/common/collect/MutableClassToInstanceMap;", "diagnosticsService", "Lnet/corda/core/node/services/diagnostics/DiagnosticsService;", "getDiagnosticsService", "()Lnet/corda/core/node/services/diagnostics/DiagnosticsService;", "getIdentityService", "()Lnet/corda/core/node/services/IdentityService;", "getKeyManagementService", "()Lnet/corda/core/node/services/KeyManagementService;", "mockCordappProvider", "Lnet/corda/testing/internal/MockCordappProvider;", "[Ljava/security/KeyPair;", "myInfo", "Lnet/corda/core/node/NodeInfo;", "getMyInfo", "()Lnet/corda/core/node/NodeInfo;", "networkMapCache", "Lnet/corda/core/node/services/NetworkMapCache;", "getNetworkMapCache", "()Lnet/corda/core/node/services/NetworkMapCache;", "getNetworkParameters", "()Lnet/corda/core/node/NetworkParameters;", "networkParametersService", "Lnet/corda/core/node/services/NetworkParametersService;", "getNetworkParametersService", "()Lnet/corda/core/node/services/NetworkParametersService;", "setNetworkParametersService", "(Lnet/corda/core/node/services/NetworkParametersService;)V", "servicesForResolution", "Lnet/corda/core/node/ServicesForResolution;", "getServicesForResolution", "()Lnet/corda/core/node/ServicesForResolution;", "transactionVerifierService", "Lnet/corda/core/node/services/TransactionVerifierService;", "getTransactionVerifierService", "()Lnet/corda/core/node/services/TransactionVerifierService;", "getValidatedTransactions", "()Lnet/corda/core/node/services/TransactionStorage;", "vaultService", "Lnet/corda/core/node/services/VaultService;", "getVaultService", "()Lnet/corda/core/node/services/VaultService;", "addMockCordapp", "", "contractClassName", "Lnet/corda/core/contracts/ContractClassName;", "cordaService", "T", "type", "Ljava/lang/Class;", "(Ljava/lang/Class;)Lnet/corda/core/serialization/SerializeAsToken;", "jdbcSession", "Ljava/sql/Connection;", "loadContractAttachment", "Lnet/corda/core/contracts/Attachment;", "stateRef", "Lnet/corda/core/contracts/StateRef;", "loadState", "Lnet/corda/core/contracts/TransactionState;", "loadStates", "", "Lnet/corda/core/contracts/StateAndRef;", "Lnet/corda/core/contracts/ContractState;", "stateRefs", "makeVaultService", "Lnet/corda/node/services/api/VaultServiceInternal;", "schemaService", "Lnet/corda/node/services/api/SchemaService;", "database", "Lnet/corda/nodeapi/internal/persistence/CordaPersistence;", "makeVaultService$node_driver", "recordTransactions", "statesToRecord", "Lnet/corda/core/node/StatesToRecord;", "txs", "Lnet/corda/core/transactions/SignedTransaction;", "registerUnloadHandler", "", "runOnStop", "Lkotlin/Function0;", "withEntityManager", "block", "Ljava/util/function/Consumer;", "Ljavax/persistence/EntityManager;", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "MockStateMachineRecordedTransactionMappingStorage", "node-driver"})
public class MockServices
implements ServiceHub {
    @NotNull
    private final MockAttachmentStorage attachments;
    private final MockCordappProvider mockCordappProvider;
    @NotNull
    private NetworkParametersService networkParametersService;
    @NotNull
    private final DiagnosticsService diagnosticsService;
    @NotNull
    private final MutableClassToInstanceMap<SerializeAsToken> cordappServices;
    private final CordappLoader cordappLoader;
    @NotNull
    private final TransactionStorage validatedTransactions;
    @NotNull
    private final IdentityService identityService;
    private final TestIdentity initialIdentity;
    private final KeyPair[] moreKeys;
    @NotNull
    private final KeyManagementService keyManagementService;
    private static final MockStateMachineRecordedTransactionMappingStorage mockStateMachineRecordedTransactionMappingStorage;
    private static final Lazy dummyAttachment$delegate;
    public static final Companion Companion;

    @NotNull
    public final ClassLoader getCordappClassloader() {
        return this.cordappLoader.getAppClassLoader();
    }

    public void recordTransactions(@NotNull StatesToRecord statesToRecord, @NotNull Iterable<SignedTransaction> txs) {
        Intrinsics.checkParameterIsNotNull((Object)statesToRecord, (String)"statesToRecord");
        Intrinsics.checkParameterIsNotNull(txs, (String)"txs");
        Iterable<SignedTransaction> $receiver$iv = txs;
        Iterator<SignedTransaction> iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            SignedTransaction element$iv;
            SignedTransaction it = element$iv = iterator.next();
            TransactionStorage transactionStorage = this.getValidatedTransactions();
            if (transactionStorage == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.corda.node.services.api.WritableTransactionStorage");
            }
            ((WritableTransactionStorage)transactionStorage).addTransaction(it);
        }
    }

    @NotNull
    public NetworkParameters getNetworkParameters() {
        NetworkParametersService networkParametersService;
        NetworkParametersService $receiver = networkParametersService = this.getNetworkParametersService();
        NetworkParameters networkParameters = $receiver.lookup($receiver.getCurrentHash());
        if (networkParameters == null) {
            Intrinsics.throwNpe();
        }
        return networkParameters;
    }

    @NotNull
    public final MockAttachmentStorage getAttachments() {
        return this.attachments;
    }

    @NotNull
    public VaultService getVaultService() {
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    public ContractUpgradeService getContractUpgradeService() {
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    public NetworkMapCache getNetworkMapCache() {
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    public TestClock getClock() {
        Clock clock = Clock.systemUTC();
        Intrinsics.checkExpressionValueIsNotNull((Object)clock, (String)"Clock.systemUTC()");
        return new TestClock(clock);
    }

    @NotNull
    public NodeInfo getMyInfo() {
        return new NodeInfo(CollectionsKt.listOf((Object)new NetworkHostAndPort("mock.node.services", 10000)), CollectionsKt.listOf((Object)this.initialIdentity.getIdentity()), 1, 1L);
    }

    @NotNull
    public TransactionVerifierService getTransactionVerifierService() {
        return (TransactionVerifierService)new InMemoryTransactionVerifierService(2, (CordappProviderInternal)this.mockCordappProvider, (AttachmentStorage)this.attachments);
    }

    @NotNull
    public CordappProvider getCordappProvider() {
        return (CordappProvider)this.mockCordappProvider;
    }

    @NotNull
    public NetworkParametersService getNetworkParametersService() {
        return this.networkParametersService;
    }

    public void setNetworkParametersService(@NotNull NetworkParametersService networkParametersService) {
        Intrinsics.checkParameterIsNotNull((Object)networkParametersService, (String)"<set-?>");
        this.networkParametersService = networkParametersService;
    }

    @NotNull
    public DiagnosticsService getDiagnosticsService() {
        return this.diagnosticsService;
    }

    @NotNull
    protected final ServicesForResolution getServicesForResolution() {
        return (ServicesForResolution)new ServicesForResolutionImpl(this.getIdentityService(), (AttachmentStorage)this.attachments, this.getCordappProvider(), this.getNetworkParametersService(), this.getValidatedTransactions());
    }

    @NotNull
    public final VaultServiceInternal makeVaultService$node_driver(@NotNull SchemaService schemaService, @NotNull CordaPersistence database2, @NotNull CordappLoader cordappLoader) {
        NodeVaultService nodeVaultService;
        Intrinsics.checkParameterIsNotNull((Object)schemaService, (String)"schemaService");
        Intrinsics.checkParameterIsNotNull((Object)database2, (String)"database");
        Intrinsics.checkParameterIsNotNull((Object)cordappLoader, (String)"cordappLoader");
        NodeVaultService $receiver = nodeVaultService = new NodeVaultService((Clock)((Object)this.getClock()), this.getKeyManagementService(), this.getServicesForResolution(), database2, schemaService, cordappLoader.getAppClassLoader());
        $receiver.start();
        return (VaultServiceInternal)nodeVaultService;
    }

    @NotNull
    public final MutableClassToInstanceMap<SerializeAsToken> getCordappServices$node_driver() {
        return this.cordappServices;
    }

    @NotNull
    public <T extends SerializeAsToken> T cordaService(@NotNull Class<T> type) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        boolean bl = type.isAnnotationPresent(CordaService.class);
        if (!bl) {
            String string = type.getName() + " is not a Corda service";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        SerializeAsToken serializeAsToken = (SerializeAsToken)this.cordappServices.getInstance(type);
        if (serializeAsToken == null) {
            throw (Throwable)new IllegalArgumentException("Corda service " + type.getName() + " does not exist");
        }
        return (T)serializeAsToken;
    }

    @NotNull
    public Connection jdbcSession() {
        throw (Throwable)new UnsupportedOperationException();
    }

    public <T> T withEntityManager(@NotNull Function1<? super EntityManager, ? extends T> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        throw (Throwable)new UnsupportedOperationException();
    }

    public void withEntityManager(@NotNull Consumer<EntityManager> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    public Void registerUnloadHandler(@NotNull Function0<Unit> runOnStop) {
        Intrinsics.checkParameterIsNotNull(runOnStop, (String)"runOnStop");
        throw (Throwable)new UnsupportedOperationException();
    }

    public final void addMockCordapp(@NotNull String contractClassName) {
        Intrinsics.checkParameterIsNotNull((Object)contractClassName, (String)"contractClassName");
        MockCordappProvider.addMockCordapp$default((MockCordappProvider)this.mockCordappProvider, (String)contractClassName, (MockAttachmentStorage)this.attachments, null, null, null, (int)28, null);
    }

    @NotNull
    public TransactionState<?> loadState(@NotNull StateRef stateRef) {
        Intrinsics.checkParameterIsNotNull((Object)stateRef, (String)"stateRef");
        return this.getServicesForResolution().loadState(stateRef);
    }

    @NotNull
    public Set<StateAndRef<ContractState>> loadStates(@NotNull Set<StateRef> stateRefs) {
        Intrinsics.checkParameterIsNotNull(stateRefs, (String)"stateRefs");
        return this.getServicesForResolution().loadStates(stateRefs);
    }

    @NotNull
    public Attachment loadContractAttachment(@NotNull StateRef stateRef) {
        Intrinsics.checkParameterIsNotNull((Object)stateRef, (String)"stateRef");
        return MockServices.Companion.getDummyAttachment();
    }

    @NotNull
    public TransactionStorage getValidatedTransactions() {
        return this.validatedTransactions;
    }

    @NotNull
    public IdentityService getIdentityService() {
        return this.identityService;
    }

    @NotNull
    public KeyManagementService getKeyManagementService() {
        return this.keyManagementService;
    }

    private MockServices(CordappLoader cordappLoader, TransactionStorage validatedTransactions, IdentityService identityService, NetworkParameters initialNetworkParameters, TestIdentity initialIdentity, KeyPair[] moreKeys, KeyManagementService keyManagementService) {
        MockCordappProvider mockCordappProvider;
        this.cordappLoader = cordappLoader;
        this.validatedTransactions = validatedTransactions;
        this.identityService = identityService;
        this.initialIdentity = initialIdentity;
        this.moreKeys = moreKeys;
        this.keyManagementService = keyManagementService;
        this.attachments = new MockAttachmentStorage();
        MockCordappProvider mockCordappProvider2 = new MockCordappProvider(this.cordappLoader, (AttachmentStorage)this.attachments, null, 4, null);
        MockServices mockServices = this;
        MockCordappProvider it = mockCordappProvider2;
        it.start();
        mockServices.mockCordappProvider = mockCordappProvider = mockCordappProvider2;
        this.networkParametersService = (NetworkParametersService)new MockNetworkParametersStorage(initialNetworkParameters);
        this.diagnosticsService = (DiagnosticsService)new NodeDiagnosticsService();
        MutableClassToInstanceMap mutableClassToInstanceMap = MutableClassToInstanceMap.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)mutableClassToInstanceMap, (String)"MutableClassToInstanceMa\u2026reate<SerializeAsToken>()");
        this.cordappServices = mutableClassToInstanceMap;
    }

    /* synthetic */ MockServices(CordappLoader cordappLoader, TransactionStorage transactionStorage, IdentityService identityService, NetworkParameters networkParameters, TestIdentity testIdentity, KeyPair[] keyPairArray, KeyManagementService keyManagementService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            KeyPair[] keyPairArray2 = (KeyPair[])ArraysKt.plus((Object[])new KeyPair[]{testIdentity.getKeyPair()}, (Object[])keyPairArray);
            keyManagementService = (KeyManagementService)new MockKeyManagementService(identityService, Arrays.copyOf(keyPairArray2, keyPairArray2.length));
        }
        this(cordappLoader, transactionStorage, identityService, networkParameters, testIdentity, keyPairArray, keyManagementService);
    }

    private MockServices(CordappLoader cordappLoader, IdentityService identityService, NetworkParameters networkParameters, TestIdentity initialIdentity, KeyPair[] moreKeys, KeyManagementService keyManagementService) {
        this(cordappLoader, (TransactionStorage)new MockTransactionStorage(), identityService, networkParameters, initialIdentity, moreKeys, keyManagementService);
    }

    private MockServices(CordappLoader cordappLoader, IdentityService identityService, NetworkParameters networkParameters, TestIdentity initialIdentity, KeyPair[] moreKeys) {
        this(cordappLoader, (TransactionStorage)new MockTransactionStorage(), identityService, networkParameters, initialIdentity, moreKeys, null, 64, null);
    }

    @JvmOverloads
    public MockServices(@NotNull Iterable<String> cordappPackages, @NotNull TestIdentity initialIdentity, @NotNull IdentityService identityService, KeyPair ... moreKeys) {
        Intrinsics.checkParameterIsNotNull(cordappPackages, (String)"cordappPackages");
        Intrinsics.checkParameterIsNotNull((Object)initialIdentity, (String)"initialIdentity");
        Intrinsics.checkParameterIsNotNull((Object)identityService, (String)"identityService");
        Intrinsics.checkParameterIsNotNull((Object)moreKeys, (String)"moreKeys");
        CordappLoader cordappLoader = net.corda.testing.node.MockServices$Companion.cordappLoaderForPackages$default(Companion, cordappPackages, null, 2, null);
        Instant instant = Instant.MIN;
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.MIN");
        this(cordappLoader, identityService, ParametersUtilitiesKt.testNetworkParameters$default(null, (int)0, (Instant)instant, (int)0, (int)0, null, (int)0, null, null, (int)507, null), initialIdentity, moreKeys);
    }

    @JvmOverloads
    public /* synthetic */ MockServices(Iterable iterable, TestIdentity testIdentity, IdentityService identityService, KeyPair[] keyPairArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            identityService = MockServicesKt.makeTestIdentityService(new PartyAndCertificate[0]);
        }
        this((Iterable<String>)iterable, testIdentity, identityService, keyPairArray);
    }

    @JvmOverloads
    public MockServices(@NotNull Iterable<String> cordappPackages, @NotNull TestIdentity initialIdentity, KeyPair ... moreKeys) {
        this(cordappPackages, initialIdentity, null, moreKeys, 4, null);
    }

    public MockServices(@NotNull Iterable<String> cordappPackages, @NotNull TestIdentity initialIdentity, @NotNull IdentityService identityService, @NotNull NetworkParameters networkParameters, KeyPair ... moreKeys) {
        Intrinsics.checkParameterIsNotNull(cordappPackages, (String)"cordappPackages");
        Intrinsics.checkParameterIsNotNull((Object)initialIdentity, (String)"initialIdentity");
        Intrinsics.checkParameterIsNotNull((Object)identityService, (String)"identityService");
        Intrinsics.checkParameterIsNotNull((Object)networkParameters, (String)"networkParameters");
        Intrinsics.checkParameterIsNotNull((Object)moreKeys, (String)"moreKeys");
        this(net.corda.testing.node.MockServices$Companion.cordappLoaderForPackages$default(Companion, cordappPackages, null, 2, null), identityService, networkParameters, initialIdentity, moreKeys);
    }

    public MockServices(@NotNull Iterable<String> cordappPackages, @NotNull TestIdentity initialIdentity, @NotNull IdentityService identityService, @NotNull NetworkParameters networkParameters, @NotNull KeyPair[] moreKeys, @NotNull KeyManagementService keyManagementService) {
        Intrinsics.checkParameterIsNotNull(cordappPackages, (String)"cordappPackages");
        Intrinsics.checkParameterIsNotNull((Object)initialIdentity, (String)"initialIdentity");
        Intrinsics.checkParameterIsNotNull((Object)identityService, (String)"identityService");
        Intrinsics.checkParameterIsNotNull((Object)networkParameters, (String)"networkParameters");
        Intrinsics.checkParameterIsNotNull((Object)moreKeys, (String)"moreKeys");
        Intrinsics.checkParameterIsNotNull((Object)keyManagementService, (String)"keyManagementService");
        this(net.corda.testing.node.MockServices$Companion.cordappLoaderForPackages$default(Companion, cordappPackages, null, 2, null), identityService, networkParameters, initialIdentity, moreKeys, keyManagementService);
    }

    @JvmOverloads
    public MockServices(@NotNull Iterable<String> cordappPackages, @NotNull CordaX500Name initialIdentityName, @NotNull IdentityService identityService, @NotNull KeyPair key, KeyPair ... moreKeys) {
        Intrinsics.checkParameterIsNotNull(cordappPackages, (String)"cordappPackages");
        Intrinsics.checkParameterIsNotNull((Object)initialIdentityName, (String)"initialIdentityName");
        Intrinsics.checkParameterIsNotNull((Object)identityService, (String)"identityService");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)moreKeys, (String)"moreKeys");
        this(cordappPackages, new TestIdentity(initialIdentityName, key), identityService, Arrays.copyOf(moreKeys, moreKeys.length));
    }

    @JvmOverloads
    public /* synthetic */ MockServices(Iterable iterable, CordaX500Name cordaX500Name, IdentityService identityService, KeyPair keyPair, KeyPair[] keyPairArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            identityService = MockServicesKt.makeTestIdentityService(new PartyAndCertificate[0]);
        }
        this((Iterable<String>)iterable, cordaX500Name, identityService, keyPair, keyPairArray);
    }

    @JvmOverloads
    public MockServices(@NotNull Iterable<String> cordappPackages, @NotNull CordaX500Name initialIdentityName, @NotNull KeyPair key, KeyPair ... moreKeys) {
        this(cordappPackages, initialIdentityName, null, key, moreKeys, 4, null);
    }

    @JvmOverloads
    public MockServices(@NotNull Iterable<String> cordappPackages, @NotNull CordaX500Name initialIdentityName, @NotNull IdentityService identityService) {
        Intrinsics.checkParameterIsNotNull(cordappPackages, (String)"cordappPackages");
        Intrinsics.checkParameterIsNotNull((Object)initialIdentityName, (String)"initialIdentityName");
        Intrinsics.checkParameterIsNotNull((Object)identityService, (String)"identityService");
        this(cordappPackages, new TestIdentity(initialIdentityName, null, 2, null), identityService, new KeyPair[0]);
    }

    @JvmOverloads
    public /* synthetic */ MockServices(Iterable iterable, CordaX500Name cordaX500Name, IdentityService identityService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            identityService = MockServicesKt.makeTestIdentityService(new PartyAndCertificate[0]);
        }
        this((Iterable<String>)iterable, cordaX500Name, identityService);
    }

    @JvmOverloads
    public MockServices(@NotNull Iterable<String> cordappPackages, @NotNull CordaX500Name initialIdentityName) {
        this(cordappPackages, initialIdentityName, null, 4, null);
    }

    public MockServices(@NotNull Iterable<String> cordappPackages) {
        Intrinsics.checkParameterIsNotNull(cordappPackages, (String)"cordappPackages");
        this(cordappPackages, new CordaX500Name("TestIdentity", "", "GB"), MockServicesKt.makeTestIdentityService(new PartyAndCertificate[0]));
    }

    @JvmOverloads
    public MockServices(@NotNull CordaX500Name initialIdentityName, @NotNull IdentityService identityService, @NotNull KeyPair key, KeyPair ... moreKeys) {
        Intrinsics.checkParameterIsNotNull((Object)initialIdentityName, (String)"initialIdentityName");
        Intrinsics.checkParameterIsNotNull((Object)identityService, (String)"identityService");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)moreKeys, (String)"moreKeys");
        String string = InternalTestUtilsKt.getCallerPackage(Reflection.getOrCreateKotlinClass(MockServices.class));
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this((Iterable<String>)CollectionsKt.listOf((Object)string), new TestIdentity(initialIdentityName, key), identityService, Arrays.copyOf(moreKeys, moreKeys.length));
    }

    @JvmOverloads
    public /* synthetic */ MockServices(CordaX500Name cordaX500Name, IdentityService identityService, KeyPair keyPair, KeyPair[] keyPairArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            identityService = MockServicesKt.makeTestIdentityService(new PartyAndCertificate[0]);
        }
        this(cordaX500Name, identityService, keyPair, keyPairArray);
    }

    @JvmOverloads
    public MockServices(@NotNull CordaX500Name initialIdentityName, @NotNull KeyPair key, KeyPair ... moreKeys) {
        this(initialIdentityName, null, key, moreKeys, 2, null);
    }

    @JvmOverloads
    public MockServices(@NotNull CordaX500Name initialIdentityName, @NotNull IdentityService identityService) {
        Intrinsics.checkParameterIsNotNull((Object)initialIdentityName, (String)"initialIdentityName");
        Intrinsics.checkParameterIsNotNull((Object)identityService, (String)"identityService");
        String string = InternalTestUtilsKt.getCallerPackage(Reflection.getOrCreateKotlinClass(MockServices.class));
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this((Iterable<String>)CollectionsKt.listOf((Object)string), new TestIdentity(initialIdentityName, null, 2, null), identityService, new KeyPair[0]);
    }

    @JvmOverloads
    public /* synthetic */ MockServices(CordaX500Name cordaX500Name, IdentityService identityService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            identityService = MockServicesKt.makeTestIdentityService(new PartyAndCertificate[0]);
        }
        this(cordaX500Name, identityService);
    }

    @JvmOverloads
    public MockServices(@NotNull CordaX500Name initialIdentityName) {
        this(initialIdentityName, null, 2, null);
    }

    public MockServices(@NotNull List<String> cordappPackages, @NotNull CordaX500Name initialIdentityName, @NotNull IdentityService identityService, @NotNull NetworkParameters networkParameters) {
        Intrinsics.checkParameterIsNotNull(cordappPackages, (String)"cordappPackages");
        Intrinsics.checkParameterIsNotNull((Object)initialIdentityName, (String)"initialIdentityName");
        Intrinsics.checkParameterIsNotNull((Object)identityService, (String)"identityService");
        Intrinsics.checkParameterIsNotNull((Object)networkParameters, (String)"networkParameters");
        this((Iterable<String>)cordappPackages, new TestIdentity(initialIdentityName, null, 2, null), identityService, networkParameters, new KeyPair[0]);
    }

    public MockServices(@NotNull List<String> cordappPackages, @NotNull CordaX500Name initialIdentityName, @NotNull IdentityService identityService, @NotNull NetworkParameters networkParameters, @NotNull KeyPair key) {
        Intrinsics.checkParameterIsNotNull(cordappPackages, (String)"cordappPackages");
        Intrinsics.checkParameterIsNotNull((Object)initialIdentityName, (String)"initialIdentityName");
        Intrinsics.checkParameterIsNotNull((Object)identityService, (String)"identityService");
        Intrinsics.checkParameterIsNotNull((Object)networkParameters, (String)"networkParameters");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this((Iterable<String>)cordappPackages, new TestIdentity(initialIdentityName, key), identityService, networkParameters, new KeyPair[0]);
    }

    public MockServices(@NotNull TestIdentity firstIdentity, TestIdentity ... moreIdentities) {
        Intrinsics.checkParameterIsNotNull((Object)firstIdentity, (String)"firstIdentity");
        Intrinsics.checkParameterIsNotNull((Object)moreIdentities, (String)"moreIdentities");
        String string = InternalTestUtilsKt.getCallerPackage(Reflection.getOrCreateKotlinClass(MockServices.class));
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this((List<String>)CollectionsKt.listOf((Object)string), firstIdentity, Arrays.copyOf(moreIdentities, moreIdentities.length));
    }

    public MockServices(@NotNull TestIdentity firstIdentity, @NotNull NetworkParameters networkParameters, TestIdentity ... moreIdentities) {
        Intrinsics.checkParameterIsNotNull((Object)firstIdentity, (String)"firstIdentity");
        Intrinsics.checkParameterIsNotNull((Object)networkParameters, (String)"networkParameters");
        Intrinsics.checkParameterIsNotNull((Object)moreIdentities, (String)"moreIdentities");
        String string = InternalTestUtilsKt.getCallerPackage(Reflection.getOrCreateKotlinClass(MockServices.class));
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this((List<String>)CollectionsKt.listOf((Object)string), firstIdentity, networkParameters, Arrays.copyOf(moreIdentities, moreIdentities.length));
    }

    /*
     * WARNING - void declaration
     */
    public MockServices(@NotNull List<String> cordappPackages, @NotNull TestIdentity firstIdentity, TestIdentity ... moreIdentities) {
        Collection<PartyAndCertificate> collection;
        void $receiver$iv$iv;
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull(cordappPackages, (String)"cordappPackages");
        Intrinsics.checkParameterIsNotNull((Object)firstIdentity, (String)"firstIdentity");
        Intrinsics.checkParameterIsNotNull((Object)moreIdentities, (String)"moreIdentities");
        Iterable iterable = cordappPackages;
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)firstIdentity);
        spreadBuilder.addSpread((Object)moreIdentities);
        Iterable iterable2 = CollectionsKt.listOf((Object[])((TestIdentity[])spreadBuilder.toArray((Object[])new TestIdentity[spreadBuilder.size()])));
        TestIdentity testIdentity = firstIdentity;
        Iterable iterable3 = iterable;
        MockServices mockServices = this;
        void var5_8 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TestIdentity testIdentity2 = (TestIdentity)item$iv$iv;
            collection = destination$iv$iv;
            PartyAndCertificate partyAndCertificate = it.getIdentity();
            collection.add(partyAndCertificate);
        }
        collection = (List)destination$iv$iv;
        Collection thisCollection$iv = $receiver$iv = (Collection)collection;
        PartyAndCertificate[] partyAndCertificateArray = thisCollection$iv.toArray(new PartyAndCertificate[0]);
        if (partyAndCertificateArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        collection = partyAndCertificateArray;
        PartyAndCertificate[] partyAndCertificateArray2 = (PartyAndCertificate[])collection;
        mockServices((Iterable<String>)iterable3, testIdentity, MockServicesKt.makeTestIdentityService(Arrays.copyOf(partyAndCertificateArray2, partyAndCertificateArray2.length)), firstIdentity.getKeyPair());
    }

    /*
     * WARNING - void declaration
     */
    public MockServices(@NotNull List<String> cordappPackages, @NotNull TestIdentity firstIdentity, @NotNull NetworkParameters networkParameters, TestIdentity ... moreIdentities) {
        Collection<PartyAndCertificate> collection;
        void $receiver$iv$iv;
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull(cordappPackages, (String)"cordappPackages");
        Intrinsics.checkParameterIsNotNull((Object)firstIdentity, (String)"firstIdentity");
        Intrinsics.checkParameterIsNotNull((Object)networkParameters, (String)"networkParameters");
        Intrinsics.checkParameterIsNotNull((Object)moreIdentities, (String)"moreIdentities");
        Iterable iterable = cordappPackages;
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)firstIdentity);
        spreadBuilder.addSpread((Object)moreIdentities);
        Iterable iterable2 = CollectionsKt.listOf((Object[])((TestIdentity[])spreadBuilder.toArray((Object[])new TestIdentity[spreadBuilder.size()])));
        TestIdentity testIdentity = firstIdentity;
        Iterable iterable3 = iterable;
        MockServices mockServices = this;
        void var6_9 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TestIdentity testIdentity2 = (TestIdentity)item$iv$iv;
            collection = destination$iv$iv;
            PartyAndCertificate partyAndCertificate = it.getIdentity();
            collection.add(partyAndCertificate);
        }
        collection = (List)destination$iv$iv;
        Collection thisCollection$iv = $receiver$iv = (Collection)collection;
        PartyAndCertificate[] partyAndCertificateArray = thisCollection$iv.toArray(new PartyAndCertificate[0]);
        if (partyAndCertificateArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        collection = partyAndCertificateArray;
        PartyAndCertificate[] partyAndCertificateArray2 = (PartyAndCertificate[])collection;
        mockServices((Iterable<String>)iterable3, testIdentity, MockServicesKt.makeTestIdentityService(Arrays.copyOf(partyAndCertificateArray2, partyAndCertificateArray2.length)), networkParameters, firstIdentity.getKeyPair());
    }

    public MockServices() {
        String string = InternalTestUtilsKt.getCallerPackage(Reflection.getOrCreateKotlinClass(MockServices.class));
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this((Iterable<String>)CollectionsKt.listOf((Object)string), new CordaX500Name("TestIdentity", "", "GB"), MockServicesKt.makeTestIdentityService(new PartyAndCertificate[0]));
    }

    static {
        Companion = new Companion(null);
        mockStateMachineRecordedTransactionMappingStorage = new MockStateMachineRecordedTransactionMappingStorage();
        dummyAttachment$delegate = LazyKt.lazy((Function0)Companion.dummyAttachment.2.INSTANCE);
    }

    public void recordTransactions(boolean notifyVault, @NotNull Iterable<SignedTransaction> txs) {
        Intrinsics.checkParameterIsNotNull(txs, (String)"txs");
        ServiceHub.DefaultImpls.recordTransactions((ServiceHub)this, (boolean)notifyVault, txs);
    }

    public void recordTransactions(boolean notifyVault, @NotNull SignedTransaction first, SignedTransaction ... remaining) {
        Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
        Intrinsics.checkParameterIsNotNull((Object)remaining, (String)"remaining");
        ServiceHub.DefaultImpls.recordTransactions((ServiceHub)this, (boolean)notifyVault, (SignedTransaction)first, (SignedTransaction[])remaining);
    }

    public void recordTransactions(@NotNull Iterable<SignedTransaction> txs) {
        Intrinsics.checkParameterIsNotNull(txs, (String)"txs");
        ServiceHub.DefaultImpls.recordTransactions((ServiceHub)this, txs);
    }

    public void recordTransactions(@NotNull SignedTransaction first, SignedTransaction ... remaining) {
        Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
        Intrinsics.checkParameterIsNotNull((Object)remaining, (String)"remaining");
        ServiceHub.DefaultImpls.recordTransactions((ServiceHub)this, (SignedTransaction)first, (SignedTransaction[])remaining);
    }

    @NotNull
    public SignedTransaction addSignature(@NotNull SignedTransaction signedTransaction) {
        Intrinsics.checkParameterIsNotNull((Object)signedTransaction, (String)"signedTransaction");
        return ServiceHub.DefaultImpls.addSignature((ServiceHub)this, (SignedTransaction)signedTransaction);
    }

    @NotNull
    public SignedTransaction addSignature(@NotNull SignedTransaction signedTransaction, @NotNull PublicKey publicKey) {
        Intrinsics.checkParameterIsNotNull((Object)signedTransaction, (String)"signedTransaction");
        Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
        return ServiceHub.DefaultImpls.addSignature((ServiceHub)this, (SignedTransaction)signedTransaction, (PublicKey)publicKey);
    }

    @NotNull
    public TransactionSignature createSignature(@NotNull FilteredTransaction filteredTransaction) {
        Intrinsics.checkParameterIsNotNull((Object)filteredTransaction, (String)"filteredTransaction");
        return ServiceHub.DefaultImpls.createSignature((ServiceHub)this, (FilteredTransaction)filteredTransaction);
    }

    @NotNull
    public TransactionSignature createSignature(@NotNull FilteredTransaction filteredTransaction, @NotNull PublicKey publicKey) {
        Intrinsics.checkParameterIsNotNull((Object)filteredTransaction, (String)"filteredTransaction");
        Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
        return ServiceHub.DefaultImpls.createSignature((ServiceHub)this, (FilteredTransaction)filteredTransaction, (PublicKey)publicKey);
    }

    @NotNull
    public TransactionSignature createSignature(@NotNull SignedTransaction signedTransaction) {
        Intrinsics.checkParameterIsNotNull((Object)signedTransaction, (String)"signedTransaction");
        return ServiceHub.DefaultImpls.createSignature((ServiceHub)this, (SignedTransaction)signedTransaction);
    }

    @NotNull
    public TransactionSignature createSignature(@NotNull SignedTransaction signedTransaction, @NotNull PublicKey publicKey) {
        Intrinsics.checkParameterIsNotNull((Object)signedTransaction, (String)"signedTransaction");
        Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
        return ServiceHub.DefaultImpls.createSignature((ServiceHub)this, (SignedTransaction)signedTransaction, (PublicKey)publicKey);
    }

    @NotNull
    public CordappContext getAppContext() {
        return ServiceHub.DefaultImpls.getAppContext((ServiceHub)this);
    }

    @NotNull
    public SignedTransaction signInitialTransaction(@NotNull TransactionBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        return ServiceHub.DefaultImpls.signInitialTransaction((ServiceHub)this, (TransactionBuilder)builder);
    }

    @NotNull
    public SignedTransaction signInitialTransaction(@NotNull TransactionBuilder builder, @NotNull PublicKey publicKey) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
        return ServiceHub.DefaultImpls.signInitialTransaction((ServiceHub)this, (TransactionBuilder)builder, (PublicKey)publicKey);
    }

    @NotNull
    public SignedTransaction signInitialTransaction(@NotNull TransactionBuilder builder, @NotNull Iterable<? extends PublicKey> signingPubKeys) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull(signingPubKeys, (String)"signingPubKeys");
        return ServiceHub.DefaultImpls.signInitialTransaction((ServiceHub)this, (TransactionBuilder)builder, signingPubKeys);
    }

    @NotNull
    public <T extends ContractState> StateAndRef<T> toStateAndRef(@NotNull StateRef stateRef) {
        Intrinsics.checkParameterIsNotNull((Object)stateRef, (String)"stateRef");
        return ServiceHub.DefaultImpls.toStateAndRef((ServiceHub)this, (StateRef)stateRef);
    }

    @NotNull
    public static final /* synthetic */ MockStateMachineRecordedTransactionMappingStorage access$getMockStateMachineRecordedTransactionMappingStorage$cp() {
        return mockStateMachineRecordedTransactionMappingStorage;
    }

    public /* synthetic */ MockServices(@NotNull CordappLoader cordappLoader, @NotNull IdentityService identityService, @NotNull NetworkParameters networkParameters, @NotNull TestIdentity initialIdentity, @NotNull KeyPair[] moreKeys, @NotNull KeyManagementService keyManagementService, DefaultConstructorMarker $constructor_marker) {
        this(cordappLoader, identityService, networkParameters, initialIdentity, moreKeys, keyManagementService);
    }

    @JvmStatic
    @NotNull
    public static final Properties makeTestDataSourceProperties(@NotNull String nodeName) {
        return Companion.makeTestDataSourceProperties(nodeName);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Pair<CordaPersistence, MockServices> makeTestDatabaseAndMockServices(@NotNull List<String> cordappPackages, @NotNull IdentityService identityService, @NotNull TestIdentity initialIdentity, @NotNull NetworkParameters networkParameters, KeyPair ... moreKeys) {
        return Companion.makeTestDatabaseAndMockServices(cordappPackages, identityService, initialIdentity, networkParameters, moreKeys);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Pair<CordaPersistence, MockServices> makeTestDatabaseAndMockServices(@NotNull List<String> cordappPackages, @NotNull IdentityService identityService, @NotNull TestIdentity initialIdentity, KeyPair ... moreKeys) {
        return net.corda.testing.node.MockServices$Companion.makeTestDatabaseAndMockServices$default(Companion, cordappPackages, identityService, initialIdentity, null, moreKeys, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Pair<CordaPersistence, MockServices> makeTestDatabaseAndPersistentServices(@NotNull List<String> cordappPackages, @NotNull TestIdentity initialIdentity, @NotNull NetworkParameters networkParameters, @NotNull Set<KeyPair> moreKeys, @NotNull Set<PartyAndCertificate> moreIdentities, @NotNull TestingNamedCacheFactory cacheFactory) {
        return Companion.makeTestDatabaseAndPersistentServices(cordappPackages, initialIdentity, networkParameters, moreKeys, moreIdentities, cacheFactory);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Pair<CordaPersistence, MockServices> makeTestDatabaseAndPersistentServices(@NotNull List<String> cordappPackages, @NotNull TestIdentity initialIdentity, @NotNull NetworkParameters networkParameters, @NotNull Set<KeyPair> moreKeys, @NotNull Set<PartyAndCertificate> moreIdentities) {
        return net.corda.testing.node.MockServices$Companion.makeTestDatabaseAndPersistentServices$default(Companion, cordappPackages, initialIdentity, networkParameters, moreKeys, moreIdentities, null, 32, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Pair<CordaPersistence, MockServices> makeTestDatabaseAndPersistentServices(@NotNull List<String> cordappPackages, @NotNull TestIdentity initialIdentity, @NotNull Set<KeyPair> moreKeys, @NotNull Set<PartyAndCertificate> moreIdentities) {
        return net.corda.testing.node.MockServices$Companion.makeTestDatabaseAndPersistentServices$default(Companion, cordappPackages, initialIdentity, null, moreKeys, moreIdentities, null, 36, null);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\f0\nH\u0016\u00a8\u0006\r"}, d2={"Lnet/corda/testing/node/MockServices$MockStateMachineRecordedTransactionMappingStorage;", "Lnet/corda/node/services/api/StateMachineRecordedTransactionMappingStorage;", "()V", "addMapping", "", "stateMachineRunId", "Lnet/corda/core/flows/StateMachineRunId;", "transactionId", "Lnet/corda/core/crypto/SecureHash;", "track", "Lnet/corda/core/messaging/DataFeed;", "", "Lnet/corda/core/messaging/StateMachineTransactionMapping;", "node-driver"})
    private static final class MockStateMachineRecordedTransactionMappingStorage
    implements StateMachineRecordedTransactionMappingStorage {
        public void addMapping(@NotNull StateMachineRunId stateMachineRunId, @NotNull SecureHash transactionId) {
            Intrinsics.checkParameterIsNotNull((Object)stateMachineRunId, (String)"stateMachineRunId");
            Intrinsics.checkParameterIsNotNull((Object)transactionId, (String)"transactionId");
            throw (Throwable)new UnsupportedOperationException();
        }

        @NotNull
        public DataFeed<List<StateMachineTransactionMapping>, StateMachineTransactionMapping> track() {
            throw (Throwable)new UnsupportedOperationException();
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u008b\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002JN\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0012\u0010$\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020\u000fH\u0007JU\u0010'\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00130(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000f0*2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0+\"\u00020\u001dH\u0007\u00a2\u0006\u0002\u0010,JZ\u0010-\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00130(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000f0*2\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u0017\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u001c2\b\b\u0002\u00100\u001a\u000201H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lnet/corda/testing/node/MockServices$Companion;", "", "()V", "dummyAttachment", "net/corda/testing/node/MockServices$Companion$dummyAttachment$2$attachment$1", "getDummyAttachment", "()Lnet/corda/testing/node/MockServices$Companion$dummyAttachment$2$attachment$1;", "dummyAttachment$delegate", "Lkotlin/Lazy;", "mockStateMachineRecordedTransactionMappingStorage", "Lnet/corda/testing/node/MockServices$MockStateMachineRecordedTransactionMappingStorage;", "cordappLoaderForPackages", "Lnet/corda/nodeapi/internal/cordapp/CordappLoader;", "packages", "", "", "versionInfo", "Lnet/corda/node/VersionInfo;", "makeMockMockServices", "Lnet/corda/testing/node/MockServices;", "cordappLoader", "identityService", "Lnet/corda/core/node/services/IdentityService;", "networkParameters", "Lnet/corda/core/node/NetworkParameters;", "initialIdentity", "Lnet/corda/testing/core/TestIdentity;", "moreKeys", "", "Ljava/security/KeyPair;", "keyManagementService", "Lnet/corda/core/node/services/KeyManagementService;", "schemaService", "Lnet/corda/node/services/api/SchemaService;", "persistence", "Lnet/corda/nodeapi/internal/persistence/CordaPersistence;", "makeTestDataSourceProperties", "Ljava/util/Properties;", "nodeName", "makeTestDatabaseAndMockServices", "Lkotlin/Pair;", "cordappPackages", "", "", "(Ljava/util/List;Lnet/corda/core/node/services/IdentityService;Lnet/corda/testing/core/TestIdentity;Lnet/corda/core/node/NetworkParameters;[Ljava/security/KeyPair;)Lkotlin/Pair;", "makeTestDatabaseAndPersistentServices", "moreIdentities", "Lnet/corda/core/identity/PartyAndCertificate;", "cacheFactory", "Lnet/corda/testing/internal/TestingNamedCacheFactory;", "node-driver"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "dummyAttachment", "getDummyAttachment()Lnet/corda/testing/node/MockServices$Companion$dummyAttachment$2$attachment$1;"))};
        }

        /*
         * WARNING - void declaration
         */
        private final CordappLoader cordappLoaderForPackages(Iterable<String> packages, VersionInfo versionInfo) {
            Collection<URL> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable iterable = InternalTestUtilsKt.cordappsForPackages(packages);
            JarScanningCordappLoader.Companion companion = JarScanningCordappLoader.Companion;
            void var4_5 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                CustomCordapp customCordapp = (CustomCordapp)item$iv$iv;
                collection = destination$iv$iv;
                URL uRL = it.getJarFile().toUri().toURL();
                collection.add(uRL);
            }
            collection = (List)destination$iv$iv;
            return (CordappLoader)JarScanningCordappLoader.Companion.fromJarUrls$default((JarScanningCordappLoader.Companion)companion, (List)collection, (VersionInfo)versionInfo, null, null, (int)12, null);
        }

        static /* bridge */ /* synthetic */ CordappLoader cordappLoaderForPackages$default(Companion companion, Iterable iterable, VersionInfo versionInfo, int n, Object object) {
            if ((n & 2) != 0) {
                versionInfo = VersionInfo.Companion.getUNKNOWN();
            }
            return companion.cordappLoaderForPackages(iterable, versionInfo);
        }

        @JvmStatic
        @NotNull
        public final Properties makeTestDataSourceProperties(@NotNull String nodeName) {
            Intrinsics.checkParameterIsNotNull((Object)nodeName, (String)"nodeName");
            Path dbDir = Paths.get("", "build", "mocknetworktestdb", nodeName).toAbsolutePath();
            Path dbPath = dbDir.resolve("persistence");
            try {
                Path path = dbDir;
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"dbDir");
                DatabaseSnapshot.INSTANCE.copyDatabaseSnapshot(path);
            }
            catch (FileAlreadyExistsException ex) {
                DriverDSLImpl.Companion.getLog$node_driver().warn("Database already exists on disk, not attempting to pre-migrate database.");
            }
            Properties props = new Properties();
            props.setProperty("dataSourceClassName", "org.h2.jdbcx.JdbcDataSource");
            props.setProperty("dataSource.url", "jdbc:h2:file:" + dbPath + ";LOCK_TIMEOUT=10000;DB_CLOSE_ON_EXIT=FALSE");
            props.setProperty("dataSource.user", "sa");
            props.setProperty("dataSource.password", "");
            return props;
        }

        @JvmStatic
        @NotNull
        public static /* bridge */ /* synthetic */ Properties makeTestDataSourceProperties$default(Companion companion, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = SecureHash.Companion.randomSHA256().toString();
            }
            return companion.makeTestDataSourceProperties(string);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Pair<CordaPersistence, MockServices> makeTestDatabaseAndMockServices(@NotNull List<String> cordappPackages, @NotNull IdentityService identityService, @NotNull TestIdentity initialIdentity, @NotNull NetworkParameters networkParameters, KeyPair ... moreKeys) {
            Intrinsics.checkParameterIsNotNull(cordappPackages, (String)"cordappPackages");
            Intrinsics.checkParameterIsNotNull((Object)identityService, (String)"identityService");
            Intrinsics.checkParameterIsNotNull((Object)initialIdentity, (String)"initialIdentity");
            Intrinsics.checkParameterIsNotNull((Object)networkParameters, (String)"networkParameters");
            Intrinsics.checkParameterIsNotNull((Object)moreKeys, (String)"moreKeys");
            CordappLoader cordappLoader = net.corda.testing.node.MockServices$Companion.cordappLoaderForPackages$default(this, cordappPackages, null, 2, null);
            Properties dataSourceProps = net.corda.testing.node.MockServices$Companion.makeTestDataSourceProperties$default(this, null, 1, null);
            NodeSchemaService schemaService = new NodeSchemaService(cordappLoader.getCordappSchemas());
            CordaPersistence database2 = net.corda.testing.internal.InternalTestUtilsKt.configureDatabase$default((Properties)dataSourceProps, (DatabaseConfig)new DatabaseConfig(false, 0L, 3, null), (Function1)((Function1)new Function1<CordaX500Name, Party>(identityService){

                @Nullable
                public final Party invoke(@NotNull CordaX500Name p1) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    return ((IdentityService)this.receiver).wellKnownPartyFromX500Name(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(IdentityService.class);
                }

                public final String getName() {
                    return "wellKnownPartyFromX500Name";
                }

                public final String getSignature() {
                    return "wellKnownPartyFromX500Name(Lnet/corda/core/identity/CordaX500Name;)Lnet/corda/core/identity/Party;";
                }
            }), (Function1)((Function1)new Function1<AbstractParty, Party>(identityService){

                @Nullable
                public final Party invoke(@NotNull AbstractParty p1) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    return ((IdentityService)this.receiver).wellKnownPartyFromAnonymous(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(IdentityService.class);
                }

                public final String getName() {
                    return "wellKnownPartyFromAnonymous";
                }

                public final String getSignature() {
                    return "wellKnownPartyFromAnonymous(Lnet/corda/core/identity/AbstractParty;)Lnet/corda/core/identity/Party;";
                }
            }), (SchemaService)((SchemaService)schemaService), (Set)schemaService.getInternalSchemas(), null, null, (boolean)false, (boolean)false, (int)960, null);
            KeyPair[] keyPairArray = (KeyPair[])ArraysKt.plus((Object[])new KeyPair[]{initialIdentity.getKeyPair()}, (Object[])moreKeys);
            MockKeyManagementService keyManagementService = new MockKeyManagementService(identityService, Arrays.copyOf(keyPairArray, keyPairArray.length));
            MockServices mockService2 = (MockServices)CordaPersistence.transaction$default((CordaPersistence)database2, (boolean)false, (Function1)((Function1)new Function1<DatabaseTransaction, MockServices>(cordappLoader, identityService, networkParameters, initialIdentity, moreKeys, keyManagementService, schemaService, database2){
                final /* synthetic */ CordappLoader $cordappLoader;
                final /* synthetic */ IdentityService $identityService;
                final /* synthetic */ NetworkParameters $networkParameters;
                final /* synthetic */ TestIdentity $initialIdentity;
                final /* synthetic */ KeyPair[] $moreKeys;
                final /* synthetic */ MockKeyManagementService $keyManagementService;
                final /* synthetic */ NodeSchemaService $schemaService;
                final /* synthetic */ CordaPersistence $database;

                @NotNull
                public final MockServices invoke(@NotNull DatabaseTransaction $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    return net.corda.testing.node.MockServices$Companion.access$makeMockMockServices(MockServices.Companion, this.$cordappLoader, this.$identityService, this.$networkParameters, this.$initialIdentity, ArraysKt.toSet((Object[])this.$moreKeys), (KeyManagementService)this.$keyManagementService, (SchemaService)this.$schemaService, this.$database);
                }
                {
                    this.$cordappLoader = cordappLoader;
                    this.$identityService = identityService;
                    this.$networkParameters = networkParameters;
                    this.$initialIdentity = testIdentity;
                    this.$moreKeys = keyPairArray;
                    this.$keyManagementService = mockKeyManagementService;
                    this.$schemaService = nodeSchemaService;
                    this.$database = cordaPersistence;
                    super(1);
                }
            }), (int)1, null);
            return new Pair((Object)database2, (Object)mockService2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public static /* bridge */ /* synthetic */ Pair makeTestDatabaseAndMockServices$default(Companion companion, List list, IdentityService identityService, TestIdentity testIdentity, NetworkParameters networkParameters, KeyPair[] keyPairArray, int n, Object object) {
            if ((n & 8) != 0) {
                Instant instant = Instant.MIN;
                Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.MIN");
                networkParameters = ParametersUtilitiesKt.testNetworkParameters$default(null, (int)0, (Instant)instant, (int)0, (int)0, null, (int)0, null, null, (int)507, null);
            }
            return companion.makeTestDatabaseAndMockServices((List<String>)list, identityService, testIdentity, networkParameters, keyPairArray);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Pair<CordaPersistence, MockServices> makeTestDatabaseAndMockServices(@NotNull List<String> cordappPackages, @NotNull IdentityService identityService, @NotNull TestIdentity initialIdentity, KeyPair ... moreKeys) {
            return net.corda.testing.node.MockServices$Companion.makeTestDatabaseAndMockServices$default(this, cordappPackages, identityService, initialIdentity, null, moreKeys, 8, null);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Pair<CordaPersistence, MockServices> makeTestDatabaseAndPersistentServices(@NotNull List<String> cordappPackages, @NotNull TestIdentity initialIdentity, @NotNull NetworkParameters networkParameters, @NotNull Set<KeyPair> moreKeys, @NotNull Set<PartyAndCertificate> moreIdentities, @NotNull TestingNamedCacheFactory cacheFactory) {
            Map $receiver$iv$iv;
            Object it;
            PersistentIdentityService persistentIdentityService;
            Intrinsics.checkParameterIsNotNull(cordappPackages, (String)"cordappPackages");
            Intrinsics.checkParameterIsNotNull((Object)initialIdentity, (String)"initialIdentity");
            Intrinsics.checkParameterIsNotNull((Object)networkParameters, (String)"networkParameters");
            Intrinsics.checkParameterIsNotNull(moreKeys, (String)"moreKeys");
            Intrinsics.checkParameterIsNotNull(moreIdentities, (String)"moreIdentities");
            Intrinsics.checkParameterIsNotNull((Object)cacheFactory, (String)"cacheFactory");
            CordappLoader cordappLoader = net.corda.testing.node.MockServices$Companion.cordappLoaderForPackages$default(this, cordappPackages, null, 2, null);
            Properties dataSourceProps = net.corda.testing.node.MockServices$Companion.makeTestDataSourceProperties$default(this, null, 1, null);
            NodeSchemaService schemaService = new NodeSchemaService(cordappLoader.getCordappSchemas());
            PersistentIdentityService identityService = new PersistentIdentityService((NamedCacheFactory)cacheFactory);
            CordaPersistence persistence2 = net.corda.testing.internal.InternalTestUtilsKt.configureDatabase$default((Properties)dataSourceProps, (DatabaseConfig)new DatabaseConfig(false, 0L, 3, null), (Function1)((Function1)new Function1<CordaX500Name, Party>(identityService){

                @Nullable
                public final Party invoke(@NotNull CordaX500Name p1) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    return ((PersistentIdentityService)this.receiver).wellKnownPartyFromX500Name(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(PersistentIdentityService.class);
                }

                public final String getName() {
                    return "wellKnownPartyFromX500Name";
                }

                public final String getSignature() {
                    return "wellKnownPartyFromX500Name(Lnet/corda/core/identity/CordaX500Name;)Lnet/corda/core/identity/Party;";
                }
            }), (Function1)((Function1)new Function1<AbstractParty, Party>(identityService){

                @Nullable
                public final Party invoke(@NotNull AbstractParty p1) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    return ((PersistentIdentityService)this.receiver).wellKnownPartyFromAnonymous(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(PersistentIdentityService.class);
                }

                public final String getName() {
                    return "wellKnownPartyFromAnonymous";
                }

                public final String getSignature() {
                    return "wellKnownPartyFromAnonymous(Lnet/corda/core/identity/AbstractParty;)Lnet/corda/core/identity/Party;";
                }
            }), (SchemaService)((SchemaService)schemaService), (Set)schemaService.getInternalSchemas(), null, null, (boolean)false, (boolean)false, (int)960, null);
            PublicKeyToOwningIdentityCacheImpl pkToIdCache = new PublicKeyToOwningIdentityCacheImpl(persistence2, (NamedCacheFactory)cacheFactory);
            PersistentIdentityService $receiver = persistentIdentityService = identityService;
            $receiver.setDatabase(persistence2);
            PersistentIdentityService.start$default((PersistentIdentityService)$receiver, (Set)SetsKt.setOf((Object)InternalTestConstantsKt.getDEV_ROOT_CA().getCertificate()), (PartyAndCertificate)initialIdentity.getIdentity(), null, (WritablePublicKeyToOwningIdentityCache)((WritablePublicKeyToOwningIdentityCache)pkToIdCache), (int)4, null);
            CordaPersistence.transaction$default((CordaPersistence)persistence2, (boolean)false, (Function1)((Function1)new Function1<DatabaseTransaction, Unit>(persistence2, initialIdentity, pkToIdCache, identityService, moreIdentities){
                final /* synthetic */ CordaPersistence $persistence$inlined;
                final /* synthetic */ TestIdentity $initialIdentity$inlined;
                final /* synthetic */ PublicKeyToOwningIdentityCacheImpl $pkToIdCache$inlined;
                final /* synthetic */ PersistentIdentityService $identityService$inlined;
                final /* synthetic */ Set $moreIdentities$inlined;
                {
                    this.$persistence$inlined = cordaPersistence;
                    this.$initialIdentity$inlined = testIdentity;
                    this.$pkToIdCache$inlined = publicKeyToOwningIdentityCacheImpl;
                    this.$identityService$inlined = persistentIdentityService;
                    this.$moreIdentities$inlined = set;
                    super(1);
                }

                public final void invoke(@NotNull DatabaseTransaction $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    this.$identityService$inlined.loadIdentities((Collection)SetsKt.plus((Set)this.$moreIdentities$inlined, (Object)this.$initialIdentity$inlined.getIdentity()));
                }
            }), (int)1, null);
            PersistentNetworkMapCache networkMapCache = new PersistentNetworkMapCache((NamedCacheFactory)cacheFactory, persistence2, (IdentityServiceInternal)identityService);
            Iterable $receiver$iv = SetsKt.plus(moreIdentities, (Object)initialIdentity.getIdentity());
            for (Object element$iv : $receiver$iv) {
                it = (PartyAndCertificate)element$iv;
                networkMapCache.addOrUpdateNode(new NodeInfo(CollectionsKt.listOf((Object)new NetworkHostAndPort("localhost", 0)), CollectionsKt.listOf((Object)it), 9, 0L));
            }
            Map aliasKeyMap = new LinkedHashMap();
            Iterable $receiver$iv2 = moreKeys;
            it = $receiver$iv2;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            int index$iv$iv = 0;
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                void keyPair;
                void index;
                Object item$iv$iv = iterator.next();
                int n = index$iv$iv++;
                KeyPair keyPair2 = (KeyPair)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                String alias = "Extra key " + (int)index;
                Map map2 = aliasKeyMap;
                void var26_27 = keyPair;
                map2.put(alias, var26_27);
                Pair pair = TuplesKt.to((Object)keyPair.getPublic(), (Object)alias);
                collection.add(pair);
            }
            List aliasedMoreKeys = (List)destination$iv$iv;
            String identityAlias = initialIdentity.getName() + " private key";
            $receiver$iv$iv = aliasKeyMap;
            destination$iv$iv = initialIdentity.getKeyPair();
            $receiver$iv$iv.put(identityAlias, destination$iv$iv);
            Pair aliasedIdentityKey = TuplesKt.to((Object)initialIdentity.getPublicKey(), (Object)identityAlias);
            BasicHSMKeyManagementService keyManagementService = new BasicHSMKeyManagementService((NamedCacheFactory)new TestingNamedCacheFactory(0L, 1, null), identityService, persistence2, (SignOnlyCryptoService)new MockCryptoService(aliasKeyMap));
            CordaPersistence.transaction$default((CordaPersistence)persistence2, (boolean)false, (Function1)((Function1)new Function1<DatabaseTransaction, Unit>(keyManagementService, aliasedMoreKeys, aliasedIdentityKey){
                final /* synthetic */ BasicHSMKeyManagementService $keyManagementService;
                final /* synthetic */ List $aliasedMoreKeys;
                final /* synthetic */ Pair $aliasedIdentityKey;

                public final void invoke(@NotNull DatabaseTransaction $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    this.$keyManagementService.start((Iterable)CollectionsKt.plus((Collection)this.$aliasedMoreKeys, (Object)this.$aliasedIdentityKey));
                }
                {
                    this.$keyManagementService = basicHSMKeyManagementService;
                    this.$aliasedMoreKeys = list;
                    this.$aliasedIdentityKey = pair;
                    super(1);
                }
            }), (int)1, null);
            MockServices mockService2 = (MockServices)CordaPersistence.transaction$default((CordaPersistence)persistence2, (boolean)false, (Function1)((Function1)new Function1<DatabaseTransaction, MockServices>(cordappLoader, identityService, networkParameters, initialIdentity, moreKeys, keyManagementService, schemaService, persistence2){
                final /* synthetic */ CordappLoader $cordappLoader;
                final /* synthetic */ PersistentIdentityService $identityService;
                final /* synthetic */ NetworkParameters $networkParameters;
                final /* synthetic */ TestIdentity $initialIdentity;
                final /* synthetic */ Set $moreKeys;
                final /* synthetic */ BasicHSMKeyManagementService $keyManagementService;
                final /* synthetic */ NodeSchemaService $schemaService;
                final /* synthetic */ CordaPersistence $persistence;

                @NotNull
                public final MockServices invoke(@NotNull DatabaseTransaction $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    return net.corda.testing.node.MockServices$Companion.access$makeMockMockServices(MockServices.Companion, this.$cordappLoader, (IdentityService)this.$identityService, this.$networkParameters, this.$initialIdentity, this.$moreKeys, (KeyManagementService)this.$keyManagementService, (SchemaService)this.$schemaService, this.$persistence);
                }
                {
                    this.$cordappLoader = cordappLoader;
                    this.$identityService = persistentIdentityService;
                    this.$networkParameters = networkParameters;
                    this.$initialIdentity = testIdentity;
                    this.$moreKeys = set;
                    this.$keyManagementService = basicHSMKeyManagementService;
                    this.$schemaService = nodeSchemaService;
                    this.$persistence = cordaPersistence;
                    super(1);
                }
            }), (int)1, null);
            return new Pair((Object)persistence2, (Object)mockService2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public static /* bridge */ /* synthetic */ Pair makeTestDatabaseAndPersistentServices$default(Companion companion, List list, TestIdentity testIdentity, NetworkParameters networkParameters, Set set, Set set2, TestingNamedCacheFactory testingNamedCacheFactory, int n, Object object) {
            if ((n & 4) != 0) {
                Instant instant = Instant.MIN;
                Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.MIN");
                networkParameters = ParametersUtilitiesKt.testNetworkParameters$default(null, (int)0, (Instant)instant, (int)0, (int)0, null, (int)0, null, null, (int)507, null);
            }
            if ((n & 0x20) != 0) {
                testingNamedCacheFactory = new TestingNamedCacheFactory(0L, 1, null);
            }
            return companion.makeTestDatabaseAndPersistentServices(list, testIdentity, networkParameters, set, set2, testingNamedCacheFactory);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Pair<CordaPersistence, MockServices> makeTestDatabaseAndPersistentServices(@NotNull List<String> cordappPackages, @NotNull TestIdentity initialIdentity, @NotNull NetworkParameters networkParameters, @NotNull Set<KeyPair> moreKeys, @NotNull Set<PartyAndCertificate> moreIdentities) {
            return net.corda.testing.node.MockServices$Companion.makeTestDatabaseAndPersistentServices$default(this, cordappPackages, initialIdentity, networkParameters, moreKeys, moreIdentities, null, 32, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Pair<CordaPersistence, MockServices> makeTestDatabaseAndPersistentServices(@NotNull List<String> cordappPackages, @NotNull TestIdentity initialIdentity, @NotNull Set<KeyPair> moreKeys, @NotNull Set<PartyAndCertificate> moreIdentities) {
            return net.corda.testing.node.MockServices$Companion.makeTestDatabaseAndPersistentServices$default(this, cordappPackages, initialIdentity, null, moreKeys, moreIdentities, null, 36, null);
        }

        /*
         * WARNING - void declaration
         */
        private final MockServices makeMockMockServices(CordappLoader cordappLoader, IdentityService identityService, NetworkParameters networkParameters, TestIdentity initialIdentity, Set<KeyPair> moreKeys, KeyManagementService keyManagementService, SchemaService schemaService, CordaPersistence persistence2) {
            void $receiver$iv;
            makeMockMockServices.1 v0;
            Collection collection = moreKeys;
            TestIdentity testIdentity = initialIdentity;
            NetworkParameters networkParameters2 = networkParameters;
            IdentityService identityService2 = identityService;
            CordappLoader cordappLoader2 = cordappLoader;
            KeyManagementService keyManagementService2 = keyManagementService;
            Set<KeyPair> set = moreKeys;
            TestIdentity testIdentity2 = initialIdentity;
            IdentityService identityService3 = identityService;
            CordappLoader cordappLoader3 = cordappLoader;
            SchemaService schemaService2 = schemaService;
            NetworkParameters networkParameters3 = networkParameters;
            CordaPersistence cordaPersistence = persistence2;
            makeMockMockServices.1 var13_22 = v0;
            makeMockMockServices.1 var12_23 = v0;
            void v1 = $receiver$iv;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            void thisCollection$iv = v1;
            KeyPair[] keyPairArray = thisCollection$iv.toArray(new KeyPair[0]);
            if (keyPairArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            KeyPair[] keyPairArray2 = keyPairArray;
            var13_22(cordaPersistence, networkParameters3, schemaService2, cordappLoader3, identityService3, testIdentity2, set, keyManagementService2, cordappLoader2, identityService2, networkParameters2, testIdentity, keyPairArray2, keyManagementService);
            return var12_23;
        }

        private final dummyAttachment.attachment.1 getDummyAttachment() {
            Lazy lazy = dummyAttachment$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[0];
            return lazy.getValue();
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ MockServices access$makeMockMockServices(Companion $this, @NotNull CordappLoader cordappLoader, @NotNull IdentityService identityService, @NotNull NetworkParameters networkParameters, @NotNull TestIdentity initialIdentity, @NotNull Set moreKeys, @NotNull KeyManagementService keyManagementService, @NotNull SchemaService schemaService, @NotNull CordaPersistence persistence2) {
            return $this.makeMockMockServices(cordappLoader, identityService, networkParameters, initialIdentity, moreKeys, keyManagementService, schemaService, persistence2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

