/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.node;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.internal.InternalUtils;
import net.corda.node.MutableClock;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lnet/corda/testing/node/TestClock;", "Lnet/corda/node/MutableClock;", "delegateClock", "Ljava/time/Clock;", "(Ljava/time/Clock;)V", "advanceBy", "", "duration", "Ljava/time/Duration;", "setTo", "newInstant", "Ljava/time/Instant;", "node-driver"})
@ThreadSafe
public final class TestClock
extends MutableClock {
    public final synchronized void advanceBy(@NotNull Duration duration) {
        Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
        Clock clock = Clock.offset(this.getDelegateClock(), duration);
        Intrinsics.checkExpressionValueIsNotNull((Object)clock, (String)"offset(delegateClock, duration)");
        this.setDelegateClock(clock);
        this.notifyMutationObservers();
    }

    public final synchronized void setTo(@NotNull Instant newInstant) {
        Intrinsics.checkParameterIsNotNull((Object)newInstant, (String)"newInstant");
        this.advanceBy(InternalUtils.until((Temporal)this.instant(), (Temporal)newInstant));
    }

    public TestClock(@NotNull Clock delegateClock) {
        Intrinsics.checkParameterIsNotNull((Object)delegateClock, (String)"delegateClock");
        super(delegateClock);
    }
}

