/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.node.internal;

import com.nhaarman.mockito_kotlin.MockitoKt;
import com.nhaarman.mockito_kotlin.StubberKt;
import java.io.Closeable;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.persistence.EntityManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import net.corda.core.concurrent.CordaFuture;
import net.corda.core.context.InvocationContext;
import net.corda.core.contracts.Attachment;
import net.corda.core.contracts.ContractState;
import net.corda.core.contracts.StateAndRef;
import net.corda.core.contracts.StateRef;
import net.corda.core.contracts.TransactionState;
import net.corda.core.cordapp.CordappContext;
import net.corda.core.crypto.CryptoUtils;
import net.corda.core.crypto.TransactionSignature;
import net.corda.core.flows.FlowLogic;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.identity.Party;
import net.corda.core.identity.PartyAndCertificate;
import net.corda.core.internal.AttachmentTrustCalculator;
import net.corda.core.internal.FlowIORequest;
import net.corda.core.internal.FlowStateMachineHandle;
import net.corda.core.internal.InternalUtils;
import net.corda.core.internal.NamedCacheFactory;
import net.corda.core.internal.NetworkParametersStorage;
import net.corda.core.internal.PathUtilsKt;
import net.corda.core.internal.ResolveTransactionsFlow;
import net.corda.core.internal.TransactionsResolver;
import net.corda.core.internal.notary.NotaryService;
import net.corda.core.messaging.CordaRPCOps;
import net.corda.core.messaging.MessageRecipients;
import net.corda.core.messaging.RPCOps;
import net.corda.core.messaging.SingleMessageRecipient;
import net.corda.core.node.NetworkParameters;
import net.corda.core.node.NodeInfo;
import net.corda.core.node.NotaryInfo;
import net.corda.core.node.StatesToRecord;
import net.corda.core.node.services.ContractUpgradeService;
import net.corda.core.node.services.IdentityService;
import net.corda.core.node.services.KeyManagementService;
import net.corda.core.node.services.NetworkParametersService;
import net.corda.core.node.services.TransactionVerifierService;
import net.corda.core.node.services.diagnostics.DiagnosticsService;
import net.corda.core.serialization.SerializationWhitelist;
import net.corda.core.serialization.SerializeAsToken;
import net.corda.core.serialization.internal.AttachmentsClassLoaderCache;
import net.corda.core.transactions.FilteredTransaction;
import net.corda.core.transactions.SignedTransaction;
import net.corda.core.transactions.TransactionBuilder;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.core.utilities.NetworkHostAndPort;
import net.corda.coretesting.internal.TestThreadFactoryKt;
import net.corda.node.CordaClock;
import net.corda.node.VersionInfo;
import net.corda.node.internal.AbstractNode;
import net.corda.node.internal.FlowManager;
import net.corda.node.internal.FlowStarterImpl;
import net.corda.node.internal.InitiatedFlowFactory;
import net.corda.node.internal.cordapp.CordappProviderInternal;
import net.corda.node.services.api.AuditService;
import net.corda.node.services.api.MonitoringService;
import net.corda.node.services.api.NetworkMapCacheInternal;
import net.corda.node.services.api.NodePropertiesStore;
import net.corda.node.services.api.SchemaService;
import net.corda.node.services.api.StartedNodeServices;
import net.corda.node.services.api.StateMachineRecordedTransactionMappingStorage;
import net.corda.node.services.api.VaultServiceInternal;
import net.corda.node.services.api.WritableTransactionStorage;
import net.corda.node.services.config.NodeConfiguration;
import net.corda.node.services.config.NotaryConfig;
import net.corda.node.services.identity.PersistentIdentityService;
import net.corda.node.services.keys.BasicHSMKeyManagementService;
import net.corda.node.services.keys.KeyManagementServiceInternal;
import net.corda.node.services.messaging.MessagingService;
import net.corda.node.services.network.NetworkMapUpdater;
import net.corda.node.services.persistence.AttachmentStorageInternal;
import net.corda.node.services.persistence.NodeAttachmentService;
import net.corda.node.services.statemachine.ExternalEvent;
import net.corda.node.services.statemachine.FlowState;
import net.corda.node.services.statemachine.FlowStateMachineImpl;
import net.corda.node.services.statemachine.StateMachineManager;
import net.corda.node.utilities.AffinityExecutor;
import net.corda.node.utilities.BindableNamedCacheFactory;
import net.corda.node.utilities.DefaultNamedCacheFactory;
import net.corda.nodeapi.internal.DevIdentityGenerator;
import net.corda.nodeapi.internal.cryptoservice.SignOnlyCryptoService;
import net.corda.nodeapi.internal.network.NetworkParametersCopier;
import net.corda.nodeapi.internal.persistence.CordaPersistence;
import net.corda.testing.common.internal.ParametersUtilitiesKt;
import net.corda.testing.node.DatabaseSnapshot;
import net.corda.testing.node.InMemoryMessagingNetwork;
import net.corda.testing.node.MockNetworkNotarySpec;
import net.corda.testing.node.MockNetworkParameters;
import net.corda.testing.node.MockServices;
import net.corda.testing.node.TestClock;
import net.corda.testing.node.internal.DriverDSLImplKt;
import net.corda.testing.node.internal.InternalMockNetwork;
import net.corda.testing.node.internal.InternalMockNetworkKt;
import net.corda.testing.node.internal.InternalMockNodeParameters;
import net.corda.testing.node.internal.InternalTestUtilsKt;
import net.corda.testing.node.internal.MessagingServiceSpy;
import net.corda.testing.node.internal.MockNetworkParametersStorage;
import net.corda.testing.node.internal.MockNodeArgs;
import net.corda.testing.node.internal.MockNodeFlowManager;
import net.corda.testing.node.internal.MockNodeMessagingService;
import net.corda.testing.node.internal.TestCordappInternal;
import net.corda.testing.node.internal.TestStartedNode;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mockito.stubbing.Stubber;
import org.slf4j.Logger;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Func1;
import rx.internal.schedulers.CachedThreadScheduler;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u00db\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b*\u0001L\b\u0016\u0018\u0000 u2\u00020\u0001:\u0002uvB\u0091\u0001\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u0012\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u0012\b\b\u0002\u0010\u0019\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010S\u001a\u00020\u00152\u0006\u0010T\u001a\u00020UJ\b\u0010V\u001a\u00020\bH\u0002J\b\u0010W\u001a\u00020XH\u0002J\u000e\u0010Y\u001a\u00020\u000f2\u0006\u0010Z\u001a\u00020>J\u000e\u0010Y\u001a\u00020\u000f2\u0006\u0010[\u001a\u00020,J\b\u0010\\\u001a\u00020XH\u0016J\u0010\u0010]\u001a\u00020,2\b\b\u0002\u0010^\u001a\u00020_J$\u0010]\u001a\u00020,2\b\b\u0002\u0010^\u001a\u00020_2\u0012\u0010`\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013J,\u0010a\u001a\u00020\u00152\u0006\u0010^\u001a\u00020_2\u0012\u0010`\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010b\u001a\u00020\bH\u0002J\u0013\u0010c\u001a\b\u0012\u0004\u0012\u00020,0\u0003H\u0010\u00a2\u0006\u0002\bdJ\u0014\u0010e\u001a\u00020,2\n\b\u0002\u0010f\u001a\u0004\u0018\u00010gH\u0007J\u0010\u0010h\u001a\u00020\u00152\b\b\u0002\u0010^\u001a\u00020_J$\u0010h\u001a\u00020\u00152\b\b\u0002\u0010^\u001a\u00020_2\u0012\u0010`\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013J\u000e\u0010i\u001a\b\u0012\u0004\u0012\u00020j0\u0003H\u0002J\u0010\u0010k\u001a\u00020l2\u0006\u0010m\u001a\u00020>H\u0002J\b\u0010n\u001a\u00020\bH\u0002J.\u0010o\u001a\u00020,2\u0006\u0010[\u001a\u00020,2\b\b\u0002\u0010^\u001a\u00020_2\u0014\b\u0002\u0010`\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013J\u0012\u0010p\u001a\u00020X2\b\b\u0002\u0010q\u001a\u00020>H\u0007J\u0006\u0010r\u001a\u00020XJ\u0006\u0010s\u001a\u00020XJ\u0006\u0010t\u001a\u00020XR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00180\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u000200\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00106\u001a\u00020\u00112\u0006\u00105\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u000e\u0010;\u001a\u00020<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\u001eR$\u0010?\u001a\u00020>2\u0006\u00105\u001a\u00020>@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u0017\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00150\u00038F\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u0017\u0010G\u001a\b\u0012\u0004\u0012\u00020,0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010FR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010FR\u000e\u0010J\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010K\u001a\u00020LX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010MR\u000e\u0010N\u001a\u00020OX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u0010QR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010\u001e\u00a8\u0006w"}, d2={"Lnet/corda/testing/node/internal/InternalMockNetwork;", "Ljava/lang/AutoCloseable;", "cordappPackages", "", "", "defaultParameters", "Lnet/corda/testing/node/MockNetworkParameters;", "networkSendManuallyPumped", "", "threadPerNode", "servicePeerAllocationStrategy", "Lnet/corda/testing/node/InMemoryMessagingNetwork$ServicePeerAllocationStrategy;", "notarySpecs", "Lnet/corda/testing/node/MockNetworkNotarySpec;", "testDirectory", "Ljava/nio/file/Path;", "initialNetworkParameters", "Lnet/corda/core/node/NetworkParameters;", "defaultFactory", "Lkotlin/Function1;", "Lnet/corda/testing/node/internal/MockNodeArgs;", "Lnet/corda/testing/node/internal/InternalMockNetwork$MockNode;", "cordappsForAllNodes", "", "Lnet/corda/testing/node/internal/TestCordappInternal;", "autoVisibleNodes", "(Ljava/util/List;Lnet/corda/testing/node/MockNetworkParameters;ZZLnet/corda/testing/node/InMemoryMessagingNetwork$ServicePeerAllocationStrategy;Ljava/util/List;Ljava/nio/file/Path;Lnet/corda/core/node/NetworkParameters;Lkotlin/jvm/functions/Function1;Ljava/util/Collection;Z)V", "_nodes", "", "getAutoVisibleNodes", "()Z", "busyLatch", "Lorg/apache/activemq/artemis/utils/ReusableLatch;", "combinedCordappsForAllNodes", "", "cordappClassLoader", "Ljava/net/URLClassLoader;", "getDefaultFactory", "()Lkotlin/jvm/functions/Function1;", "defaultNotaryIdentity", "Lnet/corda/core/identity/Party;", "getDefaultNotaryIdentity", "()Lnet/corda/core/identity/Party;", "defaultNotaryNode", "Lnet/corda/testing/node/internal/TestStartedNode;", "getDefaultNotaryNode", "()Lnet/corda/testing/node/internal/TestStartedNode;", "messagingNetwork", "Lnet/corda/testing/node/InMemoryMessagingNetwork;", "getMessagingNetwork", "()Lnet/corda/testing/node/InMemoryMessagingNetwork;", "networkId", "", "<set-?>", "networkParameters", "getNetworkParameters", "()Lnet/corda/core/node/NetworkParameters;", "setNetworkParameters", "(Lnet/corda/core/node/NetworkParameters;)V", "networkParametersCopier", "Lnet/corda/nodeapi/internal/network/NetworkParametersCopier;", "getNetworkSendManuallyPumped", "", "nextNodeId", "getNextNodeId", "()I", "setNextNodeId", "(I)V", "nodes", "getNodes", "()Ljava/util/List;", "notaryNodes", "getNotaryNodes", "getNotarySpecs", "serializationEnv", "sharedServerThread", "net/corda/testing/node/internal/InternalMockNetwork$sharedServerThread$1", "Lnet/corda/testing/node/internal/InternalMockNetwork$sharedServerThread$1;", "sharedUserCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "getTestDirectory", "()Ljava/nio/file/Path;", "getThreadPerNode", "addressToNode", "msgRecipient", "Lnet/corda/core/messaging/MessageRecipients;", "anyFlowsSuspendedOnAsyncOperation", "awaitAsyncOperations", "", "baseDirectory", "nodeId", "node", "close", "createNode", "parameters", "Lnet/corda/testing/node/internal/InternalMockNodeParameters;", "nodeFactory", "createNodeImpl", "start", "createNotaries", "createNotaries$node_driver", "createPartyNode", "legalName", "Lnet/corda/core/identity/CordaX500Name;", "createUnstartedNode", "generateNotaryIdentities", "Lnet/corda/core/node/NotaryInfo;", "getServerThread", "Lnet/corda/node/utilities/AffinityExecutor$ServiceAffinityExecutor;", "id", "pumpAll", "restartNode", "runNetwork", "rounds", "startNodes", "stopNodes", "waitQuiescent", "Companion", "MockNode", "node-driver"})
public class InternalMockNetwork
implements AutoCloseable {
    @NotNull
    private NetworkParameters networkParameters;
    private int nextNodeId;
    private final ReusableLatch busyLatch;
    @NotNull
    private final InMemoryMessagingNetwork messagingNetwork;
    private final long networkId;
    private final NetworkParametersCopier networkParametersCopier;
    private final List<MockNode> _nodes;
    private final AtomicInteger sharedUserCount;
    private final Set<TestCordappInternal> combinedCordappsForAllNodes;
    private final URLClassLoader cordappClassLoader;
    private final AutoCloseable serializationEnv;
    @NotNull
    private final List<TestStartedNode> notaryNodes;
    private final sharedServerThread.1 sharedServerThread;
    private final boolean networkSendManuallyPumped;
    private final boolean threadPerNode;
    @NotNull
    private final List<MockNetworkNotarySpec> notarySpecs;
    @NotNull
    private final Path testDirectory;
    @NotNull
    private final Function1<MockNodeArgs, MockNode> defaultFactory;
    private final boolean autoVisibleNodes;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final NetworkParameters getNetworkParameters() {
        return this.networkParameters;
    }

    private final void setNetworkParameters(NetworkParameters networkParameters) {
        this.networkParameters = networkParameters;
    }

    public final int getNextNodeId() {
        return this.nextNodeId;
    }

    private final void setNextNodeId(int n) {
        this.nextNodeId = n;
    }

    @NotNull
    public final InMemoryMessagingNetwork getMessagingNetwork() {
        return this.messagingNetwork;
    }

    @NotNull
    public final List<MockNode> getNodes() {
        return this._nodes;
    }

    @NotNull
    public final List<TestStartedNode> getNotaryNodes() {
        return this.notaryNodes;
    }

    @NotNull
    public final TestStartedNode getDefaultNotaryNode() {
        switch (this.notaryNodes.size()) {
            case 0: {
                throw (Throwable)new IllegalStateException("There are no notaries defined on the network");
            }
            case 1: {
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("There is more than one notary defined on the network");
            }
        }
        return this.notaryNodes.get(0);
    }

    @NotNull
    public final Party getDefaultNotaryIdentity() {
        Party party = (Party)CollectionsKt.singleOrNull((List)this.getDefaultNotaryNode().getInfo().getLegalIdentities());
        if (party == null) {
            throw (Throwable)new IllegalStateException("Default notary has multiple identities");
        }
        return party;
    }

    /*
     * WARNING - void declaration
     */
    private final List<NotaryInfo> generateNotaryIdentities() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.notarySpecs;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            void index;
            void $name_validating;
            int n = index$iv$iv++;
            MockNetworkNotarySpec mockNetworkNotarySpec = (MockNetworkNotarySpec)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            CordaX500Name name = $name_validating.component1();
            boolean validating = $name_validating.component2();
            Party identity = DevIdentityGenerator.INSTANCE.installKeyStoreWithNodeIdentity(this.baseDirectory(this.nextNodeId + index), name);
            NotaryInfo notaryInfo = new NotaryInfo(identity, validating);
            collection.add(notaryInfo);
        }
        return (List)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<TestStartedNode> createNotaries$node_driver() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.notarySpecs;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void spec;
            MockNetworkNotarySpec mockNetworkNotarySpec = (MockNetworkNotarySpec)item$iv$iv;
            Collection collection = destination$iv$iv;
            TestStartedNode testStartedNode = this.createNode(new InternalMockNodeParameters(null, spec.getName(), null, (Function1)new Function1<NodeConfiguration, NotaryConfig>((MockNetworkNotarySpec)spec){
                final /* synthetic */ MockNetworkNotarySpec $spec;

                @Nullable
                public final NotaryConfig invoke(@NotNull NodeConfiguration it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return ((NodeConfiguration)StubberKt.whenever((Stubber)MockitoKt.doReturn((Object)new NotaryConfig(this.$spec.getValidating(), null, this.$spec.getClassName(), 0, null, null, null, 122, null)), (Object)it)).getNotary();
                }
                {
                    this.$spec = mockNetworkNotarySpec;
                    super(1);
                }
            }, null, null, null, 117, null));
            collection.add(testStartedNode);
        }
        return (List)var3_3;
    }

    private final AffinityExecutor.ServiceAffinityExecutor getServerThread(int id) {
        AffinityExecutor.ServiceAffinityExecutor serviceAffinityExecutor;
        if (this.threadPerNode) {
            serviceAffinityExecutor = new AffinityExecutor.ServiceAffinityExecutor("Mock node " + id + " thread", 1);
        } else {
            this.sharedUserCount.incrementAndGet();
            serviceAffinityExecutor = this.sharedServerThread;
        }
        return serviceAffinityExecutor;
    }

    @NotNull
    public final MockNode createUnstartedNode(@NotNull InternalMockNodeParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        return this.createUnstartedNode(parameters, this.defaultFactory);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ MockNode createUnstartedNode$default(InternalMockNetwork internalMockNetwork, InternalMockNodeParameters internalMockNodeParameters, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createUnstartedNode");
        }
        if ((n & 1) != 0) {
            internalMockNodeParameters = new InternalMockNodeParameters(null, null, null, null, null, null, null, 127, null);
        }
        return internalMockNetwork.createUnstartedNode(internalMockNodeParameters);
    }

    @NotNull
    public final MockNode createUnstartedNode(@NotNull InternalMockNodeParameters parameters, @NotNull Function1<? super MockNodeArgs, ? extends MockNode> nodeFactory) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull(nodeFactory, (String)"nodeFactory");
        return this.createNodeImpl(parameters, nodeFactory, false);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ MockNode createUnstartedNode$default(InternalMockNetwork internalMockNetwork, InternalMockNodeParameters internalMockNodeParameters, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createUnstartedNode");
        }
        if ((n & 1) != 0) {
            internalMockNodeParameters = new InternalMockNodeParameters(null, null, null, null, null, null, null, 127, null);
        }
        return internalMockNetwork.createUnstartedNode(internalMockNodeParameters, (Function1<? super MockNodeArgs, ? extends MockNode>)function1);
    }

    @NotNull
    public final TestStartedNode createNode(@NotNull InternalMockNodeParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        return this.createNode(parameters, this.defaultFactory);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ TestStartedNode createNode$default(InternalMockNetwork internalMockNetwork, InternalMockNodeParameters internalMockNodeParameters, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createNode");
        }
        if ((n & 1) != 0) {
            internalMockNodeParameters = new InternalMockNodeParameters(null, null, null, null, null, null, null, 127, null);
        }
        return internalMockNetwork.createNode(internalMockNodeParameters);
    }

    @NotNull
    public final TestStartedNode createNode(@NotNull InternalMockNodeParameters parameters, @NotNull Function1<? super MockNodeArgs, ? extends MockNode> nodeFactory) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull(nodeFactory, (String)"nodeFactory");
        Object object = InternalUtils.uncheckedCast((Object)this.createNodeImpl(parameters, nodeFactory, true).getStarted());
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (TestStartedNode)object;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ TestStartedNode createNode$default(InternalMockNetwork internalMockNetwork, InternalMockNodeParameters internalMockNodeParameters, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createNode");
        }
        if ((n & 1) != 0) {
            internalMockNodeParameters = new InternalMockNodeParameters(null, null, null, null, null, null, null, 127, null);
        }
        return internalMockNetwork.createNode(internalMockNodeParameters, (Function1<? super MockNodeArgs, ? extends MockNode>)function1);
    }

    private final MockNode createNodeImpl(InternalMockNodeParameters parameters, Function1<? super MockNodeArgs, ? extends MockNode> nodeFactory, boolean start2) {
        NodeConfiguration nodeConfiguration;
        int n;
        Integer n2 = parameters.getForcedID();
        if (n2 != null) {
            n = n2;
        } else {
            int n3 = this.nextNodeId;
            this.nextNodeId = n3 + 1;
            n = n3;
        }
        int id = n;
        Path baseDirectory = this.baseDirectory(id);
        Path certificatesDirectory = PathUtilsKt.div((Path)baseDirectory, (String)"certificates");
        PathUtilsKt.createDirectories((Path)certificatesDirectory, (FileAttribute[])new FileAttribute[0]);
        NodeConfiguration it = nodeConfiguration = InternalMockNetworkKt.access$mockNodeConfiguration(certificatesDirectory);
        ((NodeConfiguration)StubberKt.whenever((Stubber)MockitoKt.doReturn((Object)baseDirectory), (Object)it)).getBaseDirectory();
        ((NodeConfiguration)StubberKt.whenever((Stubber)MockitoKt.doReturn((Object)baseDirectory), (Object)it)).getNetworkParametersPath();
        CordaX500Name cordaX500Name = parameters.getLegalName();
        if (cordaX500Name == null) {
            cordaX500Name = new CordaX500Name("Mock Company " + id, "London", "GB");
        }
        ((NodeConfiguration)StubberKt.whenever((Stubber)MockitoKt.doReturn((Object)cordaX500Name), (Object)it)).getMyLegalName();
        ((NodeConfiguration)StubberKt.whenever((Stubber)MockitoKt.doReturn((Object)MockServices.Companion.makeTestDataSourceProperties("node_" + id + "_net_" + this.networkId)), (Object)it)).getDataSourceProperties();
        ((NodeConfiguration)StubberKt.whenever((Stubber)MockitoKt.doReturn((Object)CollectionsKt.emptyList()), (Object)it)).getExtraNetworkMapKeys();
        ((NodeConfiguration)StubberKt.whenever((Stubber)MockitoKt.doReturn((Object)CollectionsKt.listOf((Object)PathUtilsKt.div((Path)baseDirectory, (String)"cordapps"))), (Object)it)).getCordappDirectories();
        ((NodeConfiguration)StubberKt.whenever((Stubber)MockitoKt.doReturn((Object)CollectionsKt.emptyList()), (Object)it)).getQuasarExcludePackages();
        parameters.getConfigOverrides().invoke((Object)it);
        NodeConfiguration config2 = nodeConfiguration;
        TestCordappInternal.Companion.installCordapps(baseDirectory, CollectionsKt.toSet((Iterable)parameters.getAdditionalCordapps()), this.combinedCordappsForAllNodes);
        MockNode node = (MockNode)((Object)nodeFactory.invoke((Object)new MockNodeArgs(config2, this, id, parameters.getEntropyRoot(), parameters.getVersion(), parameters.getFlowManager())));
        Collection collection = this._nodes;
        collection.add(node);
        if (start2) {
            node.start();
        }
        return node;
    }

    @NotNull
    public final TestStartedNode restartNode(@NotNull TestStartedNode node, @NotNull InternalMockNodeParameters parameters, @NotNull Function1<? super MockNodeArgs, ? extends MockNode> nodeFactory) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull(nodeFactory, (String)"nodeFactory");
        node.getInternals().disableDBCloseOnStop();
        node.dispose();
        MockNodeFlowManager mockNodeFlowManager = null;
        Collection collection = null;
        VersionInfo versionInfo = null;
        Function1 function1 = null;
        BigInteger bigInteger = null;
        Integer n = node.getInternals().getId();
        CordaX500Name cordaX500Name = node.getInternals().getConfiguration().getMyLegalName();
        return this.createNode(InternalMockNodeParameters.copy$default(parameters, n, cordaX500Name, bigInteger, function1, versionInfo, collection, mockNodeFlowManager, 124, null), nodeFactory);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ TestStartedNode restartNode$default(InternalMockNetwork internalMockNetwork, TestStartedNode testStartedNode, InternalMockNodeParameters internalMockNodeParameters, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: restartNode");
        }
        if ((n & 2) != 0) {
            internalMockNodeParameters = new InternalMockNodeParameters(null, null, null, null, null, null, null, 127, null);
        }
        if ((n & 4) != 0) {
            function1 = internalMockNetwork.defaultFactory;
        }
        return internalMockNetwork.restartNode(testStartedNode, internalMockNodeParameters, function1);
    }

    @NotNull
    public final Path baseDirectory(@NotNull TestStartedNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return this.baseDirectory(node.getInternals().getId());
    }

    @NotNull
    public final Path baseDirectory(int nodeId) {
        return PathUtilsKt.div((Path)this.testDirectory, (String)("nodes/" + nodeId));
    }

    @JvmOverloads
    public final void runNetwork(int rounds) {
        int n;
        int n2 = n = !this.networkSendManuallyPumped ? 1 : 0;
        if (n == 0) {
            String string = "MockNetwork.runNetwork() should only be used when networkSendManuallyPumped == false. You can use MockNetwork.waitQuiescent() to wait for all the nodes to process all the messages on their queues instead.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (rounds == -1) {
            do {
                this.awaitAsyncOperations();
            } while (this.pumpAll());
        } else {
            n = 0;
            int n3 = rounds;
            while (n < n3) {
                int it = n++;
                this.pumpAll();
            }
        }
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void runNetwork$default(InternalMockNetwork internalMockNetwork, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: runNetwork");
        }
        if ((n2 & 1) != 0) {
            n = -1;
        }
        internalMockNetwork.runNetwork(n);
    }

    @JvmOverloads
    public final void runNetwork() {
        InternalMockNetwork.runNetwork$default(this, 0, 1, null);
    }

    private final boolean pumpAll() {
        boolean bl;
        block5: {
            MockNodeMessagingService it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv = this.messagingNetwork.getEndpoints$node_driver();
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (MockNodeMessagingService)((Object)element$iv$iv);
                if (!it.getActive()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (MockNodeMessagingService)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                InMemoryMessagingNetwork.MessageTransfer messageTransfer = it.pumpReceive(false);
                collection.add(messageTransfer);
            }
            List transferredMessages = (List)destination$iv$iv;
            $receiver$iv = transferredMessages;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    InMemoryMessagingNetwork.MessageTransfer it2 = (InMemoryMessagingNetwork.MessageTransfer)element$iv;
                    if (!(it2 != null)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void awaitAsyncOperations() {
        while (this.anyFlowsSuspendedOnAsyncOperation()) {
            Thread.sleep(50L);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean anyFlowsSuspendedOnAsyncOperation() {
        boolean bl;
        block4: {
            void $receiver$iv$iv;
            List<MockNode> allNodes = this._nodes;
            Iterable $receiver$iv = allNodes;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                MockNode it = (MockNode)((Object)element$iv$iv);
                Iterable list$iv$iv = it.getSmm().snapshot();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List allActiveFlows = (List)destination$iv$iv;
            $receiver$iv = allActiveFlows;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    FlowIORequest flowIORequest;
                    FlowStateMachineImpl it = (FlowStateMachineImpl)element$iv;
                    FlowState flowState = it.snapshot().getCheckpoint().getFlowState();
                    boolean bl2 = flowState instanceof FlowState.Started && ((flowIORequest = ((FlowState.Started)flowState).getFlowIORequest()) instanceof FlowIORequest.ExecuteAsyncOperation ? true : flowIORequest instanceof FlowIORequest.Sleep);
                    if (!bl2) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmOverloads
    @NotNull
    public final TestStartedNode createPartyNode(@Nullable CordaX500Name legalName) {
        return this.createNode(new InternalMockNodeParameters(null, legalName, null, null, null, null, null, 125, null));
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ TestStartedNode createPartyNode$default(InternalMockNetwork internalMockNetwork, CordaX500Name cordaX500Name, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createPartyNode");
        }
        if ((n & 1) != 0) {
            cordaX500Name = null;
        }
        return internalMockNetwork.createPartyNode(cordaX500Name);
    }

    @JvmOverloads
    @NotNull
    public final TestStartedNode createPartyNode() {
        return InternalMockNetwork.createPartyNode$default(this, null, 1, null);
    }

    @NotNull
    public final MockNode addressToNode(@NotNull MessageRecipients msgRecipient) {
        MockNode mockNode;
        Intrinsics.checkParameterIsNotNull((Object)msgRecipient, (String)"msgRecipient");
        MessageRecipients messageRecipients = msgRecipient;
        if (messageRecipients instanceof SingleMessageRecipient) {
            Iterable $receiver$iv = this.getNodes();
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $receiver$iv) {
                MockNode it = (MockNode)((Object)element$iv);
                TestStartedNode testStartedNode = it.getStarted();
                if (testStartedNode == null) {
                    Intrinsics.throwNpe();
                }
                if (!Intrinsics.areEqual((Object)testStartedNode.getNetwork().getMyAddress(), (Object)msgRecipient)) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            mockNode = single$iv;
        } else if (messageRecipients instanceof InMemoryMessagingNetwork.DistributedServiceHandle) {
            Object v3;
            block11: {
                Iterable $receiver$iv = this.getNodes();
                for (Object element$iv : $receiver$iv) {
                    MockNode it = (MockNode)((Object)element$iv);
                    TestStartedNode testStartedNode = it.getStarted();
                    if (testStartedNode == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!testStartedNode.getInfo().isLegalIdentity(((InMemoryMessagingNetwork.DistributedServiceHandle)msgRecipient).getParty())) continue;
                    v3 = element$iv;
                    break block11;
                }
                v3 = null;
            }
            if ((mockNode = (MockNode)v3) == null) {
                throw (Throwable)new IllegalArgumentException("Couldn't find node advertising service with owning party name: " + ((InMemoryMessagingNetwork.DistributedServiceHandle)msgRecipient).getParty().getName() + ' ');
            }
        } else {
            throw (Throwable)new IllegalArgumentException("Method not implemented for different type of message recipients");
        }
        return mockNode;
    }

    public final void startNodes() {
        boolean bl;
        Collection collection = this.getNodes();
        boolean bl2 = bl = !collection.isEmpty();
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Iterable $receiver$iv = this.getNodes();
        for (Object element$iv : $receiver$iv) {
            MockNode it = (MockNode)((Object)element$iv);
            TestStartedNode testStartedNode = it.getStarted();
            if (testStartedNode != null) continue;
            testStartedNode = it.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopNodes() {
        Closeable closeable = this.cordappClassLoader;
        Throwable throwable = null;
        try {
            URLClassLoader $noName_0 = (URLClassLoader)closeable;
            AutoCloseable autoCloseable = this.serializationEnv;
            Throwable throwable2 = null;
            try {
                AutoCloseable it = autoCloseable;
                Iterable $receiver$iv = this.getNodes();
                for (Object element$iv : $receiver$iv) {
                    MockNode node = (MockNode)((Object)element$iv);
                    TestStartedNode testStartedNode = node.getStarted();
                    if (testStartedNode != null) {
                        testStartedNode.dispose();
                    }
                    Path path = DatabaseSnapshot.INSTANCE.databaseFilename(node.getConfiguration().getBaseDirectory());
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"DatabaseSnapshot.databas\u2026figuration.baseDirectory)");
                    PathUtilsKt.deleteIfExists((Path)path);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
            }
            this.messagingNetwork.stop();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void waitQuiescent() {
        this.busyLatch.await(30000L);
    }

    @Override
    public void close() {
        this.stopNodes();
    }

    public final boolean getNetworkSendManuallyPumped() {
        return this.networkSendManuallyPumped;
    }

    public final boolean getThreadPerNode() {
        return this.threadPerNode;
    }

    @NotNull
    public final List<MockNetworkNotarySpec> getNotarySpecs() {
        return this.notarySpecs;
    }

    @NotNull
    public final Path getTestDirectory() {
        return this.testDirectory;
    }

    @NotNull
    public final Function1<MockNodeArgs, MockNode> getDefaultFactory() {
        return this.defaultFactory;
    }

    public final boolean getAutoVisibleNodes() {
        return this.autoVisibleNodes;
    }

    public InternalMockNetwork(@NotNull List<String> cordappPackages, @NotNull MockNetworkParameters defaultParameters, boolean networkSendManuallyPumped, boolean threadPerNode, @NotNull InMemoryMessagingNetwork.ServicePeerAllocationStrategy servicePeerAllocationStrategy, @NotNull List<MockNetworkNotarySpec> notarySpecs, @NotNull Path testDirectory, @NotNull NetworkParameters initialNetworkParameters, @NotNull Function1<? super MockNodeArgs, ? extends MockNode> defaultFactory, @NotNull Collection<? extends TestCordappInternal> cordappsForAllNodes, boolean autoVisibleNodes) {
        Intrinsics.checkParameterIsNotNull(cordappPackages, (String)"cordappPackages");
        Intrinsics.checkParameterIsNotNull((Object)defaultParameters, (String)"defaultParameters");
        Intrinsics.checkParameterIsNotNull((Object)servicePeerAllocationStrategy, (String)"servicePeerAllocationStrategy");
        Intrinsics.checkParameterIsNotNull(notarySpecs, (String)"notarySpecs");
        Intrinsics.checkParameterIsNotNull((Object)testDirectory, (String)"testDirectory");
        Intrinsics.checkParameterIsNotNull((Object)initialNetworkParameters, (String)"initialNetworkParameters");
        Intrinsics.checkParameterIsNotNull(defaultFactory, (String)"defaultFactory");
        Intrinsics.checkParameterIsNotNull(cordappsForAllNodes, (String)"cordappsForAllNodes");
        this.networkSendManuallyPumped = networkSendManuallyPumped;
        this.threadPerNode = threadPerNode;
        this.notarySpecs = notarySpecs;
        this.testDirectory = testDirectory;
        this.defaultFactory = defaultFactory;
        this.autoVisibleNodes = autoVisibleNodes;
        this.networkParameters = initialNetworkParameters;
        SecurityUtils.setAPrioriDisabledProvider((String)"BC", (boolean)true);
        boolean bl = initialNetworkParameters.getNotaries().isEmpty();
        if (!bl) {
            String string = "Define notaries using notarySpecs";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.busyLatch = new ReusableLatch();
        this.messagingNetwork = InMemoryMessagingNetwork.Companion.create$node_driver(this.networkSendManuallyPumped, servicePeerAllocationStrategy, this.busyLatch);
        this.networkId = CryptoUtils.random63BitValue();
        InternalMockNetwork internalMockNetwork = this;
        Object object = new ArrayList();
        internalMockNetwork._nodes = object;
        this.sharedUserCount = new AtomicInteger(0);
        this.combinedCordappsForAllNodes = SetsKt.plus(InternalTestUtilsKt.cordappsForPackages((Iterable<String>)cordappPackages), (Iterable)cordappsForAllNodes);
        this.cordappClassLoader = Companion.createCordappClassLoader((Collection<? extends TestCordappInternal>)this.combinedCordappsForAllNodes);
        AutoCloseable autoCloseable = InternalTestUtilsKt.setDriverSerialization(this.cordappClassLoader);
        internalMockNetwork = this;
        if (autoCloseable == null) {
            String string = "Using more than one mock network simultaneously is not supported.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        internalMockNetwork.serializationEnv = object = autoCloseable;
        this.sharedServerThread = new AffinityExecutor.ServiceAffinityExecutor(this, "Mock network", 1){
            final /* synthetic */ InternalMockNetwork this$0;

            public void shutdown() {
                if (InternalMockNetwork.access$getSharedUserCount$p(this.this$0).decrementAndGet() == 0) {
                    super.shutdown();
                }
            }

            public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
                if (!this.isShutdown()) {
                    this.flush();
                    bl = true;
                } else {
                    bl = super.awaitTermination(timeout, unit);
                }
                return bl;
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2);
            }
        };
        try {
            List<NotaryInfo> notaryInfos = this.generateNotaryIdentities();
            this.networkParameters = NetworkParameters.copy$default((NetworkParameters)initialNetworkParameters, (int)0, notaryInfos, (int)0, (int)0, null, (int)0, null, (int)125, null);
            this.networkParametersCopier = new NetworkParametersCopier(this.networkParameters, null, false, false, 14, null);
            this.notaryNodes = this.createNotaries$node_driver();
        }
        catch (Throwable t) {
            this.stopNodes();
            throw t;
        }
    }

    public /* synthetic */ InternalMockNetwork(List list, MockNetworkParameters mockNetworkParameters, boolean bl, boolean bl2, InMemoryMessagingNetwork.ServicePeerAllocationStrategy servicePeerAllocationStrategy, List list2, Path path, NetworkParameters networkParameters, Function1 function1, Collection collection, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            mockNetworkParameters = new MockNetworkParameters(false, false, null, null, null, null, 63, null);
        }
        if ((n & 4) != 0) {
            bl = mockNetworkParameters.getNetworkSendManuallyPumped();
        }
        if ((n & 8) != 0) {
            bl2 = mockNetworkParameters.getThreadPerNode();
        }
        if ((n & 0x10) != 0) {
            servicePeerAllocationStrategy = mockNetworkParameters.getServicePeerAllocationStrategy();
        }
        if ((n & 0x20) != 0) {
            list2 = mockNetworkParameters.getNotarySpecs();
        }
        if ((n & 0x40) != 0) {
            Path path2 = Paths.get("build", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(\"build\")");
            path = PathUtilsKt.div((Path)PathUtilsKt.div((Path)path2, (String)"mock-network"), (String)DriverDSLImplKt.getTimestampAsDirectoryName());
        }
        if ((n & 0x80) != 0) {
            networkParameters = ParametersUtilitiesKt.testNetworkParameters$default(null, (int)0, null, (int)0, (int)0, null, (int)0, null, null, (int)511, null);
        }
        if ((n & 0x100) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 0x200) != 0) {
            collection = SetsKt.emptySet();
        }
        if ((n & 0x400) != 0) {
            bl3 = true;
        }
        this(list, mockNetworkParameters, bl, bl2, servicePeerAllocationStrategy, list2, path, networkParameters, (Function1<? super MockNodeArgs, ? extends MockNode>)function1, collection, bl3);
    }

    public InternalMockNetwork() {
        this(null, null, false, false, null, null, null, null, null, null, false, 2047, null);
    }

    @NotNull
    public static final /* synthetic */ AtomicInteger access$getSharedUserCount$p(InternalMockNetwork $this) {
        return $this.sharedUserCount;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u00e2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002fgB!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0002H\u0002J(\u0010;\u001a\u00020\u00022\u0006\u0010<\u001a\u00020=2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020?012\b\u0010@\u001a\u0004\u0018\u00010AH\u0016J\u0006\u0010B\u001a\u000209J\u000e\u0010C\u001a\b\u0012\u0004\u0012\u00020E0DH\u0014J\u0010\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0014J\b\u0010J\u001a\u00020KH\u0014J\b\u0010L\u001a\u00020MH\u0014J\u0006\u0010N\u001a\u000209J\u000e\u0010O\u001a\b\u0012\u0004\u0012\u00020P01H\u0014JR\u0010Q\u001a\b\u0012\u0004\u0012\u0002HS0R\"\f\b\u0000\u0010S*\u0006\u0012\u0002\b\u00030T2\u0012\u0010U\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030T0V2\f\u0010W\u001a\b\u0012\u0004\u0012\u0002HS0V2\f\u0010X\u001a\b\u0012\u0004\u0012\u0002HS0Y2\u0006\u0010Z\u001a\u00020\bJ\u000e\u0010[\u001a\u0002092\u0006\u0010\\\u001a\u00020]J\b\u0010^\u001a\u00020\u0002H\u0016J\b\u0010_\u001a\u000209H\u0014J0\u0010`\u001a\u0002092\f\u0010>\u001a\b\u0012\u0004\u0012\u00020?012\u0006\u0010<\u001a\u00020=2\b\u0010a\u001a\u0004\u0018\u00010b2\u0006\u0010c\u001a\u00020dH\u0014J\b\u0010e\u001a\u000209H\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u0010\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u001e0\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0016R\u0014\u0010\"\u001a\u00020#8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020\bX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020\u000e018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0010R\u0016\u00103\u001a\u0004\u0018\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0014\u00106\u001a\u00020\u00148TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0016\u00a8\u0006h"}, d2={"Lnet/corda/testing/node/internal/InternalMockNetwork$MockNode;", "Lnet/corda/node/internal/AbstractNode;", "Lnet/corda/testing/node/internal/TestStartedNode;", "args", "Lnet/corda/testing/node/internal/MockNodeArgs;", "mockFlowManager", "Lnet/corda/testing/node/internal/MockNodeFlowManager;", "allowAppSchemaUpgradeWithCheckpoints", "", "(Lnet/corda/testing/node/internal/MockNodeArgs;Lnet/corda/testing/node/internal/MockNodeFlowManager;Z)V", "_rxIoScheduler", "Lrx/Scheduler;", "_serializationWhitelists", "", "Lnet/corda/core/serialization/SerializationWhitelist;", "get_serializationWhitelists", "()Ljava/util/List;", "_serializationWhitelists$delegate", "Lkotlin/Lazy;", "acceptableLiveFiberCountOnStop", "", "getAcceptableLiveFiberCountOnStop", "()I", "setAcceptableLiveFiberCountOnStop", "(I)V", "dbCloser", "Lkotlin/Function0;", "", "entropyCounter", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/math/BigInteger;", "kotlin.jvm.PlatformType", "id", "getId", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "mockNet", "Lnet/corda/testing/node/internal/InternalMockNetwork;", "getMockNet", "()Lnet/corda/testing/node/internal/InternalMockNetwork;", "runMigrationScripts", "getRunMigrationScripts", "()Z", "rxIoScheduler", "getRxIoScheduler", "()Lrx/Scheduler;", "serializationWhitelists", "", "getSerializationWhitelists", "started", "getStarted", "()Lnet/corda/testing/node/internal/TestStartedNode;", "transactionVerifierWorkerCount", "getTransactionVerifierWorkerCount", "advertiseNodeToNetwork", "", "newNode", "createStartedNode", "nodeInfo", "Lnet/corda/core/node/NodeInfo;", "rpcOps", "Lnet/corda/core/messaging/RPCOps;", "notaryService", "Lnet/corda/core/internal/notary/NotaryService;", "disableDBCloseOnStop", "initKeyStores", "", "Ljava/security/cert/X509Certificate;", "makeKeyManagementService", "Lnet/corda/node/services/keys/KeyManagementServiceInternal;", "identityService", "Lnet/corda/node/services/identity/PersistentIdentityService;", "makeMessagingService", "Lnet/corda/testing/node/internal/MockNodeMessagingService;", "makeNetworkParametersStorage", "Lnet/corda/core/internal/NetworkParametersStorage;", "manuallyCloseDB", "myAddresses", "Lnet/corda/core/utilities/NetworkHostAndPort;", "registerInitiatedFlowFactory", "Lrx/Observable;", "T", "Lnet/corda/core/flows/FlowLogic;", "initiatingFlowClass", "Ljava/lang/Class;", "initiatedFlowClass", "factory", "Lnet/corda/node/internal/InitiatedFlowFactory;", "track", "setMessagingServiceSpy", "spy", "Lnet/corda/testing/node/internal/MessagingServiceSpy;", "start", "startDatabase", "startMessagingService", "myNotaryIdentity", "Lnet/corda/core/identity/PartyAndCertificate;", "networkParameters", "Lnet/corda/core/node/NetworkParameters;", "startShell", "Companion", "TestStartedNodeImpl", "node-driver"})
    public static class MockNode
    extends AbstractNode<TestStartedNode> {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        private final boolean runMigrationScripts = true;
        @NotNull
        private final InternalMockNetwork mockNet;
        private final int id;
        private final AtomicReference<BigInteger> entropyCounter;
        private Scheduler _rxIoScheduler;
        private final Lazy _serializationWhitelists$delegate;
        private Function0<? extends Object> dbCloser;
        private int acceptableLiveFiberCountOnStop;
        private final MockNodeFlowManager mockFlowManager;
        private static final Logger staticLog;
        public static final Companion Companion;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MockNode.class), "_serializationWhitelists", "get_serializationWhitelists()Ljava/util/List;"))};
            Companion = new Companion(null);
            staticLog = KotlinUtilsKt.contextLogger((Object)Companion);
        }

        protected boolean getRunMigrationScripts() {
            return this.runMigrationScripts;
        }

        @NotNull
        public final InternalMockNetwork getMockNet() {
            return this.mockNet;
        }

        public final int getId() {
            return this.id;
        }

        @NotNull
        protected Logger getLog() {
            return staticLog;
        }

        protected int getTransactionVerifierWorkerCount() {
            return 1;
        }

        @NotNull
        protected Scheduler getRxIoScheduler() {
            Scheduler scheduler = this._rxIoScheduler;
            if (scheduler == null) {
                CachedThreadScheduler cachedThreadScheduler;
                CachedThreadScheduler it = cachedThreadScheduler = new CachedThreadScheduler(TestThreadFactoryKt.testThreadFactory$default((Object)((Object)this), (boolean)false, (int)1, null));
                Collection collection = this.getRunOnStop();
                Function0<Unit> function0 = new Function0<Unit>(it){

                    public final void invoke() {
                        ((CachedThreadScheduler)this.receiver).shutdown();
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(CachedThreadScheduler.class);
                    }

                    public final String getName() {
                        return "shutdown";
                    }

                    public final String getSignature() {
                        return "shutdown()V";
                    }
                };
                collection.add(function0);
                this._rxIoScheduler = (Scheduler)it;
                scheduler = (Scheduler)cachedThreadScheduler;
            }
            return scheduler;
        }

        @Nullable
        public TestStartedNode getStarted() {
            return (TestStartedNode)super.getStarted();
        }

        @NotNull
        public TestStartedNode createStartedNode(@NotNull NodeInfo nodeInfo, @NotNull List<? extends RPCOps> rpcOps, @Nullable NotaryService notaryService) {
            Intrinsics.checkParameterIsNotNull((Object)nodeInfo, (String)"nodeInfo");
            Intrinsics.checkParameterIsNotNull(rpcOps, (String)"rpcOps");
            MessagingService messagingService = this.getNetwork();
            if (messagingService == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.corda.testing.node.internal.MockNodeMessagingService");
            }
            return new TestStartedNodeImpl(this, this.getAttachments(), (MockNodeMessagingService)messagingService, new StartedNodeServices(this){
                private final /* synthetic */ AbstractNode.ServiceHubInternalImpl $$delegate_0;
                private final /* synthetic */ FlowStarterImpl $$delegate_1;
                final /* synthetic */ MockNode this$0;
                {
                    this.this$0 = $outer;
                    this.$$delegate_0 = $outer.getServices();
                    this.$$delegate_1 = $outer.getFlowStarter();
                }

                @NotNull
                public AttachmentTrustCalculator getAttachmentTrustCalculator() {
                    return this.$$delegate_0.getAttachmentTrustCalculator();
                }

                @NotNull
                public AttachmentStorageInternal getAttachments() {
                    return this.$$delegate_0.getAttachments();
                }

                @NotNull
                public AttachmentsClassLoaderCache getAttachmentsClassLoaderCache() {
                    return this.$$delegate_0.getAttachmentsClassLoaderCache();
                }

                @NotNull
                public AuditService getAuditService() {
                    return this.$$delegate_0.getAuditService();
                }

                @NotNull
                public NamedCacheFactory getCacheFactory() {
                    return this.$$delegate_0.getCacheFactory();
                }

                @NotNull
                public Clock getClock() {
                    return this.$$delegate_0.getClock();
                }

                @NotNull
                public NodeConfiguration getConfiguration() {
                    return this.$$delegate_0.getConfiguration();
                }

                @NotNull
                public ContractUpgradeService getContractUpgradeService() {
                    return this.$$delegate_0.getContractUpgradeService();
                }

                @NotNull
                public CordappProviderInternal getCordappProvider() {
                    return this.$$delegate_0.getCordappProvider();
                }

                @NotNull
                public CordaPersistence getDatabase() {
                    return this.$$delegate_0.getDatabase();
                }

                @NotNull
                public DiagnosticsService getDiagnosticsService() {
                    return this.$$delegate_0.getDiagnosticsService();
                }

                @NotNull
                public ExecutorService getExternalOperationExecutor() {
                    return this.$$delegate_0.getExternalOperationExecutor();
                }

                @NotNull
                public IdentityService getIdentityService() {
                    return this.$$delegate_0.getIdentityService();
                }

                @NotNull
                public KeyManagementService getKeyManagementService() {
                    return this.$$delegate_0.getKeyManagementService();
                }

                @NotNull
                public MonitoringService getMonitoringService() {
                    return this.$$delegate_0.getMonitoringService();
                }

                @NotNull
                public NodeInfo getMyInfo() {
                    return this.$$delegate_0.getMyInfo();
                }

                @NotNull
                public NetworkMapCacheInternal getNetworkMapCache() {
                    return this.$$delegate_0.getNetworkMapCache();
                }

                @NotNull
                public NetworkMapUpdater getNetworkMapUpdater() {
                    return this.$$delegate_0.getNetworkMapUpdater();
                }

                @NotNull
                public NetworkParameters getNetworkParameters() {
                    return this.$$delegate_0.getNetworkParameters();
                }

                @NotNull
                public NetworkParametersService getNetworkParametersService() {
                    return (NetworkParametersService)this.$$delegate_0.getNetworkParametersService();
                }

                @NotNull
                public MessagingService getNetworkService() {
                    return this.$$delegate_0.getNetworkService();
                }

                @NotNull
                public NodePropertiesStore getNodeProperties() {
                    return this.$$delegate_0.getNodeProperties();
                }

                @Nullable
                public NotaryService getNotaryService() {
                    return this.$$delegate_0.getNotaryService();
                }

                @NotNull
                public List<Class<? extends FlowLogic<?>>> getRpcFlows() {
                    return this.$$delegate_0.getRpcFlows();
                }

                @NotNull
                public SchemaService getSchemaService() {
                    return this.$$delegate_0.getSchemaService();
                }

                @NotNull
                public StateMachineRecordedTransactionMappingStorage getStateMachineRecordedTransactionMapping() {
                    return (StateMachineRecordedTransactionMappingStorage)this.$$delegate_0.getStateMachineRecordedTransactionMapping();
                }

                @NotNull
                public TransactionVerifierService getTransactionVerifierService() {
                    return this.$$delegate_0.getTransactionVerifierService();
                }

                @NotNull
                public WritableTransactionStorage getValidatedTransactions() {
                    return this.$$delegate_0.getValidatedTransactions();
                }

                @NotNull
                public VaultServiceInternal getVaultService() {
                    return this.$$delegate_0.getVaultService();
                }

                @NotNull
                public SignedTransaction addSignature(@NotNull SignedTransaction signedTransaction) {
                    Intrinsics.checkParameterIsNotNull((Object)signedTransaction, (String)"signedTransaction");
                    return this.$$delegate_0.addSignature(signedTransaction);
                }

                @NotNull
                public SignedTransaction addSignature(@NotNull SignedTransaction signedTransaction, @NotNull PublicKey publicKey) {
                    Intrinsics.checkParameterIsNotNull((Object)signedTransaction, (String)"signedTransaction");
                    Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
                    return this.$$delegate_0.addSignature(signedTransaction, publicKey);
                }

                @NotNull
                public <T extends SerializeAsToken> T cordaService(@NotNull Class<T> type) {
                    Intrinsics.checkParameterIsNotNull(type, (String)"type");
                    return (T)this.$$delegate_0.cordaService(type);
                }

                @NotNull
                public TransactionSignature createSignature(@NotNull FilteredTransaction filteredTransaction) {
                    Intrinsics.checkParameterIsNotNull((Object)filteredTransaction, (String)"filteredTransaction");
                    return this.$$delegate_0.createSignature(filteredTransaction);
                }

                @NotNull
                public TransactionSignature createSignature(@NotNull FilteredTransaction filteredTransaction, @NotNull PublicKey publicKey) {
                    Intrinsics.checkParameterIsNotNull((Object)filteredTransaction, (String)"filteredTransaction");
                    Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
                    return this.$$delegate_0.createSignature(filteredTransaction, publicKey);
                }

                @NotNull
                public TransactionSignature createSignature(@NotNull SignedTransaction signedTransaction) {
                    Intrinsics.checkParameterIsNotNull((Object)signedTransaction, (String)"signedTransaction");
                    return this.$$delegate_0.createSignature(signedTransaction);
                }

                @NotNull
                public TransactionSignature createSignature(@NotNull SignedTransaction signedTransaction, @NotNull PublicKey publicKey) {
                    Intrinsics.checkParameterIsNotNull((Object)signedTransaction, (String)"signedTransaction");
                    Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
                    return this.$$delegate_0.createSignature(signedTransaction, publicKey);
                }

                @NotNull
                public TransactionsResolver createTransactionsResolver(@NotNull ResolveTransactionsFlow flow) {
                    Intrinsics.checkParameterIsNotNull((Object)flow, (String)"flow");
                    return this.$$delegate_0.createTransactionsResolver(flow);
                }

                @NotNull
                public CordappContext getAppContext() {
                    return this.$$delegate_0.getAppContext();
                }

                @Nullable
                public InitiatedFlowFactory<?> getFlowFactory(@NotNull Class<? extends FlowLogic<?>> initiatingFlowClass) {
                    Intrinsics.checkParameterIsNotNull(initiatingFlowClass, (String)"initiatingFlowClass");
                    return this.$$delegate_0.getFlowFactory(initiatingFlowClass);
                }

                @NotNull
                public Connection jdbcSession() {
                    return this.$$delegate_0.jdbcSession();
                }

                @NotNull
                public Attachment loadContractAttachment(@NotNull StateRef stateRef) {
                    Intrinsics.checkParameterIsNotNull((Object)stateRef, (String)"stateRef");
                    return this.$$delegate_0.loadContractAttachment(stateRef);
                }

                @NotNull
                public TransactionState<?> loadState(@NotNull StateRef stateRef) {
                    Intrinsics.checkParameterIsNotNull((Object)stateRef, (String)"stateRef");
                    return this.$$delegate_0.loadState(stateRef);
                }

                @NotNull
                public Set<StateAndRef<ContractState>> loadStates(@NotNull Set<StateRef> stateRefs) {
                    Intrinsics.checkParameterIsNotNull(stateRefs, (String)"stateRefs");
                    return this.$$delegate_0.loadStates(stateRefs);
                }

                public void recordTransactions(boolean notifyVault, @NotNull Iterable<SignedTransaction> txs) {
                    Intrinsics.checkParameterIsNotNull(txs, (String)"txs");
                    this.$$delegate_0.recordTransactions(notifyVault, txs);
                }

                public void recordTransactions(boolean notifyVault, @NotNull SignedTransaction first, SignedTransaction ... remaining) {
                    Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
                    Intrinsics.checkParameterIsNotNull((Object)remaining, (String)"remaining");
                    this.$$delegate_0.recordTransactions(notifyVault, first, remaining);
                }

                public void recordTransactions(@NotNull Iterable<SignedTransaction> txs) {
                    Intrinsics.checkParameterIsNotNull(txs, (String)"txs");
                    this.$$delegate_0.recordTransactions(txs);
                }

                public void recordTransactions(@NotNull StatesToRecord statesToRecord, @NotNull Iterable<SignedTransaction> txs) {
                    Intrinsics.checkParameterIsNotNull((Object)statesToRecord, (String)"statesToRecord");
                    Intrinsics.checkParameterIsNotNull(txs, (String)"txs");
                    this.$$delegate_0.recordTransactions(statesToRecord, txs);
                }

                public void recordTransactions(@NotNull SignedTransaction first, SignedTransaction ... remaining) {
                    Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
                    Intrinsics.checkParameterIsNotNull((Object)remaining, (String)"remaining");
                    this.$$delegate_0.recordTransactions(first, remaining);
                }

                public void registerUnloadHandler(@NotNull Function0<Unit> runOnStop) {
                    Intrinsics.checkParameterIsNotNull(runOnStop, (String)"runOnStop");
                    this.$$delegate_0.registerUnloadHandler(runOnStop);
                }

                @NotNull
                public SignedTransaction signInitialTransaction(@NotNull TransactionBuilder builder) {
                    Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                    return this.$$delegate_0.signInitialTransaction(builder);
                }

                @NotNull
                public SignedTransaction signInitialTransaction(@NotNull TransactionBuilder builder, @NotNull PublicKey publicKey) {
                    Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                    Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
                    return this.$$delegate_0.signInitialTransaction(builder, publicKey);
                }

                @NotNull
                public SignedTransaction signInitialTransaction(@NotNull TransactionBuilder builder, @NotNull Iterable<? extends PublicKey> signingPubKeys) {
                    Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                    Intrinsics.checkParameterIsNotNull(signingPubKeys, (String)"signingPubKeys");
                    return this.$$delegate_0.signInitialTransaction(builder, signingPubKeys);
                }

                @NotNull
                public <T extends ContractState> StateAndRef<T> toStateAndRef(@NotNull StateRef stateRef) {
                    Intrinsics.checkParameterIsNotNull((Object)stateRef, (String)"stateRef");
                    return this.$$delegate_0.toStateAndRef(stateRef);
                }

                public void withEntityManager(@NotNull Consumer<EntityManager> block) {
                    Intrinsics.checkParameterIsNotNull(block, (String)"block");
                    this.$$delegate_0.withEntityManager(block);
                }

                public <T> T withEntityManager(@NotNull Function1<? super EntityManager, ? extends T> block) {
                    Intrinsics.checkParameterIsNotNull(block, (String)"block");
                    return (T)this.$$delegate_0.withEntityManager(block);
                }

                @NotNull
                public <T> CordaFuture<? extends FlowStateMachineHandle<T>> invokeFlowAsync(@NotNull Class<? extends FlowLogic<? extends T>> logicType, @NotNull InvocationContext context, Object ... args) {
                    Intrinsics.checkParameterIsNotNull(logicType, (String)"logicType");
                    Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                    Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
                    return this.$$delegate_1.invokeFlowAsync(logicType, context, args);
                }

                @NotNull
                public <T> CordaFuture<? extends FlowStateMachineHandle<T>> startFlow(@NotNull FlowLogic<? extends T> logic, @NotNull InvocationContext context) {
                    Intrinsics.checkParameterIsNotNull(logic, (String)"logic");
                    Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                    return this.$$delegate_1.startFlow(logic, context);
                }

                @NotNull
                public <T> CordaFuture<? extends FlowStateMachineHandle<T>> startFlow(@NotNull ExternalEvent.ExternalStartFlowEvent<T> event) {
                    Intrinsics.checkParameterIsNotNull(event, (String)"event");
                    return this.$$delegate_1.startFlow(event);
                }
            }, nodeInfo, this.getSmm(), this.getDatabase(), rpcOps, notaryService);
        }

        @NotNull
        public TestStartedNode start() {
            this.mockNet.networkParametersCopier.install(this.getConfiguration().getBaseDirectory());
            Object object = super.start();
            MockNode mockNode = this;
            TestStartedNode p1 = (TestStartedNode)object;
            mockNode.advertiseNodeToNetwork(p1);
            return (TestStartedNode)object;
        }

        /*
         * WARNING - void declaration
         */
        private final void advertiseNodeToNetwork(TestStartedNode newNode) {
            void $receiver$iv$iv;
            if (!this.mockNet.getAutoVisibleNodes()) {
                return;
            }
            Iterable $receiver$iv = this.mockNet.getNodes();
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                TestStartedNode testStartedNode;
                Object element$iv$iv = element$iv$iv$iv;
                MockNode it = (MockNode)((Object)element$iv$iv);
                if (it.getStarted() == null) continue;
                TestStartedNode it$iv$iv = testStartedNode;
                destination$iv$iv.add(it$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                TestStartedNode existingNode = (TestStartedNode)element$iv;
                newNode.getServices().getNetworkMapCache().addOrUpdateNode(existingNode.getInfo());
                existingNode.getServices().getNetworkMapCache().addOrUpdateNode(newNode.getInfo());
            }
        }

        @NotNull
        protected MockNodeMessagingService makeMessagingService() {
            return (MockNodeMessagingService)((Object)this.closeOnStop((AutoCloseable)((Object)new MockNodeMessagingService(this.getConfiguration(), (AffinityExecutor)this.getServerThread(), null, 4, null)), false));
        }

        protected void startMessagingService(@NotNull List<? extends RPCOps> rpcOps, @NotNull NodeInfo nodeInfo, @Nullable PartyAndCertificate myNotaryIdentity, @NotNull NetworkParameters networkParameters) {
            Intrinsics.checkParameterIsNotNull(rpcOps, (String)"rpcOps");
            Intrinsics.checkParameterIsNotNull((Object)nodeInfo, (String)"nodeInfo");
            Intrinsics.checkParameterIsNotNull((Object)networkParameters, (String)"networkParameters");
            MessagingService messagingService = this.getNetwork();
            if (messagingService == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.corda.testing.node.internal.MockNodeMessagingService");
            }
            ((MockNodeMessagingService)messagingService).start(this.mockNet.getMessagingNetwork(), !this.mockNet.getThreadPerNode(), this.id, myNotaryIdentity);
        }

        public final void setMessagingServiceSpy(@NotNull MessagingServiceSpy spy) {
            Intrinsics.checkParameterIsNotNull((Object)spy, (String)"spy");
            spy.set_messagingService$node_driver(this.getNetwork());
            MessagingService messagingService = this.getNetwork();
            if (messagingService == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.corda.testing.node.internal.MockNodeMessagingService");
            }
            ((MockNodeMessagingService)messagingService).setSpy(spy);
        }

        @NotNull
        protected KeyManagementServiceInternal makeKeyManagementService(@NotNull PersistentIdentityService identityService) {
            Intrinsics.checkParameterIsNotNull((Object)identityService, (String)"identityService");
            return (KeyManagementServiceInternal)new BasicHSMKeyManagementService((NamedCacheFactory)this.getCacheFactory(), identityService, this.getDatabase(), (SignOnlyCryptoService)this.getCryptoService());
        }

        public void startShell() {
        }

        @NotNull
        protected Set<X509Certificate> initKeyStores() {
            return this.getKeyStoreHandler().init(this.entropyCounter.updateAndGet(initKeyStores.1.INSTANCE));
        }

        @NotNull
        protected List<NetworkHostAndPort> myAddresses() {
            return CollectionsKt.listOf((Object)new NetworkHostAndPort("mock.node", 1000));
        }

        private final List<SerializationWhitelist> get_serializationWhitelists() {
            Lazy lazy = this._serializationWhitelists$delegate;
            MockNode mockNode = this;
            KProperty kProperty = $$delegatedProperties[0];
            return (List)lazy.getValue();
        }

        @NotNull
        public List<SerializationWhitelist> getSerializationWhitelists() {
            return this.get_serializationWhitelists();
        }

        protected void startDatabase() {
            super.startDatabase();
            this.dbCloser = (Function0)new Function0<Unit>(this.getDatabase()){

                public final void invoke() {
                    ((CordaPersistence)this.receiver).close();
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(CordaPersistence.class);
                }

                public final String getName() {
                    return "close";
                }

                public final String getSignature() {
                    return "close()V";
                }
            };
            Collection collection = this.getRunOnStop();
            Function0<? extends Object> function0 = this.dbCloser;
            if (function0 == null) {
                Intrinsics.throwNpe();
            }
            Function0<? extends Object> function02 = function0;
            collection.add(function02);
        }

        public final void disableDBCloseOnStop() {
            Collection collection = this.getRunOnStop();
            Function0<? extends Object> function0 = this.dbCloser;
            Collection collection2 = collection;
            if (collection2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
            }
            TypeIntrinsics.asMutableCollection((Object)collection2).remove(function0);
        }

        public final void manuallyCloseDB() {
            Function0<? extends Object> function0 = this.dbCloser;
            if (function0 != null) {
                function0.invoke();
            }
            this.dbCloser = null;
        }

        public final int getAcceptableLiveFiberCountOnStop() {
            return this.acceptableLiveFiberCountOnStop;
        }

        public final void setAcceptableLiveFiberCountOnStop(int n) {
            this.acceptableLiveFiberCountOnStop = n;
        }

        protected int acceptableLiveFiberCountOnStop() {
            return this.acceptableLiveFiberCountOnStop;
        }

        @NotNull
        public final <T extends FlowLogic<?>> Observable<T> registerInitiatedFlowFactory(@NotNull Class<? extends FlowLogic<?>> initiatingFlowClass, @NotNull Class<T> initiatedFlowClass, @NotNull InitiatedFlowFactory<? extends T> factory, boolean track) {
            Observable observable;
            Intrinsics.checkParameterIsNotNull(initiatingFlowClass, (String)"initiatingFlowClass");
            Intrinsics.checkParameterIsNotNull(initiatedFlowClass, (String)"initiatedFlowClass");
            Intrinsics.checkParameterIsNotNull(factory, (String)"factory");
            this.mockFlowManager.registerTestingFactory(initiatingFlowClass, factory);
            if (track) {
                Observable observable2 = this.getSmm().getChanges().filter((Func1)registerInitiatedFlowFactory.1.INSTANCE).map((Func1)registerInitiatedFlowFactory.2.INSTANCE).ofType(initiatedFlowClass);
                observable = observable2;
                Intrinsics.checkExpressionValueIsNotNull((Object)observable2, (String)"smm.changes.filter { it \u2026fType(initiatedFlowClass)");
            } else {
                Observable observable3 = Observable.empty();
                observable = observable3;
                Intrinsics.checkExpressionValueIsNotNull((Object)observable3, (String)"Observable.empty<T>()");
            }
            return observable;
        }

        @NotNull
        protected NetworkParametersStorage makeNetworkParametersStorage() {
            return new MockNetworkParametersStorage(null, 1, null);
        }

        public MockNode(@NotNull MockNodeArgs args, @NotNull MockNodeFlowManager mockFlowManager, boolean allowAppSchemaUpgradeWithCheckpoints) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            Intrinsics.checkParameterIsNotNull((Object)((Object)mockFlowManager), (String)"mockFlowManager");
            NodeConfiguration nodeConfiguration = args.getConfig();
            Clock clock = Clock.systemUTC();
            Intrinsics.checkExpressionValueIsNotNull((Object)clock, (String)"Clock.systemUTC()");
            super(nodeConfiguration, (CordaClock)new TestClock(clock), (BindableNamedCacheFactory)new DefaultNamedCacheFactory(), args.getVersion(), (FlowManager)mockFlowManager, args.getNetwork().getServerThread(args.getId()), args.getNetwork().busyLatch, null, null, true, allowAppSchemaUpgradeWithCheckpoints, 384, null);
            this.mockFlowManager = mockFlowManager;
            this.runMigrationScripts = true;
            this.mockNet = args.getNetwork();
            this.id = args.getId();
            boolean bl2 = bl = this.id >= 0;
            if (!bl) {
                String string = "Node ID must be zero or positive, was passed: " + this.id;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            this.entropyCounter = new AtomicReference<BigInteger>(args.getEntropyRoot());
            this._serializationWhitelists$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<SerializationWhitelist>>(this){
                final /* synthetic */ MockNode this$0;

                @NotNull
                public final List<SerializationWhitelist> invoke() {
                    return CollectionsKt.toMutableList((Collection)MockNode.access$getSerializationWhitelists$p$s-578360628(this.this$0));
                }
                {
                    this.this$0 = mockNode;
                    super(0);
                }
            }));
        }

        public /* synthetic */ MockNode(MockNodeArgs mockNodeArgs, MockNodeFlowManager mockNodeFlowManager, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                mockNodeFlowManager = mockNodeArgs.getFlowManager();
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            this(mockNodeArgs, mockNodeFlowManager, bl);
        }

        @NotNull
        public static final /* synthetic */ List access$getSerializationWhitelists$p$s-578360628(MockNode $this) {
            return super.getSerializationWhitelists();
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u0015J\b\u0010(\u001a\u00020)H\u0016J2\u0010*\u001a\b\u0012\u0004\u0012\u0002H,0+\"\f\b\u0000\u0010,*\u0006\u0012\u0002\b\u00030-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H,0/2\u0006\u00100\u001a\u000201H\u0016JF\u0010*\u001a\b\u0012\u0004\u0012\u0002H,0+\"\f\b\u0000\u0010,*\u0006\u0012\u0002\b\u00030-2\u0012\u00102\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030-0/2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H,0/2\u0006\u00100\u001a\u000201H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u00063"}, d2={"Lnet/corda/testing/node/internal/InternalMockNetwork$MockNode$TestStartedNodeImpl;", "Lnet/corda/testing/node/internal/TestStartedNode;", "internals", "Lnet/corda/testing/node/internal/InternalMockNetwork$MockNode;", "attachments", "Lnet/corda/node/services/persistence/NodeAttachmentService;", "network", "Lnet/corda/testing/node/internal/MockNodeMessagingService;", "services", "Lnet/corda/node/services/api/StartedNodeServices;", "info", "Lnet/corda/core/node/NodeInfo;", "smm", "Lnet/corda/node/services/statemachine/StateMachineManager;", "database", "Lnet/corda/nodeapi/internal/persistence/CordaPersistence;", "rpcOpsList", "", "Lnet/corda/core/messaging/RPCOps;", "notaryService", "Lnet/corda/core/internal/notary/NotaryService;", "(Lnet/corda/testing/node/internal/InternalMockNetwork$MockNode;Lnet/corda/node/services/persistence/NodeAttachmentService;Lnet/corda/testing/node/internal/MockNodeMessagingService;Lnet/corda/node/services/api/StartedNodeServices;Lnet/corda/core/node/NodeInfo;Lnet/corda/node/services/statemachine/StateMachineManager;Lnet/corda/nodeapi/internal/persistence/CordaPersistence;Ljava/util/List;Lnet/corda/core/internal/notary/NotaryService;)V", "getAttachments", "()Lnet/corda/node/services/persistence/NodeAttachmentService;", "getDatabase", "()Lnet/corda/nodeapi/internal/persistence/CordaPersistence;", "getInfo", "()Lnet/corda/core/node/NodeInfo;", "getInternals", "()Lnet/corda/testing/node/internal/InternalMockNetwork$MockNode;", "getNetwork", "()Lnet/corda/testing/node/internal/MockNodeMessagingService;", "getNotaryService", "()Lnet/corda/core/internal/notary/NotaryService;", "getRpcOpsList", "()Ljava/util/List;", "getServices", "()Lnet/corda/node/services/api/StartedNodeServices;", "getSmm", "()Lnet/corda/node/services/statemachine/StateMachineManager;", "dispose", "", "registerInitiatedFlow", "Lrx/Observable;", "T", "Lnet/corda/core/flows/FlowLogic;", "initiatedFlowClass", "Ljava/lang/Class;", "track", "", "initiatingFlowClass", "node-driver"})
        private static final class TestStartedNodeImpl
        implements TestStartedNode {
            @NotNull
            private final MockNode internals;
            @NotNull
            private final NodeAttachmentService attachments;
            @NotNull
            private final MockNodeMessagingService network;
            @NotNull
            private final StartedNodeServices services;
            @NotNull
            private final NodeInfo info;
            @NotNull
            private final StateMachineManager smm;
            @NotNull
            private final CordaPersistence database;
            @NotNull
            private final List<RPCOps> rpcOpsList;
            @Nullable
            private final NotaryService notaryService;

            @Override
            public void dispose() {
                this.getInternals().stop();
            }

            @Override
            @NotNull
            public <T extends FlowLogic<?>> Observable<T> registerInitiatedFlow(@NotNull Class<T> initiatedFlowClass, boolean track) {
                Intrinsics.checkParameterIsNotNull(initiatedFlowClass, (String)"initiatedFlowClass");
                this.getInternals().getFlowManager().registerInitiatedFlow(initiatedFlowClass);
                Observable observable = this.getSmm().getChanges().filter((Func1)registerInitiatedFlow.1.INSTANCE).map((Func1)registerInitiatedFlow.2.INSTANCE).ofType(initiatedFlowClass);
                Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"smm.changes.filter { it \u2026fType(initiatedFlowClass)");
                return observable;
            }

            @Override
            @NotNull
            public <T extends FlowLogic<?>> Observable<T> registerInitiatedFlow(@NotNull Class<? extends FlowLogic<?>> initiatingFlowClass, @NotNull Class<T> initiatedFlowClass, boolean track) {
                Intrinsics.checkParameterIsNotNull(initiatingFlowClass, (String)"initiatingFlowClass");
                Intrinsics.checkParameterIsNotNull(initiatedFlowClass, (String)"initiatedFlowClass");
                this.getInternals().getFlowManager().registerInitiatedFlow(initiatingFlowClass, initiatedFlowClass);
                Observable observable = this.getSmm().getChanges().filter((Func1)registerInitiatedFlow.3.INSTANCE).map((Func1)registerInitiatedFlow.4.INSTANCE).ofType(initiatedFlowClass);
                Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"smm.changes.filter { it \u2026fType(initiatedFlowClass)");
                return observable;
            }

            @Override
            @NotNull
            public MockNode getInternals() {
                return this.internals;
            }

            @Override
            @NotNull
            public NodeAttachmentService getAttachments() {
                return this.attachments;
            }

            @Override
            @NotNull
            public MockNodeMessagingService getNetwork() {
                return this.network;
            }

            @Override
            @NotNull
            public StartedNodeServices getServices() {
                return this.services;
            }

            @Override
            @NotNull
            public NodeInfo getInfo() {
                return this.info;
            }

            @Override
            @NotNull
            public StateMachineManager getSmm() {
                return this.smm;
            }

            @Override
            @NotNull
            public CordaPersistence getDatabase() {
                return this.database;
            }

            @Override
            @NotNull
            public List<RPCOps> getRpcOpsList() {
                return this.rpcOpsList;
            }

            @Override
            @Nullable
            public NotaryService getNotaryService() {
                return this.notaryService;
            }

            public TestStartedNodeImpl(@NotNull MockNode internals, @NotNull NodeAttachmentService attachments, @NotNull MockNodeMessagingService network, @NotNull StartedNodeServices services, @NotNull NodeInfo info, @NotNull StateMachineManager smm, @NotNull CordaPersistence database2, @NotNull List<? extends RPCOps> rpcOpsList, @Nullable NotaryService notaryService) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)internals), (String)"internals");
                Intrinsics.checkParameterIsNotNull((Object)attachments, (String)"attachments");
                Intrinsics.checkParameterIsNotNull((Object)((Object)network), (String)"network");
                Intrinsics.checkParameterIsNotNull((Object)services, (String)"services");
                Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                Intrinsics.checkParameterIsNotNull((Object)smm, (String)"smm");
                Intrinsics.checkParameterIsNotNull((Object)database2, (String)"database");
                Intrinsics.checkParameterIsNotNull(rpcOpsList, (String)"rpcOpsList");
                this.internals = internals;
                this.attachments = attachments;
                this.network = network;
                this.services = services;
                this.info = info;
                this.smm = smm;
                this.database = database2;
                this.rpcOpsList = rpcOpsList;
                this.notaryService = notaryService;
            }

            @Override
            @Nullable
            public InMemoryMessagingNetwork.MessageTransfer pumpReceive(boolean block) {
                return TestStartedNode.DefaultImpls.pumpReceive(this, block);
            }

            @Override
            public void setMessagingServiceSpy(@NotNull MessagingServiceSpy spy) {
                Intrinsics.checkParameterIsNotNull((Object)spy, (String)"spy");
                TestStartedNode.DefaultImpls.setMessagingServiceSpy(this, spy);
            }

            @Override
            @NotNull
            public CordaRPCOps getCordaRPCOps() {
                return TestStartedNode.DefaultImpls.getCordaRPCOps(this);
            }
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/testing/node/internal/InternalMockNetwork$MockNode$Companion;", "", "()V", "staticLog", "Lorg/slf4j/Logger;", "node-driver"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u00a8\u0006\b"}, d2={"Lnet/corda/testing/node/internal/InternalMockNetwork$Companion;", "", "()V", "createCordappClassLoader", "Ljava/net/URLClassLoader;", "cordapps", "", "Lnet/corda/testing/node/internal/TestCordappInternal;", "node-driver"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public final URLClassLoader createCordappClassLoader(@Nullable Collection<? extends TestCordappInternal> cordapps) {
            Collection<URL> collection;
            void $receiver$iv$iv;
            Collection $receiver$iv;
            URLClassLoader uRLClassLoader;
            if (cordapps == null || cordapps.isEmpty()) {
                return null;
            }
            Iterable iterable = cordapps;
            URLClassLoader uRLClassLoader2 = uRLClassLoader;
            URLClassLoader uRLClassLoader3 = uRLClassLoader;
            void var3_5 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                TestCordappInternal testCordappInternal = (TestCordappInternal)item$iv$iv;
                collection = destination$iv$iv;
                URL uRL = it.getJarFile().toUri().toURL();
                collection.add(uRL);
            }
            collection = (List)destination$iv$iv;
            Collection thisCollection$iv = $receiver$iv = (Collection)collection;
            URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
            if (uRLArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            collection = uRLArray;
            uRLClassLoader2((URL[])collection);
            return uRLClassLoader3;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

