/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.driver;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.corda.core.internal.InternalUtils;
import net.corda.core.internal.PathUtilsKt;
import net.corda.core.node.NetworkParameters;
import net.corda.testing.driver.Driver;
import net.corda.testing.driver.DriverDSL;
import net.corda.testing.driver.DriverParameters;
import net.corda.testing.driver.JmxPolicy;
import net.corda.testing.driver.NodeHandle;
import net.corda.testing.driver.PortAllocation;
import net.corda.testing.node.NotarySpec;
import net.corda.testing.node.internal.CompatibilityZoneParams;
import net.corda.testing.node.internal.DriverDSLImpl;
import net.corda.testing.node.internal.DriverDSLImplKt;
import net.corda.testing.node.internal.InternalDriverDSL;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00010\u0005\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\u0010\b\u001a\n\u0010\t\u001a\u00020\n*\u00020\u000b\u00a8\u0006\f"}, d2={"driver", "A", "defaultParameters", "Lnet/corda/testing/driver/DriverParameters;", "dsl", "Lkotlin/Function1;", "Lnet/corda/testing/driver/DriverDSL;", "Lkotlin/ExtensionFunctionType;", "(Lnet/corda/testing/driver/DriverParameters;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "logFile", "Ljava/io/File;", "Lnet/corda/testing/driver/NodeHandle;", "node-driver"})
@JvmName(name="Driver")
public final class Driver {
    @NotNull
    public static final File logFile(@NotNull NodeHandle $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        File file = PathUtilsKt.div((Path)$receiver.getBaseDirectory(), (String)"logs").toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"(baseDirectory / \"logs\").toFile()");
        return (File)SequencesKt.single((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)file, null, (int)1, null)), (Function1)logFile.1.INSTANCE));
    }

    public static final <A> A driver(@NotNull DriverParameters defaultParameters, @NotNull Function1<? super DriverDSL, ? extends A> dsl) {
        Intrinsics.checkParameterIsNotNull((Object)defaultParameters, (String)"defaultParameters");
        Intrinsics.checkParameterIsNotNull(dsl, (String)"dsl");
        PortAllocation portAllocation = defaultParameters.getPortAllocation();
        PortAllocation portAllocation2 = defaultParameters.getDebugPortAllocation();
        Map<String, String> map2 = defaultParameters.getSystemProperties();
        Path path = defaultParameters.getDriverDirectory().toAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"defaultParameters.driverDirectory.toAbsolutePath()");
        boolean bl = defaultParameters.getPremigrateH2Database();
        boolean bl2 = defaultParameters.getAllowHibernateToManageAppSchema();
        Map<String, String> map3 = defaultParameters.getEnvironmentVariables();
        List<Path> list = defaultParameters.getDjvmCordaSource();
        Path path2 = defaultParameters.getDjvmBootstrapSource();
        Collection collection = (Collection)InternalUtils.uncheckedCast(defaultParameters.getCordappsForAllNodes());
        boolean bl3 = defaultParameters.getInMemoryDB();
        Map<String, Object> map4 = defaultParameters.getNotaryCustomOverrides();
        NetworkParameters networkParameters = defaultParameters.getNetworkParameters();
        CompatibilityZoneParams compatibilityZoneParams = null;
        JmxPolicy jmxPolicy = defaultParameters.getJmxPolicy();
        List<NotarySpec> list2 = defaultParameters.getNotarySpecs();
        return DriverDSLImplKt.genericDriver((InternalDriverDSL)new DriverDSLImpl(portAllocation, portAllocation2, map2, path, defaultParameters.getUseTestClock(), defaultParameters.isDebug(), defaultParameters.getStartNodesInProcess(), defaultParameters.getWaitForAllNodesToFinish(), defaultParameters.getExtraCordappPackagesToScan(), jmxPolicy, list2, compatibilityZoneParams, networkParameters, map4, bl3, collection, path2, list, map3, bl2, bl), driver.1.INSTANCE, dsl);
    }

    public static /* bridge */ /* synthetic */ Object driver$default(DriverParameters driverParameters, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            driverParameters = new DriverParameters(false, null, null, null, null, false, false, false, null, null, null, null, null, false, 16383, null);
        }
        return Driver.driver(driverParameters, function1);
    }
}

