/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.driver;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.net.ServerSocket;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import net.corda.testing.driver.PortAllocation;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public class SharedMemoryIncremental
extends PortAllocation {
    private static final int DEFAULT_START_PORT = 10000;
    private static final int FIRST_EPHEMERAL_PORT = 30000;
    private int startPort;
    private int endPort;
    private MappedByteBuffer mb;
    private Long startingAddress;
    private File file;
    private RandomAccessFile backingFile;
    public static SharedMemoryIncremental INSTANCE = new SharedMemoryIncremental(10000, 30000);
    private static Unsafe UNSAFE = SharedMemoryIncremental.getUnsafe();

    private SharedMemoryIncremental(int startPort, int endPort) {
        this.file = new File(System.getProperty("user.home"), "corda-" + this.startPort + "-to-" + this.endPort + "-port-allocator.bin");
        try {
            this.backingFile = new RandomAccessFile(this.file, "rw");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.startPort = startPort;
        this.endPort = endPort;
        try {
            this.mb = this.backingFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, 16L);
            this.startingAddress = ((DirectBuffer)((Object)this.mb)).address();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Unsafe getUnsafe() {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            return (Unsafe)f.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int nextPort() {
        long newValue;
        boolean portAvailable;
        boolean reserveSuccess;
        boolean loopSuccess;
        do {
            long oldValue;
            newValue = (oldValue = UNSAFE.getLongVolatile(null, this.startingAddress)) + 1L >= (long)this.endPort || oldValue < (long)this.startPort ? (long)this.startPort : oldValue + 1L;
            reserveSuccess = UNSAFE.compareAndSwapLong(null, this.startingAddress, oldValue, newValue);
            portAvailable = this.isLocalPortAvailable(newValue);
        } while (!(loopSuccess = reserveSuccess && portAvailable));
        return (int)newValue;
    }

    private boolean isLocalPortAvailable(Long portToTest) {
        try {
            ServerSocket serverSocket = new ServerSocket(Math.toIntExact(portToTest));
            Throwable throwable = null;
            if (serverSocket != null) {
                if (throwable != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    serverSocket.close();
                }
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

