/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.driver.internal;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.validation.constraints.NotNull;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.concurrent.CordaFuture;
import net.corda.core.flows.FlowLogic;
import net.corda.core.messaging.CordaRPCOps;
import net.corda.core.node.NodeInfo;
import net.corda.core.utilities.NetworkHostAndPort;
import net.corda.node.internal.NodeWithInfo;
import net.corda.node.services.api.StartedNodeServices;
import net.corda.node.services.config.NodeConfiguration;
import net.corda.nodeapi.internal.config.User;
import net.corda.nodeapi.internal.persistence.CordaPersistence;
import net.corda.testing.driver.InProcess;
import net.corda.testing.driver.internal.NodeHandleInternal;
import org.jetbrains.annotations.Nullable;
import rx.Observable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002BK\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u0010,\u001a\u00020\u0011H\u0016J\t\u0010-\u001a\u00020\u0004H\u00c6\u0003J\t\u0010.\u001a\u00020\u0006H\u00c6\u0003J\t\u0010/\u001a\u00020\bH\u00c6\u0003J\t\u00100\u001a\u00020\nH\u00c6\u0003J\t\u00101\u001a\u00020\fH\u00c6\u0003J\t\u00102\u001a\u00020\u000eH\u00c2\u0003J\u000f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u00c2\u0003J\t\u00104\u001a\u00020\u0013H\u00c2\u0003J_\u00105\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u00c6\u0001J\u0013\u00106\u001a\u00020\f2\b\u00107\u001a\u0004\u0018\u000108H\u00d6\u0003J\t\u00109\u001a\u00020:H\u00d6\u0001J*\u0010;\u001a\b\u0012\u0004\u0012\u0002H=0<\"\f\b\u0000\u0010=*\u0006\u0012\u0002\b\u00030>2\f\u0010?\u001a\b\u0012\u0004\u0012\u0002H=0@H\u0017J\b\u0010A\u001a\u00020\u0011H\u0016J\t\u0010B\u001a\u00020CH\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u0006D"}, d2={"Lnet/corda/testing/driver/internal/InProcessImpl;", "Lnet/corda/testing/driver/InProcess;", "Lnet/corda/testing/driver/internal/NodeHandleInternal;", "nodeInfo", "Lnet/corda/core/node/NodeInfo;", "rpc", "Lnet/corda/core/messaging/CordaRPCOps;", "configuration", "Lnet/corda/node/services/config/NodeConfiguration;", "webAddress", "Lnet/corda/core/utilities/NetworkHostAndPort;", "useHTTPS", "", "nodeThread", "Ljava/lang/Thread;", "onStopCallback", "Lkotlin/Function0;", "", "node", "Lnet/corda/node/internal/NodeWithInfo;", "(Lnet/corda/core/node/NodeInfo;Lnet/corda/core/messaging/CordaRPCOps;Lnet/corda/node/services/config/NodeConfiguration;Lnet/corda/core/utilities/NetworkHostAndPort;ZLjava/lang/Thread;Lkotlin/jvm/functions/Function0;Lnet/corda/node/internal/NodeWithInfo;)V", "getConfiguration", "()Lnet/corda/node/services/config/NodeConfiguration;", "database", "Lnet/corda/nodeapi/internal/persistence/CordaPersistence;", "getDatabase", "()Lnet/corda/nodeapi/internal/persistence/CordaPersistence;", "getNodeInfo", "()Lnet/corda/core/node/NodeInfo;", "getRpc", "()Lnet/corda/core/messaging/CordaRPCOps;", "rpcUsers", "", "Lnet/corda/testing/node/User;", "getRpcUsers", "()Ljava/util/List;", "services", "Lnet/corda/node/services/api/StartedNodeServices;", "getServices", "()Lnet/corda/node/services/api/StartedNodeServices;", "getUseHTTPS", "()Z", "getWebAddress", "()Lnet/corda/core/utilities/NetworkHostAndPort;", "close", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "", "hashCode", "", "registerInitiatedFlow", "Lrx/Observable;", "T", "Lnet/corda/core/flows/FlowLogic;", "initiatedFlowClass", "Ljava/lang/Class;", "stop", "toString", "", "node-driver"})
public final class InProcessImpl
implements InProcess,
NodeHandleInternal {
    @org.jetbrains.annotations.NotNull
    private final CordaPersistence database;
    @org.jetbrains.annotations.NotNull
    private final List<net.corda.testing.node.User> rpcUsers;
    @org.jetbrains.annotations.NotNull
    private final NodeInfo nodeInfo;
    @org.jetbrains.annotations.NotNull
    private final CordaRPCOps rpc;
    @org.jetbrains.annotations.NotNull
    private final NodeConfiguration configuration;
    @org.jetbrains.annotations.NotNull
    private final NetworkHostAndPort webAddress;
    private final boolean useHTTPS;
    private final Thread nodeThread;
    private final Function0<Unit> onStopCallback;
    private final NodeWithInfo node;

    @org.jetbrains.annotations.NotNull
    public final CordaPersistence getDatabase() {
        return this.database;
    }

    @org.jetbrains.annotations.NotNull
    public StartedNodeServices getServices() {
        return this.node.getServices();
    }

    @Override
    @org.jetbrains.annotations.NotNull
    public List<net.corda.testing.node.User> getRpcUsers() {
        return this.rpcUsers;
    }

    @Override
    public void stop() {
        Thread thread;
        this.node.dispose();
        Thread $receiver = thread = this.nodeThread;
        $receiver.interrupt();
        $receiver.join();
        this.onStopCallback.invoke();
    }

    @Override
    public void close() {
        this.stop();
    }

    @Override
    @NotNull
    @org.jetbrains.annotations.NotNull
    public <T extends FlowLogic<?>> Observable<T> registerInitiatedFlow(@org.jetbrains.annotations.NotNull Class<T> initiatedFlowClass) {
        Intrinsics.checkParameterIsNotNull(initiatedFlowClass, (String)"initiatedFlowClass");
        this.node.registerInitiatedFlow(initiatedFlowClass);
        Observable observable = Observable.empty();
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Observable.empty()");
        return observable;
    }

    @Override
    @org.jetbrains.annotations.NotNull
    public NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    @Override
    @org.jetbrains.annotations.NotNull
    public CordaRPCOps getRpc() {
        return this.rpc;
    }

    @Override
    @org.jetbrains.annotations.NotNull
    public NodeConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    @org.jetbrains.annotations.NotNull
    public NetworkHostAndPort getWebAddress() {
        return this.webAddress;
    }

    @Override
    public boolean getUseHTTPS() {
        return this.useHTTPS;
    }

    /*
     * WARNING - void declaration
     */
    public InProcessImpl(@org.jetbrains.annotations.NotNull NodeInfo nodeInfo, @org.jetbrains.annotations.NotNull CordaRPCOps rpc, @org.jetbrains.annotations.NotNull NodeConfiguration configuration, @org.jetbrains.annotations.NotNull NetworkHostAndPort webAddress, boolean useHTTPS, @org.jetbrains.annotations.NotNull Thread nodeThread2, @org.jetbrains.annotations.NotNull Function0<Unit> onStopCallback, @org.jetbrains.annotations.NotNull NodeWithInfo node) {
        Collection<net.corda.testing.node.User> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)nodeInfo, (String)"nodeInfo");
        Intrinsics.checkParameterIsNotNull((Object)rpc, (String)"rpc");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)webAddress, (String)"webAddress");
        Intrinsics.checkParameterIsNotNull((Object)nodeThread2, (String)"nodeThread");
        Intrinsics.checkParameterIsNotNull(onStopCallback, (String)"onStopCallback");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        this.nodeInfo = nodeInfo;
        this.rpc = rpc;
        this.configuration = configuration;
        this.webAddress = webAddress;
        this.useHTTPS = useHTTPS;
        this.nodeThread = nodeThread2;
        this.onStopCallback = onStopCallback;
        this.node = node;
        this.database = this.node.getNode().getDatabase();
        Iterable iterable = this.getConfiguration().getRpcUsers();
        InProcessImpl inProcessImpl = this;
        void var10_11 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            User user = (User)item$iv$iv;
            collection = destination$iv$iv;
            net.corda.testing.node.User user2 = new net.corda.testing.node.User(it.getUsername(), it.getPassword(), it.getPermissions());
            collection.add(user2);
        }
        collection = (List)destination$iv$iv;
        inProcessImpl.rpcUsers = collection;
    }

    @Override
    @org.jetbrains.annotations.NotNull
    public <T> CordaFuture<T> startFlow(@org.jetbrains.annotations.NotNull FlowLogic<? extends T> logic) {
        Intrinsics.checkParameterIsNotNull(logic, (String)"logic");
        return InProcess.DefaultImpls.startFlow(this, logic);
    }

    @Override
    @org.jetbrains.annotations.NotNull
    public NetworkHostAndPort getP2pAddress() {
        return NodeHandleInternal.DefaultImpls.getP2pAddress(this);
    }

    @Override
    @org.jetbrains.annotations.NotNull
    public NetworkHostAndPort getRpcAddress() {
        return NodeHandleInternal.DefaultImpls.getRpcAddress(this);
    }

    @Override
    @org.jetbrains.annotations.NotNull
    public NetworkHostAndPort getRpcAdminAddress() {
        return NodeHandleInternal.DefaultImpls.getRpcAdminAddress(this);
    }

    @Override
    @Nullable
    public NetworkHostAndPort getJmxAddress() {
        return NodeHandleInternal.DefaultImpls.getJmxAddress(this);
    }

    @Override
    @org.jetbrains.annotations.NotNull
    public Path getBaseDirectory() {
        return NodeHandleInternal.DefaultImpls.getBaseDirectory(this);
    }

    @org.jetbrains.annotations.NotNull
    public final NodeInfo component1() {
        return this.getNodeInfo();
    }

    @org.jetbrains.annotations.NotNull
    public final CordaRPCOps component2() {
        return this.getRpc();
    }

    @org.jetbrains.annotations.NotNull
    public final NodeConfiguration component3() {
        return this.getConfiguration();
    }

    @org.jetbrains.annotations.NotNull
    public final NetworkHostAndPort component4() {
        return this.getWebAddress();
    }

    public final boolean component5() {
        return this.getUseHTTPS();
    }

    private final Thread component6() {
        return this.nodeThread;
    }

    private final Function0<Unit> component7() {
        return this.onStopCallback;
    }

    private final NodeWithInfo component8() {
        return this.node;
    }

    @org.jetbrains.annotations.NotNull
    public final InProcessImpl copy(@org.jetbrains.annotations.NotNull NodeInfo nodeInfo, @org.jetbrains.annotations.NotNull CordaRPCOps rpc, @org.jetbrains.annotations.NotNull NodeConfiguration configuration, @org.jetbrains.annotations.NotNull NetworkHostAndPort webAddress, boolean useHTTPS, @org.jetbrains.annotations.NotNull Thread nodeThread2, @org.jetbrains.annotations.NotNull Function0<Unit> onStopCallback, @org.jetbrains.annotations.NotNull NodeWithInfo node) {
        Intrinsics.checkParameterIsNotNull((Object)nodeInfo, (String)"nodeInfo");
        Intrinsics.checkParameterIsNotNull((Object)rpc, (String)"rpc");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)webAddress, (String)"webAddress");
        Intrinsics.checkParameterIsNotNull((Object)nodeThread2, (String)"nodeThread");
        Intrinsics.checkParameterIsNotNull(onStopCallback, (String)"onStopCallback");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return new InProcessImpl(nodeInfo, rpc, configuration, webAddress, useHTTPS, nodeThread2, onStopCallback, node);
    }

    @org.jetbrains.annotations.NotNull
    public static /* bridge */ /* synthetic */ InProcessImpl copy$default(InProcessImpl inProcessImpl, NodeInfo nodeInfo, CordaRPCOps cordaRPCOps, NodeConfiguration nodeConfiguration, NetworkHostAndPort networkHostAndPort, boolean bl, Thread thread, Function0 function0, NodeWithInfo nodeWithInfo, int n, Object object) {
        if ((n & 1) != 0) {
            nodeInfo = inProcessImpl.getNodeInfo();
        }
        if ((n & 2) != 0) {
            cordaRPCOps = inProcessImpl.getRpc();
        }
        if ((n & 4) != 0) {
            nodeConfiguration = inProcessImpl.getConfiguration();
        }
        if ((n & 8) != 0) {
            networkHostAndPort = inProcessImpl.getWebAddress();
        }
        if ((n & 0x10) != 0) {
            bl = inProcessImpl.getUseHTTPS();
        }
        if ((n & 0x20) != 0) {
            thread = inProcessImpl.nodeThread;
        }
        if ((n & 0x40) != 0) {
            function0 = inProcessImpl.onStopCallback;
        }
        if ((n & 0x80) != 0) {
            nodeWithInfo = inProcessImpl.node;
        }
        return inProcessImpl.copy(nodeInfo, cordaRPCOps, nodeConfiguration, networkHostAndPort, bl, thread, function0, nodeWithInfo);
    }

    @org.jetbrains.annotations.NotNull
    public String toString() {
        return "InProcessImpl(nodeInfo=" + this.getNodeInfo() + ", rpc=" + this.getRpc() + ", configuration=" + this.getConfiguration() + ", webAddress=" + this.getWebAddress() + ", useHTTPS=" + this.getUseHTTPS() + ", nodeThread=" + this.nodeThread + ", onStopCallback=" + this.onStopCallback + ", node=" + this.node + ")";
    }

    public int hashCode() {
        NodeInfo nodeInfo = this.getNodeInfo();
        CordaRPCOps cordaRPCOps = this.getRpc();
        NodeConfiguration nodeConfiguration = this.getConfiguration();
        NetworkHostAndPort networkHostAndPort = this.getWebAddress();
        int n = ((((nodeInfo != null ? nodeInfo.hashCode() : 0) * 31 + (cordaRPCOps != null ? cordaRPCOps.hashCode() : 0)) * 31 + (nodeConfiguration != null ? nodeConfiguration.hashCode() : 0)) * 31 + (networkHostAndPort != null ? networkHostAndPort.hashCode() : 0)) * 31;
        int n2 = this.getUseHTTPS() ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        Thread thread = this.nodeThread;
        Function0<Unit> function0 = this.onStopCallback;
        NodeWithInfo nodeWithInfo = this.node;
        return (((n + n2) * 31 + (thread != null ? thread.hashCode() : 0)) * 31 + (function0 != null ? function0.hashCode() : 0)) * 31 + (nodeWithInfo != null ? nodeWithInfo.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof InProcessImpl)) break block3;
                InProcessImpl inProcessImpl = (InProcessImpl)object;
                if (!Intrinsics.areEqual((Object)this.getNodeInfo(), (Object)inProcessImpl.getNodeInfo()) || !Intrinsics.areEqual((Object)this.getRpc(), (Object)inProcessImpl.getRpc()) || !Intrinsics.areEqual((Object)this.getConfiguration(), (Object)inProcessImpl.getConfiguration()) || !Intrinsics.areEqual((Object)this.getWebAddress(), (Object)inProcessImpl.getWebAddress()) || !(this.getUseHTTPS() == inProcessImpl.getUseHTTPS()) || !Intrinsics.areEqual((Object)this.nodeThread, (Object)inProcessImpl.nodeThread) || !Intrinsics.areEqual(this.onStopCallback, inProcessImpl.onStopCallback) || !Intrinsics.areEqual((Object)this.node, (Object)inProcessImpl.node)) break block3;
            }
            return true;
        }
        return false;
    }
}

