/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.driver.internal;

import java.nio.file.Path;
import kotlin.Metadata;
import net.corda.core.utilities.NetworkHostAndPort;
import net.corda.node.services.config.NodeConfiguration;
import net.corda.testing.driver.NodeHandle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0014\u0010\u0012\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u0012\u0010\u0014\u001a\u00020\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\r\u00a8\u0006\u001a"}, d2={"Lnet/corda/testing/driver/internal/NodeHandleInternal;", "Lnet/corda/testing/driver/NodeHandle;", "baseDirectory", "Ljava/nio/file/Path;", "getBaseDirectory", "()Ljava/nio/file/Path;", "configuration", "Lnet/corda/node/services/config/NodeConfiguration;", "getConfiguration", "()Lnet/corda/node/services/config/NodeConfiguration;", "jmxAddress", "Lnet/corda/core/utilities/NetworkHostAndPort;", "getJmxAddress", "()Lnet/corda/core/utilities/NetworkHostAndPort;", "p2pAddress", "getP2pAddress", "rpcAddress", "getRpcAddress", "rpcAdminAddress", "getRpcAdminAddress", "useHTTPS", "", "getUseHTTPS", "()Z", "webAddress", "getWebAddress", "node-driver"})
public interface NodeHandleInternal
extends NodeHandle {
    @NotNull
    public NodeConfiguration getConfiguration();

    public boolean getUseHTTPS();

    @NotNull
    public NetworkHostAndPort getWebAddress();

    @Override
    @NotNull
    public NetworkHostAndPort getP2pAddress();

    @Override
    @NotNull
    public NetworkHostAndPort getRpcAddress();

    @Override
    @NotNull
    public NetworkHostAndPort getRpcAdminAddress();

    @Override
    @Nullable
    public NetworkHostAndPort getJmxAddress();

    @Override
    @NotNull
    public Path getBaseDirectory();

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static NetworkHostAndPort getP2pAddress(NodeHandleInternal $this) {
            return $this.getConfiguration().getP2pAddress();
        }

        @NotNull
        public static NetworkHostAndPort getRpcAddress(NodeHandleInternal $this) {
            return $this.getConfiguration().getRpcOptions().getAddress();
        }

        @NotNull
        public static NetworkHostAndPort getRpcAdminAddress(NodeHandleInternal $this) {
            return $this.getConfiguration().getRpcOptions().getAdminAddress();
        }

        @Nullable
        public static NetworkHostAndPort getJmxAddress(NodeHandleInternal $this) {
            NetworkHostAndPort networkHostAndPort;
            Integer n = $this.getConfiguration().getJmxMonitoringHttpPort();
            if (n != null) {
                Integer n2 = n;
                int it = ((Number)n2).intValue();
                networkHostAndPort = new NetworkHostAndPort("localhost", it);
            } else {
                networkHostAndPort = null;
            }
            return networkHostAndPort;
        }

        @NotNull
        public static Path getBaseDirectory(NodeHandleInternal $this) {
            return $this.getConfiguration().getBaseDirectory();
        }
    }
}

