/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.node;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SplittableRandom;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiFunction;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.CordaInternal;
import net.corda.core.DoNotImplement;
import net.corda.core.crypto.CompositeKey;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.identity.Party;
import net.corda.core.identity.PartyAndCertificate;
import net.corda.core.internal.concurrent.CordaFutureImplKt;
import net.corda.core.internal.concurrent.OpenFuture;
import net.corda.core.messaging.AllPossibleRecipients;
import net.corda.core.messaging.MessageRecipientGroup;
import net.corda.core.messaging.MessageRecipients;
import net.corda.core.messaging.SingleMessageRecipient;
import net.corda.core.serialization.CordaSerializable;
import net.corda.core.serialization.SingletonSerializeAsToken;
import net.corda.core.utilities.ByteSequence;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.node.services.messaging.Message;
import net.corda.testing.node.internal.MockNodeMessagingService;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.subjects.PublishSubject;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0007\u0018\u0000 P2\u00020\u0001:\u0007PQRSTUVB#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001f\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u00122\b\u00103\u001a\u0004\u0018\u000104H\u0001\u00a2\u0006\u0002\b5J\u0017\u00106\u001a\u0004\u0018\u00010\u001a2\u0006\u00107\u001a\u00020!H\u0001\u00a2\u0006\u0002\b8J\u001b\u00109\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001e2\u0006\u0010:\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b;J\u001c\u0010<\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u001e0\u00112\u0006\u0010:\u001a\u00020,H\u0002J\u0017\u0010=\u001a\u0004\u0018\u00010\u00122\u0006\u0010>\u001a\u00020\u0012H\u0001\u00a2\u0006\u0002\b?J%\u0010@\u001a\u0002012\u0006\u0010A\u001a\u00020\u00122\u0006\u0010B\u001a\u00020C2\u0006\u0010:\u001a\u00020DH\u0001\u00a2\u0006\u0002\bEJ\u0015\u0010F\u001a\u0002012\u0006\u0010G\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\bHJ\u0015\u0010I\u001a\u0002012\u0006\u0010J\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\bKJ\u0010\u0010L\u001a\u0004\u0018\u00010\u000b2\u0006\u0010M\u001a\u00020\u0003J\u0010\u0010N\u001a\u0002012\u0006\u0010J\u001a\u00020\u000bH\u0002J\u0006\u0010O\u001a\u000201R2\u0010\t\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\r\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00120\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u001c8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u001e0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0#8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0#8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b)\u0010%\u001a\u0004\b*\u0010'R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010+\u001a\u0014\u0012\u0004\u0012\u00020,\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0-0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lnet/corda/testing/node/InMemoryMessagingNetwork;", "Lnet/corda/core/serialization/SingletonSerializeAsToken;", "sendManuallyPumped", "", "servicePeerAllocationStrategy", "Lnet/corda/testing/node/InMemoryMessagingNetwork$ServicePeerAllocationStrategy;", "messagesInFlight", "Lorg/apache/activemq/artemis/utils/ReusableLatch;", "(ZLnet/corda/testing/node/InMemoryMessagingNetwork$ServicePeerAllocationStrategy;Lorg/apache/activemq/artemis/utils/ReusableLatch;)V", "_receivedMessages", "Lrx/subjects/PublishSubject;", "Lnet/corda/testing/node/InMemoryMessagingNetwork$MessageTransfer;", "kotlin.jvm.PlatformType", "_sentMessages", "counter", "", "endpoints", "", "Lnet/corda/testing/node/internal/MockNodeMessagingService;", "getEndpoints$node_driver", "()Ljava/util/List;", "endpointsExternal", "Lnet/corda/testing/node/InMemoryMessagingNetwork$MockMessagingService;", "getEndpointsExternal", "handleEndpointMap", "Ljava/util/HashMap;", "Lnet/corda/testing/node/InMemoryMessagingNetwork$PeerHandle;", "latencyCalculator", "Lnet/corda/testing/node/InMemoryMessagingNetwork$LatencyCalculator;", "messageReceiveQueues", "Ljava/util/concurrent/LinkedBlockingQueue;", "messageSendQueue", "peersMapping", "Lnet/corda/core/identity/CordaX500Name;", "receivedMessages", "Lrx/Observable;", "receivedMessages$annotations", "()V", "getReceivedMessages", "()Lrx/Observable;", "sentMessages", "sentMessages$annotations", "getSentMessages", "serviceToPeersMapping", "Lnet/corda/testing/node/InMemoryMessagingNetwork$DistributedServiceHandle;", "Ljava/util/LinkedHashSet;", "timer", "Ljava/util/Timer;", "addNotaryIdentity", "", "node", "notaryService", "Lnet/corda/core/identity/PartyAndCertificate;", "addNotaryIdentity$node_driver", "getPeer", "name", "getPeer$node_driver", "getQueueForPeerHandle", "recipients", "getQueueForPeerHandle$node_driver", "getQueuesForServiceHandle", "initPeer", "messagingService", "initPeer$node_driver", "msgSend", "from", "message", "Lnet/corda/node/services/messaging/Message;", "Lnet/corda/core/messaging/MessageRecipients;", "msgSend$node_driver", "netNodeHasShutdown", "peerHandle", "netNodeHasShutdown$node_driver", "onMessageTransfer", "transfer", "onMessageTransfer$node_driver", "pumpSend", "block", "pumpSendInternal", "stop", "Companion", "DistributedServiceHandle", "LatencyCalculator", "MessageTransfer", "MockMessagingService", "PeerHandle", "ServicePeerAllocationStrategy", "node-driver"})
@ThreadSafe
public final class InMemoryMessagingNetwork
extends SingletonSerializeAsToken {
    private int counter;
    private final HashMap<PeerHandle, MockNodeMessagingService> handleEndpointMap;
    private final LinkedBlockingQueue<MessageTransfer> messageSendQueue;
    private final PublishSubject<MessageTransfer> _sentMessages;
    private final HashMap<PeerHandle, LinkedBlockingQueue<MessageTransfer>> messageReceiveQueues;
    private final PublishSubject<MessageTransfer> _receivedMessages;
    private final HashMap<DistributedServiceHandle, LinkedHashSet<PeerHandle>> serviceToPeersMapping;
    private final HashMap<CordaX500Name, PeerHandle> peersMapping;
    private volatile LatencyCalculator latencyCalculator;
    private final Timer timer;
    private final boolean sendManuallyPumped;
    private final ServicePeerAllocationStrategy servicePeerAllocationStrategy;
    private final ReusableLatch messagesInFlight;
    private static final String MESSAGES_LOG_NAME = "messages";
    private static final Logger log;
    public static final Companion Companion;

    public static /* synthetic */ void sentMessages$annotations() {
    }

    @NotNull
    public final Observable<MessageTransfer> getSentMessages() {
        PublishSubject<MessageTransfer> publishSubject = this._sentMessages;
        Intrinsics.checkExpressionValueIsNotNull(publishSubject, (String)"_sentMessages");
        return (Observable)publishSubject;
    }

    public static /* synthetic */ void receivedMessages$annotations() {
    }

    @NotNull
    public final Observable<MessageTransfer> getReceivedMessages() {
        PublishSubject<MessageTransfer> publishSubject = this._receivedMessages;
        Intrinsics.checkExpressionValueIsNotNull(publishSubject, (String)"_receivedMessages");
        return (Observable)publishSubject;
    }

    @CordaInternal
    @NotNull
    public final synchronized List<MockNodeMessagingService> getEndpoints$node_driver() {
        Collection<MockNodeMessagingService> collection = this.handleEndpointMap.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"handleEndpointMap.values");
        return CollectionsKt.toList((Iterable)collection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized List<MockMessagingService> getEndpointsExternal() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Collection<MockNodeMessagingService> collection = this.handleEndpointMap.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"handleEndpointMap.values");
        Iterable iterable = $receiver$iv = (Iterable)collection;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            MockNodeMessagingService mockNodeMessagingService = (MockNodeMessagingService)((Object)item$iv$iv);
            Collection collection2 = destination$iv$iv;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            MockMessagingService mockMessagingService = MockMessagingService.Companion.createMockMessagingService$node_driver((MockNodeMessagingService)v1);
            collection2.add(mockMessagingService);
        }
        return CollectionsKt.toList((Iterable)((List)var3_3));
    }

    @CordaInternal
    @Nullable
    public final PeerHandle getPeer$node_driver(@NotNull CordaX500Name name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.peersMapping.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CordaInternal
    @Nullable
    public final MockNodeMessagingService initPeer$node_driver(@NotNull MockNodeMessagingService messagingService) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)messagingService), (String)"messagingService");
        Object object = this.peersMapping;
        CordaX500Name cordaX500Name = messagingService.getMyAddress().getName();
        Object object2 = messagingService.getMyAddress();
        object.put(cordaX500Name, object2);
        object = this;
        synchronized (object) {
            object2 = this.handleEndpointMap.put(messagingService.getMyAddress(), messagingService);
        }
        return object2;
    }

    @CordaInternal
    public final void onMessageTransfer$node_driver(@NotNull MessageTransfer transfer) {
        Intrinsics.checkParameterIsNotNull((Object)transfer, (String)"transfer");
        this._receivedMessages.onNext((Object)transfer);
        this.messagesInFlight.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CordaInternal
    public final void addNotaryIdentity$node_driver(@NotNull MockNodeMessagingService node, @Nullable PartyAndCertificate notaryService) {
        Object object;
        PartyAndCertificate it;
        Object object2;
        Object object3;
        PartyAndCertificate partyAndCertificate;
        PartyAndCertificate it2;
        Intrinsics.checkParameterIsNotNull((Object)((Object)node), (String)"node");
        PeerHandle peerHandle = node.getMyAddress();
        PartyAndCertificate partyAndCertificate2 = notaryService;
        if (partyAndCertificate2 != null && !((it2 = (partyAndCertificate = partyAndCertificate2)).getOwningKey() instanceof CompositeKey)) {
            Map map2 = this.peersMapping;
            object3 = it2.getName();
            PeerHandle peerHandle2 = peerHandle;
            map2.put(object3, peerHandle2);
        }
        if ((object2 = notaryService) == null || (object2 = CollectionsKt.listOf((Object)new DistributedServiceHandle((it = (object = object2)).getParty()))) == null) {
            object2 = CollectionsKt.emptyList();
        }
        Object serviceHandles = object2;
        object = this;
        synchronized (object) {
            Iterable $receiver$iv = (Iterable)serviceHandles;
            object3 = $receiver$iv.iterator();
            while (object3.hasNext()) {
                Object object4;
                Map $receiver$iv2 = this.serviceToPeersMapping;
                Object element$iv = object3.next();
                DistributedServiceHandle it3 = (DistributedServiceHandle)element$iv;
                Object value$iv = $receiver$iv2.get(it3);
                if (value$iv == null) {
                    LinkedHashSet answer$iv = new LinkedHashSet();
                    $receiver$iv2.put(it3, answer$iv);
                    object4 = answer$iv;
                } else {
                    object4 = value$iv;
                }
                ((LinkedHashSet)object4).add(peerHandle);
            }
            object3 = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CordaInternal
    public final void msgSend$node_driver(@NotNull MockNodeMessagingService from, @NotNull Message message, @NotNull MessageRecipients recipients) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)from), (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)recipients, (String)"recipients");
        InMemoryMessagingNetwork inMemoryMessagingNetwork = this;
        synchronized (inMemoryMessagingNetwork) {
            this.messagesInFlight.countUp();
            Collection collection = this.messageSendQueue;
            MessageTransfer messageTransfer = MessageTransfer.Companion.createMessageTransfer$node_driver(from.getMyAddress(), message, recipients);
            collection.add(messageTransfer);
            messageTransfer = Unit.INSTANCE;
        }
        if (!this.sendManuallyPumped) {
            this.pumpSend(false);
        }
    }

    @CordaInternal
    public final synchronized void netNodeHasShutdown$node_driver(@NotNull PeerHandle peerHandle) {
        MockNodeMessagingService endpoint;
        Intrinsics.checkParameterIsNotNull((Object)peerHandle, (String)"peerHandle");
        MockNodeMessagingService mockNodeMessagingService = endpoint = this.handleEndpointMap.get(peerHandle);
        if (mockNodeMessagingService == null || !mockNodeMessagingService.hasPendingDeliveries()) {
            this.handleEndpointMap.remove(peerHandle);
        }
    }

    /*
     * WARNING - void declaration
     */
    @CordaInternal
    @NotNull
    public final synchronized LinkedBlockingQueue<MessageTransfer> getQueueForPeerHandle$node_driver(@NotNull PeerHandle recipients) {
        LinkedBlockingQueue linkedBlockingQueue;
        Intrinsics.checkParameterIsNotNull((Object)recipients, (String)"recipients");
        Map $receiver$iv = this.messageReceiveQueues;
        Object value$iv = $receiver$iv.get(recipients);
        if (value$iv == null) {
            LinkedBlockingQueue answer$iv = new LinkedBlockingQueue();
            $receiver$iv.put(recipients, answer$iv);
            linkedBlockingQueue = answer$iv;
        } else {
            void var3_3;
            linkedBlockingQueue = var3_3;
        }
        return linkedBlockingQueue;
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized List<LinkedBlockingQueue<MessageTransfer>> getQueuesForServiceHandle(DistributedServiceHandle recipients) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        LinkedHashSet<PeerHandle> linkedHashSet = this.serviceToPeersMapping.get(recipients);
        if (linkedHashSet == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(linkedHashSet, (String)"serviceToPeersMapping[recipients]!!");
        Iterable iterable = $receiver$iv = (Iterable)linkedHashSet;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Object object;
            void it;
            PeerHandle peerHandle = (PeerHandle)item$iv$iv;
            Collection collection = destination$iv$iv;
            Map $receiver$iv2 = this.messageReceiveQueues;
            Object value$iv = $receiver$iv2.get(it);
            if (value$iv == null) {
                LinkedBlockingQueue answer$iv = new LinkedBlockingQueue();
                $receiver$iv2.put(it, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            LinkedBlockingQueue linkedBlockingQueue = (LinkedBlockingQueue)object;
            collection.add(linkedBlockingQueue);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        List list;
        InMemoryMessagingNetwork inMemoryMessagingNetwork = this;
        synchronized (inMemoryMessagingNetwork) {
            this.counter = -1;
            Collection<MockNodeMessagingService> collection = this.handleEndpointMap.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"handleEndpointMap.values");
            list = CollectionsKt.toList((Iterable)collection);
        }
        List nodes = list;
        Iterable $receiver$iv = nodes;
        for (Object element$iv : $receiver$iv) {
            MockNodeMessagingService it = (MockNodeMessagingService)((Object)element$iv);
            it.close();
        }
        this.handleEndpointMap.clear();
        this.messageReceiveQueues.clear();
        this.timer.cancel();
    }

    @Nullable
    public final MessageTransfer pumpSend(boolean block) {
        MessageTransfer messageTransfer = block ? this.messageSendQueue.take() : this.messageSendQueue.poll();
        if (messageTransfer == null) {
            return null;
        }
        MessageTransfer transfer = messageTransfer;
        Logger logger = log;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
        Logger $receiver$iv = logger;
        if ($receiver$iv.isTraceEnabled()) {
            Logger logger2 = $receiver$iv;
            String string = transfer.toString();
            logger2.trace(string);
        }
        LatencyCalculator calc = this.latencyCalculator;
        if (calc != null && transfer.getRecipients() instanceof SingleMessageRecipient) {
            OpenFuture messageSent = CordaFutureImplKt.openFuture();
            Timer timer = this.timer;
            long l = calc.between(transfer.getSender(), (SingleMessageRecipient)transfer.getRecipients()).toMillis();
            TimerTask timerTask = new TimerTask(this, transfer, messageSent){
                final /* synthetic */ InMemoryMessagingNetwork this$0;
                final /* synthetic */ MessageTransfer $transfer$inlined;
                final /* synthetic */ OpenFuture $messageSent$inlined;
                {
                    this.this$0 = inMemoryMessagingNetwork;
                    this.$transfer$inlined = messageTransfer;
                    this.$messageSent$inlined = openFuture;
                }

                public void run() {
                    TimerTask $receiver = this;
                    InMemoryMessagingNetwork.access$pumpSendInternal(this.this$0, this.$transfer$inlined);
                    this.$messageSent$inlined.set((Object)Unit.INSTANCE);
                }
            };
            timer.schedule(timerTask, l);
            if (block) {
                KotlinUtilsKt.getOrThrow$default((Future)((Future)messageSent), null, (int)1, null);
            }
        } else {
            this.pumpSendInternal(transfer);
        }
        return transfer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void pumpSendInternal(MessageTransfer transfer) {
        MessageRecipients messageRecipients = transfer.getRecipients();
        if (messageRecipients instanceof PeerHandle) {
            this.getQueueForPeerHandle$node_driver((PeerHandle)transfer.getRecipients()).add(transfer);
        } else if (messageRecipients instanceof DistributedServiceHandle) {
            List<LinkedBlockingQueue<MessageTransfer>> queues = this.getQueuesForServiceHandle((DistributedServiceHandle)transfer.getRecipients());
            LinkedBlockingQueue<MessageTransfer> queue = this.servicePeerAllocationStrategy.pickNext((DistributedServiceHandle)transfer.getRecipients(), queues);
            queue.add(transfer);
        } else if (messageRecipients instanceof AllPossibleRecipients) {
            InMemoryMessagingNetwork inMemoryMessagingNetwork = this;
            synchronized (inMemoryMessagingNetwork) {
                Iterator<PeerHandle> iterator = this.handleEndpointMap.keySet().iterator();
                while (iterator.hasNext()) {
                    PeerHandle handle;
                    PeerHandle peerHandle = handle = iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)peerHandle, (String)"handle");
                    this.getQueueForPeerHandle$node_driver(peerHandle).add(transfer);
                }
                Unit unit = Unit.INSTANCE;
            }
        } else {
            throw (Throwable)new IllegalArgumentException("Unknown type of recipient handle");
        }
        this._sentMessages.onNext((Object)transfer);
    }

    private InMemoryMessagingNetwork(boolean sendManuallyPumped, ServicePeerAllocationStrategy servicePeerAllocationStrategy, ReusableLatch messagesInFlight) {
        this.sendManuallyPumped = sendManuallyPumped;
        this.servicePeerAllocationStrategy = servicePeerAllocationStrategy;
        this.messagesInFlight = messagesInFlight;
        this.handleEndpointMap = new HashMap();
        this.messageSendQueue = new LinkedBlockingQueue();
        this._sentMessages = PublishSubject.create();
        this.messageReceiveQueues = new HashMap();
        this._receivedMessages = PublishSubject.create();
        this.serviceToPeersMapping = new HashMap();
        this.peersMapping = new HashMap();
        this.timer = new Timer();
    }

    /* synthetic */ InMemoryMessagingNetwork(boolean bl, ServicePeerAllocationStrategy servicePeerAllocationStrategy, ReusableLatch reusableLatch, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            servicePeerAllocationStrategy = new ServicePeerAllocationStrategy.Random(null, 1, null);
        }
        if ((n & 4) != 0) {
            reusableLatch = new ReusableLatch();
        }
        this(bl, servicePeerAllocationStrategy, reusableLatch);
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger((String)MESSAGES_LOG_NAME);
    }

    public static final /* synthetic */ void access$pumpSendInternal(InMemoryMessagingNetwork $this, @NotNull MessageTransfer transfer) {
        $this.pumpSendInternal(transfer);
    }

    public /* synthetic */ InMemoryMessagingNetwork(boolean sendManuallyPumped, @NotNull ServicePeerAllocationStrategy servicePeerAllocationStrategy, @NotNull ReusableLatch messagesInFlight, DefaultConstructorMarker $constructor_marker) {
        this(sendManuallyPumped, servicePeerAllocationStrategy, messagesInFlight);
    }

    @CordaSerializable
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lnet/corda/testing/node/InMemoryMessagingNetwork$MessageTransfer;", "", "sender", "Lnet/corda/testing/node/InMemoryMessagingNetwork$PeerHandle;", "message", "Lnet/corda/node/services/messaging/Message;", "recipients", "Lnet/corda/core/messaging/MessageRecipients;", "(Lnet/corda/testing/node/InMemoryMessagingNetwork$PeerHandle;Lnet/corda/node/services/messaging/Message;Lnet/corda/core/messaging/MessageRecipients;)V", "getMessage$node_driver", "()Lnet/corda/node/services/messaging/Message;", "messageData", "Lnet/corda/core/utilities/ByteSequence;", "getMessageData", "()Lnet/corda/core/utilities/ByteSequence;", "getRecipients", "()Lnet/corda/core/messaging/MessageRecipients;", "getSender", "()Lnet/corda/testing/node/InMemoryMessagingNetwork$PeerHandle;", "toString", "", "Companion", "node-driver"})
    public static final class MessageTransfer {
        @NotNull
        private final PeerHandle sender;
        @NotNull
        private final Message message;
        @NotNull
        private final MessageRecipients recipients;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final ByteSequence getMessageData() {
            return this.message.getData();
        }

        @NotNull
        public String toString() {
            return this.message.getTopic() + " from '" + this.sender + "' to '" + this.recipients + '\'';
        }

        @NotNull
        public final PeerHandle getSender() {
            return this.sender;
        }

        @NotNull
        public final Message getMessage$node_driver() {
            return this.message;
        }

        @NotNull
        public final MessageRecipients getRecipients() {
            return this.recipients;
        }

        private MessageTransfer(PeerHandle sender, Message message, MessageRecipients recipients) {
            this.sender = sender;
            this.message = message;
            this.recipients = recipients;
        }

        public /* synthetic */ MessageTransfer(@NotNull PeerHandle sender, @NotNull Message message, @NotNull MessageRecipients recipients, DefaultConstructorMarker $constructor_marker) {
            this(sender, message, recipients);
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lnet/corda/testing/node/InMemoryMessagingNetwork$MessageTransfer$Companion;", "", "()V", "createMessageTransfer", "Lnet/corda/testing/node/InMemoryMessagingNetwork$MessageTransfer;", "sender", "Lnet/corda/testing/node/InMemoryMessagingNetwork$PeerHandle;", "message", "Lnet/corda/node/services/messaging/Message;", "recipients", "Lnet/corda/core/messaging/MessageRecipients;", "createMessageTransfer$node_driver", "node-driver"})
        public static final class Companion {
            @NotNull
            public final MessageTransfer createMessageTransfer$node_driver(@NotNull PeerHandle sender, @NotNull Message message, @NotNull MessageRecipients recipients) {
                Intrinsics.checkParameterIsNotNull((Object)sender, (String)"sender");
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                Intrinsics.checkParameterIsNotNull((Object)recipients, (String)"recipients");
                return new MessageTransfer(sender, message, recipients, null);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lnet/corda/testing/node/InMemoryMessagingNetwork$LatencyCalculator;", "", "between", "Ljava/time/Duration;", "sender", "Lnet/corda/core/messaging/SingleMessageRecipient;", "receiver", "node-driver"})
    public static interface LatencyCalculator {
        @NotNull
        public Duration between(@NotNull SingleMessageRecipient var1, @NotNull SingleMessageRecipient var2);
    }

    @CordaSerializable
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lnet/corda/testing/node/InMemoryMessagingNetwork$PeerHandle;", "Lnet/corda/core/messaging/SingleMessageRecipient;", "id", "", "name", "Lnet/corda/core/identity/CordaX500Name;", "(ILnet/corda/core/identity/CordaX500Name;)V", "getId", "()I", "getName", "()Lnet/corda/core/identity/CordaX500Name;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "node-driver"})
    public static final class PeerHandle
    implements SingleMessageRecipient {
        private final int id;
        @NotNull
        private final CordaX500Name name;

        @NotNull
        public String toString() {
            return this.name.toString();
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof PeerHandle && ((PeerHandle)other).id == this.id;
        }

        public int hashCode() {
            return Integer.hashCode(this.id);
        }

        public final int getId() {
            return this.id;
        }

        @NotNull
        public final CordaX500Name getName() {
            return this.name;
        }

        public PeerHandle(int id, @NotNull CordaX500Name name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            this.id = id;
            this.name = name;
        }

        public final int component1() {
            return this.id;
        }

        @NotNull
        public final CordaX500Name component2() {
            return this.name;
        }

        @NotNull
        public final PeerHandle copy(int id, @NotNull CordaX500Name name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return new PeerHandle(id, name);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ PeerHandle copy$default(PeerHandle peerHandle, int n, CordaX500Name cordaX500Name, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = peerHandle.id;
            }
            if ((n2 & 2) != 0) {
                cordaX500Name = peerHandle.name;
            }
            return peerHandle.copy(n, cordaX500Name);
        }
    }

    @CordaSerializable
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lnet/corda/testing/node/InMemoryMessagingNetwork$DistributedServiceHandle;", "Lnet/corda/core/messaging/MessageRecipientGroup;", "party", "Lnet/corda/core/identity/Party;", "(Lnet/corda/core/identity/Party;)V", "getParty", "()Lnet/corda/core/identity/Party;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "node-driver"})
    public static final class DistributedServiceHandle
    implements MessageRecipientGroup {
        @NotNull
        private final Party party;

        @NotNull
        public String toString() {
            return "Service(" + this.party + ')';
        }

        @NotNull
        public final Party getParty() {
            return this.party;
        }

        public DistributedServiceHandle(@NotNull Party party) {
            Intrinsics.checkParameterIsNotNull((Object)party, (String)"party");
            this.party = party;
        }

        @NotNull
        public final Party component1() {
            return this.party;
        }

        @NotNull
        public final DistributedServiceHandle copy(@NotNull Party party) {
            Intrinsics.checkParameterIsNotNull((Object)party, (String)"party");
            return new DistributedServiceHandle(party);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ DistributedServiceHandle copy$default(DistributedServiceHandle distributedServiceHandle, Party party, int n, Object object) {
            if ((n & 1) != 0) {
                party = distributedServiceHandle.party;
            }
            return distributedServiceHandle.copy(party);
        }

        public int hashCode() {
            Party party = this.party;
            return party != null ? party.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DistributedServiceHandle)) break block3;
                    DistributedServiceHandle distributedServiceHandle = (DistributedServiceHandle)object;
                    if (!Intrinsics.areEqual((Object)this.party, (Object)distributedServiceHandle.party)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00040\bH&\u00a2\u0006\u0002\u0010\t\u0082\u0001\u0002\f\r\u00a8\u0006\u000e"}, d2={"Lnet/corda/testing/node/InMemoryMessagingNetwork$ServicePeerAllocationStrategy;", "", "()V", "pickNext", "A", "service", "Lnet/corda/testing/node/InMemoryMessagingNetwork$DistributedServiceHandle;", "pickFrom", "", "(Lnet/corda/testing/node/InMemoryMessagingNetwork$DistributedServiceHandle;Ljava/util/List;)Ljava/lang/Object;", "Random", "RoundRobin", "Lnet/corda/testing/node/InMemoryMessagingNetwork$ServicePeerAllocationStrategy$Random;", "Lnet/corda/testing/node/InMemoryMessagingNetwork$ServicePeerAllocationStrategy$RoundRobin;", "node-driver"})
    @DoNotImplement
    public static abstract class ServicePeerAllocationStrategy {
        public abstract <A> A pickNext(@NotNull DistributedServiceHandle var1, @NotNull List<? extends A> var2);

        private ServicePeerAllocationStrategy() {
        }

        public /* synthetic */ ServicePeerAllocationStrategy(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\b0\fH\u0016\u00a2\u0006\u0002\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lnet/corda/testing/node/InMemoryMessagingNetwork$ServicePeerAllocationStrategy$Random;", "Lnet/corda/testing/node/InMemoryMessagingNetwork$ServicePeerAllocationStrategy;", "random", "Ljava/util/SplittableRandom;", "(Ljava/util/SplittableRandom;)V", "getRandom", "()Ljava/util/SplittableRandom;", "pickNext", "A", "service", "Lnet/corda/testing/node/InMemoryMessagingNetwork$DistributedServiceHandle;", "pickFrom", "", "(Lnet/corda/testing/node/InMemoryMessagingNetwork$DistributedServiceHandle;Ljava/util/List;)Ljava/lang/Object;", "node-driver"})
        public static final class Random
        extends ServicePeerAllocationStrategy {
            @NotNull
            private final SplittableRandom random;

            @Override
            public <A> A pickNext(@NotNull DistributedServiceHandle service, @NotNull List<? extends A> pickFrom) {
                Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
                Intrinsics.checkParameterIsNotNull(pickFrom, (String)"pickFrom");
                return pickFrom.get(this.random.nextInt(pickFrom.size()));
            }

            @NotNull
            public final SplittableRandom getRandom() {
                return this.random;
            }

            public Random(@NotNull SplittableRandom random) {
                Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
                super(null);
                this.random = random;
            }

            public /* synthetic */ Random(SplittableRandom splittableRandom, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    splittableRandom = new SplittableRandom();
                }
                this(splittableRandom);
            }

            public Random() {
                this(null, 1, null);
            }
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000bH\u0016\u00a2\u0006\u0002\u0010\fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/corda/testing/node/InMemoryMessagingNetwork$ServicePeerAllocationStrategy$RoundRobin;", "Lnet/corda/testing/node/InMemoryMessagingNetwork$ServicePeerAllocationStrategy;", "()V", "previousPicks", "Ljava/util/HashMap;", "Lnet/corda/testing/node/InMemoryMessagingNetwork$DistributedServiceHandle;", "", "pickNext", "A", "service", "pickFrom", "", "(Lnet/corda/testing/node/InMemoryMessagingNetwork$DistributedServiceHandle;Ljava/util/List;)Ljava/lang/Object;", "node-driver"})
        public static final class RoundRobin
        extends ServicePeerAllocationStrategy {
            private final HashMap<DistributedServiceHandle, Integer> previousPicks = new HashMap();

            @Override
            public <A> A pickNext(@NotNull DistributedServiceHandle service, @NotNull List<? extends A> pickFrom) {
                Integer nextIndex2;
                Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
                Intrinsics.checkParameterIsNotNull(pickFrom, (String)"pickFrom");
                Integer n = this.previousPicks.compute(service, new BiFunction<DistributedServiceHandle, Integer, Integer>(pickFrom){
                    final /* synthetic */ List $pickFrom;

                    public final int apply(@NotNull DistributedServiceHandle $noName_0, @Nullable Integer previous) {
                        Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                        Integer n = previous;
                        return (n != null ? n + 1 : 0) % this.$pickFrom.size();
                    }
                    {
                        this.$pickFrom = list;
                    }
                });
                if (n == null) {
                    Intrinsics.throwNpe();
                }
                Integer n2 = nextIndex2 = n;
                Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"nextIndex");
                return pickFrom.get(n2);
            }

            public RoundRobin() {
                super(null);
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lnet/corda/testing/node/InMemoryMessagingNetwork$MockMessagingService;", "", "messagingService", "Lnet/corda/testing/node/internal/MockNodeMessagingService;", "(Lnet/corda/testing/node/internal/MockNodeMessagingService;)V", "pumpReceive", "Lnet/corda/testing/node/InMemoryMessagingNetwork$MessageTransfer;", "block", "", "Companion", "node-driver"})
    public static final class MockMessagingService {
        private final MockNodeMessagingService messagingService;
        public static final Companion Companion = new Companion(null);

        @Nullable
        public final MessageTransfer pumpReceive(boolean block) {
            return this.messagingService.pumpReceive(block);
        }

        private MockMessagingService(MockNodeMessagingService messagingService) {
            this.messagingService = messagingService;
        }

        public /* synthetic */ MockMessagingService(@NotNull MockNodeMessagingService messagingService, DefaultConstructorMarker $constructor_marker) {
            this(messagingService);
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lnet/corda/testing/node/InMemoryMessagingNetwork$MockMessagingService$Companion;", "", "()V", "createMockMessagingService", "Lnet/corda/testing/node/InMemoryMessagingNetwork$MockMessagingService;", "messagingService", "Lnet/corda/testing/node/internal/MockNodeMessagingService;", "createMockMessagingService$node_driver", "node-driver"})
        public static final class Companion {
            @CordaInternal
            @NotNull
            public final MockMessagingService createMockMessagingService$node_driver(@NotNull MockNodeMessagingService messagingService) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)messagingService), (String)"messagingService");
                return new MockMessagingService(messagingService, null);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0001\u00a2\u0006\u0002\b\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/corda/testing/node/InMemoryMessagingNetwork$Companion;", "", "()V", "MESSAGES_LOG_NAME", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "create", "Lnet/corda/testing/node/InMemoryMessagingNetwork;", "sendManuallyPumped", "", "servicePeerAllocationStrategy", "Lnet/corda/testing/node/InMemoryMessagingNetwork$ServicePeerAllocationStrategy;", "messagesInFlight", "Lorg/apache/activemq/artemis/utils/ReusableLatch;", "create$node_driver", "node-driver"})
    public static final class Companion {
        @CordaInternal
        @NotNull
        public final InMemoryMessagingNetwork create$node_driver(boolean sendManuallyPumped, @NotNull ServicePeerAllocationStrategy servicePeerAllocationStrategy, @NotNull ReusableLatch messagesInFlight) {
            Intrinsics.checkParameterIsNotNull((Object)servicePeerAllocationStrategy, (String)"servicePeerAllocationStrategy");
            Intrinsics.checkParameterIsNotNull((Object)messagesInFlight, (String)"messagesInFlight");
            return new InMemoryMessagingNetwork(sendManuallyPumped, servicePeerAllocationStrategy, messagesInFlight, null);
        }

        @CordaInternal
        @NotNull
        public static /* bridge */ /* synthetic */ InMemoryMessagingNetwork create$node_driver$default(Companion companion, boolean bl, ServicePeerAllocationStrategy servicePeerAllocationStrategy, ReusableLatch reusableLatch, int n, Object object) {
            if ((n & 2) != 0) {
                servicePeerAllocationStrategy = new ServicePeerAllocationStrategy.Random(null, 1, null);
            }
            if ((n & 4) != 0) {
                reusableLatch = new ReusableLatch();
            }
            return companion.create$node_driver(bl, servicePeerAllocationStrategy, reusableLatch);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

