/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.node.internal;

import co.paralleluniverse.fibers.instrument.JavaAgent;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.Statement;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import javax.sql.DataSource;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KFunction;
import kotlin.reflect.KProperty;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import net.corda.client.rpc.CordaRPCClient;
import net.corda.client.rpc.CordaRPCConnection;
import net.corda.client.rpc.RPCException;
import net.corda.common.validation.internal.Validated;
import net.corda.core.concurrent.ConcurrencyUtils;
import net.corda.core.concurrent.CordaFuture;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.identity.Party;
import net.corda.core.internal.InternalUtils;
import net.corda.core.internal.PathUtilsKt;
import net.corda.core.internal.ThreadBox;
import net.corda.core.internal.concurrent.CordaFutureImplKt;
import net.corda.core.internal.cordapp.ManifestUtilsKt;
import net.corda.core.messaging.ClientRpcSslOptions;
import net.corda.core.messaging.CordaRPCOps;
import net.corda.core.node.NetworkParameters;
import net.corda.core.node.NodeInfo;
import net.corda.core.node.NotaryInfo;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializationFactory;
import net.corda.core.utilities.ByteArrays;
import net.corda.core.utilities.ByteSequence;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.core.utilities.NetworkHostAndPort;
import net.corda.node.NodeRegistrationOption;
import net.corda.node.VersionInfo;
import net.corda.node.internal.AbstractNodeKt;
import net.corda.node.internal.DataSourceFactory;
import net.corda.node.internal.Node;
import net.corda.node.internal.NodeWithInfo;
import net.corda.node.services.Permissions;
import net.corda.node.services.config.ConfigHelper;
import net.corda.node.services.config.ConfigUtilitiesKt;
import net.corda.node.services.config.FlowOverride;
import net.corda.node.services.config.FlowOverrideConfig;
import net.corda.node.services.config.NetworkServicesConfig;
import net.corda.node.services.config.NodeConfiguration;
import net.corda.node.services.config.NodeConfigurationKt;
import net.corda.node.services.config.NotaryConfig;
import net.corda.node.services.config.rpc.NodeRpcOptions;
import net.corda.node.utilities.registration.HTTPNetworkRegistrationService;
import net.corda.node.utilities.registration.NetworkRegistrationService;
import net.corda.node.utilities.registration.NodeRegistrationConfiguration;
import net.corda.node.utilities.registration.NodeRegistrationHelper;
import net.corda.nodeapi.internal.DevIdentityGenerator;
import net.corda.nodeapi.internal.SignedNodeInfo;
import net.corda.nodeapi.internal.config.ConfigUtilities;
import net.corda.nodeapi.internal.crypto.X509KeyStore;
import net.corda.nodeapi.internal.network.NetworkParametersCopier;
import net.corda.nodeapi.internal.network.NodeInfoFilesCopier;
import net.corda.notary.experimental.raft.RaftConfig;
import net.corda.testing.core.TestConstants;
import net.corda.testing.driver.JmxPolicy;
import net.corda.testing.driver.NodeHandle;
import net.corda.testing.driver.NodeParameters;
import net.corda.testing.driver.NotaryHandle;
import net.corda.testing.driver.PortAllocation;
import net.corda.testing.driver.VerifierType;
import net.corda.testing.driver.WebserverHandle;
import net.corda.testing.driver.internal.InProcessImpl;
import net.corda.testing.driver.internal.NodeHandleInternal;
import net.corda.testing.driver.internal.OutOfProcessImpl;
import net.corda.testing.node.ClusterSpec;
import net.corda.testing.node.DatabaseSnapshot;
import net.corda.testing.node.NotarySpec;
import net.corda.testing.node.TestCordapp;
import net.corda.testing.node.User;
import net.corda.testing.node.internal.CompatibilityZoneParams;
import net.corda.testing.node.internal.CustomCordapp;
import net.corda.testing.node.internal.DriverDSLImpl;
import net.corda.testing.node.internal.DriverDSLImplKt;
import net.corda.testing.node.internal.DummyClusterSpec;
import net.corda.testing.node.internal.InProcessNode;
import net.corda.testing.node.internal.InternalDriverDSL;
import net.corda.testing.node.internal.InternalMockNetworkKt;
import net.corda.testing.node.internal.InternalTestUtilsKt;
import net.corda.testing.node.internal.ListenProcessDeathException;
import net.corda.testing.node.internal.NetworkVisibilityController;
import net.corda.testing.node.internal.NodeListenProcessDeathException;
import net.corda.testing.node.internal.ProcessUtilities;
import net.corda.testing.node.internal.SharedCompatibilityZoneParams;
import net.corda.testing.node.internal.ShutdownManager;
import net.corda.testing.node.internal.SplitCompatibilityZoneParams;
import net.corda.testing.node.internal.TestCordappInternal;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import rx.schedulers.Schedulers;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0098\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0010\u0018\u0000 \u00b0\u00012\u00020\u0001:\n\u00b0\u0001\u00b1\u0001\u00b2\u0001\u00b3\u0001\u00b4\u0001B\u00f5\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0010\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0006\u0012\u0006\u0010\u001b\u001a\u00020\u000b\u0012\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d\u0012\b\u0010\u001f\u001a\u0004\u0018\u00010\t\u0012\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\u0010\u0012\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\b\u0002\u0010\"\u001a\u00020\u000b\u0012\b\b\u0002\u0010#\u001a\u00020\u000b\u00a2\u0006\u0002\u0010$J\u0010\u0010g\u001a\u00020\t2\u0006\u0010h\u001a\u00020iH\u0016J\"\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020i2\u0006\u0010m\u001a\u00020n2\b\b\u0002\u0010o\u001a\u00020pH\u0002J\u001e\u0010q\u001a\b\u0012\u0004\u0012\u00020k0(2\u0006\u0010r\u001a\u00020k2\u0006\u0010s\u001a\u00020\u000bH\u0002J&\u0010t\u001a\b\u0012\u0004\u0012\u00020u0(2\u0006\u0010r\u001a\u00020k2\u000e\u0010v\u001a\n\u0012\u0006\b\u0001\u0012\u00020w0(H\u0002J\u0016\u0010x\u001a\b\u0012\u0004\u0012\u00020i0\u00102\u0006\u0010y\u001a\u00020\u0014H\u0002J\u000e\u0010z\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010H\u0002J@\u0010{\u001a\b\u0012\u0004\u0012\u0002H|0(\"\u0004\b\u0000\u0010|2\u0006\u0010}\u001a\u00020\u00072\u0006\u0010~\u001a\u00020\u007f2\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\u0010\u0010\u0082\u0001\u001a\u000b\u0012\u0006\u0012\u0004\u0018\u0001H|0\u0083\u0001H\u0016J\u001d\u0010\u0084\u0001\u001a\u00030\u0085\u00012\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\u0007\u0010\u0088\u0001\u001a\u00020wH\u0002J\u001d\u0010\u0089\u0001\u001a\u00020\u00072\u0007\u0010\u008a\u0001\u001a\u00020\u00072\t\b\u0002\u0010\u008b\u0001\u001a\u00020\u000bH\u0002J\n\u0010\u008c\u0001\u001a\u00030\u008d\u0001H\u0016J\n\u0010\u008e\u0001\u001a\u00030\u008d\u0001H\u0016J5\u0010\u008f\u0001\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020k\u0012\u0005\u0012\u00030\u0091\u00010\u0090\u00010\u00100(2\b\u0010\u0092\u0001\u001a\u00030\u0093\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0094\u0001\u001a\t\u0012\u0005\u0012\u00030\u0087\u00010(2\u0006\u0010m\u001a\u00020nH\u0016J*\u0010\u0094\u0001\u001a\t\u0012\u0005\u0012\u00030\u0087\u00010(2\u0006\u0010m\u001a\u00020n2\n\u0010\u0095\u0001\u001a\u0005\u0018\u00010\u0081\u0001H\u0016\u00a2\u0006\u0003\u0010\u0096\u0001JJ\u0010\u0097\u0001\u001a\t\u0012\u0005\u0012\u00030\u0087\u00010(2\u0006\u0010r\u001a\u00020k2\u0007\u0010\u0098\u0001\u001a\u00020p2\r\u0010\u0099\u0001\u001a\b\u0018\u00010OR\u00020\u00002\u0006\u0010m\u001a\u00020n2\n\u0010\u0095\u0001\u001a\u0005\u0018\u00010\u0081\u0001H\u0002\u00a2\u0006\u0003\u0010\u009a\u0001J+\u0010\u009b\u0001\u001a\b\u0012\u0004\u0012\u00020k0(2\u0006\u0010r\u001a\u00020k2\b\u0010\u0092\u0001\u001a\u00030\u0093\u00012\b\u0010\u009c\u0001\u001a\u00030\u009d\u0001H\u0002JQ\u0010\u009e\u0001\u001a\u0015\u0012\u0011\u0012\u000f\u0012\u000b\u0012\t\u0012\u0005\u0012\u00030\u0087\u00010\u00100(0\u00102\r\u0010\u009f\u0001\u001a\b\u0012\u0004\u0012\u00020k0\u00102\r\u0010\u0099\u0001\u001a\b\u0018\u00010OR\u00020\u00002\u0015\u0010\u00a0\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0006H\u0002J#\u0010\u00a1\u0001\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020k\u0012\u0005\u0012\u00030\u0091\u00010\u0090\u00010\u00100(H\u0002J7\u0010\u00a2\u0001\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020k\u0012\u0005\u0012\u00030\u0091\u00010\u0090\u00010(2\u0006\u0010y\u001a\u00020\u00142\b\u0010\u0092\u0001\u001a\u00030\u0093\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J0\u0010\u00a3\u0001\u001a\t\u0012\u0005\u0012\u00030\u008d\u00010(2\u0006\u0010r\u001a\u00020k2\u0010\b\u0002\u0010\u00a4\u0001\u001a\t\u0012\u0004\u0012\u00020\u00070\u00a5\u0001H\u0002\u00a2\u0006\u0003\u0010\u00a6\u0001J-\u0010\u00a7\u0001\u001a\u000f\u0012\u000b\u0012\t\u0012\u0005\u0012\u00030\u0087\u00010\u00100(2\u0006\u0010y\u001a\u00020\u00142\r\u0010\u0099\u0001\u001a\b\u0018\u00010OR\u00020\u0000H\u0002JC\u0010\u00a8\u0001\u001a\t\u0012\u0005\u0012\u00030\u0087\u00010(2\u0006\u0010r\u001a\u00020k2\r\u0010\u0099\u0001\u001a\b\u0018\u00010OR\u00020\u00002\u0006\u0010m\u001a\u00020n2\f\b\u0002\u0010\u0095\u0001\u001a\u0005\u0018\u00010\u0081\u0001H\u0002\u00a2\u0006\u0003\u0010\u00a9\u0001JL\u0010\u00aa\u0001\u001a\u000f\u0012\u000b\u0012\t\u0012\u0005\u0012\u00030\u0087\u00010\u00100(2\u0006\u0010r\u001a\u00020k2\u0006\u0010y\u001a\u00020\u00142\r\u0010\u0099\u0001\u001a\b\u0018\u00010OR\u00020\u00002\u0015\u0010\u00a0\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0006H\u0002J#\u0010\u00ab\u0001\u001a\t\u0012\u0005\u0012\u00030\u0085\u00010(2\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\u0007\u0010\u00ac\u0001\u001a\u00020\u0007H\u0016J\r\u0010\u00ad\u0001\u001a\u00020k*\u00020kH\u0002J\u0016\u0010\u00ae\u0001\u001a\u00020k*\u00020k2\u0007\u0010\u00af\u0001\u001a\u00020\u000bH\u0002R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0\u00100(X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001d\u0010.\u001a\u0004\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u00102\u001a\u0004\b/\u00100R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0016\u00105\u001a\u0004\u0018\u000106X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0019\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u0013\u0010\u001f\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010>R\u001d\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0011\u0010D\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010@R\u0014\u0010H\u001a\b\u0012\u0004\u0012\u00020J0IX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010-R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010-R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010MR\u001a\u0010N\u001a\u000e\u0012\n\u0012\b\u0018\u00010OR\u00020\u00000(X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u0010QR\u000e\u0010R\u001a\u00020SX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u0010CR\u001a\u0010U\u001a\b\u0012\u0004\u0012\u00020)0\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bV\u0010@R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010@R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010<R\u0011\u0010#\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010-R\u001b\u0010Z\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\\\u00102\u001a\u0004\b[\u00100R\u0014\u0010]\u001a\u00020+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b^\u0010_R\u0011\u0010\r\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b`\u0010-R\u0014\u0010a\u001a\b\u0012\u0004\u0012\u00020c0bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\bd\u0010CR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\be\u0010-R\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\bf\u0010-\u00a8\u0006\u00b5\u0001"}, d2={"Lnet/corda/testing/node/internal/DriverDSLImpl;", "Lnet/corda/testing/node/internal/InternalDriverDSL;", "portAllocation", "Lnet/corda/testing/driver/PortAllocation;", "debugPortAllocation", "systemProperties", "", "", "driverDirectory", "Ljava/nio/file/Path;", "useTestClock", "", "isDebug", "startNodesInProcess", "waitForAllNodesToFinish", "extraCordappPackagesToScan", "", "jmxPolicy", "Lnet/corda/testing/driver/JmxPolicy;", "notarySpecs", "Lnet/corda/testing/node/NotarySpec;", "compatibilityZone", "Lnet/corda/testing/node/internal/CompatibilityZoneParams;", "networkParameters", "Lnet/corda/core/node/NetworkParameters;", "notaryCustomOverrides", "", "inMemoryDB", "cordappsForAllNodes", "", "Lnet/corda/testing/node/internal/TestCordappInternal;", "djvmBootstrapSource", "djvmCordaSource", "environmentVariables", "allowHibernateToManageAppSchema", "premigrateH2Database", "(Lnet/corda/testing/driver/PortAllocation;Lnet/corda/testing/driver/PortAllocation;Ljava/util/Map;Ljava/nio/file/Path;ZZZZLjava/util/List;Lnet/corda/testing/driver/JmxPolicy;Ljava/util/List;Lnet/corda/testing/node/internal/CompatibilityZoneParams;Lnet/corda/core/node/NetworkParameters;Ljava/util/Map;ZLjava/util/Collection;Ljava/nio/file/Path;Ljava/util/List;Ljava/util/Map;ZZ)V", "_executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "_notaries", "Lnet/corda/core/concurrent/CordaFuture;", "Lnet/corda/testing/driver/NotaryHandle;", "_shutdownManager", "Lnet/corda/testing/node/internal/ShutdownManager;", "getAllowHibernateToManageAppSchema", "()Z", "bytemanJarPath", "getBytemanJarPath", "()Ljava/lang/String;", "bytemanJarPath$delegate", "Lkotlin/Lazy;", "getCompatibilityZone", "()Lnet/corda/testing/node/internal/CompatibilityZoneParams;", "cordappsClassLoader", "Ljava/net/URLClassLoader;", "getCordappsClassLoader", "()Ljava/net/URLClassLoader;", "getCordappsForAllNodes", "()Ljava/util/Collection;", "getDebugPortAllocation", "()Lnet/corda/testing/driver/PortAllocation;", "getDjvmBootstrapSource", "()Ljava/nio/file/Path;", "getDjvmCordaSource", "()Ljava/util/List;", "getDriverDirectory", "getEnvironmentVariables", "()Ljava/util/Map;", "executorService", "getExecutorService", "()Ljava/util/concurrent/ScheduledExecutorService;", "getExtraCordappPackagesToScan", "extraCustomCordapps", "", "Lnet/corda/testing/node/internal/CustomCordapp;", "getInMemoryDB", "getJmxPolicy", "()Lnet/corda/testing/driver/JmxPolicy;", "networkMapAvailability", "Lnet/corda/testing/node/internal/DriverDSLImpl$LocalNetworkMap;", "getNetworkParameters", "()Lnet/corda/core/node/NetworkParameters;", "networkVisibilityController", "Lnet/corda/testing/node/internal/NetworkVisibilityController;", "getNotaryCustomOverrides", "notaryHandles", "getNotaryHandles", "getNotarySpecs", "getPortAllocation", "getPremigrateH2Database", "quasarJarPath", "getQuasarJarPath", "quasarJarPath$delegate", "shutdownManager", "getShutdownManager", "()Lnet/corda/testing/node/internal/ShutdownManager;", "getStartNodesInProcess", "state", "Lnet/corda/core/internal/ThreadBox;", "Lnet/corda/testing/node/internal/DriverDSLImpl$State;", "getSystemProperties", "getUseTestClock", "getWaitForAllNodesToFinish", "baseDirectory", "nodeName", "Lnet/corda/core/identity/CordaX500Name;", "createConfig", "Lnet/corda/testing/node/internal/DriverDSLImpl$NodeConfig;", "providedName", "parameters", "Lnet/corda/testing/driver/NodeParameters;", "p2pAddress", "Lnet/corda/core/utilities/NetworkHostAndPort;", "createSchema", "config", "hibernateForAppSchema", "establishRpc", "Lnet/corda/core/messaging/CordaRPCOps;", "processDeathFuture", "Ljava/lang/Process;", "generateNodeNames", "spec", "getCallerPackage", "pollUntilNonNull", "A", "pollName", "pollInterval", "Ljava/time/Duration;", "warnCount", "", "check", "Lkotlin/Function0;", "queryWebserver", "Lnet/corda/testing/driver/WebserverHandle;", "handle", "Lnet/corda/testing/driver/NodeHandle;", "process", "resolveJar", "className", "verbose", "shutdown", "", "start", "startAllNotaryRegistrations", "Lkotlin/Pair;", "Lnet/corda/core/node/NotaryInfo;", "rootCert", "Ljava/security/cert/X509Certificate;", "startNode", "bytemanPort", "(Lnet/corda/testing/driver/NodeParameters;Ljava/lang/Integer;)Lnet/corda/core/concurrent/CordaFuture;", "startNodeInternal", "webAddress", "localNetworkMap", "(Lnet/corda/testing/node/internal/DriverDSLImpl$NodeConfig;Lnet/corda/core/utilities/NetworkHostAndPort;Lnet/corda/testing/node/internal/DriverDSLImpl$LocalNetworkMap;Lnet/corda/testing/driver/NodeParameters;Ljava/lang/Integer;)Lnet/corda/core/concurrent/CordaFuture;", "startNodeRegistration", "networkServicesConfig", "Lnet/corda/node/services/config/NetworkServicesConfig;", "startNotaries", "configs", "customOverrides", "startNotaryIdentityGeneration", "startNotaryRegistration", "startOutOfProcessMiniNode", "extraCmdLineFlag", "", "(Lnet/corda/testing/node/internal/DriverDSLImpl$NodeConfig;[Ljava/lang/String;)Lnet/corda/core/concurrent/CordaFuture;", "startRaftNotaryCluster", "startRegisteredNode", "(Lnet/corda/testing/node/internal/DriverDSLImpl$NodeConfig;Lnet/corda/testing/node/internal/DriverDSLImpl$LocalNetworkMap;Lnet/corda/testing/driver/NodeParameters;Ljava/lang/Integer;)Lnet/corda/core/concurrent/CordaFuture;", "startSingleNotary", "startWebserver", "maximumHeapSize", "checkAndOverrideForInMemoryDB", "withNotaryDefinition", "validating", "Companion", "LocalNetworkMap", "NodeConfig", "State", "Waitable", "node-driver"})
public final class DriverDSLImpl
implements InternalDriverDSL {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private ScheduledExecutorService _executorService;
    private ShutdownManager _shutdownManager;
    private Set<CustomCordapp> extraCustomCordapps;
    private final NetworkVisibilityController networkVisibilityController;
    private CordaFuture<LocalNetworkMap> networkMapAvailability;
    private CordaFuture<List<NotaryHandle>> _notaries;
    @Nullable
    private final URLClassLoader cordappsClassLoader;
    private final ThreadBox<State> state;
    private final Lazy quasarJarPath$delegate;
    private final Lazy bytemanJarPath$delegate;
    @NotNull
    private final PortAllocation portAllocation;
    @NotNull
    private final PortAllocation debugPortAllocation;
    @NotNull
    private final Map<String, String> systemProperties;
    @NotNull
    private final Path driverDirectory;
    private final boolean useTestClock;
    private final boolean isDebug;
    private final boolean startNodesInProcess;
    private final boolean waitForAllNodesToFinish;
    @NotNull
    private final List<String> extraCordappPackagesToScan;
    @NotNull
    private final JmxPolicy jmxPolicy;
    @NotNull
    private final List<NotarySpec> notarySpecs;
    @Nullable
    private final CompatibilityZoneParams compatibilityZone;
    @NotNull
    private final NetworkParameters networkParameters;
    @NotNull
    private final Map<String, Object> notaryCustomOverrides;
    private final boolean inMemoryDB;
    @Nullable
    private final Collection<TestCordappInternal> cordappsForAllNodes;
    @Nullable
    private final Path djvmBootstrapSource;
    @NotNull
    private final List<Path> djvmCordaSource;
    @NotNull
    private final Map<String, String> environmentVariables;
    private final boolean allowHibernateToManageAppSchema;
    private final boolean premigrateH2Database;
    private static final Duration RPC_CONNECT_POLL_INTERVAL;
    @NotNull
    private static final Logger log;
    private static final AtomicInteger inMemoryCounter;
    private static final Duration notaryHandleTimeout;
    private static final List<Map<String, Object>> defaultRpcUserList;
    private static final CordaX500Name[] names;
    private static final Set<String> DRIVER_REQUIRED_PERMISSIONS;
    private static final String CORDA_TESTING_ATTRIBUTE = "Corda-Testing";
    private static final List<String> CORDAPP_MANIFEST_ATTRIBUTES;
    private static final Set<String> propertiesInScope;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DriverDSLImpl.class), "quasarJarPath", "getQuasarJarPath()Ljava/lang/String;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DriverDSLImpl.class), "bytemanJarPath", "getBytemanJarPath()Ljava/lang/String;"))};
        Companion = new Companion(null);
        RPC_CONNECT_POLL_INTERVAL = KotlinUtilsKt.getMillis((int)100);
        log = KotlinUtilsKt.contextLogger((Object)Companion);
        inMemoryCounter = new AtomicInteger();
        notaryHandleTimeout = Duration.ofMinutes(1L);
        defaultRpcUserList = CollectionsKt.listOf((Object)ConfigUtilities.toConfig((Object)new net.corda.nodeapi.internal.config.User("default", "default", SetsKt.setOf((Object)"ALL"))).root().unwrapped());
        names = new CordaX500Name[]{TestConstants.ALICE_NAME, TestConstants.BOB_NAME, TestConstants.DUMMY_BANK_A_NAME};
        DRIVER_REQUIRED_PERMISSIONS = SetsKt.setOf((Object[])new String[]{Permissions.Companion.invokeRpc((KFunction)Companion.DRIVER_REQUIRED_PERMISSIONS.1.INSTANCE), Permissions.Companion.invokeRpc((KFunction)Companion.DRIVER_REQUIRED_PERMISSIONS.2.INSTANCE), Permissions.Companion.invokeRpc((KFunction)Companion.DRIVER_REQUIRED_PERMISSIONS.3.INSTANCE), Permissions.Companion.invokeRpc((KFunction)Companion.DRIVER_REQUIRED_PERMISSIONS.4.INSTANCE), Permissions.Companion.invokeRpc((KFunction)Companion.DRIVER_REQUIRED_PERMISSIONS.5.INSTANCE), Permissions.Companion.invokeRpc((KFunction)Companion.DRIVER_REQUIRED_PERMISSIONS.6.INSTANCE), Permissions.Companion.invokeRpc((KFunction)Companion.DRIVER_REQUIRED_PERMISSIONS.7.INSTANCE), Permissions.Companion.invokeRpc((KFunction)Companion.DRIVER_REQUIRED_PERMISSIONS.8.INSTANCE), Permissions.Companion.invokeRpc((KFunction)Companion.DRIVER_REQUIRED_PERMISSIONS.9.INSTANCE), Permissions.Companion.invokeRpc("vaultQueryBy"), Permissions.Companion.invokeRpc("vaultTrackBy"), Permissions.Companion.invokeRpc((KFunction)Companion.DRIVER_REQUIRED_PERMISSIONS.10.INSTANCE), Permissions.Companion.invokeRpc((KFunction)Companion.DRIVER_REQUIRED_PERMISSIONS.11.INSTANCE)});
        List list = Collections.unmodifiableList(CollectionsKt.listOf((Object[])new String[]{"Cordapp-Contract-Name", "Cordapp-Contract-Licence", "Cordapp-Contract-Vendor", "Cordapp-Contract-Version", "Cordapp-Workflow-Name", "Cordapp-Workflow-Licence", "Cordapp-Workflow-Vendor", "Cordapp-Workflow-Version"}));
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"unmodifiableList(listOf(\u2026RKFLOW_VERSION\n        ))");
        CORDAPP_MANIFEST_ATTRIBUTES = list;
        propertiesInScope = SetsKt.setOf((Object)"java.io.tmpdir");
    }

    @NotNull
    public final ScheduledExecutorService getExecutorService() {
        ScheduledExecutorService scheduledExecutorService = this._executorService;
        if (scheduledExecutorService == null) {
            Intrinsics.throwNpe();
        }
        return scheduledExecutorService;
    }

    @Override
    @NotNull
    public ShutdownManager getShutdownManager() {
        ShutdownManager shutdownManager = this._shutdownManager;
        if (shutdownManager == null) {
            Intrinsics.throwNpe();
        }
        return shutdownManager;
    }

    @Override
    @NotNull
    public List<NotaryHandle> getNotaryHandles() {
        CordaFuture<List<NotaryHandle>> cordaFuture = this._notaries;
        if (cordaFuture == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_notaries");
        }
        return (List)KotlinUtilsKt.getOrThrow$default((Future)((Future)cordaFuture), null, (int)1, null);
    }

    @Override
    @Nullable
    public URLClassLoader getCordappsClassLoader() {
        return this.cordappsClassLoader;
    }

    private final String getQuasarJarPath() {
        Lazy lazy = this.quasarJarPath$delegate;
        DriverDSLImpl driverDSLImpl = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (String)lazy.getValue();
    }

    private final String getBytemanJarPath() {
        Lazy lazy = this.bytemanJarPath$delegate;
        DriverDSLImpl driverDSLImpl = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (String)lazy.getValue();
    }

    private final NodeConfig checkAndOverrideForInMemoryDB(@NotNull NodeConfig $receiver) {
        NodeConfig nodeConfig;
        NodeConfig nodeConfig2;
        NodeConfig $receiver2 = nodeConfig2 = $receiver;
        if (this.inMemoryDB && DriverDSLImpl.Companion.isH2Database($receiver2.getCorda())) {
            String jdbcUrl = "jdbc:h2:mem:persistence" + inMemoryCounter.getAndIncrement() + ";DB_CLOSE_ON_EXIT=FALSE;LOCK_TIMEOUT=10000;WRITE_DELAY=100";
            $receiver2.getCorda().getDataSourceProperties().setProperty("dataSource.url", jdbcUrl);
            nodeConfig = new NodeConfig(ConfigUtilitiesKt.plus((Config)$receiver2.getTypesafe(), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"dataSourceProperties", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"dataSource.url", (Object)jdbcUrl))))));
        } else {
            nodeConfig = $receiver2;
        }
        return nodeConfig;
    }

    private final String resolveJar(String className, boolean verbose) {
        String string;
        try {
            CodeSource src;
            Class<?> type;
            Class<?> clazz = type = Class.forName(className);
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"type");
            ProtectionDomain protectionDomain = clazz.getProtectionDomain();
            Intrinsics.checkExpressionValueIsNotNull((Object)protectionDomain, (String)"type.protectionDomain");
            CodeSource codeSource = src = protectionDomain.getCodeSource();
            Intrinsics.checkExpressionValueIsNotNull((Object)codeSource, (String)"src");
            URL uRL = codeSource.getLocation();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"src.location");
            string = ((Object)InternalUtils.toPath((URL)uRL)).toString();
        }
        catch (Exception e) {
            boolean bl = verbose;
            if (bl) {
                log.warn("Unable to locate JAR for class given by `" + className + "` on classpath:", (Throwable)e);
            } else if (!bl) {
                log.info("Unable to locate JAR for class given by `" + className + "` on classpath");
            }
            throw (Throwable)e;
        }
        return string;
    }

    static /* bridge */ /* synthetic */ String resolveJar$default(DriverDSLImpl driverDSLImpl, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return driverDSLImpl.resolveJar(string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Closeable closeable = this.getCordappsClassLoader();
        Throwable throwable = null;
        try {
            URLClassLoader $noName_0 = (URLClassLoader)closeable;
            if (this.waitForAllNodesToFinish) {
                ThreadBox<State> this_$iv = this.state;
                Lock lock = this_$iv.getLock();
                lock.lock();
                try {
                    State $receiver = (State)this_$iv.getContent();
                    Iterable $receiver$iv = $receiver.getProcesses();
                    for (Object element$iv : $receiver$iv) {
                        Waitable it = (Waitable)element$iv;
                        it.waitFor();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }
            ShutdownManager shutdownManager = this._shutdownManager;
            if (shutdownManager != null) {
                shutdownManager.shutdown();
            }
            ScheduledExecutorService scheduledExecutorService = this._executorService;
            List<Runnable> list = scheduledExecutorService != null ? scheduledExecutorService.shutdownNow() : null;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final CordaFuture<CordaRPCOps> establishRpc(NodeConfig config2, CordaFuture<? extends Process> processDeathFuture2) {
        NetworkHostAndPort rpcAddress = config2.getCorda().getRpcOptions().getAddress();
        ClientRpcSslOptions clientRpcSslOptions = AbstractNodeKt.clientSslOptionsCompatibleWith((NodeRpcOptions)config2.getCorda().getRpcOptions());
        CordaRPCClient client = new CordaRPCClient(rpcAddress, clientRpcSslOptions, null, 4, null);
        CordaFuture connectionFuture2 = InternalTestUtilsKt.poll$default(this.getExecutorService(), "RPC connection", RPC_CONNECT_POLL_INTERVAL, 0, (Function0)new Function0<CordaRPCConnection>(config2, client, processDeathFuture2, rpcAddress){
            final /* synthetic */ NodeConfig $config;
            final /* synthetic */ CordaRPCClient $client;
            final /* synthetic */ CordaFuture $processDeathFuture;
            final /* synthetic */ NetworkHostAndPort $rpcAddress;

            @Nullable
            public final CordaRPCConnection invoke() {
                Object object;
                try {
                    object = this.$config.getCorda().getRpcUsers().get(0);
                    net.corda.nodeapi.internal.config.User $receiver = (net.corda.nodeapi.internal.config.User)object;
                    object = CordaRPCClient.start$default((CordaRPCClient)this.$client, (String)$receiver.getUsername(), (String)$receiver.getPassword(), null, (int)4, null);
                }
                catch (RPCException e) {
                    if (this.$processDeathFuture.isDone()) {
                        throw (Throwable)e;
                    }
                    DriverDSLImpl.Companion.getLog$node_driver().info("Failed to connect to RPC at " + this.$rpcAddress);
                    object = null;
                }
                return object;
            }
            {
                this.$config = nodeConfig;
                this.$client = cordaRPCClient;
                this.$processDeathFuture = cordaFuture;
                this.$rpcAddress = networkHostAndPort;
                super(0);
            }
        }, 8, null);
        return ConcurrencyUtils.firstOf((CordaFuture[])new CordaFuture[]{connectionFuture2, processDeathFuture2}, (Function1)((Function1)new Function1<CordaFuture<? extends Object>, CordaRPCOps>(this, processDeathFuture2, rpcAddress, connectionFuture2){
            final /* synthetic */ DriverDSLImpl this$0;
            final /* synthetic */ CordaFuture $processDeathFuture;
            final /* synthetic */ NetworkHostAndPort $rpcAddress;
            final /* synthetic */ CordaFuture $connectionFuture;

            @NotNull
            public final CordaRPCOps invoke(@NotNull CordaFuture<? extends Object> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                if (Intrinsics.areEqual(it, (Object)this.$processDeathFuture)) {
                    throw (Throwable)((Object)new ListenProcessDeathException(this.$rpcAddress, (Process)KotlinUtilsKt.getOrThrow$default((Future)((Future)this.$processDeathFuture), null, (int)1, null)));
                }
                CordaRPCConnection connection = (CordaRPCConnection)KotlinUtilsKt.getOrThrow$default((Future)((Future)this.$connectionFuture), null, (int)1, null);
                this.this$0.getShutdownManager().registerShutdown((Function0<Unit>)((Function0)new Function0<Unit>(connection){

                    public final void invoke() {
                        ((CordaRPCConnection)this.receiver).close();
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(CordaRPCConnection.class);
                    }

                    public final String getName() {
                        return "close";
                    }

                    public final String getSignature() {
                        return "close()V";
                    }
                }));
                return connection.getProxy();
            }
            {
                this.this$0 = driverDSLImpl;
                this.$processDeathFuture = cordaFuture;
                this.$rpcAddress = networkHostAndPort;
                this.$connectionFuture = cordaFuture2;
                super(1);
            }
        }));
    }

    @Override
    @NotNull
    public CordaFuture<NodeHandle> startNode(@NotNull NodeParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        return this.startNode(parameters, null);
    }

    @Override
    @NotNull
    public CordaFuture<NodeHandle> startNode(@NotNull NodeParameters parameters, @Nullable Integer bytemanPort) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        NetworkHostAndPort p2pAddress = this.portAllocation.nextHostAndPort();
        CordaX500Name cordaX500Name = parameters.getProvidedName();
        if (cordaX500Name == null) {
            cordaX500Name = new CordaX500Name(((CordaX500Name)DriverDSLImpl.Companion.oneOf(DriverDSLImpl.names)).getOrganisation() + '-' + p2pAddress.getPort(), "London", "GB");
        }
        CordaX500Name name = cordaX500Name;
        NodeConfig config2 = this.createConfig(name, parameters, p2pAddress);
        if (DriverDSLImpl.Companion.isH2Database(config2) && !this.inMemoryDB) {
            if (this.premigrateH2Database) {
                try {
                    DatabaseSnapshot.INSTANCE.copyDatabaseSnapshot(config2.getCorda().getBaseDirectory());
                }
                catch (FileAlreadyExistsException ex) {
                    log.warn("Database already exists on disk, not attempting to pre-migrate database.");
                }
            }
            this.getShutdownManager().registerShutdown((Function0<Unit>)((Function0)new Function0<Unit>(config2){
                final /* synthetic */ NodeConfig $config;

                public final void invoke() {
                    net.corda.testing.node.internal.DriverDSLImpl$Companion.access$shutdownAndDeleteDatabase(DriverDSLImpl.Companion, this.$config.getCorda());
                }
                {
                    this.$config = nodeConfig;
                    super(0);
                }
            }));
        }
        CompatibilityZoneParams compatibilityZoneParams = this.compatibilityZone;
        CordaFuture registrationFuture2 = (compatibilityZoneParams != null ? compatibilityZoneParams.getRootCert() : null) != null ? CordaFutureImplKt.flatMap(this.createSchema(config2, false), (Function1)((Function1)new Function1<NodeConfig, CordaFuture<NodeConfig>>(this){
            final /* synthetic */ DriverDSLImpl this$0;

            @NotNull
            public final CordaFuture<NodeConfig> invoke(@NotNull NodeConfig it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return DriverDSLImpl.access$startNodeRegistration(this.this$0, it, this.this$0.getCompatibilityZone().getRootCert(), this.this$0.getCompatibilityZone().config());
            }
            {
                this.this$0 = driverDSLImpl;
                super(1);
            }
        })) : CordaFutureImplKt.doneFuture((Object)config2);
        return CordaFutureImplKt.flatMap((CordaFuture)registrationFuture2, (Function1)((Function1)new Function1<NodeConfig, CordaFuture<NodeHandle>>(this, parameters, bytemanPort){
            final /* synthetic */ DriverDSLImpl this$0;
            final /* synthetic */ NodeParameters $parameters;
            final /* synthetic */ Integer $bytemanPort;

            @NotNull
            public final CordaFuture<NodeHandle> invoke(@NotNull NodeConfig conf) {
                Intrinsics.checkParameterIsNotNull((Object)conf, (String)"conf");
                return CordaFutureImplKt.flatMap((CordaFuture)DriverDSLImpl.access$getNetworkMapAvailability$p(this.this$0), (Function1)((Function1)new Function1<LocalNetworkMap, CordaFuture<NodeHandle>>(this, conf){
                    final /* synthetic */ startNode.2 this$0;
                    final /* synthetic */ NodeConfig $conf;

                    @NotNull
                    public final CordaFuture<NodeHandle> invoke(@Nullable LocalNetworkMap networkMap) {
                        return DriverDSLImpl.access$startRegisteredNode(this.this$0.this$0, this.$conf, networkMap, this.this$0.$parameters, this.this$0.$bytemanPort);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$conf = nodeConfig;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = driverDSLImpl;
                this.$parameters = nodeParameters;
                this.$bytemanPort = n;
                super(1);
            }
        }));
    }

    private final CordaFuture<NodeHandle> startRegisteredNode(NodeConfig config2, LocalNetworkMap localNetworkMap, NodeParameters parameters, Integer bytemanPort) {
        NetworkHostAndPort webAddress = this.portAllocation.nextHostAndPort();
        return this.startNodeInternal(config2, webAddress, localNetworkMap, parameters, bytemanPort);
    }

    static /* bridge */ /* synthetic */ CordaFuture startRegisteredNode$default(DriverDSLImpl driverDSLImpl, NodeConfig nodeConfig, LocalNetworkMap localNetworkMap, NodeParameters nodeParameters, Integer n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = null;
        }
        return driverDSLImpl.startRegisteredNode(nodeConfig, localNetworkMap, nodeParameters, n);
    }

    /*
     * WARNING - void declaration
     */
    private final NodeConfig createConfig(CordaX500Name providedName, NodeParameters parameters, NetworkHostAndPort p2pAddress) {
        Collection<Map> collection;
        Object object;
        User it;
        Collection<FlowOverride> collection2;
        Iterable $receiver$iv$iv;
        void $receiver$iv;
        FlowOverrideConfig flowOverrideConfig;
        Map map2;
        Pair[] pairArray;
        void it2;
        Pair[] pairArray2;
        Object item$iv$iv;
        CompatibilityZoneParams $receiver$iv$iv2;
        Iterable $receiver$iv2;
        Path baseDirectory = PathUtilsKt.createDirectories((Path)this.baseDirectory(providedName), (FileAttribute[])new FileAttribute[0]);
        NetworkHostAndPort networkHostAndPort = parameters.getRpcAddress();
        if (networkHostAndPort == null) {
            networkHostAndPort = this.portAllocation.nextHostAndPort();
        }
        NetworkHostAndPort rpcAddress = networkHostAndPort;
        NetworkHostAndPort rpcAdminAddress = this.portAllocation.nextHostAndPort();
        Iterable iterable = $receiver$iv2 = (Iterable)parameters.getRpcUsers();
        Pair[] destination$iv$iv = (Pair[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        Iterator iterator = $receiver$iv$iv2.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            User user = (User)item$iv$iv;
            pairArray2 = destination$iv$iv;
            pairArray = User.copy$default((User)it2, null, null, SetsKt.plus(it2.getPermissions(), (Iterable)DRIVER_REQUIRED_PERMISSIONS), 3, null);
            pairArray2.add(pairArray);
        }
        List users = (List)destination$iv$iv;
        $receiver$iv$iv2 = this.compatibilityZone;
        if ($receiver$iv$iv2 == null) {
            map2 = MapsKt.emptyMap();
        } else if ($receiver$iv$iv2 instanceof SharedCompatibilityZoneParams) {
            map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"compatibilityZoneURL", (Object)this.compatibilityZone.doormanURL().toString()));
        } else if ($receiver$iv$iv2 instanceof SplitCompatibilityZoneParams) {
            map2 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"networkServices.doormanURL", (Object)this.compatibilityZone.doormanURL().toString()), TuplesKt.to((Object)"networkServices.networkMapURL", (Object)this.compatibilityZone.networkMapURL().toString())});
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Map czUrlConfig = map2;
        Integer jmxPort = this.jmxPolicy.getStartJmxHttpServer() ? Integer.valueOf(this.jmxPolicy.getJmxHttpServerPortAllocation().nextPort()) : null;
        Map jmxConfig = jmxPort != null ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"jmxMonitoringHttpPort", (Object)jmxPort)) : MapsKt.emptyMap();
        item$iv$iv = parameters.getFlowOverrides();
        pairArray = flowOverrideConfig;
        pairArray2 = flowOverrideConfig;
        it2 = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList($receiver$iv.size());
        void $i$f$mapTo = $receiver$iv$iv;
        Iterator iterator2 = $i$f$mapTo.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv2;
            Map.Entry entry = item$iv$iv2 = iterator2.next();
            collection2 = destination$iv$iv2;
            String string = ((Class)it.getKey()).getCanonicalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.key.canonicalName");
            String string2 = ((Class)it.getValue()).getCanonicalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.value.canonicalName");
            object = new FlowOverride(string, string2);
            collection2.add((FlowOverride)object);
        }
        collection2 = (List)destination$iv$iv2;
        pairArray((List)collection2);
        Pair[] flowOverrideConfig2 = pairArray2;
        Pair[] pairArray3 = new Pair[9];
        pairArray3[0] = TuplesKt.to((Object)"myLegalName", (Object)providedName.toString());
        pairArray3[1] = TuplesKt.to((Object)"p2pAddress", (Object)p2pAddress.toString());
        pairArray3[2] = TuplesKt.to((Object)"rpcSettings.address", (Object)rpcAddress.toString());
        pairArray3[3] = TuplesKt.to((Object)"rpcSettings.adminAddress", (Object)rpcAdminAddress.toString());
        pairArray3[4] = TuplesKt.to((Object)"useTestClock", (Object)this.useTestClock);
        Pair[] pairArray4 = pairArray3;
        Pair[] pairArray5 = pairArray3;
        int n = 5;
        String string = "rpcUsers";
        if (users.isEmpty()) {
            collection = defaultRpcUserList;
        } else {
            Collection<Map> collection3;
            void $receiver$iv$iv3;
            void $receiver$iv3;
            $receiver$iv$iv = users;
            object = string;
            int n2 = n;
            pairArray = pairArray4;
            pairArray2 = pairArray5;
            destination$iv$iv2 = $receiver$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
            for (Map.Entry item$iv$iv2 : $receiver$iv$iv3) {
                it = (User)((Object)item$iv$iv2);
                collection3 = destination$iv$iv3;
                Map map3 = ConfigUtilities.toConfig((Object)it).root().unwrapped();
                collection3.add(map3);
            }
            collection3 = (List)destination$iv$iv3;
            pairArray5 = pairArray2;
            pairArray4 = pairArray;
            n = n2;
            string = object;
            collection = collection3;
        }
        pairArray4[n] = TuplesKt.to((Object)string, collection);
        pairArray5[6] = TuplesKt.to((Object)"verifierType", (Object)parameters.getVerifierType().name());
        pairArray5[7] = TuplesKt.to((Object)"flowOverrides", (Object)ConfigUtilities.toConfig((Object)flowOverrideConfig2).root().unwrapped());
        pairArray5[8] = TuplesKt.to((Object)"additionalNodeInfoPollingFrequencyMsec", (Object)1000);
        Config overrides = ConfigUtilitiesKt.plus((Config)ConfigUtilitiesKt.plus((Config)ConfigUtilitiesKt.plus((Config)ConfigUtilitiesKt.configOf((Pair[])pairArray5), (Map)czUrlConfig), (Map)jmxConfig), parameters.getCustomOverrides());
        return this.checkAndOverrideForInMemoryDB(new NodeConfig(DriverDSLImpl.Companion.withDJVMConfig(ConfigHelper.loadConfig$default((ConfigHelper)ConfigHelper.INSTANCE, (Path)baseDirectory, null, (boolean)true, (Config)(overrides.hasPath("devMode") ? overrides : ConfigUtilitiesKt.plus((Config)overrides, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"devMode", (Object)true)))), (int)2, null), this.djvmBootstrapSource, this.djvmCordaSource)));
    }

    static /* bridge */ /* synthetic */ NodeConfig createConfig$default(DriverDSLImpl driverDSLImpl, CordaX500Name cordaX500Name, NodeParameters nodeParameters, NetworkHostAndPort networkHostAndPort, int n, Object object) {
        if ((n & 4) != 0) {
            networkHostAndPort = driverDSLImpl.portAllocation.nextHostAndPort();
        }
        return driverDSLImpl.createConfig(cordaX500Name, nodeParameters, networkHostAndPort);
    }

    /*
     * WARNING - void declaration
     */
    private final CordaFuture<NodeConfig> createSchema(NodeConfig config2, boolean hibernateForAppSchema) {
        void $receiver$iv;
        if (this.startNodesInProcess || this.inMemoryDB) {
            return CordaFutureImplKt.doneFuture((Object)config2);
        }
        Collection collection = CollectionsKt.listOfNotNull((Object[])new String[]{"run-migration-scripts", "--core-schemas", "--app-schemas", hibernateForAppSchema ? "--allow-hibernate-to-manage-app-schema" : null});
        NodeConfig nodeConfig = config2;
        DriverDSLImpl driverDSLImpl = this;
        void v0 = $receiver$iv;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v0;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray2 = stringArray;
        return CordaFutureImplKt.map(driverDSLImpl.startOutOfProcessMiniNode(nodeConfig, stringArray2), (Function1)((Function1)new Function1<Unit, NodeConfig>(config2){
            final /* synthetic */ NodeConfig $config;

            @NotNull
            public final NodeConfig invoke(@NotNull Unit it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$config;
            }
            {
                this.$config = nodeConfig;
                super(1);
            }
        }));
    }

    private final CordaFuture<NodeConfig> startNodeRegistration(NodeConfig config2, X509Certificate rootCert, NetworkServicesConfig networkServicesConfig) {
        VersionInfo versionInfo = new VersionInfo(11, "1", "1", "1");
        PathUtilsKt.createDirectories((Path)config2.getCorda().getCertificatesDirectory(), (FileAttribute[])new FileAttribute[0]);
        Path rootTruststorePath = PathUtilsKt.div((Path)config2.getCorda().getCertificatesDirectory(), (String)"network-root-truststore.jks");
        String rootTruststorePassword = "corda-root-password";
        X509KeyStore.Companion.fromFile(rootTruststorePath, rootTruststorePassword, true).update((Function1)new Function1<X509KeyStore, Unit>(rootCert){
            final /* synthetic */ X509Certificate $rootCert;

            public final void invoke(@NotNull X509KeyStore $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                $receiver.setCertificate("cordarootca", this.$rootCert);
            }
            {
                this.$rootCert = x509Certificate;
                super(1);
            }
        });
        return this.startNodesInProcess ? CordaFutureImplKt.fork((Executor)this.getExecutorService(), (Function0)((Function0)new Function0<NodeConfig>(config2, networkServicesConfig, versionInfo, rootTruststorePath, rootTruststorePassword){
            final /* synthetic */ NodeConfig $config;
            final /* synthetic */ NetworkServicesConfig $networkServicesConfig;
            final /* synthetic */ VersionInfo $versionInfo;
            final /* synthetic */ Path $rootTruststorePath;
            final /* synthetic */ String $rootTruststorePassword;

            @NotNull
            public final NodeConfig invoke() {
                NodeRegistrationHelper nodeRegistrationHelper;
                NodeRegistrationHelper $receiver = nodeRegistrationHelper = new NodeRegistrationHelper(new NodeRegistrationConfiguration(this.$config.getCorda()), (NetworkRegistrationService)new HTTPNetworkRegistrationService(this.$networkServicesConfig, this.$versionInfo, null, 4, null), new NodeRegistrationOption(this.$rootTruststorePath, this.$rootTruststorePassword), null, null, null, 56, null);
                $receiver.generateKeysAndRegister();
                $receiver.generateNodeIdentity();
                return this.$config;
            }
            {
                this.$config = nodeConfig;
                this.$networkServicesConfig = networkServicesConfig;
                this.$versionInfo = versionInfo;
                this.$rootTruststorePath = path;
                this.$rootTruststorePassword = string;
                super(0);
            }
        })) : CordaFutureImplKt.map(this.startOutOfProcessMiniNode(config2, new String[]{"initial-registration", "--network-root-truststore=" + rootTruststorePath.toAbsolutePath(), "--network-root-truststore-password=" + rootTruststorePassword}), (Function1)((Function1)new Function1<Unit, NodeConfig>(config2){
            final /* synthetic */ NodeConfig $config;

            @NotNull
            public final NodeConfig invoke(@NotNull Unit it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$config;
            }
            {
                this.$config = nodeConfig;
                super(1);
            }
        }));
    }

    private final WebserverHandle queryWebserver(NodeHandle handle, Process process) {
        NodeHandle nodeHandle = handle;
        if (nodeHandle == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.testing.driver.internal.NodeHandleInternal");
        }
        String protocol = ((NodeHandleInternal)nodeHandle).getUseHTTPS() ? "https://" : "http://";
        URL url = new URL(protocol + ((NodeHandleInternal)handle).getWebAddress() + "/api/status");
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).build();
        while (process.isAlive()) {
            try {
                Response response;
                Response response2 = response = client.newCall(new Request.Builder().url(url).build()).execute();
                Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
                if (!response2.isSuccessful()) continue;
                ResponseBody responseBody = response.body();
                if (!Intrinsics.areEqual((Object)(responseBody != null ? responseBody.string() : null), (Object)"started")) continue;
                return new WebserverHandle(((NodeHandleInternal)handle).getWebAddress(), process);
            }
            catch (ConnectException e) {
                log.debug("Retrying webserver info at " + ((NodeHandleInternal)handle).getWebAddress());
            }
        }
        throw (Throwable)new IllegalStateException("Webserver at " + ((NodeHandleInternal)handle).getWebAddress() + " has died");
    }

    @Override
    @NotNull
    public CordaFuture<WebserverHandle> startWebserver(@NotNull NodeHandle handle, @NotNull String maximumHeapSize) {
        Intrinsics.checkParameterIsNotNull((Object)handle, (String)"handle");
        Intrinsics.checkParameterIsNotNull((Object)maximumHeapSize, (String)"maximumHeapSize");
        Integer debugPort = this.isDebug ? Integer.valueOf(this.debugPortAllocation.nextPort()) : null;
        Process process = DriverDSLImpl.Companion.startWebserver((NodeHandleInternal)handle, debugPort, maximumHeapSize);
        this.getShutdownManager().registerProcessShutdown(process);
        CordaFuture<Unit> webReadyFuture = InternalTestUtilsKt.addressMustBeBoundFuture(this.getExecutorService(), ((NodeHandleInternal)handle).getWebAddress(), process);
        return CordaFutureImplKt.map(webReadyFuture, (Function1)((Function1)new Function1<Unit, WebserverHandle>(this, handle, process){
            final /* synthetic */ DriverDSLImpl this$0;
            final /* synthetic */ NodeHandle $handle;
            final /* synthetic */ Process $process;

            @NotNull
            public final WebserverHandle invoke(@NotNull Unit it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return DriverDSLImpl.access$queryWebserver(this.this$0, this.$handle, this.$process);
            }
            {
                this.this$0 = driverDSLImpl;
                this.$handle = nodeHandle;
                this.$process = process;
                super(1);
            }
        }));
    }

    @Override
    public void start() {
        CordaFuture cordaFuture;
        boolean bl;
        if (this.startNodesInProcess) {
            Schedulers.reset();
        }
        if (!(bl = this.networkParameters.getNotaries().isEmpty())) {
            String string = "Define notaries using notarySpecs";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this._executorService = Executors.newScheduledThreadPool(2, new ThreadFactoryBuilder().setNameFormat("driver-pool-thread-%d").build());
        this._shutdownManager = new ShutdownManager(this.getExecutorService());
        List callerPackage = CollectionsKt.toMutableList((Collection)this.getCallerPackage());
        String string = (String)CollectionsKt.firstOrNull((List)callerPackage);
        if (string != null) {
            if (StringsKt.startsWith$default((String)string, (String)"net.corda.node", (boolean)false, (int)2, null)) {
                callerPackage.add("net.corda.testing");
            }
        }
        this.extraCustomCordapps = InternalTestUtilsKt.cordappsForPackages(CollectionsKt.plus((Collection)this.extraCordappPackagesToScan, (Iterable)callerPackage));
        if (this.compatibilityZone == null) {
            cordaFuture = CordaFutureImplKt.map(this.startNotaryIdentityGeneration(), (Function1)((Function1)new Function1<List<? extends Pair<? extends NodeConfig, ? extends NotaryInfo>>, Pair<? extends List<? extends Pair<? extends NodeConfig, ? extends NotaryInfo>>, ? extends LocalNetworkMap>>(this){
                final /* synthetic */ DriverDSLImpl this$0;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Pair<List<Pair<NodeConfig, NotaryInfo>>, LocalNetworkMap> invoke(@NotNull List<Pair<NodeConfig, NotaryInfo>> notaryInfos) {
                    Collection<NotaryInfo> collection;
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    Pair pair;
                    LocalNetworkMap localNetworkMap;
                    Intrinsics.checkParameterIsNotNull(notaryInfos, (String)"notaryInfos");
                    Iterable iterable = notaryInfos;
                    DriverDSLImpl driverDSLImpl = this.this$0;
                    LocalNetworkMap localNetworkMap2 = localNetworkMap;
                    LocalNetworkMap localNetworkMap3 = localNetworkMap;
                    List<Pair<NodeConfig, NotaryInfo>> list = notaryInfos;
                    Pair pair2 = pair;
                    Pair pair3 = pair;
                    void var3_9 = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void it;
                        Pair pair4 = (Pair)item$iv$iv;
                        collection = destination$iv$iv;
                        NotaryInfo notaryInfo = (NotaryInfo)it.getSecond();
                        collection.add(notaryInfo);
                    }
                    collection = (List)destination$iv$iv;
                    localNetworkMap2((List<NotaryInfo>)collection);
                    pair2(list, (Object)localNetworkMap3);
                    return pair3;
                }
                {
                    this.this$0 = driverDSLImpl;
                    super(1);
                }
            }));
        } else {
            CordaFuture<List<Pair<NodeConfig, NotaryInfo>>> notaryInfosFuture2 = this.compatibilityZone.getRootCert() == null ? this.startNotaryIdentityGeneration() : this.startAllNotaryRegistrations(this.compatibilityZone.getRootCert(), this.compatibilityZone);
            cordaFuture = CordaFutureImplKt.map(notaryInfosFuture2, (Function1)((Function1)new Function1<List<? extends Pair<? extends NodeConfig, ? extends NotaryInfo>>, Pair>(this){
                final /* synthetic */ DriverDSLImpl this$0;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Pair invoke(@NotNull List<Pair<NodeConfig, NotaryInfo>> notaryInfos) {
                    Collection<NotaryInfo> collection;
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    Intrinsics.checkParameterIsNotNull(notaryInfos, (String)"notaryInfos");
                    Iterable iterable = notaryInfos;
                    Function1<List<NotaryInfo>, Unit> function1 = this.this$0.getCompatibilityZone().getPublishNotaries();
                    void var3_4 = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void it;
                        Pair pair = (Pair)item$iv$iv;
                        collection = destination$iv$iv;
                        NotaryInfo notaryInfo = (NotaryInfo)it.getSecond();
                        collection.add(notaryInfo);
                    }
                    collection = (List)destination$iv$iv;
                    function1.invoke((Object)collection);
                    return new Pair(notaryInfos, null);
                }
                {
                    this.this$0 = driverDSLImpl;
                    super(1);
                }
            }));
        }
        CordaFuture notaryInfosFuture3 = cordaFuture;
        this.networkMapAvailability = CordaFutureImplKt.map((CordaFuture)notaryInfosFuture3, (Function1)start.2.INSTANCE);
        this._notaries = CordaFutureImplKt.map((CordaFuture)notaryInfosFuture3, (Function1)((Function1)new Function1<Pair<? extends List<? extends Pair<? extends NodeConfig, ? extends NotaryInfo>>, ? extends LocalNetworkMap>, List<? extends NotaryHandle>>(this){
            final /* synthetic */ DriverDSLImpl this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<NotaryHandle> invoke(@NotNull Pair<? extends List<Pair<NodeConfig, NotaryInfo>>, LocalNetworkMap> $notaryInfos_localNetworkMap) {
                int n;
                Object object;
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull($notaryInfos_localNetworkMap, (String)"<name for destructuring parameter 0>");
                List notaryInfos = (List)$notaryInfos_localNetworkMap.component1();
                LocalNetworkMap localNetworkMap = (LocalNetworkMap)$notaryInfos_localNetworkMap.component2();
                Iterable iterable = notaryInfos;
                Object object2 = this.this$0;
                void var6_6 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    Pair pair = (Pair)item$iv$iv;
                    object = destination$iv$iv;
                    NodeConfig nodeConfig = (NodeConfig)it.getFirst();
                    object.add(nodeConfig);
                }
                object = (List)destination$iv$iv;
                List listOfFutureNodeHandles = DriverDSLImpl.access$startNotaries((DriverDSLImpl)object2, (List)object, localNetworkMap, this.this$0.getNotaryCustomOverrides());
                $receiver$iv = notaryInfos;
                Iterator<T> first$iv = $receiver$iv.iterator();
                Iterator<T> second$iv = ((Iterable)listOfFutureNodeHandles).iterator();
                int n2 = CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10);
                int n3 = CollectionsKt.collectionSizeOrDefault((Iterable)listOfFutureNodeHandles, (int)10);
                int n4 = n = Math.min(n2, n3);
                ArrayList<E> list$iv = new ArrayList<E>(n4);
                while (first$iv.hasNext() && second$iv.hasNext()) {
                    void nodeHandlesFuture;
                    void $$_$_notaryInfo;
                    CordaFuture $i$f$map = (CordaFuture)second$iv.next();
                    Pair pair = (Pair)first$iv.next();
                    object2 = list$iv;
                    NotaryInfo notaryInfo = (NotaryInfo)$$_$_notaryInfo.component2();
                    object = new NotaryHandle(notaryInfo.getIdentity(), notaryInfo.getValidating(), (CordaFuture<List<NodeHandle>>)nodeHandlesFuture);
                    ((ArrayList)object2).add(object);
                }
                return list$iv;
            }
            {
                this.this$0 = driverDSLImpl;
                super(1);
            }
        }));
        try {
            CordaFuture<List<NotaryHandle>> cordaFuture2 = this._notaries;
            if (cordaFuture2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"_notaries");
            }
            Iterable $receiver$iv = (Iterable)KotlinUtilsKt.getOrThrow((Future)((Future)CordaFutureImplKt.map(cordaFuture2, (Function1)start.4.INSTANCE)), (Duration)notaryHandleTimeout);
            for (Object element$iv : $receiver$iv) {
                CordaFuture future = (CordaFuture)element$iv;
                KotlinUtilsKt.getOrThrow((Future)((Future)future), (Duration)notaryHandleTimeout);
            }
        }
        catch (NodeListenProcessDeathException e) {
            CharSequence charSequence = e.getCauseFromStdError();
            String message = !StringsKt.isBlank((CharSequence)charSequence) ? "Unable to start notaries. Failed with the following error: " + e.getCauseFromStdError() : "Unable to start notaries. A required port might be bound already.";
            throw (Throwable)new IllegalStateException(message);
        }
        catch (ListenProcessDeathException e) {
            throw (Throwable)new IllegalStateException("Unable to start notaries. A required port might be bound already.", (Throwable)((Object)e));
        }
        catch (TimeoutException e) {
            throw (Throwable)new IllegalStateException("Unable to start notaries. A required port might be bound already.", e);
        }
    }

    private final List<String> getCallerPackage() {
        List list;
        int index;
        Object[] stackTrace;
        block4: {
            int n;
            if (this.cordappsForAllNodes != null) {
                return CollectionsKt.emptyList();
            }
            stackTrace = new Throwable().getStackTrace();
            Intrinsics.checkExpressionValueIsNotNull((Object)stackTrace, (String)"stackTrace");
            Object[] $receiver$iv = stackTrace;
            Iterator iterator = CollectionsKt.reversed((Iterable)((Iterable)ArraysKt.getIndices((Object[])$receiver$iv))).iterator();
            while (iterator.hasNext()) {
                Object it;
                int index$iv = ((Number)iterator.next()).intValue();
                Object object = it = $receiver$iv[index$iv];
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it");
                if (!Intrinsics.areEqual((Object)((StackTraceElement)object).getClassName(), (Object)"net.corda.testing.driver.Driver")) continue;
                n = index$iv;
                break block4;
            }
            n = index = -1;
        }
        if (index == -1) {
            list = CollectionsKt.emptyList();
        } else {
            Object object = stackTrace[index + 1];
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"stackTrace[index + 1]");
            Class<?> clazz = Class.forName(((StackTraceElement)object).getClassName());
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(stackTrace[index + 1].className)");
            list = CollectionsKt.listOf((Object)InternalUtils.getPackageName_(clazz));
        }
        return list;
    }

    private final CordaFuture<List<Pair<NodeConfig, NotaryInfo>>> startNotaryIdentityGeneration() {
        return CordaFutureImplKt.fork((Executor)this.getExecutorService(), (Function0)((Function0)new Function0<List<? extends Pair<? extends NodeConfig, ? extends NotaryInfo>>>(this){
            final /* synthetic */ DriverDSLImpl this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Pair<NodeConfig, NotaryInfo>> invoke() {
                void var3_3;
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)this.this$0.getNotarySpecs();
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    Path path;
                    CordaX500Name it;
                    Collection<Path> collection;
                    Iterable $receiver$iv$iv2;
                    Collection destination$iv$iv2;
                    Iterable $receiver$iv2;
                    DevIdentityGenerator devIdentityGenerator;
                    Party party;
                    void spec;
                    NotarySpec notarySpec = (NotarySpec)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    Map notaryConfig = MapsKt.mapOf((Pair)TuplesKt.to((Object)"notary", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"validating", (Object)spec.getValidating()))));
                    NodeParameters parameters = new NodeParameters(null, spec.getRpcUsers(), spec.getVerifierType(), MapsKt.plus((Map)notaryConfig, this.this$0.getNotaryCustomOverrides()), null, spec.getMaximumHeapSize(), null, null, null, null, 977, null);
                    NodeConfig config2 = DriverDSLImpl.createConfig$default(this.this$0, spec.getName(), parameters, null, 4, null);
                    ClusterSpec clusterSpec = spec.getCluster();
                    if (clusterSpec == null) {
                        party = DevIdentityGenerator.INSTANCE.installKeyStoreWithNodeIdentity(this.this$0.baseDirectory(spec.getName()), spec.getName());
                    } else if (clusterSpec instanceof ClusterSpec.Raft) {
                        Iterable iterable2 = DriverDSLImpl.access$generateNodeNames(this.this$0, (NotarySpec)spec);
                        devIdentityGenerator = DevIdentityGenerator.INSTANCE;
                        void var13_13 = $receiver$iv2;
                        destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                        for (T item$iv$iv2 : $receiver$iv$iv2) {
                            CordaX500Name cordaX500Name = (CordaX500Name)item$iv$iv2;
                            collection = destination$iv$iv2;
                            path = this.this$0.baseDirectory(it);
                            collection.add(path);
                        }
                        collection = (List)destination$iv$iv2;
                        party = devIdentityGenerator.generateDistributedNotarySingularIdentity((List)collection, spec.getName());
                    } else if (clusterSpec instanceof DummyClusterSpec) {
                        if (((DummyClusterSpec)spec.getCluster()).getCompositeServiceIdentity()) {
                            $receiver$iv2 = DriverDSLImpl.access$generateNodeNames(this.this$0, (NotarySpec)spec);
                            devIdentityGenerator = DevIdentityGenerator.INSTANCE;
                            $receiver$iv$iv2 = $receiver$iv2;
                            destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                            for (T item$iv$iv2 : $receiver$iv$iv2) {
                                it = (CordaX500Name)item$iv$iv2;
                                collection = destination$iv$iv2;
                                path = this.this$0.baseDirectory(it);
                                collection.add(path);
                            }
                            collection = (List)destination$iv$iv2;
                            party = devIdentityGenerator.generateDistributedNotarySingularIdentity(collection, spec.getName());
                        } else {
                            $receiver$iv2 = DriverDSLImpl.access$generateNodeNames(this.this$0, (NotarySpec)spec);
                            devIdentityGenerator = DevIdentityGenerator.INSTANCE;
                            $receiver$iv$iv2 = $receiver$iv2;
                            destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                            for (T item$iv$iv2 : $receiver$iv$iv2) {
                                it = (CordaX500Name)item$iv$iv2;
                                collection = destination$iv$iv2;
                                path = this.this$0.baseDirectory(it);
                                collection.add(path);
                            }
                            collection = (List)destination$iv$iv2;
                            party = DevIdentityGenerator.generateDistributedNotaryCompositeIdentity$default((DevIdentityGenerator)devIdentityGenerator, collection, (CordaX500Name)spec.getName(), (int)0, (int)4, null);
                        }
                    } else {
                        throw (Throwable)new UnsupportedOperationException("Cluster spec " + spec.getCluster() + " not supported by Driver");
                    }
                    Party identity = party;
                    Pair pair = new Pair((Object)config2, (Object)new NotaryInfo(identity, spec.getValidating()));
                    collection2.add(pair);
                }
                return (List)var3_3;
            }
            {
                this.this$0 = driverDSLImpl;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final CordaFuture<List<Pair<NodeConfig, NotaryInfo>>> startAllNotaryRegistrations(X509Certificate rootCert, CompatibilityZoneParams compatibilityZone) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.notarySpecs;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void spec;
            boolean bl;
            NotarySpec notarySpec = (NotarySpec)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = bl = spec.getCluster() == null;
            if (!bl) {
                String string = "Registering distributed notaries not supported";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            CordaFuture<Pair<NodeConfig, NotaryInfo>> cordaFuture = this.startNotaryRegistration((NotarySpec)spec, rootCert, compatibilityZone);
            collection.add(cordaFuture);
        }
        return CordaFutureImplKt.transpose((Collection)((List)destination$iv$iv));
    }

    private final CordaFuture<Pair<NodeConfig, NotaryInfo>> startNotaryRegistration(NotarySpec spec, X509Certificate rootCert, CompatibilityZoneParams compatibilityZone) {
        NodeParameters parameters = new NodeParameters(null, spec.getRpcUsers(), spec.getVerifierType(), this.notaryCustomOverrides, null, spec.getMaximumHeapSize(), null, null, null, null, 977, null);
        return CordaFutureImplKt.flatMap((CordaFuture)CordaFutureImplKt.flatMap(this.createSchema(DriverDSLImpl.createConfig$default(this, spec.getName(), parameters, null, 4, null), false), (Function1)((Function1)new Function1<NodeConfig, CordaFuture<NodeConfig>>(this, rootCert, compatibilityZone){
            final /* synthetic */ DriverDSLImpl this$0;
            final /* synthetic */ X509Certificate $rootCert;
            final /* synthetic */ CompatibilityZoneParams $compatibilityZone;

            @NotNull
            public final CordaFuture<NodeConfig> invoke(@NotNull NodeConfig config2) {
                Intrinsics.checkParameterIsNotNull((Object)config2, (String)"config");
                return DriverDSLImpl.access$startNodeRegistration(this.this$0, config2, this.$rootCert, this.$compatibilityZone.config());
            }
            {
                this.this$0 = driverDSLImpl;
                this.$rootCert = x509Certificate;
                this.$compatibilityZone = compatibilityZoneParams;
                super(1);
            }
        })), (Function1)((Function1)new Function1<NodeConfig, CordaFuture<Pair<? extends NodeConfig, ? extends NotaryInfo>>>(this, spec){
            final /* synthetic */ DriverDSLImpl this$0;
            final /* synthetic */ NotarySpec $spec;

            @NotNull
            public final CordaFuture<Pair<NodeConfig, NotaryInfo>> invoke(@NotNull NodeConfig config2) {
                Intrinsics.checkParameterIsNotNull((Object)config2, (String)"config");
                return this.this$0.getStartNodesInProcess() ? CordaFutureImplKt.fork((Executor)this.this$0.getExecutorService(), (Function0)((Function0)new Function0<Pair<? extends NodeConfig, ? extends NotaryInfo>>(this, config2){
                    final /* synthetic */ startNotaryRegistration.2 this$0;
                    final /* synthetic */ NodeConfig $config;

                    @NotNull
                    public final Pair<NodeConfig, NotaryInfo> invoke() {
                        NodeInfo nodeInfo = new Node(this.$config.getCorda(), InternalMockNetworkKt.getMOCK_VERSION_INFO(), false, null, null, null, null, false, 248, null).generateAndSaveNodeInfo();
                        return new Pair((Object)DriverDSLImpl.access$withNotaryDefinition(this.this$0.this$0, this.$config, this.this$0.$spec.getValidating()), (Object)new NotaryInfo((Party)nodeInfo.getLegalIdentities().get(0), this.this$0.$spec.getValidating()));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$config = nodeConfig;
                        super(0);
                    }
                })) : CordaFutureImplKt.map((CordaFuture)DriverDSLImpl.access$startOutOfProcessMiniNode(this.this$0, config2, new String[]{"generate-node-info"}), (Function1)((Function1)new Function1<Unit, Pair<? extends NodeConfig, ? extends NotaryInfo>>(this, config2){
                    final /* synthetic */ startNotaryRegistration.2 this$0;
                    final /* synthetic */ NodeConfig $config;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @NotNull
                    public final Pair<NodeConfig, NotaryInfo> invoke(@NotNull Unit it) {
                        byte[] $i$f$list;
                        Object nodeInfoFile2;
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        Path $receiver$iv = this.$config.getCorda().getBaseDirectory();
                        AutoCloseable autoCloseable = Files.list($receiver$iv);
                        Throwable throwable = null;
                        try {
                            Object paths = (Stream)autoCloseable;
                            paths = (Path)paths.filter(startNotaryRegistration.nodeInfoFile.1.1.INSTANCE).findFirst().get();
                        }
                        catch (Throwable paths) {
                            throwable = paths;
                            throw paths;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        }
                        Object object = nodeInfoFile2 = paths;
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"nodeInfoFile");
                        Object $receiver$iv2 = object;
                        byte[] $receiver$iv$iv = PathUtilsKt.readAll((Path)$receiver$iv2);
                        SerializationFactory serializationFactory$iv$iv = SerializationFactory.Companion.getDefaultFactory();
                        SerializationContext context$iv$iv = serializationFactory$iv$iv.getDefaultContext();
                        byte[] byArray = $i$f$list = $receiver$iv$iv;
                        boolean bl = $i$f$list = !(byArray.length == 0);
                        if (!$i$f$list) {
                            String string = "Empty bytes";
                            throw (Throwable)new IllegalArgumentException(string.toString());
                        }
                        ByteSequence $receiver$iv$iv$iv = ByteArrays.sequence$default((byte[])$receiver$iv$iv, (int)0, (int)0, (int)3, null);
                        NodeInfo nodeInfo = ((SignedNodeInfo)serializationFactory$iv$iv.deserialize($receiver$iv$iv$iv, SignedNodeInfo.class, context$iv$iv)).verified();
                        return new Pair((Object)DriverDSLImpl.access$withNotaryDefinition(this.this$0.this$0, this.$config, this.this$0.$spec.getValidating()), (Object)new NotaryInfo((Party)nodeInfo.getLegalIdentities().get(0), this.this$0.$spec.getValidating()));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$config = nodeConfig;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = driverDSLImpl;
                this.$spec = notarySpec;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final List<CordaX500Name> generateNodeNames(NotarySpec spec) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        ClusterSpec clusterSpec = spec.getCluster();
        if (clusterSpec == null) {
            Intrinsics.throwNpe();
        }
        Iterable iterable = $receiver$iv = (Iterable)RangesKt.until((int)0, (int)clusterSpec.getClusterSize());
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            CordaX500Name cordaX500Name = CordaX500Name.copy$default((CordaX500Name)spec.getName(), null, null, (String)(spec.getName().getOrganisation() + '-' + (int)it), null, null, null, (int)59, null);
            collection.add(cordaX500Name);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<CordaFuture<List<NodeHandle>>> startNotaries(List<NodeConfig> configs, LocalNetworkMap localNetworkMap, Map<String, ? extends Object> customOverrides) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.zip((Iterable)this.notarySpecs, (Iterable)configs);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            CordaFuture<List<NodeHandle>> cordaFuture;
            void $spec_config;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            NotarySpec spec = (NotarySpec)$spec_config.component1();
            NodeConfig config2 = (NodeConfig)$spec_config.component2();
            ClusterSpec clusterSpec = spec.getCluster();
            if (clusterSpec == null) {
                cordaFuture = this.startSingleNotary(config2, spec, localNetworkMap, customOverrides);
            } else if (clusterSpec instanceof ClusterSpec.Raft || clusterSpec instanceof DummyClusterSpec) {
                cordaFuture = this.startRaftNotaryCluster(spec, localNetworkMap);
            } else {
                throw (Throwable)new IllegalArgumentException("BFT-SMaRt not supported");
            }
            CordaFuture<List<NodeHandle>> cordaFuture2 = cordaFuture;
            collection.add(cordaFuture2);
        }
        return (List)destination$iv$iv;
    }

    private final CordaFuture<List<NodeHandle>> startSingleNotary(NodeConfig config2, NotarySpec spec, LocalNetworkMap localNetworkMap, Map<String, ? extends Object> customOverrides) {
        Map notaryConfig = MapsKt.mapOf((Pair)TuplesKt.to((Object)"notary", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"validating", (Object)spec.getValidating()))));
        NetworkHostAndPort networkHostAndPort = null;
        String string = null;
        Map map2 = null;
        Collection collection = null;
        String string2 = spec.getMaximumHeapSize();
        Map map3 = MapsKt.plus((Map)notaryConfig, customOverrides);
        Boolean bl = spec.getStartInProcess();
        return CordaFutureImplKt.map((CordaFuture)DriverDSLImpl.startRegisteredNode$default(this, config2, localNetworkMap, new NodeParameters(null, spec.getRpcUsers(), spec.getVerifierType(), map3, bl, string2, collection, map2, string, networkHostAndPort, 961, null), null, 8, null), (Function1)startSingleNotary.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final CordaFuture<List<NodeHandle>> startRaftNotaryCluster(NotarySpec spec, LocalNetworkMap localNetworkMap) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Function2<NetworkHostAndPort, NetworkHostAndPort, Map<String, ? extends Object>> notaryConfig$ = new Function2<NetworkHostAndPort, NetworkHostAndPort, Map<String, ? extends Object>>(spec){
            final /* synthetic */ NotarySpec $spec;

            @NotNull
            public final Map<String, Object> invoke(@NotNull NetworkHostAndPort nodeAddress, @Nullable NetworkHostAndPort clusterAddress) {
                Intrinsics.checkParameterIsNotNull((Object)nodeAddress, (String)"nodeAddress");
                List clusterAddresses = clusterAddress != null ? CollectionsKt.listOf((Object)clusterAddress) : CollectionsKt.emptyList();
                NotaryConfig config2 = new NotaryConfig(this.$spec.getValidating(), this.$spec.getName(), null, 0, null, new RaftConfig(nodeAddress, clusterAddresses), null, null, 220, null);
                return MapsKt.mapOf((Pair)TuplesKt.to((Object)"notary", (Object)ConfigUtilities.toConfig((Object)config2).root().unwrapped()));
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Map invoke$default(startRaftNotaryCluster.1 var0, NetworkHostAndPort networkHostAndPort, NetworkHostAndPort networkHostAndPort2, int n, Object object) {
                if ((n & 2) != 0) {
                    networkHostAndPort2 = null;
                }
                return var0.invoke(networkHostAndPort, networkHostAndPort2);
            }
            {
                this.$spec = notarySpec;
                super(2);
            }
        };
        List<CordaX500Name> nodeNames = this.generateNodeNames(spec);
        NetworkHostAndPort clusterAddress = this.portAllocation.nextHostAndPort();
        NodeParameters firstParams = new NodeParameters(null, spec.getRpcUsers(), spec.getVerifierType(), startRaftNotaryCluster.1.invoke$default(notaryConfig$, clusterAddress, null, 2, null), null, null, null, null, null, null, 1009, null);
        CordaFuture<NodeConfig> firstConfig = this.createSchema(DriverDSLImpl.createConfig$default(this, nodeNames.get(0), firstParams, null, 4, null), this.allowHibernateToManageAppSchema);
        CordaFuture firstNodeFuture = DriverDSLImpl.startRegisteredNode$default(this, (NodeConfig)KotlinUtilsKt.getOrThrow$default((Future)((Future)firstConfig), null, (int)1, null), localNetworkMap, firstParams, null, 8, null);
        Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.drop((Iterable)nodeNames, (int)1);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            CordaX500Name cordaX500Name = (CordaX500Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            NetworkHostAndPort nodeAddress = this.portAllocation.nextHostAndPort();
            NodeParameters params = new NodeParameters(null, spec.getRpcUsers(), spec.getVerifierType(), notaryConfig$.invoke(nodeAddress, clusterAddress), null, null, null, null, null, null, 1009, null);
            CordaFuture<NodeConfig> config2 = this.createSchema(DriverDSLImpl.createConfig$default(this, (CordaX500Name)it, params, null, 4, null), this.allowHibernateToManageAppSchema);
            CordaFuture cordaFuture = DriverDSLImpl.startRegisteredNode$default(this, (NodeConfig)KotlinUtilsKt.getOrThrow$default((Future)((Future)config2), null, (int)1, null), localNetworkMap, params, null, 8, null);
            collection.add(cordaFuture);
        }
        List restNodeFutures = (List)destination$iv$iv;
        return CordaFutureImplKt.flatMap((CordaFuture)firstNodeFuture, (Function1)((Function1)new Function1<NodeHandle, CordaFuture<List<? extends NodeHandle>>>(restNodeFutures){
            final /* synthetic */ List $restNodeFutures;

            @NotNull
            public final CordaFuture<List<NodeHandle>> invoke(@NotNull NodeHandle first) {
                Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
                return CordaFutureImplKt.map((CordaFuture)CordaFutureImplKt.transpose((Collection)this.$restNodeFutures), (Function1)((Function1)new Function1<List<? extends NodeHandle>, List<? extends NodeHandle>>(first){
                    final /* synthetic */ NodeHandle $first;

                    @NotNull
                    public final List<NodeHandle> invoke(@NotNull List<? extends NodeHandle> rest) {
                        Intrinsics.checkParameterIsNotNull(rest, (String)"rest");
                        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.$first), (Iterable)rest);
                    }
                    {
                        this.$first = nodeHandle;
                        super(1);
                    }
                }));
            }
            {
                this.$restNodeFutures = list;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Path baseDirectory(@NotNull CordaX500Name nodeName) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)nodeName, (String)"nodeName");
        String $receiver$iv = nodeName.getOrganisation();
        CharSequence charSequence = $receiver$iv;
        Appendable destination$iv$iv = new StringBuilder();
        int n = 0;
        int n2 = $receiver$iv$iv.length();
        while (n < n2) {
            void index$iv$iv;
            char element$iv$iv = $receiver$iv$iv.charAt((int)index$iv$iv);
            char it = element$iv$iv;
            if (!CharsKt.isWhitespace((char)it)) {
                destination$iv$iv.append(element$iv$iv);
            }
            ++index$iv$iv;
        }
        String string = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"filterTo(StringBuilder(), predicate).toString()");
        String nodeDirectoryName = string;
        return PathUtilsKt.div((Path)this.driverDirectory, (String)nodeDirectoryName);
    }

    private final CordaFuture<Unit> startOutOfProcessMiniNode(NodeConfig config2, String[] extraCmdLineFlag) {
        Integer debugPort = this.isDebug ? Integer.valueOf(this.debugPortAllocation.nextPort()) : null;
        String string = this.getQuasarJarPath();
        String string2 = this.getBytemanJarPath();
        String string3 = ZonedDateTime.now().format(DateTimeFormatter.ofPattern("HHmmss.SSS"));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"ZonedDateTime.now().form\u2026.ofPattern(\"HHmmss.SSS\"))");
        Process process = DriverDSLImpl.Companion.startOutOfProcessNode(config2, string, debugPort, string2, null, this.systemProperties, "512m", null, string3, this.environmentVariables, extraCmdLineFlag);
        return InternalTestUtilsKt.poll$default(this.getExecutorService(), extraCmdLineFlag + " (" + config2.getCorda().getMyLegalName() + ')', null, 0, (Function0)new Function0<Unit>(process){
            final /* synthetic */ Process $process;

            @Nullable
            public final Unit invoke() {
                return this.$process.isAlive() ? null : Unit.INSTANCE;
            }
            {
                this.$process = process;
                super(0);
            }
        }, 12, null);
    }

    static /* bridge */ /* synthetic */ CordaFuture startOutOfProcessMiniNode$default(DriverDSLImpl driverDSLImpl, NodeConfig nodeConfig, String[] stringArray, int n, Object object) {
        if ((n & 2) != 0) {
            stringArray = new String[]{};
        }
        return driverDSLImpl.startOutOfProcessMiniNode(nodeConfig, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final CordaFuture<NodeHandle> startNodeInternal(NodeConfig config2, NetworkHostAndPort webAddress, LocalNetworkMap localNetworkMap, NodeParameters parameters, Integer bytemanPort) {
        CordaFuture cordaFuture;
        Unit unit;
        Waitable waitable;
        Collection collection;
        State $receiver;
        Object this_$iv;
        Object object;
        Lock it;
        String string;
        void destination$iv;
        void $receiver$iv;
        Object object2;
        LocalNetworkMap localNetworkMap2;
        NetworkVisibilityController.VisibilityHandle visibilityHandle = this.networkVisibilityController.register(config2.getCorda().getMyLegalName());
        Path baseDirectory = PathUtilsKt.createDirectories((Path)config2.getCorda().getBaseDirectory(), (FileAttribute[])new FileAttribute[0]);
        String identifier = ZonedDateTime.now().format(DateTimeFormatter.ofPattern("HHmmss.SSS"));
        LocalNetworkMap localNetworkMap3 = localNetworkMap;
        if (localNetworkMap3 != null && (localNetworkMap3 = localNetworkMap3.getNetworkParametersCopier()) != null) {
            localNetworkMap3.install(baseDirectory);
        }
        if ((localNetworkMap2 = localNetworkMap) != null && (localNetworkMap2 = localNetworkMap2.getNodeInfosCopier()) != null) {
            localNetworkMap2.addConfig(baseDirectory);
        }
        Function0 onNodeExit2 = (Function0)new Function0<Unit>(localNetworkMap, baseDirectory, visibilityHandle){
            final /* synthetic */ LocalNetworkMap $localNetworkMap;
            final /* synthetic */ Path $baseDirectory;
            final /* synthetic */ NetworkVisibilityController.VisibilityHandle $visibilityHandle;

            public final void invoke() {
                LocalNetworkMap localNetworkMap = this.$localNetworkMap;
                if (localNetworkMap != null && (localNetworkMap = localNetworkMap.getNodeInfosCopier()) != null) {
                    localNetworkMap.removeConfig(this.$baseDirectory);
                }
                this.$visibilityHandle.close();
            }
            {
                this.$localNetworkMap = localNetworkMap;
                this.$baseDirectory = path;
                this.$visibilityHandle = visibilityHandle;
                super(0);
            }
        };
        Object $receiver2 = object2 = config2.getTypesafe();
        boolean useHTTPS = $receiver2.hasPath("useHTTPS") && $receiver2.getBoolean("useHTTPS");
        object2 = parameters.getAdditionalCordapps();
        $receiver2 = new HashSet();
        Object object3 = baseDirectory;
        Object object4 = TestCordappInternal.Companion;
        for (Object item$iv : $receiver$iv) {
            TestCordapp testCordapp = (TestCordapp)item$iv;
            string = destination$iv;
            void v2 = it;
            if (v2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.corda.testing.node.internal.TestCordappInternal");
            }
            object = (TestCordappInternal)v2;
            string.add(object);
        }
        string = destination$iv;
        Set set = (Set)((Object)string);
        Set<CustomCordapp> set2 = this.extraCustomCordapps;
        if (set2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extraCustomCordapps");
        }
        Collection<TestCordappInternal> collection2 = this.cordappsForAllNodes;
        ((TestCordappInternal.Companion)object4).installCordapps((Path)object3, set, SetsKt.plus(set2, (Iterable)(collection2 != null ? (Iterable)collection2 : (Iterable)SetsKt.emptySet())));
        Boolean bl = parameters.getStartInSameProcess();
        if (bl != null ? bl : this.startNodesInProcess) {
            CordaFuture nodeAndThreadFuture = DriverDSLImpl.Companion.startInProcessNode(this.getExecutorService(), config2, this.allowHibernateToManageAppSchema);
            this.getShutdownManager().registerShutdown((CordaFuture<Function0<Unit>>)CordaFutureImplKt.map((CordaFuture)nodeAndThreadFuture, (Function1)startNodeInternal.nodeFuture.1.INSTANCE));
            CordaFuture nodeFuture2 = CordaFutureImplKt.flatMap((CordaFuture)nodeAndThreadFuture, (Function1)((Function1)new Function1<Pair<? extends NodeWithInfo, ? extends Thread>, CordaFuture<InProcessImpl>>(this, config2, visibilityHandle, webAddress, useHTTPS, onNodeExit2){
                final /* synthetic */ DriverDSLImpl this$0;
                final /* synthetic */ NodeConfig $config;
                final /* synthetic */ NetworkVisibilityController.VisibilityHandle $visibilityHandle;
                final /* synthetic */ NetworkHostAndPort $webAddress;
                final /* synthetic */ boolean $useHTTPS;
                final /* synthetic */ Function0 $onNodeExit;

                @NotNull
                public final CordaFuture<InProcessImpl> invoke(@NotNull Pair<NodeWithInfo, ? extends Thread> $node_thread) {
                    Intrinsics.checkParameterIsNotNull($node_thread, (String)"<name for destructuring parameter 0>");
                    NodeWithInfo node = (NodeWithInfo)$node_thread.component1();
                    Thread thread = (Thread)$node_thread.component2();
                    node.getNode().getNodeReadyFuture().get();
                    return CordaFutureImplKt.flatMap((CordaFuture)DriverDSLImpl.access$establishRpc(this.this$0, this.$config, (CordaFuture)CordaFutureImplKt.openFuture()), (Function1)((Function1)new Function1<CordaRPCOps, CordaFuture<InProcessImpl>>(this, thread, node){
                        final /* synthetic */ startNodeInternal.nodeFuture.nodeFuture.1 this$0;
                        final /* synthetic */ Thread $thread;
                        final /* synthetic */ NodeWithInfo $node;

                        @NotNull
                        public final CordaFuture<InProcessImpl> invoke(@NotNull CordaRPCOps rpc) {
                            Intrinsics.checkParameterIsNotNull((Object)rpc, (String)"rpc");
                            return CordaFutureImplKt.map(this.this$0.$visibilityHandle.listen(rpc), (Function1)((Function1)new Function1<Unit, InProcessImpl>(this, rpc){
                                final /* synthetic */ startNodeInternal.nodeFuture.nodeFuture.1 this$0;
                                final /* synthetic */ CordaRPCOps $rpc;

                                @NotNull
                                public final InProcessImpl invoke(@NotNull Unit it) {
                                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                    return new InProcessImpl(this.$rpc.nodeInfo(), this.$rpc, this.this$0.this$0.$config.getCorda(), this.this$0.this$0.$webAddress, this.this$0.this$0.$useHTTPS, this.this$0.$thread, (Function0<Unit>)this.this$0.this$0.$onNodeExit, this.this$0.$node);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$rpc = cordaRPCOps;
                                    super(1);
                                }
                            }));
                        }
                        {
                            this.this$0 = var1_1;
                            this.$thread = thread;
                            this.$node = nodeWithInfo;
                            super(1);
                        }
                    }));
                }
                {
                    this.this$0 = driverDSLImpl;
                    this.$config = nodeConfig;
                    this.$visibilityHandle = visibilityHandle;
                    this.$webAddress = networkHostAndPort;
                    this.$useHTTPS = bl;
                    this.$onNodeExit = function0;
                    super(1);
                }
            }));
            this_$iv = this.state;
            it = this_$iv.getLock();
            it.lock();
            try {
                $receiver = (State)this_$iv.getContent();
                collection = $receiver.getProcesses();
                waitable = new Waitable(nodeAndThreadFuture){
                    final /* synthetic */ CordaFuture $nodeAndThreadFuture$inlined;
                    {
                        this.$nodeAndThreadFuture$inlined = cordaFuture;
                    }

                    public void waitFor() {
                        ((Thread)((Pair)KotlinUtilsKt.getOrThrow$default((Future)((Future)this.$nodeAndThreadFuture$inlined), null, (int)1, null)).getSecond()).join();
                    }
                };
                collection.add(waitable);
                unit = Unit.INSTANCE;
            }
            finally {
                it.unlock();
            }
            cordaFuture = nodeFuture2;
        } else {
            NetworkHostAndPort networkHostAndPort;
            void $receiver$iv2;
            Integer debugPort = this.isDebug ? Integer.valueOf(this.debugPortAllocation.nextPort()) : null;
            log.info("StartNodeInternal for " + config2.getCorda().getMyLegalName().getOrganisation() + " - calling create schema");
            KotlinUtilsKt.getOrThrow$default((Future)((Future)this.createSchema(config2, this.allowHibernateToManageAppSchema)), null, (int)1, null);
            log.info("StartNodeInternal for " + config2.getCorda().getMyLegalName().getOrganisation() + " - create schema done");
            String string2 = this.getQuasarJarPath();
            String string3 = this.getBytemanJarPath();
            String string4 = parameters.getMaximumHeapSize();
            String string5 = parameters.getLogLevelOverride();
            String string6 = identifier;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"identifier");
            this_$iv = CollectionsKt.listOfNotNull((Object)(this.allowHibernateToManageAppSchema ? "--allow-hibernate-to-manage-app-schema" : null));
            Map<String, String> map2 = this.environmentVariables;
            String string7 = string6;
            String string8 = string5;
            String string9 = string4;
            Map<String, String> map3 = this.systemProperties;
            Integer n = bytemanPort;
            String string10 = string3;
            object = debugPort;
            string = string2;
            object3 = config2;
            object4 = Companion;
            void v13 = $receiver$iv2;
            if (v13 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Lock thisCollection$iv = v13;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] stringArray2 = stringArray;
            Process process = ((Companion)object4).startOutOfProcessNode((NodeConfig)object3, string, (Integer)object, string10, n, map3, string9, string8, string7, map2, stringArray2);
            this.getShutdownManager().registerProcessShutdown(process);
            if (this.waitForAllNodesToFinish) {
                this_$iv = this.state;
                thisCollection$iv = this_$iv.getLock();
                thisCollection$iv.lock();
                try {
                    $receiver = (State)this_$iv.getContent();
                    collection = $receiver.getProcesses();
                    waitable = new Waitable(process){
                        final /* synthetic */ Process $process$inlined;
                        {
                            this.$process$inlined = process;
                        }

                        public void waitFor() {
                            this.$process$inlined.waitFor();
                        }
                    };
                    collection.add(waitable);
                    unit = Unit.INSTANCE;
                }
                finally {
                    thisCollection$iv.unlock();
                }
            }
            if ((networkHostAndPort = config2.getCorda().getMessagingServerAddress()) == null) {
                networkHostAndPort = config2.getCorda().getP2pAddress();
            }
            NetworkHostAndPort effectiveP2PAddress = networkHostAndPort;
            CordaFuture<Unit> p2pReadyFuture2 = InternalTestUtilsKt.nodeMustBeStartedFuture(this.getExecutorService(), PathUtilsKt.div((Path)config2.getCorda().getBaseDirectory(), (String)("net.corda.node.Corda." + identifier + ".stdout.log")), process, (Function0<NodeListenProcessDeathException>)((Function0)new Function0<NodeListenProcessDeathException>(effectiveP2PAddress, process, config2, identifier){
                final /* synthetic */ NetworkHostAndPort $effectiveP2PAddress;
                final /* synthetic */ Process $process;
                final /* synthetic */ NodeConfig $config;
                final /* synthetic */ String $identifier;

                @NotNull
                public final NodeListenProcessDeathException invoke() {
                    return new NodeListenProcessDeathException(this.$effectiveP2PAddress, this.$process, PathUtilsKt.readText$default((Path)PathUtilsKt.div((Path)this.$config.getCorda().getBaseDirectory(), (String)("net.corda.node.Corda." + this.$identifier + ".stderr.log")), null, (int)1, null));
                }
                {
                    this.$effectiveP2PAddress = networkHostAndPort;
                    this.$process = process;
                    this.$config = nodeConfig;
                    this.$identifier = string;
                    super(0);
                }
            }));
            cordaFuture = CordaFutureImplKt.flatMap(p2pReadyFuture2, (Function1)((Function1)new Function1<Unit, CordaFuture<OutOfProcessImpl>>(this, config2, process, visibilityHandle, effectiveP2PAddress, webAddress, useHTTPS, debugPort, onNodeExit2){
                final /* synthetic */ DriverDSLImpl this$0;
                final /* synthetic */ NodeConfig $config;
                final /* synthetic */ Process $process;
                final /* synthetic */ NetworkVisibilityController.VisibilityHandle $visibilityHandle;
                final /* synthetic */ NetworkHostAndPort $effectiveP2PAddress;
                final /* synthetic */ NetworkHostAndPort $webAddress;
                final /* synthetic */ boolean $useHTTPS;
                final /* synthetic */ Integer $debugPort;
                final /* synthetic */ Function0 $onNodeExit;

                @NotNull
                public final CordaFuture<OutOfProcessImpl> invoke(@NotNull Unit it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    CordaFuture processDeathFuture2 = InternalTestUtilsKt.poll$default(this.this$0.getExecutorService(), "process death while waiting for RPC (" + this.$config.getCorda().getMyLegalName() + ')', null, 0, (Function0)new Function0<Process>(this){
                        final /* synthetic */ startNodeInternal.nodeFuture.4 this$0;

                        @Nullable
                        public final Process invoke() {
                            return this.this$0.$process.isAlive() ? null : this.this$0.$process;
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }, 12, null);
                    return CordaFutureImplKt.flatMap((CordaFuture)DriverDSLImpl.access$establishRpc(this.this$0, this.$config, processDeathFuture2), (Function1)((Function1)new Function1<CordaRPCOps, CordaFuture<OutOfProcessImpl>>(this, processDeathFuture2){
                        final /* synthetic */ startNodeInternal.nodeFuture.4 this$0;
                        final /* synthetic */ CordaFuture $processDeathFuture;

                        @NotNull
                        public final CordaFuture<OutOfProcessImpl> invoke(@NotNull CordaRPCOps rpc) {
                            Intrinsics.checkParameterIsNotNull((Object)rpc, (String)"rpc");
                            CordaFuture networkMapFuture2 = CordaFutureImplKt.flatMap((CordaFuture)CordaFutureImplKt.fork((Executor)this.this$0.this$0.getExecutorService(), (Function0)((Function0)new Function0<CordaFuture<Unit>>(this, rpc){
                                final /* synthetic */ startNodeInternal.nodeFuture.1 this$0;
                                final /* synthetic */ CordaRPCOps $rpc;

                                @NotNull
                                public final CordaFuture<Unit> invoke() {
                                    return this.this$0.this$0.$visibilityHandle.listen(this.$rpc);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$rpc = cordaRPCOps;
                                    super(0);
                                }
                            })), (Function1)startNodeInternal.nodeFuture.networkMapFuture.2.INSTANCE);
                            return ConcurrencyUtils.firstOf((CordaFuture[])new CordaFuture[]{this.$processDeathFuture, networkMapFuture2}, (Function1)((Function1)new Function1<CordaFuture<? extends Object>, OutOfProcessImpl>(this, rpc){
                                final /* synthetic */ startNodeInternal.nodeFuture.1 this$0;
                                final /* synthetic */ CordaRPCOps $rpc;

                                @NotNull
                                public final OutOfProcessImpl invoke(@NotNull CordaFuture<? extends Object> it) {
                                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                                    if (Intrinsics.areEqual(it, (Object)this.this$0.$processDeathFuture)) {
                                        throw (Throwable)((Object)new ListenProcessDeathException(this.this$0.this$0.$effectiveP2PAddress, this.this$0.this$0.$process));
                                    }
                                    this.this$0.$processDeathFuture.cancel(true);
                                    DriverDSLImpl.Companion.getLog$node_driver().info("Node handle is ready. NodeInfo: " + this.$rpc.nodeInfo() + ", WebAddress: " + this.this$0.this$0.$webAddress);
                                    return new OutOfProcessImpl(this.$rpc.nodeInfo(), this.$rpc, this.this$0.this$0.$config.getCorda(), this.this$0.this$0.$webAddress, this.this$0.this$0.$useHTTPS, this.this$0.this$0.$debugPort, this.this$0.this$0.$process, (Function0<Unit>)this.this$0.this$0.$onNodeExit);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$rpc = cordaRPCOps;
                                    super(1);
                                }
                            }));
                        }
                        {
                            this.this$0 = var1_1;
                            this.$processDeathFuture = cordaFuture;
                            super(1);
                        }
                    }));
                }
                {
                    this.this$0 = driverDSLImpl;
                    this.$config = nodeConfig;
                    this.$process = process;
                    this.$visibilityHandle = visibilityHandle;
                    this.$effectiveP2PAddress = networkHostAndPort;
                    this.$webAddress = networkHostAndPort2;
                    this.$useHTTPS = bl;
                    this.$debugPort = n;
                    this.$onNodeExit = function0;
                    super(1);
                }
            }));
        }
        CordaFuture nodeFuture3 = cordaFuture;
        return CordaFutureImplKt.doOnError((CordaFuture)nodeFuture3, (Function1)((Function1)new Function1<Throwable, Unit>(onNodeExit2){
            final /* synthetic */ Function0 $onNodeExit;

            public final void invoke(@NotNull Throwable it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$onNodeExit.invoke();
            }
            {
                this.$onNodeExit = function0;
                super(1);
            }
        }));
    }

    @Override
    @NotNull
    public <A> CordaFuture<A> pollUntilNonNull(@NotNull String pollName, @NotNull Duration pollInterval, int warnCount, @NotNull Function0<? extends A> check) {
        Intrinsics.checkParameterIsNotNull((Object)pollName, (String)"pollName");
        Intrinsics.checkParameterIsNotNull((Object)pollInterval, (String)"pollInterval");
        Intrinsics.checkParameterIsNotNull(check, (String)"check");
        CordaFuture<? extends A> pollFuture = InternalTestUtilsKt.poll(this.getExecutorService(), pollName, pollInterval, warnCount, check);
        this.getShutdownManager().registerShutdown((Function0<Unit>)((Function0)new Function0<Unit>(pollFuture){
            final /* synthetic */ CordaFuture $pollFuture;

            public final void invoke() {
                this.$pollFuture.cancel(true);
            }
            {
                this.$pollFuture = cordaFuture;
                super(0);
            }
        }));
        return pollFuture;
    }

    private final NodeConfig withNotaryDefinition(@NotNull NodeConfig $receiver, boolean validating) {
        return new NodeConfig(ConfigUtilitiesKt.plus((Config)$receiver.getTypesafe(), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"notary", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"validating", (Object)validating))))));
    }

    @NotNull
    public final PortAllocation getPortAllocation() {
        return this.portAllocation;
    }

    @NotNull
    public final PortAllocation getDebugPortAllocation() {
        return this.debugPortAllocation;
    }

    @NotNull
    public final Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    @NotNull
    public final Path getDriverDirectory() {
        return this.driverDirectory;
    }

    public final boolean getUseTestClock() {
        return this.useTestClock;
    }

    public final boolean isDebug() {
        return this.isDebug;
    }

    public final boolean getStartNodesInProcess() {
        return this.startNodesInProcess;
    }

    public final boolean getWaitForAllNodesToFinish() {
        return this.waitForAllNodesToFinish;
    }

    @NotNull
    public final List<String> getExtraCordappPackagesToScan() {
        return this.extraCordappPackagesToScan;
    }

    @NotNull
    public final JmxPolicy getJmxPolicy() {
        return this.jmxPolicy;
    }

    @NotNull
    public final List<NotarySpec> getNotarySpecs() {
        return this.notarySpecs;
    }

    @Nullable
    public final CompatibilityZoneParams getCompatibilityZone() {
        return this.compatibilityZone;
    }

    @NotNull
    public final NetworkParameters getNetworkParameters() {
        return this.networkParameters;
    }

    @NotNull
    public final Map<String, Object> getNotaryCustomOverrides() {
        return this.notaryCustomOverrides;
    }

    public final boolean getInMemoryDB() {
        return this.inMemoryDB;
    }

    @Nullable
    public final Collection<TestCordappInternal> getCordappsForAllNodes() {
        return this.cordappsForAllNodes;
    }

    @Nullable
    public final Path getDjvmBootstrapSource() {
        return this.djvmBootstrapSource;
    }

    @NotNull
    public final List<Path> getDjvmCordaSource() {
        return this.djvmCordaSource;
    }

    @NotNull
    public final Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public final boolean getAllowHibernateToManageAppSchema() {
        return this.allowHibernateToManageAppSchema;
    }

    public final boolean getPremigrateH2Database() {
        return this.premigrateH2Database;
    }

    public DriverDSLImpl(@NotNull PortAllocation portAllocation, @NotNull PortAllocation debugPortAllocation, @NotNull Map<String, String> systemProperties, @NotNull Path driverDirectory, boolean useTestClock, boolean isDebug, boolean startNodesInProcess, boolean waitForAllNodesToFinish, @NotNull List<String> extraCordappPackagesToScan, @NotNull JmxPolicy jmxPolicy, @NotNull List<NotarySpec> notarySpecs, @Nullable CompatibilityZoneParams compatibilityZone, @NotNull NetworkParameters networkParameters, @NotNull Map<String, ? extends Object> notaryCustomOverrides, boolean inMemoryDB, @Nullable Collection<? extends TestCordappInternal> cordappsForAllNodes, @Nullable Path djvmBootstrapSource, @NotNull List<? extends Path> djvmCordaSource, @NotNull Map<String, String> environmentVariables, boolean allowHibernateToManageAppSchema, boolean premigrateH2Database) {
        Intrinsics.checkParameterIsNotNull((Object)portAllocation, (String)"portAllocation");
        Intrinsics.checkParameterIsNotNull((Object)debugPortAllocation, (String)"debugPortAllocation");
        Intrinsics.checkParameterIsNotNull(systemProperties, (String)"systemProperties");
        Intrinsics.checkParameterIsNotNull((Object)driverDirectory, (String)"driverDirectory");
        Intrinsics.checkParameterIsNotNull(extraCordappPackagesToScan, (String)"extraCordappPackagesToScan");
        Intrinsics.checkParameterIsNotNull((Object)jmxPolicy, (String)"jmxPolicy");
        Intrinsics.checkParameterIsNotNull(notarySpecs, (String)"notarySpecs");
        Intrinsics.checkParameterIsNotNull((Object)networkParameters, (String)"networkParameters");
        Intrinsics.checkParameterIsNotNull(notaryCustomOverrides, (String)"notaryCustomOverrides");
        Intrinsics.checkParameterIsNotNull(djvmCordaSource, (String)"djvmCordaSource");
        Intrinsics.checkParameterIsNotNull(environmentVariables, (String)"environmentVariables");
        this.portAllocation = portAllocation;
        this.debugPortAllocation = debugPortAllocation;
        this.systemProperties = systemProperties;
        this.driverDirectory = driverDirectory;
        this.useTestClock = useTestClock;
        this.isDebug = isDebug;
        this.startNodesInProcess = startNodesInProcess;
        this.waitForAllNodesToFinish = waitForAllNodesToFinish;
        this.extraCordappPackagesToScan = extraCordappPackagesToScan;
        this.jmxPolicy = jmxPolicy;
        this.notarySpecs = notarySpecs;
        this.compatibilityZone = compatibilityZone;
        this.networkParameters = networkParameters;
        this.notaryCustomOverrides = notaryCustomOverrides;
        this.inMemoryDB = inMemoryDB;
        this.cordappsForAllNodes = cordappsForAllNodes;
        this.djvmBootstrapSource = djvmBootstrapSource;
        this.djvmCordaSource = djvmCordaSource;
        this.environmentVariables = environmentVariables;
        this.allowHibernateToManageAppSchema = allowHibernateToManageAppSchema;
        this.premigrateH2Database = premigrateH2Database;
        this.networkVisibilityController = new NetworkVisibilityController();
        this.cordappsClassLoader = DriverDSLImpl.Companion.createCordappsClassLoader(this.cordappsForAllNodes);
        this.state = new ThreadBox((Object)new State(), null, 2, null);
        this.quasarJarPath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DriverDSLImpl this$0;

            @NotNull
            public final String invoke() {
                return DriverDSLImpl.resolveJar$default(this.this$0, "co.paralleluniverse.fibers.Suspendable", false, 2, null);
            }
            {
                this.this$0 = driverDSLImpl;
                super(0);
            }
        }));
        this.bytemanJarPath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DriverDSLImpl this$0;

            @Nullable
            public final String invoke() {
                String string;
                try {
                    string = DriverDSLImpl.access$resolveJar(this.this$0, "org.jboss.byteman.agent.Transformer", false);
                }
                catch (Exception e) {
                    string = null;
                }
                return string;
            }
            {
                this.this$0 = driverDSLImpl;
                super(0);
            }
        }));
    }

    public /* synthetic */ DriverDSLImpl(PortAllocation portAllocation, PortAllocation portAllocation2, Map map2, Path path, boolean bl, boolean bl2, boolean bl3, boolean bl4, List list, JmxPolicy jmxPolicy, List list2, CompatibilityZoneParams compatibilityZoneParams, NetworkParameters networkParameters, Map map3, boolean bl5, Collection collection, Path path2, List list3, Map map4, boolean bl6, boolean bl7, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80000) != 0) {
            bl6 = true;
        }
        if ((n & 0x100000) != 0) {
            bl7 = true;
        }
        this(portAllocation, portAllocation2, map2, path, bl, bl2, bl3, bl4, list, jmxPolicy, list2, compatibilityZoneParams, networkParameters, map3, bl5, collection, path2, list3, map4, bl6, bl7);
    }

    @Override
    @NotNull
    public CordaFuture<NodeHandle> startNode() {
        return InternalDriverDSL.DefaultImpls.startNode(this);
    }

    @Override
    @NotNull
    public CordaFuture<NodeHandle> startNode(@NotNull NodeParameters defaultParameters, @Nullable CordaX500Name providedName, @NotNull List<User> rpcUsers, @NotNull VerifierType verifierType, @NotNull Map<String, ? extends Object> customOverrides, @Nullable Boolean startInSameProcess, @NotNull String maximumHeapSize, @Nullable String logLevelOverride) {
        Intrinsics.checkParameterIsNotNull((Object)defaultParameters, (String)"defaultParameters");
        Intrinsics.checkParameterIsNotNull(rpcUsers, (String)"rpcUsers");
        Intrinsics.checkParameterIsNotNull((Object)((Object)verifierType), (String)"verifierType");
        Intrinsics.checkParameterIsNotNull(customOverrides, (String)"customOverrides");
        Intrinsics.checkParameterIsNotNull((Object)maximumHeapSize, (String)"maximumHeapSize");
        return InternalDriverDSL.DefaultImpls.startNode(this, defaultParameters, providedName, rpcUsers, verifierType, customOverrides, startInSameProcess, maximumHeapSize, logLevelOverride);
    }

    @Override
    @NotNull
    public CordaFuture<NodeHandle> startNode(@NotNull NodeParameters defaultParameters, @Nullable CordaX500Name providedName, @NotNull List<User> rpcUsers, @NotNull VerifierType verifierType, @NotNull Map<String, ? extends Object> customOverrides, @Nullable Boolean startInSameProcess, @NotNull String maximumHeapSize) {
        Intrinsics.checkParameterIsNotNull((Object)defaultParameters, (String)"defaultParameters");
        Intrinsics.checkParameterIsNotNull(rpcUsers, (String)"rpcUsers");
        Intrinsics.checkParameterIsNotNull((Object)((Object)verifierType), (String)"verifierType");
        Intrinsics.checkParameterIsNotNull(customOverrides, (String)"customOverrides");
        Intrinsics.checkParameterIsNotNull((Object)maximumHeapSize, (String)"maximumHeapSize");
        return InternalDriverDSL.DefaultImpls.startNode(this, defaultParameters, providedName, rpcUsers, verifierType, customOverrides, startInSameProcess, maximumHeapSize);
    }

    @Override
    @NotNull
    public CordaFuture<WebserverHandle> startWebserver(@NotNull NodeHandle handle) {
        Intrinsics.checkParameterIsNotNull((Object)handle, (String)"handle");
        return InternalDriverDSL.DefaultImpls.startWebserver(this, handle);
    }

    @Override
    @NotNull
    public Path baseDirectory(@NotNull String nodeName) {
        Intrinsics.checkParameterIsNotNull((Object)nodeName, (String)"nodeName");
        return InternalDriverDSL.DefaultImpls.baseDirectory(this, nodeName);
    }

    @Override
    @NotNull
    public CordaFuture<Unit> pollUntilTrue(@NotNull String pollName, @NotNull Duration pollInterval, int warnCount, @NotNull Function0<Boolean> check) {
        Intrinsics.checkParameterIsNotNull((Object)pollName, (String)"pollName");
        Intrinsics.checkParameterIsNotNull((Object)pollInterval, (String)"pollInterval");
        Intrinsics.checkParameterIsNotNull(check, (String)"check");
        return InternalDriverDSL.DefaultImpls.pollUntilTrue(this, pollName, pollInterval, warnCount, check);
    }

    @Override
    @NotNull
    public NotaryHandle getDefaultNotaryHandle() {
        return InternalDriverDSL.DefaultImpls.getDefaultNotaryHandle(this);
    }

    @Override
    @NotNull
    public Party getDefaultNotaryIdentity() {
        return InternalDriverDSL.DefaultImpls.getDefaultNotaryIdentity(this);
    }

    @Override
    @NotNull
    public CordaFuture<NodeHandle> getDefaultNotaryNode() {
        return InternalDriverDSL.DefaultImpls.getDefaultNotaryNode(this);
    }

    @Override
    public int nextPort() {
        return InternalDriverDSL.DefaultImpls.nextPort(this);
    }

    @NotNull
    public static final /* synthetic */ CordaFuture access$startNodeRegistration(DriverDSLImpl $this, @NotNull NodeConfig config2, @NotNull X509Certificate rootCert, @NotNull NetworkServicesConfig networkServicesConfig) {
        return $this.startNodeRegistration(config2, rootCert, networkServicesConfig);
    }

    @NotNull
    public static final /* synthetic */ CordaFuture access$getNetworkMapAvailability$p(DriverDSLImpl $this) {
        CordaFuture<LocalNetworkMap> cordaFuture = $this.networkMapAvailability;
        if (cordaFuture == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"networkMapAvailability");
        }
        return cordaFuture;
    }

    public static final /* synthetic */ void access$setNetworkMapAvailability$p(DriverDSLImpl $this, @NotNull CordaFuture cordaFuture) {
        $this.networkMapAvailability = cordaFuture;
    }

    @NotNull
    public static final /* synthetic */ CordaFuture access$startRegisteredNode(DriverDSLImpl $this, @NotNull NodeConfig config2, @Nullable LocalNetworkMap localNetworkMap, @NotNull NodeParameters parameters, @Nullable Integer bytemanPort) {
        return $this.startRegisteredNode(config2, localNetworkMap, parameters, bytemanPort);
    }

    @NotNull
    public static final /* synthetic */ WebserverHandle access$queryWebserver(DriverDSLImpl $this, @NotNull NodeHandle handle, @NotNull Process process) {
        return $this.queryWebserver(handle, process);
    }

    @NotNull
    public static final /* synthetic */ List access$startNotaries(DriverDSLImpl $this, @NotNull List configs, @Nullable LocalNetworkMap localNetworkMap, @NotNull Map customOverrides) {
        return $this.startNotaries(configs, localNetworkMap, customOverrides);
    }

    @NotNull
    public static final /* synthetic */ List access$generateNodeNames(DriverDSLImpl $this, @NotNull NotarySpec spec) {
        return $this.generateNodeNames(spec);
    }

    @NotNull
    public static final /* synthetic */ NodeConfig access$withNotaryDefinition(DriverDSLImpl $this, @NotNull NodeConfig $receiver, boolean validating) {
        return $this.withNotaryDefinition($receiver, validating);
    }

    @NotNull
    public static final /* synthetic */ CordaFuture access$startOutOfProcessMiniNode(DriverDSLImpl $this, @NotNull NodeConfig config2, @NotNull String[] extraCmdLineFlag) {
        return $this.startOutOfProcessMiniNode(config2, extraCmdLineFlag);
    }

    @NotNull
    public static final /* synthetic */ CordaFuture access$establishRpc(DriverDSLImpl $this, @NotNull NodeConfig config2, @NotNull CordaFuture processDeathFuture2) {
        return $this.establishRpc(config2, (CordaFuture<? extends Process>)processDeathFuture2);
    }

    @NotNull
    public static final /* synthetic */ String access$resolveJar(DriverDSLImpl $this, @NotNull String className, boolean verbose) {
        return $this.resolveJar(className, verbose);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lnet/corda/testing/node/internal/DriverDSLImpl$Waitable;", "", "waitFor", "", "node-driver"})
    public static interface Waitable {
        public void waitFor() throws InterruptedException;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lnet/corda/testing/node/internal/DriverDSLImpl$State;", "", "()V", "processes", "Ljava/util/ArrayList;", "Lnet/corda/testing/node/internal/DriverDSLImpl$Waitable;", "Lkotlin/collections/ArrayList;", "getProcesses", "()Ljava/util/ArrayList;", "node-driver"})
    public static final class State {
        @NotNull
        private final ArrayList<Waitable> processes = new ArrayList();

        @NotNull
        public final ArrayList<Waitable> getProcesses() {
            return this.processes;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lnet/corda/testing/node/internal/DriverDSLImpl$LocalNetworkMap;", "", "notaryInfos", "", "Lnet/corda/core/node/NotaryInfo;", "(Lnet/corda/testing/node/internal/DriverDSLImpl;Ljava/util/List;)V", "networkParametersCopier", "Lnet/corda/nodeapi/internal/network/NetworkParametersCopier;", "getNetworkParametersCopier", "()Lnet/corda/nodeapi/internal/network/NetworkParametersCopier;", "nodeInfosCopier", "Lnet/corda/nodeapi/internal/network/NodeInfoFilesCopier;", "getNodeInfosCopier", "()Lnet/corda/nodeapi/internal/network/NodeInfoFilesCopier;", "node-driver"})
    public final class LocalNetworkMap {
        @NotNull
        private final NetworkParametersCopier networkParametersCopier;
        @NotNull
        private final NodeInfoFilesCopier nodeInfosCopier;

        @NotNull
        public final NetworkParametersCopier getNetworkParametersCopier() {
            return this.networkParametersCopier;
        }

        @NotNull
        public final NodeInfoFilesCopier getNodeInfosCopier() {
            return this.nodeInfosCopier;
        }

        public LocalNetworkMap(List<NotaryInfo> notaryInfos) {
            NodeInfoFilesCopier nodeInfoFilesCopier;
            Intrinsics.checkParameterIsNotNull(notaryInfos, (String)"notaryInfos");
            this.networkParametersCopier = new NetworkParametersCopier(NetworkParameters.copy$default((NetworkParameters)DriverDSLImpl.this.getNetworkParameters(), (int)0, notaryInfos, (int)0, (int)0, null, (int)0, null, (int)125, null), null, false, false, 14, null);
            NodeInfoFilesCopier nodeInfoFilesCopier2 = new NodeInfoFilesCopier(null, 1, null);
            LocalNetworkMap localNetworkMap = this;
            NodeInfoFilesCopier it = nodeInfoFilesCopier2;
            DriverDSLImpl.this.getShutdownManager().registerShutdown((Function0<Unit>)((Function0)new Function0<Unit>(it){

                public final void invoke() {
                    ((NodeInfoFilesCopier)this.receiver).close();
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(NodeInfoFilesCopier.class);
                }

                public final String getName() {
                    return "close";
                }

                public final String getSignature() {
                    return "close()V";
                }
            }));
            localNetworkMap.nodeInfosCopier = nodeInfoFilesCopier = nodeInfoFilesCopier2;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lnet/corda/testing/node/internal/DriverDSLImpl$NodeConfig;", "", "typesafe", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "corda", "Lnet/corda/node/services/config/NodeConfiguration;", "getCorda", "()Lnet/corda/node/services/config/NodeConfiguration;", "getTypesafe", "()Lcom/typesafe/config/Config;", "node-driver"})
    private static final class NodeConfig {
        @NotNull
        private final NodeConfiguration corda;
        @NotNull
        private final Config typesafe;

        @NotNull
        public final NodeConfiguration getCorda() {
            return this.corda;
        }

        @NotNull
        public final Config getTypesafe() {
            return this.typesafe;
        }

        public NodeConfig(@NotNull Config typesafe) {
            Intrinsics.checkParameterIsNotNull((Object)typesafe, (String)"typesafe");
            this.typesafe = typesafe;
            this.corda = (NodeConfiguration)Validated.DefaultImpls.value$default((Validated)NodeConfigurationKt.parseAsNodeConfiguration$default((Config)this.typesafe, null, (int)1, null), null, (int)1, null);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010 \u001a\u0004\u0018\u00010!2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#H\u0002J\u001a\u0010%\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050'0&H\u0002J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u0005H\u0002J!\u00101\u001a\u0002H2\"\u0004\b\u0000\u001022\f\u00103\u001a\b\u0012\u0004\u0012\u0002H20\u0017H\u0002\u00a2\u0006\u0002\u00104J\u0010\u00105\u001a\u0002062\u0006\u0010,\u001a\u00020-H\u0002J2\u00107\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020:0'082\u0006\u0010;\u001a\u00020<2\u0006\u0010,\u001a\u00020.2\u0006\u0010=\u001a\u00020\u001dH\u0002J\u008d\u0001\u0010>\u001a\u00020?2\u0006\u0010,\u001a\u00020.2\u0006\u0010@\u001a\u00020\u00052\b\u0010A\u001a\u0004\u0018\u00010B2\b\u0010C\u001a\u0004\u0018\u00010\u00052\b\u0010D\u001a\u0004\u0018\u00010B2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010F\u001a\u00020\u00052\b\u0010G\u001a\u0004\u0018\u00010\u00052\u0006\u0010H\u001a\u00020\u00052\u0012\u0010I\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000f2\u000e\b\u0002\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017H\u0002\u00a2\u0006\u0002\u0010KJ'\u0010L\u001a\u00020?2\u0006\u0010M\u001a\u00020N2\b\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010F\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010OJ\u001b\u0010P\u001a\u00020Q\"\u0004\b\u0000\u0010R2\u0006\u0010S\u001a\u0002HRH\u0002\u00a2\u0006\u0002\u0010TJ)\u0010U\u001a\n \u000e*\u0004\u0018\u00010V0V*\u00020V2\u0012\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010'H\u0082\u0002J$\u0010X\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000f*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000fH\u0002J\f\u0010Y\u001a\u00020V*\u00020NH\u0002J$\u0010Z\u001a\u00020V*\u00020V2\b\u0010[\u001a\u0004\u0018\u00010\u001e2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0004H\u0002J>\u0010]\u001a\u00020V\"\u0004\b\u0000\u0010R*\u00020V2\u0006\u0010^\u001a\u00020\u00052\b\u0010_\u001a\u0004\u0018\u0001HR2\u0012\u0010`\u001a\u000e\u0012\u0004\u0012\u0002HR\u0012\u0004\u0012\u00020Q0aH\u0082\b\u00a2\u0006\u0002\u0010bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u0010\f\u001aH\u0012D\u0012B\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00010\u0001 \u000e* \u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\u000f0\r0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0016\u0010\u001a\u001a\n \u000e*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001c\u001a\u00020\u001d*\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001f\u00a8\u0006c"}, d2={"Lnet/corda/testing/node/internal/DriverDSLImpl$Companion;", "", "()V", "CORDAPP_MANIFEST_ATTRIBUTES", "", "", "CORDA_TESTING_ATTRIBUTE", "DRIVER_REQUIRED_PERMISSIONS", "", "DRIVER_REQUIRED_PERMISSIONS$annotations", "RPC_CONNECT_POLL_INTERVAL", "Ljava/time/Duration;", "defaultRpcUserList", "", "kotlin.jvm.PlatformType", "", "inMemoryCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "log", "Lorg/slf4j/Logger;", "getLog$node_driver", "()Lorg/slf4j/Logger;", "names", "", "Lnet/corda/core/identity/CordaX500Name;", "[Lnet/corda/core/identity/CordaX500Name;", "notaryHandleTimeout", "propertiesInScope", "isExcludedJar", "", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)Z", "createCordappsClassLoader", "Ljava/net/URLClassLoader;", "cordapps", "", "Lnet/corda/testing/node/internal/TestCordappInternal;", "inheritFromParentProcess", "", "Lkotlin/Pair;", "isCordapp", "manifest", "Ljava/util/jar/Manifest;", "isH2Database", "config", "Lnet/corda/node/services/config/NodeConfiguration;", "Lnet/corda/testing/node/internal/DriverDSLImpl$NodeConfig;", "isTestArtifact", "name", "oneOf", "A", "array", "([Ljava/lang/Object;)Ljava/lang/Object;", "shutdownAndDeleteDatabase", "", "startInProcessNode", "Lnet/corda/core/concurrent/CordaFuture;", "Lnet/corda/node/internal/NodeWithInfo;", "Ljava/lang/Thread;", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "allowHibernateToManageAppSchema", "startOutOfProcessNode", "Ljava/lang/Process;", "quasarJarPath", "debugPort", "", "bytemanJarPath", "bytemanPort", "overriddenSystemProperties", "maximumHeapSize", "logLevelOverride", "identifier", "environmentVariables", "extraCmdLineFlag", "(Lnet/corda/testing/node/internal/DriverDSLImpl$NodeConfig;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Integer;Ljava/util/Map;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;[Ljava/lang/String;)Ljava/lang/Process;", "startWebserver", "handle", "Lnet/corda/testing/driver/internal/NodeHandleInternal;", "(Lnet/corda/testing/driver/internal/NodeHandleInternal;Ljava/lang/Integer;Ljava/lang/String;)Ljava/lang/Process;", "valueFor", "Lcom/typesafe/config/ConfigValue;", "T", "any", "(Ljava/lang/Object;)Lcom/typesafe/config/ConfigValue;", "plus", "Lcom/typesafe/config/Config;", "property", "removeResolvedClasspath", "toWebServerConfig", "withDJVMConfig", "bootstrapSource", "cordaSource", "withOptionalValue", "key", "obj", "body", "Lkotlin/Function1;", "(Lcom/typesafe/config/Config;Ljava/lang/String;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Lcom/typesafe/config/Config;", "node-driver"})
    public static final class Companion {
        @NotNull
        public final Logger getLog$node_driver() {
            return log;
        }

        private static /* synthetic */ void DRIVER_REQUIRED_PERMISSIONS$annotations() {
        }

        /*
         * WARNING - void declaration
         */
        private final Config withDJVMConfig(@NotNull Config $receiver, Path bootstrapSource, List<? extends Path> cordaSource) {
            Config config2;
            if ($receiver.hasPath("devMode")) {
                Config config3;
                if ($receiver.getBoolean("devMode")) {
                    Collection<String> collection;
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    Companion companion;
                    void var13_9;
                    String string;
                    Config config4;
                    void $receiver$iv2;
                    Config config5 = $receiver;
                    Companion companion2 = this;
                    String key$iv = "devModeOptions.djvm.bootstrapSource";
                    if (bootstrapSource == null) {
                        config4 = $receiver$iv2;
                    } else {
                        void path;
                        Path path2 = bootstrapSource;
                        string = key$iv;
                        var13_9 = $receiver$iv2;
                        companion = Companion.valueFor(path.toString());
                        Config config6 = var13_9.withValue(string, (ConfigValue)companion);
                        config4 = config6;
                        Intrinsics.checkExpressionValueIsNotNull((Object)config6, (String)"withValue(key, body(obj))");
                    }
                    Iterable this_$iv = cordaSource;
                    companion = this;
                    string = "devModeOptions.djvm.cordaSource";
                    var13_9 = config4;
                    $receiver$iv2 = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv) {
                        void p1;
                        Path $i$f$withOptionalValue = (Path)item$iv$iv;
                        collection = destination$iv$iv;
                        String string2 = p1.toString();
                        collection.add(string2);
                    }
                    collection = (List)destination$iv$iv;
                    config3 = var13_9.withValue(string, companion.valueFor(collection));
                } else {
                    config3 = $receiver.withoutPath("devModeOptions");
                }
                config2 = config3;
                Intrinsics.checkExpressionValueIsNotNull((Object)config3, (String)"if (getBoolean(\"devMode\"\u2026tions\")\n                }");
            } else {
                config2 = $receiver;
            }
            return config2;
        }

        private final <T> Config withOptionalValue(@NotNull Config $receiver, String key, T obj, Function1<? super T, ? extends ConfigValue> body) {
            Config config2;
            if (obj == null) {
                config2 = $receiver;
            } else {
                Config config3 = $receiver.withValue(key, (ConfigValue)body.invoke(obj));
                config2 = config3;
                Intrinsics.checkExpressionValueIsNotNull((Object)config3, (String)"withValue(key, body(obj))");
            }
            return config2;
        }

        private final <T> ConfigValue valueFor(T any) {
            ConfigValue configValue = ConfigValueFactory.fromAnyRef(any);
            Intrinsics.checkExpressionValueIsNotNull((Object)configValue, (String)"ConfigValueFactory.fromAnyRef(any)");
            return configValue;
        }

        private final <A> A oneOf(A[] array) {
            return array[new Random().nextInt(array.length)];
        }

        private final CordaFuture<Pair<NodeWithInfo, Thread>> startInProcessNode(ScheduledExecutorService executorService, NodeConfig config2, boolean allowHibernateToManageAppSchema) {
            NetworkHostAndPort networkHostAndPort = config2.getCorda().getMessagingServerAddress();
            if (networkHostAndPort == null) {
                networkHostAndPort = config2.getCorda().getP2pAddress();
            }
            NetworkHostAndPort effectiveP2PAddress = networkHostAndPort;
            return CordaFutureImplKt.flatMap((CordaFuture)CordaFutureImplKt.fork((Executor)executorService, (Function0)((Function0)new Function0<Pair<? extends NodeWithInfo, ? extends Thread>>(config2, allowHibernateToManageAppSchema){
                final /* synthetic */ NodeConfig $config;
                final /* synthetic */ boolean $allowHibernateToManageAppSchema;

                @NotNull
                public final Pair<NodeWithInfo, Thread> invoke() {
                    DriverDSLImpl.Companion.getLog$node_driver().info("Starting in-process Node " + this.$config.getCorda().getMyLegalName().getOrganisation());
                    if (!JavaAgent.isActive()) {
                        throw (Throwable)new IllegalStateException("No quasar agent: -javaagent:lib/quasar.jar and working directory project root might fix");
                    }
                    DriverDSLImplKt.writeConfig(this.$config.getCorda().getBaseDirectory(), "node.conf", DriverDSLImplKt.access$toNodeOnly(this.$config.getTypesafe()));
                    InProcessNode node = new InProcessNode(this.$config.getCorda(), InternalMockNetworkKt.getMOCK_VERSION_INFO(), null, this.$allowHibernateToManageAppSchema, 4, null);
                    NodeInfo nodeInfo = node.start();
                    NodeWithInfo nodeWithInfo = new NodeWithInfo((Node)node, nodeInfo);
                    Thread nodeThread2 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)this.$config.getCorda().getMyLegalName().getOrganisation(), (int)0, (Function0)((Function0)new Function0<Unit>(node){
                        final /* synthetic */ InProcessNode $node;

                        public final void invoke() {
                            try {
                                this.$node.run();
                            }
                            catch (Throwable th) {
                                DriverDSLImpl.Companion.getLog$node_driver().error("Node run terminated unexpectedly", th);
                            }
                            DriverDSLImpl.Companion.getLog$node_driver().info("Node run completed");
                        }
                        {
                            this.$node = inProcessNode;
                            super(0);
                        }
                    }), (int)23, null);
                    return TuplesKt.to((Object)nodeWithInfo, (Object)nodeThread2);
                }
                {
                    this.$config = nodeConfig;
                    this.$allowHibernateToManageAppSchema = bl;
                    super(0);
                }
            })), (Function1)((Function1)new Function1<Pair<? extends NodeWithInfo, ? extends Thread>, CordaFuture<Pair<? extends NodeWithInfo, ? extends Thread>>>(executorService, effectiveP2PAddress){
                final /* synthetic */ ScheduledExecutorService $executorService;
                final /* synthetic */ NetworkHostAndPort $effectiveP2PAddress;

                @NotNull
                public final CordaFuture<Pair<NodeWithInfo, Thread>> invoke(@NotNull Pair<NodeWithInfo, ? extends Thread> nodeAndThread) {
                    Intrinsics.checkParameterIsNotNull(nodeAndThread, (String)"nodeAndThread");
                    return CordaFutureImplKt.map((CordaFuture)InternalTestUtilsKt.addressMustBeBoundFuture$default(this.$executorService, this.$effectiveP2PAddress, null, 4, null), (Function1)((Function1)new Function1<Unit, Pair<? extends NodeWithInfo, ? extends Thread>>(nodeAndThread){
                        final /* synthetic */ Pair $nodeAndThread;

                        @NotNull
                        public final Pair<NodeWithInfo, Thread> invoke(@NotNull Unit it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            return this.$nodeAndThread;
                        }
                        {
                            this.$nodeAndThread = pair;
                            super(1);
                        }
                    }));
                }
                {
                    this.$executorService = scheduledExecutorService;
                    this.$effectiveP2PAddress = networkHostAndPort;
                    super(1);
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        private final Process startOutOfProcessNode(NodeConfig config2, String quasarJarPath2, Integer debugPort, String bytemanJarPath2, Integer bytemanPort, Map<String, String> overriddenSystemProperties, String maximumHeapSize, String logLevelOverride, String identifier, Map<String, String> environmentVariables, String[] extraCmdLineFlag) {
            void $receiver$iv$iv;
            Object object;
            Object item$iv$iv;
            void $receiver$iv$iv2;
            Map<String, Object> $receiver$iv;
            Object object2;
            String string;
            Logger logger = this.getLog$node_driver();
            StringBuilder stringBuilder = new StringBuilder().append("Starting out-of-process Node ").append(config2.getCorda().getMyLegalName().getOrganisation()).append(", ").append("debug port is ");
            Object object3 = debugPort;
            if (object3 == null) {
                object3 = "not enabled";
            }
            StringBuilder stringBuilder2 = stringBuilder.append(object3).append(", ").append("byteMan: ");
            if (bytemanJarPath2 == null) {
                string = "not in classpath";
            } else {
                StringBuilder stringBuilder3 = new StringBuilder().append("port is ");
                Object object4 = bytemanPort;
                if (object4 == null) {
                    object4 = "not enabled";
                }
                string = stringBuilder3.append(object4).toString();
            }
            logger.info(stringBuilder2.append(string).toString());
            DriverDSLImplKt.writeConfig(config2.getCorda().getBaseDirectory(), "node.conf", DriverDSLImplKt.access$toNodeOnly(config2.getTypesafe()));
            Map systemProperties = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"name", (Object)config2.getCorda().getMyLegalName()), TuplesKt.to((Object)"visualvm.display.name", (Object)("corda-" + config2.getCorda().getMyLegalName()))});
            Integer n = debugPort;
            if (n != null) {
                object2 = n;
                int it = ((Number)object2).intValue();
                Map map2 = systemProperties;
                Pair pair = TuplesKt.to((Object)"log4j2.level", (Object)"debug");
                map2.put(pair.getFirst(), pair.getSecond());
                map2 = systemProperties;
                pair = TuplesKt.to((Object)"log4j2.debug", (Object)"true");
                map2.put(pair.getFirst(), pair.getSecond());
            }
            object2 = systemProperties;
            Iterable<Pair<String, String>> it = this.inheritFromParentProcess();
            MapsKt.putAll((Map)object2, it);
            object2 = systemProperties;
            object2.putAll(overriddenSystemProperties);
            String excludePackagePattern = "x(antlr**;bftsmart**;ch**;co.paralleluniverse**;com.codahale**;com.esotericsoftware**;com.fasterxml**;com.google**;com.ibm**;com.intellij**;com.jcabi**;com.nhaarman**;com.opengamma**;com.typesafe**;com.zaxxer**;de.javakaffee**;groovy**;groovyjarjarantlr**;groovyjarjarasm**;io.atomix**;io.github**;io.netty**;jdk**;joptsimple**;junit**;kotlin**;net.corda.djvm**;djvm.**;net.bytebuddy**;net.i2p**;org.apache**;org.assertj**;org.bouncycastle**;org.codehaus**;org.crsh**;org.dom4j**;org.fusesource**;org.h2**;org.hamcrest**;org.hibernate**;org.jboss**;org.jcp**;org.joda**;org.junit**;org.mockito**;org.objectweb**;org.objenesis**;org.slf4j**;org.w3c**;org.xml**;org.yaml**;reflectasm**;rx**;org.jolokia**;com.lmax**;picocli**;liquibase**;com.github.benmanes**;org.json**;org.postgresql**;nonapi.io.github.classgraph**;)";
            String excludeClassloaderPattern = "l(net.corda.djvm.**;net.corda.core.serialization.internal.**)";
            Map<String, Object> $i$a$1$let = $receiver$iv = this.removeResolvedClasspath(systemProperties);
            Collection destination$iv$iv = new ArrayList($receiver$iv.size());
            void var19_20 = $receiver$iv$iv2;
            Iterator iterator = var19_20.entrySet().iterator();
            while (iterator.hasNext()) {
                void it2;
                object = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                String string2 = "-D" + (String)it2.getKey() + '=' + it2.getValue();
                collection.add(string2);
            }
            List extraJvmArguments = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)("-javaagent:" + quasarJarPath2 + '=' + excludePackagePattern + excludeClassloaderPattern));
            String loggingLevel = logLevelOverride != null ? logLevelOverride : (debugPort == null ? "INFO" : "DEBUG");
            Collection it3 = destination$iv$iv = CollectionsKt.mutableListOf((Object[])new String[]{"--base-directory=" + config2.getCorda().getBaseDirectory(), "--logging-level=" + loggingLevel, "--no-local-shell"});
            CollectionsKt.addAll((Collection)it3, (Object[])extraCmdLineFlag);
            List arguments = CollectionsKt.toList((Iterable)destination$iv$iv);
            List bytemanJvmArgs2 = (List)((Function0)new Function0<List<? extends String>>(bytemanJarPath2, bytemanPort, debugPort){
                final /* synthetic */ String $bytemanJarPath;
                final /* synthetic */ Integer $bytemanPort;
                final /* synthetic */ Integer $debugPort;

                @NotNull
                public final List<String> invoke() {
                    String string;
                    String string2 = this.$bytemanJarPath;
                    if (string2 != null) {
                        String string3;
                        String it = string3 = string2;
                        Integer n = this.$bytemanPort;
                        if (n != null) {
                            Integer n2 = n;
                            int it2 = ((Number)n2).intValue();
                            string = "-javaagent:" + this.$bytemanJarPath + "=port:" + this.$bytemanPort + ",listener:true";
                        } else {
                            string = null;
                        }
                    } else {
                        string = null;
                    }
                    String bytemanAgent = string;
                    return CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(bytemanAgent), (Iterable)(bytemanAgent != null && this.$debugPort != null ? CollectionsKt.listOf((Object[])new String[]{"-Dorg.jboss.byteman.verbose=true", "-Dorg.jboss.byteman.debug=true"}) : CollectionsKt.emptyList()));
                }
                {
                    this.$bytemanJarPath = string;
                    this.$bytemanPort = n;
                    this.$debugPort = n2;
                    super(0);
                }
            }).invoke();
            Iterable $receiver$iv2 = ProcessUtilities.INSTANCE.getDefaultClassPath();
            item$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Path cpPathEntry;
                String cpEntry = (String)element$iv$iv;
                Path path = cpPathEntry = Paths.get(cpEntry, new String[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"cpPathEntry");
                boolean bl = PathUtilsKt.isRegularFile((Path)path, (LinkOption[])new LinkOption[0]) && !Companion.isTestArtifact(((Object)cpPathEntry.getFileName()).toString()) && !Companion.isExcludedJar(cpPathEntry);
                if (!bl) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List cp = (List)destination$iv$iv2;
            boolean bl = false;
            Map<String, String> map3 = environmentVariables;
            object = identifier;
            List list = cp;
            String string3 = maximumHeapSize;
            Path path = config2.getCorda().getBaseDirectory();
            List list2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)extraJvmArguments, (Iterable)bytemanJvmArgs2), (Object)"-Dnet.corda.node.printErrorsToStdErr=true");
            Integer n2 = debugPort;
            return ProcessUtilities.startJavaProcess$default(ProcessUtilities.INSTANCE, "net.corda.node.Corda", arguments, list, path, n2, list2, string3, (String)object, map3, bl, 512, null);
        }

        static /* bridge */ /* synthetic */ Process startOutOfProcessNode$default(Companion companion, NodeConfig nodeConfig, String string, Integer n, String string2, Integer n2, Map map2, String string3, String string4, String string5, Map map3, String[] stringArray, int n3, Object object) {
            if ((n3 & 0x400) != 0) {
                stringArray = new String[]{};
            }
            return companion.startOutOfProcessNode(nodeConfig, string, n, string2, n2, map2, string3, string4, string5, map3, stringArray);
        }

        private final boolean isH2Database(NodeConfiguration config2) {
            String string = config2.getDataSourceProperties().getProperty("dataSource.url");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"config.dataSourcePropert\u2026roperty(\"dataSource.url\")");
            return StringsKt.startsWith$default((String)string, (String)"jdbc:h2:", (boolean)false, (int)2, null);
        }

        private final boolean isH2Database(NodeConfig config2) {
            return this.isH2Database(config2.getCorda());
        }

        private final boolean isTestArtifact(String name) {
            return StringsKt.endsWith$default((String)name, (String)"-tests.jar", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)"-test.jar", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"corda-mock", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"junit", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"testng", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"mockito", (boolean)false, (int)2, null);
        }

        private final boolean isTestArtifact(Manifest manifest) {
            return ManifestUtilsKt.get((Manifest)manifest, (String)DriverDSLImpl.CORDA_TESTING_ATTRIBUTE) != null;
        }

        private final boolean isCordapp(Manifest manifest) {
            boolean bl;
            block3: {
                Iterable $receiver$iv = CORDAPP_MANIFEST_ATTRIBUTES;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        String it = (String)element$iv;
                        if (!(ManifestUtilsKt.get((Manifest)manifest, (String)it) != null)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl || ManifestUtilsKt.get((Manifest)manifest, (String)"Target-Platform-Version") != null && ManifestUtilsKt.get((Manifest)manifest, (String)"Min-Platform-Version") != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean isExcludedJar(@NotNull Path $receiver) {
            boolean bl;
            JarInputStream jarInputStream;
            InputStream inputStream = Files.newInputStream($receiver, new OpenOption[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"Files.newInputStream(this)");
            Closeable closeable = inputStream;
            JarInputStream jarInputStream2 = jarInputStream;
            JarInputStream jarInputStream3 = jarInputStream;
            int n = 8192;
            BufferedInputStream bufferedInputStream = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
            jarInputStream2(bufferedInputStream);
            closeable = jarInputStream3;
            Throwable throwable = null;
            try {
                Manifest manifest;
                JarInputStream jar = (JarInputStream)closeable;
                if (jar.getManifest() == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                Manifest manifest2 = manifest;
                bl = Companion.isCordapp(manifest2) || Companion.isTestArtifact(manifest2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private final Process startWebserver(NodeHandleInternal handle, Integer debugPort, String maximumHeapSize) {
            Collection<String> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            String className = "net.corda.webserver.WebServer";
            DriverDSLImplKt.writeConfig(handle.getBaseDirectory(), "web-server.conf", this.toWebServerConfig(handle));
            Iterable<Pair<String, String>> iterable = this.inheritFromParentProcess();
            Collection collection2 = CollectionsKt.listOf((Object)("-Dname=node-" + handle.getP2pAddress() + "-webserver"));
            Integer n = debugPort;
            Path path = null;
            List list = null;
            List list2 = CollectionsKt.listOf((Object[])new String[]{"--base-directory", ((Object)handle.getBaseDirectory()).toString()});
            String string = className;
            ProcessUtilities processUtilities = ProcessUtilities.INSTANCE;
            void var6_13 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                String string2 = "-D" + (String)it.getFirst() + '=' + (String)it.getSecond();
                collection.add(string2);
            }
            collection = (List)destination$iv$iv;
            return ProcessUtilities.startJavaProcess$default(processUtilities, string, list2, list, path, n, CollectionsKt.plus((Collection)collection2, (Iterable)collection), maximumHeapSize, null, null, false, 908, null);
        }

        /*
         * WARNING - void declaration
         */
        private final Iterable<Pair<String, String>> inheritFromParentProcess() {
            void var3_3;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)propertiesInScope;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                String propName = (String)element$iv$iv;
                String propValue = System.getProperty(propName);
                Iterable list$iv$iv = propValue == null ? SetsKt.emptySet() : SetsKt.setOf((Object)new Pair((Object)propName, (Object)propValue));
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)var3_3;
        }

        private final Config toWebServerConfig(@NotNull NodeHandleInternal $receiver) {
            Config config2 = ConfigFactory.empty();
            config2 = this.plus(config2, (Pair<String, ? extends Object>)TuplesKt.to((Object)"webAddress", (Object)$receiver.getWebAddress().toString()));
            config2 = this.plus(config2, (Pair<String, ? extends Object>)TuplesKt.to((Object)"myLegalName", (Object)$receiver.getConfiguration().getMyLegalName().toString()));
            config2 = this.plus(config2, (Pair<String, ? extends Object>)TuplesKt.to((Object)"rpcAddress", (Object)$receiver.getConfiguration().getRpcOptions().getAddress().toString()));
            config2 = this.plus(config2, (Pair<String, ? extends Object>)TuplesKt.to((Object)"rpcUsers", (Object)ConfigUtilities.toConfig((Object)$receiver.getConfiguration()).getValue("rpcUsers")));
            config2 = this.plus(config2, (Pair<String, ? extends Object>)TuplesKt.to((Object)"useHTTPS", (Object)$receiver.getUseHTTPS()));
            config2 = this.plus(config2, (Pair<String, ? extends Object>)TuplesKt.to((Object)"baseDirectory", (Object)((Object)$receiver.getConfiguration().getBaseDirectory().toAbsolutePath()).toString()));
            config2 = this.plus(config2, (Pair<String, ? extends Object>)TuplesKt.to((Object)"keyStorePath", (Object)((Object)$receiver.getConfiguration().getP2pSslOptions().getKeyStore().getPath()).toString()));
            config2 = this.plus(config2, (Pair<String, ? extends Object>)TuplesKt.to((Object)"keyStorePassword", (Object)$receiver.getConfiguration().getP2pSslOptions().getKeyStore().getStorePassword()));
            config2 = this.plus(config2, (Pair<String, ? extends Object>)TuplesKt.to((Object)"trustStorePath", (Object)((Object)$receiver.getConfiguration().getP2pSslOptions().getTrustStore().getPath()).toString()));
            Config config3 = config2 = this.plus(config2, (Pair<String, ? extends Object>)TuplesKt.to((Object)"trustStorePassword", (Object)$receiver.getConfiguration().getP2pSslOptions().getTrustStore().getStorePassword()));
            Intrinsics.checkExpressionValueIsNotNull((Object)config3, (String)"config");
            return config3;
        }

        /*
         * WARNING - void declaration
         */
        private final URLClassLoader createCordappsClassLoader(Collection<? extends TestCordappInternal> cordapps) {
            Collection<URL> collection;
            void $receiver$iv$iv;
            Collection $receiver$iv;
            URLClassLoader uRLClassLoader;
            if (cordapps == null || cordapps.isEmpty()) {
                return null;
            }
            Iterable iterable = cordapps;
            URLClassLoader uRLClassLoader2 = uRLClassLoader;
            URLClassLoader uRLClassLoader3 = uRLClassLoader;
            void var3_5 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                TestCordappInternal testCordappInternal = (TestCordappInternal)item$iv$iv;
                collection = destination$iv$iv;
                URL uRL = it.getJarFile().toUri().toURL();
                collection.add(uRL);
            }
            collection = (List)destination$iv$iv;
            Collection thisCollection$iv = $receiver$iv = (Collection)collection;
            URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
            if (uRLArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            collection = uRLArray;
            uRLClassLoader2((URL[])collection);
            return uRLClassLoader3;
        }

        private final Config plus(@NotNull Config $receiver, Pair<String, ? extends Object> property) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return $receiver.withValue((String)property.getFirst(), ConfigValueFactory.fromAnyRef((Object)property.getSecond()));
        }

        /*
         * WARNING - void declaration
         */
        private final Map<String, Object> removeResolvedClasspath(@NotNull Map<String, ? extends Object> $receiver) {
            void $receiver$iv$iv;
            Map<String, ? extends Object> $receiver$iv;
            Map<String, ? extends Object> map2 = $receiver$iv = $receiver;
            Map destination$iv$iv = new LinkedHashMap();
            void var5_5 = $receiver$iv$iv;
            for (Map.Entry element$iv$iv : var5_5.entrySet()) {
                Map.Entry it = element$iv$iv;
                if (Intrinsics.areEqual((Object)((String)it.getKey()), (Object)"java.class.path")) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            return destination$iv$iv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void shutdownAndDeleteDatabase(NodeConfiguration config2) {
            DataSource dataSource;
            DataSource dataSource2 = dataSource = DataSourceFactory.createDataSource$default((DataSourceFactory)DataSourceFactory.INSTANCE, (Properties)config2.getDataSourceProperties(), (boolean)false, null, (int)6, null);
            AutoCloseable autoCloseable = dataSource2.getConnection();
            Throwable throwable = null;
            try {
                boolean bl;
                Connection connection = (Connection)autoCloseable;
                AutoCloseable autoCloseable2 = connection.createStatement();
                Throwable throwable2 = null;
                try {
                    Statement statement = (Statement)autoCloseable2;
                    bl = statement.execute("SHUTDOWN");
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                }
                boolean bl2 = bl;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            Path path = DatabaseSnapshot.INSTANCE.databaseFilename(config2.getBaseDirectory());
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"DatabaseSnapshot.databas\u2026ame(config.baseDirectory)");
            PathUtilsKt.deleteIfExists((Path)path);
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$shutdownAndDeleteDatabase(Companion $this, @NotNull NodeConfiguration config2) {
            $this.shutdownAndDeleteDatabase(config2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

