/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.node.internal;

import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.crypto.Crypto;
import net.corda.core.crypto.CryptoUtils;
import net.corda.core.crypto.SecureHashKt;
import net.corda.core.crypto.SignatureScheme;
import net.corda.core.crypto.internal.Instances;
import net.corda.core.crypto.internal.ProviderMapKt;
import net.corda.nodeapi.internal.crypto.ContentSignerBuilder;
import net.corda.nodeapi.internal.cryptoservice.CryptoService;
import net.corda.nodeapi.internal.cryptoservice.CryptoServiceException;
import net.corda.nodeapi.internal.cryptoservice.WrappedPrivateKey;
import net.corda.nodeapi.internal.cryptoservice.WrappingMode;
import org.bouncycastle.operator.ContentSigner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J$\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u0004H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u0004H\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\"\u0010 \u001a\u00020!2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020!2\b\u0010#\u001a\u0004\u0018\u00010\u0004H\u0016J \u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020!H\u0016J \u0010&\u001a\u00020!2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u0004H\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lnet/corda/testing/node/internal/MockCryptoService;", "Lnet/corda/nodeapi/internal/cryptoservice/CryptoService;", "initialKeyPairs", "", "", "Ljava/security/KeyPair;", "(Ljava/util/Map;)V", "aliasToKey", "", "wrappingKeys", "Ljavax/crypto/SecretKey;", "containsKey", "", "alias", "createWrappingKey", "", "failIfExists", "generateKeyPair", "Ljava/security/PublicKey;", "scheme", "Lnet/corda/core/crypto/SignatureScheme;", "generateWrappedKeyPair", "Lkotlin/Pair;", "Lnet/corda/nodeapi/internal/cryptoservice/WrappedPrivateKey;", "masterKeyAlias", "childKeyScheme", "getPublicKey", "getSigner", "Lorg/bouncycastle/operator/ContentSigner;", "getWrappingMode", "Lnet/corda/nodeapi/internal/cryptoservice/WrappingMode;", "keyAlgorithmFromScheme", "sign", "", "data", "signAlgorithm", "wrappedPrivateKey", "payloadToSign", "signWithAlgorithm", "node-driver"})
public final class MockCryptoService
implements CryptoService {
    private final Map<String, KeyPair> aliasToKey;
    private final Map<String, SecretKey> wrappingKeys;

    public boolean containsKey(@NotNull String alias) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        return this.aliasToKey.containsKey(alias);
    }

    @Nullable
    public PublicKey getPublicKey(@NotNull String alias) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        KeyPair keyPair = this.aliasToKey.get(alias);
        return keyPair != null ? keyPair.getPublic() : null;
    }

    @NotNull
    public byte[] sign(@NotNull String alias, @NotNull byte[] data, @Nullable String signAlgorithm) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        try {
            byte[] byArray;
            String string = signAlgorithm;
            if (string == null) {
                KeyPair keyPair = this.aliasToKey.get(alias);
                if (keyPair == null) {
                    Intrinsics.throwNpe();
                }
                PrivateKey privateKey = keyPair.getPrivate();
                Intrinsics.checkExpressionValueIsNotNull((Object)privateKey, (String)"aliasToKey[alias]!!.private");
                byArray = Crypto.doSign((PrivateKey)privateKey, (byte[])data);
            } else {
                byArray = this.signWithAlgorithm(alias, data, signAlgorithm);
            }
            return byArray;
        }
        catch (Exception e) {
            throw (Throwable)new CryptoServiceException("Cannot sign using the key with alias " + alias + ". SHA256 of data to be signed: " + SecureHashKt.sha256((byte[])data), (Throwable)e, false, 4, null);
        }
    }

    private final byte[] signWithAlgorithm(String alias, byte[] data, String signAlgorithm) {
        KeyPair keyPair = this.aliasToKey.get(alias);
        if (keyPair == null) {
            Intrinsics.throwNpe();
        }
        PrivateKey privateKey = keyPair.getPrivate();
        Signature signature = Signature.getInstance(signAlgorithm, (Provider)ProviderMapKt.getCordaBouncyCastleProvider());
        signature.initSign(privateKey, CryptoUtils.newSecureRandom());
        signature.update(data);
        byte[] byArray = signature.sign();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"signature.sign()");
        return byArray;
    }

    @NotNull
    public ContentSigner getSigner(@NotNull String alias) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        try {
            PrivateKey privateKey;
            KeyPair keyPair = this.aliasToKey.get(alias);
            if (keyPair == null) {
                Intrinsics.throwNpe();
            }
            PrivateKey privateKey2 = privateKey = keyPair.getPrivate();
            Intrinsics.checkExpressionValueIsNotNull((Object)privateKey2, (String)"privateKey");
            SignatureScheme signatureScheme = Crypto.findSignatureScheme((PrivateKey)privateKey2);
            return ContentSignerBuilder.build$default((ContentSignerBuilder)ContentSignerBuilder.INSTANCE, (SignatureScheme)signatureScheme, (PrivateKey)privateKey, (Provider)Crypto.findProvider((String)signatureScheme.getProviderName()), (SecureRandom)CryptoUtils.newSecureRandom(), (boolean)false, (int)16, null);
        }
        catch (Exception e) {
            throw (Throwable)new CryptoServiceException("Cannot get Signer for key with alias " + alias, (Throwable)e, false, 4, null);
        }
    }

    @NotNull
    public PublicKey generateKeyPair(@NotNull String alias, @NotNull SignatureScheme scheme) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        Intrinsics.checkParameterIsNotNull((Object)scheme, (String)"scheme");
        KeyPair keyPair = Crypto.generateKeyPair((SignatureScheme)scheme);
        Map<String, KeyPair> map2 = this.aliasToKey;
        KeyPair keyPair2 = keyPair;
        map2.put(alias, keyPair2);
        PublicKey publicKey = keyPair.getPublic();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"keyPair.public");
        return publicKey;
    }

    public synchronized void createWrappingKey(@NotNull String alias, boolean failIfExists) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        if (this.wrappingKeys.get(alias) != null) {
            boolean bl = failIfExists;
            if (bl) {
                throw (Throwable)new IllegalArgumentException("There is an existing key with the alias: " + alias);
            }
            if (!bl) {
                return;
            }
            throw new NoWhenBranchMatchedException();
        }
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(this.wrappingKeySize());
        SecretKey wrappingKey = keyGenerator.generateKey();
        Map<String, SecretKey> map2 = this.wrappingKeys;
        SecretKey secretKey = wrappingKey;
        Intrinsics.checkExpressionValueIsNotNull((Object)secretKey, (String)"wrappingKey");
        SecretKey secretKey2 = secretKey;
        map2.put(alias, secretKey2);
    }

    @NotNull
    public Pair<PublicKey, WrappedPrivateKey> generateWrappedKeyPair(@NotNull String masterKeyAlias, @NotNull SignatureScheme childKeyScheme) {
        Intrinsics.checkParameterIsNotNull((Object)masterKeyAlias, (String)"masterKeyAlias");
        Intrinsics.checkParameterIsNotNull((Object)childKeyScheme, (String)"childKeyScheme");
        SecretKey secretKey = this.wrappingKeys.get(masterKeyAlias);
        if (secretKey == null) {
            throw (Throwable)new IllegalStateException("There is no master key under the alias: " + masterKeyAlias);
        }
        SecretKey wrappingKey = secretKey;
        KeyPair keyPair = Crypto.generateKeyPair((SignatureScheme)childKeyScheme);
        Cipher cipher = Cipher.getInstance("AES", (Provider)ProviderMapKt.getCordaBouncyCastleProvider());
        cipher.init(3, wrappingKey);
        byte[] privateKeyMaterialWrapped = cipher.wrap(keyPair.getPrivate());
        PublicKey publicKey = keyPair.getPublic();
        Intrinsics.checkExpressionValueIsNotNull((Object)privateKeyMaterialWrapped, (String)"privateKeyMaterialWrapped");
        return new Pair((Object)publicKey, (Object)new WrappedPrivateKey(privateKeyMaterialWrapped, childKeyScheme, null, 4, null));
    }

    @NotNull
    public byte[] sign(@NotNull String masterKeyAlias, @NotNull WrappedPrivateKey wrappedPrivateKey, @NotNull byte[] payloadToSign) {
        Intrinsics.checkParameterIsNotNull((Object)masterKeyAlias, (String)"masterKeyAlias");
        Intrinsics.checkParameterIsNotNull((Object)wrappedPrivateKey, (String)"wrappedPrivateKey");
        Intrinsics.checkParameterIsNotNull((Object)payloadToSign, (String)"payloadToSign");
        SecretKey secretKey = this.wrappingKeys.get(masterKeyAlias);
        if (secretKey == null) {
            throw (Throwable)new IllegalStateException("There is no master key under the alias: " + masterKeyAlias);
        }
        SecretKey wrappingKey = secretKey;
        Cipher cipher = Cipher.getInstance("AES", (Provider)ProviderMapKt.getCordaBouncyCastleProvider());
        cipher.init(4, wrappingKey);
        Key key = cipher.unwrap(wrappedPrivateKey.getKeyMaterial(), this.keyAlgorithmFromScheme(wrappedPrivateKey.getSignatureScheme()), 2);
        if (key == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.security.PrivateKey");
        }
        PrivateKey privateKey = (PrivateKey)key;
        Signature signature = Instances.INSTANCE.getSignatureInstance(wrappedPrivateKey.getSignatureScheme().getSignatureName(), (Provider)ProviderMapKt.getCordaBouncyCastleProvider());
        signature.initSign(privateKey, CryptoUtils.newSecureRandom());
        signature.update(payloadToSign);
        byte[] byArray = signature.sign();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"signature.sign()");
        return byArray;
    }

    private final String keyAlgorithmFromScheme(SignatureScheme scheme) {
        String string;
        SignatureScheme signatureScheme = scheme;
        if (Intrinsics.areEqual((Object)signatureScheme, (Object)Crypto.ECDSA_SECP256R1_SHA256) || Intrinsics.areEqual((Object)signatureScheme, (Object)Crypto.ECDSA_SECP256K1_SHA256)) {
            string = "EC";
        } else if (Intrinsics.areEqual((Object)signatureScheme, (Object)Crypto.RSA_SHA256)) {
            string = "RSA";
        } else {
            throw (Throwable)new IllegalArgumentException("No algorithm for scheme ID " + scheme.getSchemeNumberID());
        }
        return string;
    }

    @Nullable
    public WrappingMode getWrappingMode() {
        return WrappingMode.DEGRADED_WRAPPED;
    }

    public MockCryptoService(@NotNull Map<String, KeyPair> initialKeyPairs) {
        Map<String, KeyPair> $receiver$iv;
        Map map2;
        Intrinsics.checkParameterIsNotNull(initialKeyPairs, (String)"initialKeyPairs");
        MockCryptoService mockCryptoService = this;
        mockCryptoService.aliasToKey = map2 = (Map)new LinkedHashMap();
        mockCryptoService = this;
        mockCryptoService.wrappingKeys = map2 = (Map)new LinkedHashMap();
        Map<String, KeyPair> map3 = $receiver$iv = initialKeyPairs;
        Iterator<Map.Entry<String, KeyPair>> iterator = map3.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, KeyPair> element$iv;
            Map.Entry<String, KeyPair> it = element$iv = iterator.next();
            Map<String, KeyPair> map4 = this.aliasToKey;
            String string = it.getKey();
            KeyPair keyPair = it.getValue();
            map4.put(string, keyPair);
        }
    }

    @NotNull
    public SignatureScheme defaultIdentitySignatureScheme() {
        return CryptoService.DefaultImpls.defaultIdentitySignatureScheme((CryptoService)this);
    }

    @NotNull
    public SignatureScheme defaultTLSSignatureScheme() {
        return CryptoService.DefaultImpls.defaultTLSSignatureScheme((CryptoService)this);
    }

    @NotNull
    public SignatureScheme defaultWrappingSignatureScheme() {
        return CryptoService.DefaultImpls.defaultWrappingSignatureScheme((CryptoService)this);
    }

    public int wrappingKeySize() {
        return CryptoService.DefaultImpls.wrappingKeySize((CryptoService)this);
    }
}

