/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.node.internal;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.crypto.CryptoUtils;
import net.corda.core.crypto.DigitalSignature;
import net.corda.core.crypto.SignableData;
import net.corda.core.crypto.TransactionSignature;
import net.corda.core.identity.PartyAndCertificate;
import net.corda.core.node.services.IdentityService;
import net.corda.core.serialization.SingletonSerializeAsToken;
import net.corda.node.services.identity.InMemoryIdentityService;
import net.corda.node.services.keys.KMSUtilsKt;
import net.corda.node.services.keys.KeyManagementServiceInternal;
import org.bouncycastle.operator.ContentSigner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0016H\u0016J\u0012\u0010\u0018\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\rH\u0016J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\rH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\rH\u0016J\u0018\u0010\u001f\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\rH\u0016J\"\u0010&\u001a\u00020'2\u0018\u0010(\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020*0)0\u0016H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lnet/corda/testing/node/internal/MockKeyManagementService;", "Lnet/corda/core/serialization/SingletonSerializeAsToken;", "Lnet/corda/node/services/keys/KeyManagementServiceInternal;", "identityService", "Lnet/corda/core/node/services/IdentityService;", "initialKeys", "", "Ljava/security/KeyPair;", "(Lnet/corda/core/node/services/IdentityService;[Ljava/security/KeyPair;)V", "getIdentityService", "()Lnet/corda/core/node/services/IdentityService;", "keyStore", "", "Ljava/security/PublicKey;", "Ljava/security/PrivateKey;", "keys", "", "getKeys", "()Ljava/util/Set;", "nextKeys", "Ljava/util/LinkedList;", "filterMyKeys", "", "candidateKeys", "freshKeyInternal", "externalId", "Ljava/util/UUID;", "getSigner", "Lorg/bouncycastle/operator/ContentSigner;", "publicKey", "getSigningKeyPair", "sign", "Lnet/corda/core/crypto/DigitalSignature$WithKey;", "bytes", "", "Lnet/corda/core/crypto/TransactionSignature;", "signableData", "Lnet/corda/core/crypto/SignableData;", "start", "", "initialKeysAndAliases", "Lkotlin/Pair;", "", "node-driver"})
public final class MockKeyManagementService
extends SingletonSerializeAsToken
implements KeyManagementServiceInternal {
    private final Map<PublicKey, PrivateKey> keyStore;
    private final LinkedList<KeyPair> nextKeys;
    @NotNull
    private final IdentityService identityService;

    @NotNull
    public Set<PublicKey> getKeys() {
        return this.keyStore.keySet();
    }

    @NotNull
    public PublicKey freshKeyInternal(@Nullable UUID externalId) {
        KeyPair keyPair = this.nextKeys.poll();
        if (keyPair == null) {
            keyPair = CryptoUtils.generateKeyPair();
        }
        KeyPair k = keyPair;
        Map<PublicKey, PrivateKey> map2 = this.keyStore;
        PublicKey publicKey = k.getPublic();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"k.public");
        PublicKey publicKey2 = publicKey;
        PrivateKey privateKey = k.getPrivate();
        Intrinsics.checkExpressionValueIsNotNull((Object)privateKey, (String)"k.private");
        PrivateKey privateKey2 = privateKey;
        map2.put(publicKey2, privateKey2);
        if (externalId != null) {
            IdentityService identityService = this.getIdentityService();
            if (identityService == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.corda.node.services.identity.InMemoryIdentityService");
            }
            InMemoryIdentityService inMemoryIdentityService = (InMemoryIdentityService)identityService;
            PublicKey publicKey3 = k.getPublic();
            Intrinsics.checkExpressionValueIsNotNull((Object)publicKey3, (String)"k.public");
            inMemoryIdentityService.registerKeyToExternalId(publicKey3, externalId);
        }
        PublicKey publicKey4 = k.getPublic();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey4, (String)"k.public");
        return publicKey4;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<PublicKey> filterMyKeys(@NotNull Iterable<? extends PublicKey> candidateKeys) {
        void $receiver$iv$iv;
        Iterable<? extends PublicKey> $receiver$iv;
        Intrinsics.checkParameterIsNotNull(candidateKeys, (String)"candidateKeys");
        Iterable<? extends PublicKey> iterable = $receiver$iv = candidateKeys;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            PublicKey it = (PublicKey)element$iv$iv;
            if (!this.getKeys().contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public ContentSigner getSigner(@NotNull PublicKey publicKey) {
        Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
        return KMSUtilsKt.getSigner((KeyPair)this.getSigningKeyPair(publicKey));
    }

    public void start(@NotNull Iterable<? extends Pair<? extends PublicKey, String>> initialKeysAndAliases) {
        Intrinsics.checkParameterIsNotNull(initialKeysAndAliases, (String)"initialKeysAndAliases");
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    private final KeyPair getSigningKeyPair(PublicKey publicKey) {
        Object v0;
        block3: {
            Iterable $receiver$iv = CryptoUtils.getKeys((PublicKey)publicKey);
            for (Object element$iv : $receiver$iv) {
                PublicKey it = (PublicKey)element$iv;
                if (!this.keyStore.containsKey(it)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        PublicKey publicKey2 = v0;
        if (publicKey2 == null) {
            throw (Throwable)new IllegalArgumentException("Public key not found: " + CryptoUtils.toStringShort((PublicKey)publicKey));
        }
        PublicKey pk = publicKey2;
        PrivateKey privateKey = this.keyStore.get(pk);
        if (privateKey == null) {
            Intrinsics.throwNpe();
        }
        return new KeyPair(pk, privateKey);
    }

    @NotNull
    public DigitalSignature.WithKey sign(@NotNull byte[] bytes, @NotNull PublicKey publicKey) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
        KeyPair keyPair = this.getSigningKeyPair(publicKey);
        return CryptoUtils.sign((KeyPair)keyPair, (byte[])bytes);
    }

    @NotNull
    public TransactionSignature sign(@NotNull SignableData signableData, @NotNull PublicKey publicKey) {
        Intrinsics.checkParameterIsNotNull((Object)signableData, (String)"signableData");
        Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
        KeyPair keyPair = this.getSigningKeyPair(publicKey);
        return CryptoUtils.sign((KeyPair)keyPair, (SignableData)signableData);
    }

    @NotNull
    public IdentityService getIdentityService() {
        return this.identityService;
    }

    /*
     * WARNING - void declaration
     */
    public MockKeyManagementService(@NotNull IdentityService identityService, KeyPair ... initialKeys) {
        void var12_10;
        void destination$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)identityService, (String)"identityService");
        Intrinsics.checkParameterIsNotNull((Object)initialKeys, (String)"initialKeys");
        this.identityService = identityService;
        KeyPair[] keyPairArray = initialKeys;
        Map map2 = new HashMap();
        MockKeyManagementService mockKeyManagementService = this;
        int n = ((void)$receiver$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void element$iv;
            void var8_9 = element$iv = $receiver$iv[i];
            var12_10 = destination$iv;
            PublicKey publicKey = it.getPublic();
            it = element$iv;
            PrivateKey privateKey = it.getPrivate();
            var12_10.put(publicKey, privateKey);
        }
        var12_10 = destination$iv;
        mockKeyManagementService.keyStore = var12_10;
        this.nextKeys = new LinkedList();
    }

    @NotNull
    public PublicKey freshKey() {
        return KeyManagementServiceInternal.DefaultImpls.freshKey((KeyManagementServiceInternal)this);
    }

    @NotNull
    public PublicKey freshKey(@NotNull UUID externalId) {
        Intrinsics.checkParameterIsNotNull((Object)externalId, (String)"externalId");
        return KeyManagementServiceInternal.DefaultImpls.freshKey((KeyManagementServiceInternal)this, (UUID)externalId);
    }

    @NotNull
    public PartyAndCertificate freshKeyAndCert(@NotNull PartyAndCertificate identity, boolean revocationEnabled) {
        Intrinsics.checkParameterIsNotNull((Object)identity, (String)"identity");
        return KeyManagementServiceInternal.DefaultImpls.freshKeyAndCert((KeyManagementServiceInternal)this, (PartyAndCertificate)identity, (boolean)revocationEnabled);
    }

    @NotNull
    public PartyAndCertificate freshKeyAndCert(@NotNull PartyAndCertificate identity, boolean revocationEnabled, @NotNull UUID externalId) {
        Intrinsics.checkParameterIsNotNull((Object)identity, (String)"identity");
        Intrinsics.checkParameterIsNotNull((Object)externalId, (String)"externalId");
        return KeyManagementServiceInternal.DefaultImpls.freshKeyAndCert((KeyManagementServiceInternal)this, (PartyAndCertificate)identity, (boolean)revocationEnabled, (UUID)externalId);
    }
}

