/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.node.internal;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.crypto.SecureHash;
import net.corda.core.identity.Party;
import net.corda.core.internal.InternalUtils;
import net.corda.core.internal.NetworkParametersStorage;
import net.corda.core.internal.SignedDataWithCert;
import net.corda.core.node.NetworkParameters;
import net.corda.core.node.NotaryInfo;
import net.corda.core.serialization.SerializationAPIKt;
import net.corda.nodeapi.internal.network.NetworkMapKt;
import net.corda.testing.common.internal.ParametersUtilitiesKt;
import net.corda.testing.core.TestConstants;
import net.corda.testing.core.TestIdentity;
import net.corda.testing.internal.InternalTestUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0006H\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u0006H\u0016J\u0018\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u0006H\u0016J\u0016\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0016J$\u0010\"\u001a\u00020 2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0016J\u000e\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020\u0003J\b\u0010)\u001a\u00020 H\u0002J\f\u0010*\u001a\u00020\u0006*\u00020\u0003H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u000ej\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u0010\u001a.\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00110\u000ej\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0011j\u0002`\u0012`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lnet/corda/testing/node/internal/MockNetworkParametersStorage;", "Lnet/corda/core/internal/NetworkParametersStorage;", "currentParameters", "Lnet/corda/core/node/NetworkParameters;", "(Lnet/corda/core/node/NetworkParameters;)V", "currentHash", "Lnet/corda/core/crypto/SecureHash;", "getCurrentHash", "()Lnet/corda/core/crypto/SecureHash;", "setCurrentHash", "(Lnet/corda/core/crypto/SecureHash;)V", "defaultHash", "getDefaultHash", "hashToParametersMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "hashToSignedParametersMap", "Lnet/corda/core/internal/SignedDataWithCert;", "Lnet/corda/nodeapi/internal/network/SignedNetworkParameters;", "getEpochFromHash", "", "hash", "(Lnet/corda/core/crypto/SecureHash;)Ljava/lang/Integer;", "getHistoricNotary", "Lnet/corda/core/node/NotaryInfo;", "party", "Lnet/corda/core/identity/Party;", "hasParameters", "", "lookup", "lookupSigned", "saveParameters", "", "signedNetworkParameters", "setCurrentParameters", "currentSignedParameters", "trustRoots", "", "Ljava/security/cert/X509Certificate;", "setCurrentParametersUnverified", "networkParameters", "storeCurrentParameters", "computeHash", "node-driver"})
public final class MockNetworkParametersStorage
implements NetworkParametersStorage {
    private final HashMap<SecureHash, NetworkParameters> hashToParametersMap;
    private final HashMap<SecureHash, SignedDataWithCert<NetworkParameters>> hashToSignedParametersMap;
    @NotNull
    private SecureHash currentHash;
    private NetworkParameters currentParameters;

    @NotNull
    public SecureHash getCurrentHash() {
        return this.currentHash;
    }

    public void setCurrentHash(@NotNull SecureHash secureHash) {
        Intrinsics.checkParameterIsNotNull((Object)secureHash, (String)"<set-?>");
        this.currentHash = secureHash;
    }

    @NotNull
    public SecureHash getDefaultHash() {
        return this.getCurrentHash();
    }

    private final SecureHash computeHash(@NotNull NetworkParameters $receiver) {
        return (SecureHash)InternalTestUtilsKt.withTestSerializationEnvIfNotSet((Function0)((Function0)new Function0<SecureHash>($receiver){
            final /* synthetic */ NetworkParameters receiver$0;

            @NotNull
            public final SecureHash invoke() {
                return SerializationAPIKt.serialize$default((Object)this.receiver$0, null, null, (int)3, null).getHash();
            }
            {
                this.receiver$0 = networkParameters;
                super(0);
            }
        }));
    }

    public final void setCurrentParametersUnverified(@NotNull NetworkParameters networkParameters) {
        Intrinsics.checkParameterIsNotNull((Object)networkParameters, (String)"networkParameters");
        this.currentParameters = networkParameters;
        this.setCurrentHash(this.computeHash(this.currentParameters));
        this.storeCurrentParameters();
    }

    public void setCurrentParameters(@NotNull SignedDataWithCert<NetworkParameters> currentSignedParameters, @NotNull Set<? extends X509Certificate> trustRoots) {
        Intrinsics.checkParameterIsNotNull(currentSignedParameters, (String)"currentSignedParameters");
        Intrinsics.checkParameterIsNotNull(trustRoots, (String)"trustRoots");
        this.currentParameters = (NetworkParameters)NetworkMapKt.verifiedNetworkParametersCert(currentSignedParameters, trustRoots);
        this.setCurrentHash(currentSignedParameters.getRaw().getHash());
        this.storeCurrentParameters();
    }

    @Nullable
    public SignedDataWithCert<NetworkParameters> lookupSigned(@NotNull SecureHash hash) {
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        return this.hashToSignedParametersMap.get(hash);
    }

    public boolean hasParameters(@NotNull SecureHash hash) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        Map map3 = map2 = (Map)this.hashToParametersMap;
        return map3.containsKey(hash);
    }

    @Nullable
    public NetworkParameters lookup(@NotNull SecureHash hash) {
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        return this.hashToParametersMap.get(hash);
    }

    @Nullable
    public Integer getEpochFromHash(@NotNull SecureHash hash) {
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        NetworkParameters networkParameters = this.lookup(hash);
        return networkParameters != null ? Integer.valueOf(networkParameters.getEpoch()) : null;
    }

    public void saveParameters(@NotNull SignedDataWithCert<NetworkParameters> signedNetworkParameters) {
        Intrinsics.checkParameterIsNotNull(signedNetworkParameters, (String)"signedNetworkParameters");
        SignedDataWithCert<NetworkParameters> networkParameters = (SignedDataWithCert<NetworkParameters>)signedNetworkParameters.verified();
        SecureHash hash = signedNetworkParameters.getRaw().getHash();
        Map map2 = this.hashToParametersMap;
        SignedDataWithCert<NetworkParameters> signedDataWithCert = networkParameters;
        map2.put(hash, signedDataWithCert);
        map2 = this.hashToSignedParametersMap;
        signedDataWithCert = signedNetworkParameters;
        map2.put(hash, signedDataWithCert);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public NotaryInfo getHistoricNotary(@NotNull Party party) {
        NotaryInfo notaryInfo;
        Object v0;
        Object it;
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)party, (String)"party");
            Iterable $receiver$iv = this.currentParameters.getNotaries();
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $receiver$iv) {
                it = (NotaryInfo)element$iv;
                if (!Intrinsics.areEqual((Object)it.getIdentity(), (Object)party)) continue;
                if (found$iv) {
                    v0 = null;
                    break block6;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        NotaryInfo inCurrentParams = v0;
        if (inCurrentParams == null) {
            void var3_2;
            Object v1;
            block7: {
                void $receiver$iv$iv;
                Object element$iv;
                Object $receiver$iv = this.hashToParametersMap;
                Map found$iv = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                element$iv = $receiver$iv$iv;
                it = element$iv.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry $$_$_parameters;
                    Map.Entry entry = $$_$_parameters = (element$iv$iv = (Map.Entry)it.next());
                    NetworkParameters parameters = (NetworkParameters)entry.getValue();
                    Iterable list$iv$iv = parameters.getNotaries();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                Iterator iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv2 = iterator.next();
                    NotaryInfo it2 = (NotaryInfo)element$iv2;
                    if (!Intrinsics.areEqual((Object)it2.getIdentity(), (Object)party)) continue;
                    v1 = element$iv2;
                    break block7;
                }
                v1 = null;
            }
            NotaryInfo inOldParams = v1;
            notaryInfo = var3_2;
        } else {
            notaryInfo = inCurrentParams;
        }
        return notaryInfo;
    }

    private final void storeCurrentParameters() {
        Map map2 = this.hashToParametersMap;
        SecureHash secureHash = this.getCurrentHash();
        Object object = this.currentParameters;
        map2.put(secureHash, object);
        TestIdentity testIdentity = new TestIdentity(TestConstants.ALICE_NAME, 20L, null, 4, null);
        SignedDataWithCert signedData2 = (SignedDataWithCert)InternalTestUtilsKt.withTestSerializationEnvIfNotSet((Function0)((Function0)new Function0<SignedDataWithCert<NetworkParameters>>(this, testIdentity){
            final /* synthetic */ MockNetworkParametersStorage this$0;
            final /* synthetic */ TestIdentity $testIdentity;

            @NotNull
            public final SignedDataWithCert<NetworkParameters> invoke() {
                NetworkParameters networkParameters = MockNetworkParametersStorage.access$getCurrentParameters$p(this.this$0);
                PrivateKey privateKey = this.$testIdentity.getKeyPair().getPrivate();
                Intrinsics.checkExpressionValueIsNotNull((Object)privateKey, (String)"testIdentity.keyPair.private");
                return InternalUtils.signWithCert((Object)networkParameters, (PrivateKey)privateKey, (X509Certificate)this.$testIdentity.getIdentity().getCertificate());
            }
            {
                this.this$0 = mockNetworkParametersStorage;
                this.$testIdentity = testIdentity;
                super(0);
            }
        }));
        object = this.hashToSignedParametersMap;
        SecureHash secureHash2 = this.getCurrentHash();
        SignedDataWithCert signedDataWithCert = signedData2;
        object.put(secureHash2, signedDataWithCert);
    }

    public MockNetworkParametersStorage(@NotNull NetworkParameters currentParameters) {
        Intrinsics.checkParameterIsNotNull((Object)currentParameters, (String)"currentParameters");
        this.currentParameters = currentParameters;
        this.hashToParametersMap = new HashMap();
        this.hashToSignedParametersMap = new HashMap();
        this.currentHash = this.computeHash(this.currentParameters);
        this.storeCurrentParameters();
    }

    public /* synthetic */ MockNetworkParametersStorage(NetworkParameters networkParameters, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Instant instant = Instant.MIN;
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.MIN");
            networkParameters = ParametersUtilitiesKt.testNetworkParameters$default(null, (int)0, (Instant)instant, (int)0, (int)0, null, (int)0, null, null, (int)507, null);
        }
        this(networkParameters);
    }

    public MockNetworkParametersStorage() {
        this(null, 1, null);
    }

    @NotNull
    public static final /* synthetic */ NetworkParameters access$getCurrentParameters$p(MockNetworkParametersStorage $this) {
        return $this.currentParameters;
    }

    public static final /* synthetic */ void access$setCurrentParameters$p(MockNetworkParametersStorage $this, @NotNull NetworkParameters networkParameters) {
        $this.currentParameters = networkParameters;
    }
}

